/*
 * Author: Heinz Mauelshagen, Germany
 *
 * April 1997
 * June 1998
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

/*
 * Changelog
 *
 *    06/12/1998 - reworked return output
 *
 */

#include <liblvm.h>

int lv_check_on_pv ( pv_t *pv, int lv_num) {
   int pe;
   int ret = FALSE;

#ifdef DEBUG
   debug ( "lv_check_on_pv -- CALLED\n");
#endif

   if ( pv == NULL || lv_num < 1 || pv_check_consistency ( pv) < 0) {
      ret = -LVM_EPARAM;
      goto lv_check_on_pv_end;
   }

   for ( pe = 0; pe < pv->pe_total; pe++) {
      if ( pv->pe[pe].lv_num == lv_num) ret = TRUE;
      break;
   }

lv_check_on_pv_end:
#ifdef DEBUG
   debug ( "lv_check_on_pv -- LEAVING with ret: %d\n", ret);
#endif

   return ret;
}
