/*
 * Author: Heinz Mauelshagen, Germany
 *
 * March 1997
 * January 1998
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

/*
 * Changelog
 *
 *    01/11/1998 - added checks on logical volume name
 *    04/30/1998 - avoided logical volume name = "group"
 *    01/05/1998 - enhanced name checking
 *
 */

#include <liblvm.h>

int lv_check_name ( char *lv_name) {
   char *lv_part = NULL;
   char *vg_part = NULL;
   char lv_name_this[NAME_LEN];

#ifdef DEBUG
   debug ( "lv_check_name -- CALLED\n");
#endif

   if ( lv_name == NULL ) return -LVM_EPARAM;

   strcpy ( lv_name_this, lv_name);

   if ( strchr ( lv_name_this, '/') != NULL) {
      if ( strncmp ( lv_name_this, "/dev/", 5) != 0)
         return -LVM_ELV_CHECK_NAME_LV_NAME;
      if ( ( lv_part = strrchr ( lv_name_this, '/')) == NULL)
         return -LVM_ELV_CHECK_NAME_LV_NAME;
      *lv_part++ = 0;
      if ( strcmp ( lv_part, "group") == 0) return -LVM_ELV_CHECK_NAME_LV_NAME;
      vg_part = &lv_name_this[4];
      *vg_part++ = 0;
      if ( strchr ( vg_part, '/') != NULL)
         return -LVM_ELV_CHECK_NAME_LV_NAME;
      if ( strrchr ( &lv_name_this[1], '/') != NULL)
         return -LVM_ELV_CHECK_NAME_LV_NAME;
      if ( vg_check_name ( vg_part) < 0)
         return -LVM_ELV_CHECK_NAME_VG_NAME;
      if ( strlen ( lv_part) > ( NAME_LEN - 1) / 2)
         return -LVM_ELV_CHECK_NAME_LV_NAME;
   } else if ( strlen ( lv_name) == 0 ||
               strchr ( lv_name, ' ') != NULL ||
               strchr ( lv_name, '\t') != NULL ||
               strchr ( lv_name, '=') != NULL ||
               strcmp ( lv_name, "group") == 0)
             return -LVM_ELV_CHECK_NAME_LV_NAME;

#ifdef DEBUG
   debug ( "lv_check_name -- LEAVING\n");
#endif
   return 0;
}
