/*
 * Author: Heinz Mauelshagen, Germany
 *
 * March,November 1997
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

/*
 * Changelog
 *
 *    11/09/97 - cleanup
 *
 */

#include <liblvm.h>

int lv_check_exist ( char *lv_name) {
   int l = 0;
   int ret = 0;
   vg_t *vg = NULL;

#ifdef DEBUG
   debug ( "lv_check_exist -- CALLED\n");
#endif

   if ( lv_name == NULL || lv_check_name ( lv_name) < 0) return -LVM_EPARAM;

   if ( ( ret = vg_read_with_pv_and_lv ( vg_name_of_lv ( lv_name), &vg)) == 0) {
      ret = FALSE;
      for ( l = 0; l < vg->lv_max; l++) {
         if ( vg->lv[l] != NULL &&
              strcmp ( vg->lv[l]->lv_name, lv_name) == 0) {
            ret = TRUE;
            break;
         }
      }
   }

#ifdef DEBUG
   debug ( "lv_check_exist -- LEAVING\n");
#endif
   return ret;
}
