/*
 * Author: Heinz Mauelshagen, Germany
 *
 * March-June 1997
 *
 * liblvm is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * liblvm is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

#ifndef _LIBLVM_H_INCLUDE
#define _LIBLVM_H_INCLUDE

#ifndef LINUX_VERSION_CODE
#  include <linux/version.h>
   /* for 2.0.x series */
#  ifndef KERNEL_VERSION
#    define KERNEL_VERSION(a,b,c) (((a) << 16) + ((b) << 8) + (c))
#  endif
#endif
#include <linux/version.h>
#include <fcntl.h>
#include <dirent.h>
#include <malloc.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#if LINUX_VERSION_CODE >= KERNEL_VERSION ( 2, 1, 0)
#  define _I386_STAT_H
#endif
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <linux/genhd.h>
#include <linux/major.h>
#include <linux/msdos_fs.h>
#include <lvm.h>


#define	VGCFG_WRITE( handle, what, size, file_name) ( { \
      if ( write ( handle, what, size) != size) { \
         fprintf ( stderr, "%s -- ERROR %d writing volume group backup " \
                           "file %s in %s [line %d]\n", \
                           cmd, errno, file_name, __FILE__, __LINE__); \
         close ( handle); \
         unlink ( file_name); \
         ret = -LVM_EVG_CFGBACKUP_WRITE; \
         goto vg_cfgbackup_end; \
      }; \
} )

#define	VGCFG_READ( handle, what, size, file_name) ( { \
      if ( read ( handle, what, size) != size) { \
         fprintf ( stderr, "%s -- ERROR %d reading volume group backup " \
                           "file %s in %s [ line %d]\n",\
                           cmd, errno, file_name, __FILE__, __LINE__); \
         close ( handle); \
         ret = -LVM_EVG_CFGRESTORE_READ; \
         goto vg_cfgrestore_end; \
      }; \
} )

extern int errno;
extern char *cmd;

#ifdef DEBUG
extern int opt_d;
#endif

/* for lvm_show_size () */
typedef	enum { SHORT, LONG} size_len_t;

/* for pv_check_free () */
typedef	enum {
   NEXT_FREE,
   LINEAR,
   LINEAR_CONTIGUOUS,
   STRIPED,
   STRIPED_CONTIGUOUS}
alloc_t;

/* for lvm_dir_cache () */
typedef struct {
   char *dev_name;
   short st_rdev;
   short st_mode;
} dir_cache_t;


/* VG functions */
int  vg_cfgbackup ( char *, char *, int, vg_t *);
int  vg_cfgrestore ( char *, char *, int, vg_t *);
int  vg_check_active ( char *);
int  vg_check_exist ( char *);
char ** vg_check_exist_all_vg ( void);
int  vg_check_name ( char *);
int  vg_check_consistency ( vg_t *);
int  vg_check_consistency_with_pv_and_lv ( vg_t *);
int  vg_check_online_all_pv ( vg_t*, pv_t***, pv_t***);
int  vg_check_pe_size ( ulong);
char ** vg_check_active_all_vg ( void);
int  vg_create ( char *, vg_t *);
int  vg_create_dir_and_group ( vg_t *);
int  vg_create_dir_and_group_and_nodes ( vg_t *, int);
void vg_deactivate ( char *);
int  vg_extend ( char *, pv_t *, vg_t *);
int  vg_free ( vg_t *, int);
char *vg_name_of_lv ( char *);
int  vg_remove ( char *);
int  vg_read ( char *, vg_t **);
int  vg_read_from_pv ( char *, vg_t **);
int  vg_read_with_pv_and_lv ( char *, vg_t **);
int  vg_reduce ( char *, pv_t *, vg_t *);
int  vg_remove_dir_and_group_and_nodes ( char *);
int  vg_set_extendable ( char*);
int  vg_clear_extendable ( char*);
int  vg_setup_for_create ( char *, vg_t *, pv_t **, int, ulong, ulong);
int  vg_setup_for_extend ( char **, int, pv_t **, vg_t *, char **);
int  vg_setup_for_merge ( vg_t *, vg_t *);
int  vg_setup_for_reduce ( char **, int, vg_t *, pv_t ***, char **);
int  vg_setup_for_split ( vg_t *, char *, vg_t **, char **, char ***, char **);
void vg_show ( vg_t *);
void vg_show_with_pv_and_lv ( vg_t *);
int  vg_write ( char*, pv_t *, vg_t *);
int  vg_write_with_pv_and_lv ( vg_t *);
int  vg_status ( char *, vg_t **);
int  vg_status_get_count ( void);
int  vg_status_get_namelist ( char *);
int  vg_status_with_pv_and_lv ( char *, vg_t **, int);


/* PV functions */
int    pe_lock ( char *, kdev_t, ulong, ushort, ushort);
int    pe_unlock ( char *);
int    pv_change ( char *, pv_t *);
int    pv_change_all_pv_of_vg ( char *, vg_t *);
int    pv_change_all_pv_for_lv_of_vg ( char *, char *, vg_t *);
int    pv_check_active ( char *, char *);
int    pv_check_active_in_all_vg ( char *);
int    pv_check_free ( pv_t *, ulong, ulong *);
int    pv_check_free_contiguous ( pv_t *, ulong, ulong *);
int    pv_check_in_vg ( vg_t *, char *);
int    pv_check_new ( pv_t *);
int    pv_check_consistency ( pv_t *);
int    pv_check_consistency_all_pv ( vg_t *);
int    pv_check_name ( char *);
int    pv_check_number ( pv_t **, int);
int    pv_check_part ( char *);
int    pv_check_volume ( char *, pv_t *);
char   **pv_find_all_pv_names ( void);
kdev_t pv_create_kdev_t ( char *);
char   *pv_create_name_from_kdev_t ( kdev_t);
int    pv_find_vg ( char *, char **);
int    pv_flush ( char *);
int    pv_get_index_by_kdev_t ( vg_t *, kdev_t);
int    pv_get_index_by_name ( vg_t *, char *);
int    pv_get_size ( char *, struct partition *);
int    pv_move_pes ( vg_t*, char*, char**, int, int, int, int);
int    pv_move_pe ( vg_t*, char*, long, long, long, long,
                    int, int, int, int);
int    pv_read ( char *, pv_t **, int *);
int    pv_read_pe ( pv_t *, disk_pe_t **);
int    pv_read_all_pv ( pv_t ***, int);
int    pv_read_all_pv_of_vg ( char *, pv_t ***, int);
int    pv_read_all_pe_of_vg ( char *, disk_pe_t ***, int);
int    pv_read_namelist ( char *, vg_t *, char **);
int    pv_release_pe ( vg_t *, disk_pe_t *, uint *, uint);
int    pv_reserve_pe ( pv_t *, disk_pe_t *, uint *, pe_t *, uint, int);
int    pv_setup_for_create ( char *, pv_t *, uint);
void   pv_show ( pv_t *);
void   pv_show_short ( pv_t *);
void   pv_show_all_pv_of_vg ( vg_t *);
void   pv_show_all_pv_of_vg_short ( vg_t *);
void   pv_show_pe ( pv_t *, disk_pe_t *, int);
int    pv_show_pe_text ( pv_t *, disk_pe_t *, int);
int    pv_status ( char *, char *, pv_t **);
int    pv_status_all_pv_of_vg ( char *, pv_t ***, int);
int    pv_write ( char*, pv_t *);
int    pv_write_all_pv_of_vg ( vg_t *);
int    pv_write_namelist ( char *, vg_t *);
int    pv_write_pe ( char*, pv_t *);
int    pv_write_with_pe ( char*, pv_t *);


/* LV functions */
char   *lv_change_vgname ( char *, char *);
int    lv_check_active ( char *, char *);
int    lv_check_on_pv ( pv_t *, int);
int    lv_check_contiguous ( vg_t *, int);
int    lv_check_consistency ( lv_t *);
int    lv_check_consistency_all_lv ( vg_t *);
int    lv_check_exist ( char *);
int    lv_check_name ( char *);
int    lv_check_stripesize ( int);
int    lv_count_pe ( pv_t *, int);
int    lv_create ( vg_t *, lv_t *, char *);
int    lv_create_name ( char *, char *, int);
int    lv_create_node ( char *, unsigned long, unsigned long);
kdev_t lv_create_kdev_t ( ulong, ulong);
int    lv_extend ( vg_t *, lv_t *, char *);
int    lv_get_index_by_kdev_t ( vg_t *, kdev_t);
int    lv_get_index_by_name ( vg_t *, char *);
int    lv_get_le_on_pv ( pv_t *, int);
char   *lv_get_name ( vg_t*, int);
int    lv_number_from_name_in_vg ( char *, vg_t *);
int    lv_le_remap ( vg_t*, le_remap_req_t*);
int    lv_read ( char *, char *, lv_t **);
int    lv_read_byindex ( char *vg_name, ulong lv_index, lv_t **lv);
int    lv_read_with_pe ( char *, char *, lv_t **);
int    lv_read_all_lv_of_vg ( char *, lv_t ***, int);
int    lv_reduce ( vg_t *, lv_t *, char *);
int    lv_release ( vg_t *, char *);
int    lv_remove ( vg_t *, lv_t *, char *);
int    lv_setup_for_create ( char *, vg_t **, char *, int *,
                             uint, uint, uint, uint, uint, uint, char **);
int    lv_setup_for_extend ( char *, vg_t *, char *, uint, char **);
int    lv_setup_for_reduce ( char *, vg_t *, char *, uint);
void   lv_show ( lv_t *);
void   lv_show_all_lv_of_vg ( vg_t *);
void   lv_show_current_pe ( lv_t *);
int    lv_show_current_pe_text ( lv_t *);
int    lv_status_byname ( char *, char *, lv_t **);
int    lv_status_byindex ( char *, ulong, lv_t **);
int    lv_status_with_pe ( char *, char *, lv_t **);
int    lv_status_all_lv_of_vg ( char *, vg_t *, lv_t ***, int);
int    lv_write ( char *, vg_t *, lv_t *, int);
int    lv_write_all_pv ( vg_t *, int);
int    lv_write_all_lv_of_vg ( char*, vg_t *);


/* print debug info on stderr */
void debug ( const char *, ...);

/* generate nice KB/MB/... strings */
char *lvm_show_size ( unsigned long long, size_len_t);

/* get the basename (no slashes) of a path */
char *basename ( char *);

/* system identifier handling */
int system_id_set ( char *);
int system_id_set_exported ( char *);
int system_id_set_imported ( char *);
int system_id_check_exported ( char *);
int system_id_check_imported ( char *);

/* LVM locking / interrupt masking etc. */
int    lvm_check_dev ( struct stat*, int);
int    lvm_check_number ( char *);
int    lvm_dir_cache ( dir_cache_t**);
int    lvm_show_filetype ( ushort, char*);
int    lvm_lock ( void);
int    lvm_unlock ( void);
void   lvm_interrupt ( void);
void   lvm_dont_interrupt ( int);
ushort lvm_get_iop_version ( void);

/* LVMTAB based functions */
int  lvm_tab_create ( void);
int  lvm_tab_get_free_vg_number ( void);
int  lvm_tab_lv_check_exist ( char *);
int  lvm_tab_vg_insert ( char *);
int  lvm_tab_vg_read_with_pv_and_lv ( char *, vg_t **);
int  lvm_tab_vg_read ( char *, vg_t **);
int  lvm_tab_vg_remove ( char *);
int  lvm_tab_vg_check_exist ( char *, vg_t **);
char **lvm_tab_vg_check_exist_all_vg ( void);


/* return codes */
#define LVM_VG_CFGBACKUP_NO_DIFF                                           100


/* error return codes */
#define LVM_EPARAM                                                          99

#define LVM_ELVM_FIND_VG_REALLOC                                           100
#define LVM_ELVM_IOP_VERSION_OPEN                                          101
#define LVM_ELVM_LOCK_YET_LOCKED                                           102
#define LVM_ELVM_READ_DEV_MAJOR                                            103
#define LVM_ELVM_READ_DEV_OPEN                                             104
#define LVM_ELVM_READ_DEV_RDEV                                             105
#define LVM_ELVM_READ_DEV_READ                                             106
#define LVM_ELVM_READ_DEV_STAT                                             107
#define LVM_ELVM_TAB_CREATE_LVMTAB                                         108
#define LVM_ELVM_TAB_CREATE_LVMTAB_DIR                                     109
#define LVM_ELVM_TAB_GET_FREE_VG_NUMBER_MALLOC                             110
#define LVM_ELVM_TAB_READ_FSTAT                                            111
#define LVM_ELVM_TAB_READ_MALLOC                                           112
#define LVM_ELVM_TAB_READ_OPEN                                             113
#define LVM_ELVM_TAB_READ_PV_CHECK_NAME                                    114
#define LVM_ELVM_TAB_READ_READ                                             115
#define LVM_ELVM_TAB_READ_SIZE                                             116
#define LVM_ELVM_TAB_READ_VG_CHECK_NAME                                    117
#define LVM_ELVM_TAB_STORE_FCHMOD                                          118
#define LVM_ELVM_TAB_STORE_OPEN                                            119
#define LVM_ELVM_TAB_STORE_WRITE                                           120
#define LVM_ELVM_TAB_VG_CHECK_EXIST_ALL_VG_REALLOC                         121
#define LVM_ELVM_TAB_VG_INSERT_REALLOC                                     122
#define LVM_ELVM_TAB_VG_INSERT_VG_EXISTS                                   123
#define LVM_ELVM_TAB_VG_REMOVE_NOT_EXISTS                                  124
#define LVM_ELVM_UNLOCK                                                    125
#define LVM_ELV_ACCESS                                                     126
#define LVM_ELV_ALLOCATED_LE                                               127
#define LVM_ELV_ALLOCATION                                                 128
#define LVM_ELV_BADBLOCK                                                   129
#define LVM_ELV_CHECK_NAME_LV_NAME                                         130
#define LVM_ELV_CHECK_NAME_LV_NUM                                          131
#define LVM_ELV_CHECK_NAME_VG_NAME                                         132
#define LVM_ELV_CHECK_STRIPE_SIZE                                          133
#define LVM_ELV_CREATE_MODE_CHMOD                                          134
#define LVM_ELV_CREATE_MODE_MKNOD                                          135
#define LVM_ELV_CREATE_REMOVE_OPEN                                         136
#define LVM_ELV_CURRENT_LE                                                 137
#define LVM_ELV_DEV                                                        138
#define LVM_ELV_EXTEND_REDUCE_OPEN                                         139
#define LVM_ELV_LE_REMAP_OPEN                                              140
#define LVM_ELV_LVNAME                                                     141
#define LVM_ELV_MIRROR_COPIES                                              142
#define LVM_ELV_OPEN                                                       143
#define LVM_ELV_READ_ALL_LV_OF_VG_LSEEK                                    144
#define LVM_ELV_READ_ALL_LV_OF_VG_MALLOC                                   145
#define LVM_ELV_READ_ALL_LV_OF_VG_NL                                       146
#define LVM_ELV_READ_ALL_LV_OF_VG_OPEN                                     147
#define LVM_ELV_READ_ALL_LV_OF_VG_READ                                     148
#define LVM_ELV_READ_ALL_LV_OF_VG_VGREAD                                   149
#define LVM_ELV_READ_BYINDEX_LV_READ_ALL_LV_OF_VG                          150
#define LVM_ELV_READ_BYINDEX_VGREAD                                        151
#define LVM_ELV_READ_BYINDEX_VG_NAME                                       152
#define LVM_ELV_READ_LV                                                    153
#define LVM_ELV_READ_LV_NAME                                               154
#define LVM_ELV_READ_LV_READ_ALL_LV_OF_VG                                  155
#define LVM_ELV_READ_VGREAD                                                156
#define LVM_ELV_READ_VG_NAME                                               157
#define LVM_ELV_RECOVERY                                                   158
#define LVM_ELV_RELEASE_LV_NUM                                             159
#define LVM_ELV_SCHEDULE                                                   160
#define LVM_ELV_SETUP_FOR_CREATE_LV_MAX                                    161
#define LVM_ELV_SETUP_FOR_CREATE_MALLOC                                    162
#define LVM_ELV_SETUP_FOR_CREATE_PE                                        163
#define LVM_ELV_SETUP_FOR_CREATE_STRIPES                                   164
#define LVM_ELV_SETUP_FOR_CREATE_STRIPESIZE                                165
#define LVM_ELV_SETUP_FOR_EXTEND_LV_INDEX                                  166
#define LVM_ELV_SETUP_FOR_EXTEND_REALLOC                                   167
#define LVM_ELV_SETUP_FOR_EXTEND_STRIPES                                   168
#define LVM_ELV_SETUP_FOR_REDUCE_LV_INDEX                                  169
#define LVM_ELV_SETUP_FOR_REDUCE_MALLOC                                    170
#define LVM_ELV_SHOW_CURRENT_PE_TEXT_LV_INDEX                              171
#define LVM_ELV_SIZE                                                       172
#define LVM_ELV_STATUS                                                     173
#define LVM_ELV_STATUS_ALL_LV_OF_VG_MALLOC                                 174
#define LVM_ELV_STATUS_INTERNAL_OPEN                                       175
#define LVM_ELV_STATUS_NL                                                  176
#define LVM_ELV_STATUS_WITH_PE_MALLOC                                      177
#define LVM_ELV_STORE_ALL_LV_OF_VG_LSEEK                                   178
#define LVM_ELV_STORE_ALL_LV_OF_VG_MALLOC                                  179
#define LVM_ELV_STORE_ALL_LV_OF_VG_OPEN                                    180
#define LVM_ELV_STORE_ALL_LV_OF_VG_WRITE                                   181
#define LVM_ELV_STORE_LSEEK                                                182
#define LVM_ELV_STORE_OPEN                                                 183
#define LVM_ELV_STORE_WRITE                                                184
#define LVM_ELV_STRIPES                                                    185
#define LVM_ELV_STRIPESIZE                                                 186
#define LVM_ELV_TIMEOUT                                                    187
#define LVM_ELV_VGNAME                                                     188
#define LVM_EPE_LOCK                                                       189
#define LVM_EPE_MOVE_LV_LE_REMAP                                           190
#define LVM_EPE_MOVE_PE_LLSEEK_IN                                          191
#define LVM_EPE_MOVE_PE_LLSEEK_OUT                                         192
#define LVM_EPE_MOVE_PE_LOCK                                               193
#define LVM_EPE_MOVE_PE_LV_GET_NAME                                        194
#define LVM_EPE_MOVE_PE_OPEN                                               195
#define LVM_EPE_MOVE_PE_OPEN_IN                                            196
#define LVM_EPE_MOVE_PE_READ_IN                                            197
#define LVM_EPE_MOVE_PE_UNLOCK                                             198
#define LVM_EPE_MOVE_PE_WRITE_OUT                                          199
#define LVM_EPE_MOVE_PV_CHANGE_DEST                                        200
#define LVM_EPE_MOVE_PV_CHANGE_SRC                                         201
#define LVM_EPE_MOVE_PV_PV_STORE_WITH_PE_DEST                              202
#define LVM_EPE_MOVE_PV_PV_STORE_WITH_PE_SRC                               203
#define LVM_EPV_CHANGE_ALL_PV_FOR_LV_OF_VG_LV_NUM                          204
#define LVM_EPV_CHANGE_OPEN                                                205
#define LVM_EPV_CHECK_CONSISTENCY_LVM_ID                                   206
#define LVM_EPV_CHECK_CONSISTENCY_LV_CUR                                   207
#define LVM_EPV_CHECK_CONSISTENCY_MAJOR                                    208
#define LVM_EPV_CHECK_CONSISTENCY_PE_ALLOCATED                             209
#define LVM_EPV_CHECK_CONSISTENCY_PE_SIZE                                  210
#define LVM_EPV_CHECK_CONSISTENCY_PE_STALE                                 211
#define LVM_EPV_CHECK_CONSISTENCY_PE_TOTAL                                 212
#define LVM_EPV_CHECK_CONSISTENCY_PV_ALLOCATABLE                           213
#define LVM_EPV_CHECK_CONSISTENCY_PV_NAME                                  214
#define LVM_EPV_CHECK_CONSISTENCY_PV_SIZE                                  215
#define LVM_EPV_CHECK_CONSISTENCY_PV_STATUS                                216
#define LVM_EPV_CHECK_CONSISTENCY_VG_NAME                                  217
#define LVM_EPV_CHECK_DEV_NAME                                             218
#define LVM_EPV_CHECK_NAME                                                 219
#define LVM_EPV_CHECK_NAME_STAT                                            220
#define LVM_EPV_CHECK_NUMBER_MALLOC                                        221
#define LVM_EPV_CHECK_NUMBER_MAX_NUMBER                                    222
#define LVM_EPV_CHECK_NUMBER_PV_NUMBER                                     223
#define LVM_EPV_CHECK_PART                                                 224
#define LVM_EPV_FIND_ALL_PV_PV_READ                                        225
#define LVM_EPV_FLUSH_OPEN                                                 226
#define LVM_EPV_GET_SIZE_IOCTL                                             227
#define LVM_EPV_GET_SIZE_LLSEEK                                            228
#define LVM_EPV_GET_SIZE_NO_EXTENDED                                       229
#define LVM_EPV_GET_SIZE_NO_PRIMARY                                        230
#define LVM_EPV_GET_SIZE_OPEN                                              231
#define LVM_EPV_GET_SIZE_PART                                              232
#define LVM_EPV_GET_SIZE_READ                                              233
#define LVM_EPV_MOVE_PES_NO_PES                                            234
#define LVM_EPV_MOVE_PES_NO_SPACE                                          235
#define LVM_EPV_MOVE_PES_REALLOC                                           236
#define LVM_EPV_READ_ALL_PE_OF_VG_MALLOC                                   237
#define LVM_EPV_READ_ALL_PE_OF_VG_PV_NUMBER                                238
#define LVM_EPV_READ_ALL_PV_LVM_DIR_CACHE                                  239
#define LVM_EPV_READ_ALL_PV_MALLOC                                         240
#define LVM_EPV_READ_ALL_PV_OF_VG_MALLOC                                   241
#define LVM_EPV_READ_ALL_PV_OF_VG_NP                                       242
#define LVM_EPV_READ_ALL_PV_OF_VG_NP_SORT                                  243
#define LVM_EPV_READ_ALL_PV_OF_VG_PV_NUMBER                                244
#define LVM_EPV_READ_ID_INVALID                                            245
#define LVM_EPV_READ_LVM_STRUCT_VERSION                                    246
#define LVM_EPV_READ_MAJOR                                                 247
#define LVM_EPV_READ_MD_DEVICE                                             248
#define LVM_EPV_READ_NAMELIST_LSEEK                                        249
#define LVM_EPV_READ_NAMELIST_MALLOC                                       250
#define LVM_EPV_READ_NAMELIST_OPEN                                         251
#define LVM_EPV_READ_NAMELIST_READ                                         252
#define LVM_EPV_READ_OPEN                                                  253
#define LVM_EPV_READ_PE_LSEEK                                              254
#define LVM_EPV_READ_PE_MALLOC                                             255
#define LVM_EPV_READ_PE_OPEN                                               256
#define LVM_EPV_READ_PE_READ                                               257
#define LVM_EPV_READ_PE_SIZE                                               258
#define LVM_EPV_READ_PV_EXPORTED                                           259
#define LVM_EPV_READ_PV_FLUSH                                              260
#define LVM_EPV_READ_RDEV                                                  261
#define LVM_EPV_READ_READ                                                  262
#define LVM_EPV_READ_STAT                                                  263
#define LVM_EPV_READ_VG_LSEEK                                              264
#define LVM_EPV_READ_VG_MAJOR                                              265
#define LVM_EPV_READ_VG_OPEN                                               266
#define LVM_EPV_READ_VG_RDEV                                               267
#define LVM_EPV_READ_VG_READ                                               268
#define LVM_EPV_READ_VG_STAT                                               269
#define LVM_EPV_RELEASE_PE_NO_PV                                           270
#define LVM_EPV_RELEASE_PE_REALLOC                                         271
#define LVM_EPV_RESERVE_PE_LV                                              272
#define LVM_EPV_SHOW_PE_TEXT_MALLOC                                        273
#define LVM_EPV_SHOW_PE_TEXT_REALLOC                                       274
#define LVM_EPV_SHOW_PE_TEXT_VG_READ_WITH_PV_AND_LV                        275
#define LVM_EPV_STATUS_ALL_PV_LVM_DIR_CACHE                                276
#define LVM_EPV_STATUS_ALL_PV_OF_VG_MALLOC                                 277
#define LVM_EPV_STATUS_ALL_PV_OF_VG_NP                                     278
#define LVM_EPV_STATUS_OPEN                                                279
#define LVM_EPV_STORE_LSEEK                                                280
#define LVM_EPV_STORE_NAMELIST_LSEEK                                       281
#define LVM_EPV_STORE_NAMELIST_MALLOC                                      282
#define LVM_EPV_STORE_NAMELIST_OPEN                                        283
#define LVM_EPV_STORE_NAMELIST_WRITE                                       284
#define LVM_EPV_STORE_OPEN                                                 285
#define LVM_EPV_STORE_PE_LSEEK                                             286
#define LVM_EPV_STORE_PE_OPEN                                              287
#define LVM_EPV_STORE_PE_SIZE                                              288
#define LVM_EPV_STORE_PE_WRITE                                             289
#define LVM_EPV_STORE_WRITE                                                290
#define LVM_ESIZE                                                          291
#define LVM_ESYSTEM_ID_SET_UNAME                                           292
#define LVM_EVG_CFGBACKUP_FILE_EXISTS                                      293
#define LVM_EVG_CFGBACKUP_MALLOC                                           294
#define LVM_EVG_CFGBACKUP_OPEN                                             295
#define LVM_EVG_CFGBACKUP_READ                                             296
#define LVM_EVG_CFGBACKUP_RENAME                                           297
#define LVM_EVG_CFGBACKUP_TMP_FILE                                         298
#define LVM_EVG_CFGBACKUP_UNLINK                                           299
#define LVM_EVG_CFGBACKUP_VG_CHECK_EXIST                                   300
#define LVM_EVG_CFGBACKUP_VG_READ_WITH_PV_AND_LV                           301
#define LVM_EVG_CFGBACKUP_WRITE                                            302
#define LVM_EVG_CFGRESTORE_FILE_EXISTS                                     303
#define LVM_EVG_CFGRESTORE_LV_CHECK_CONSISTENCY                            304
#define LVM_EVG_CFGRESTORE_MALLOC                                          305
#define LVM_EVG_CFGRESTORE_OPEN                                            306
#define LVM_EVG_CFGRESTORE_PV_CHECK_CONSISTENCY                            307
#define LVM_EVG_CFGRESTORE_READ                                            308
#define LVM_EVG_CFGRESTORE_VG_CHECK_CONSISTENCY                            309
#define LVM_EVG_CFGRESTORE_VG_CHECK_CONSISTENCY_WITH_PV_AND_LV             310
#define LVM_EVG_CHECK_ACTIVE_ALL_VG_COUNT                                  311
#define LVM_EVG_CHECK_ACTIVE_ALL_VG_MALLOC                                 312
#define LVM_EVG_CHECK_ACTIVE_ALL_VG_NAMELIST                               313
#define LVM_EVG_CHECK_CONSISTENCY                                          314
#define LVM_EVG_CHECK_CONSISTENCY_LV_CUR                                   315
#define LVM_EVG_CHECK_CONSISTENCY_MAX_PE_PER_PV                            316
#define LVM_EVG_CHECK_CONSISTENCY_PE_ALLOCATED                             317
#define LVM_EVG_CHECK_CONSISTENCY_PE_TOTAL                                 318
#define LVM_EVG_CHECK_CONSISTENCY_PVG_TOTAL                                319
#define LVM_EVG_CHECK_CONSISTENCY_PV_ACT                                   320
#define LVM_EVG_CHECK_CONSISTENCY_PV_CUR                                   321
#define LVM_EVG_CHECK_CONSISTENCY_SIZE                                     322
#define LVM_EVG_CHECK_CONSISTENCY_VGDA                                     323
#define LVM_EVG_CHECK_CONSISTENCY_VG_ACCESS                                324
#define LVM_EVG_CHECK_CONSISTENCY_VG_NAME                                  325
#define LVM_EVG_CHECK_CONSISTENCY_VG_STATUS                                326
#define LVM_EVG_CHECK_EXIST_PV_COUNT                                       327
#define LVM_EVG_CHECK_NAME                                                 328
#define LVM_EVG_CHECK_ONLINE_ALL_PV                                        329
#define LVM_EVG_CHECK_ONLINE_ALL_PV_MALLOC                                 330
#define LVM_EVG_CHECK_PE_SIZE                                              331
#define LVM_EVG_CREATE_DIR_AND_GROUP_CHMOD_DIR                             332
#define LVM_EVG_CREATE_DIR_AND_GROUP_CHMOD_GROUP                           333
#define LVM_EVG_CREATE_DIR_AND_GROUP_MKDIR                                 334
#define LVM_EVG_CREATE_DIR_AND_GROUP_MKNOD                                 335
#define LVM_EVG_CREATE_REMOVE_OPEN                                         336
#define LVM_EVG_EXTEND_REDUCE_OPEN                                         337
#define LVM_EVG_READ_FROM_PV_CHECK_CONSISTENCY                             338
#define LVM_EVG_READ_FROM_PV_LSEEK                                         339
#define LVM_EVG_READ_FROM_PV_LVM_STRUCT_VERSION                            340
#define LVM_EVG_READ_FROM_PV_OPEN                                          341
#define LVM_EVG_READ_FROM_PV_PV_READ                                       342
#define LVM_EVG_READ_FROM_PV_READ                                          343
#define LVM_EVG_READ_LSEEK                                                 344
#define LVM_EVG_READ_LVM_STRUCT_VERSION                                    345
#define LVM_EVG_READ_OPEN                                                  346
#define LVM_EVG_READ_PV                                                    347
#define LVM_EVG_READ_READ                                                  348
#define LVM_EVG_READ_VG_EXPORTED                                           349
#define LVM_EVG_READ_WITH_PV_AND_LV_LV_ALLOCATED_LE                        350
#define LVM_EVG_READ_WITH_PV_AND_LV_MALLOC                                 351
#define LVM_EVG_READ_WITH_PV_AND_LV_PV_CUR                                 352
#define LVM_EVG_SETUP_FOR_CREATE_MALLOC                                    353
#define LVM_EVG_SETUP_FOR_CREATE_PV_SIZE                                   354
#define LVM_EVG_SETUP_FOR_CREATE_VG_NUMBER                                 355
#define LVM_EVG_SETUP_FOR_EXTEND_MALLOC                                    356
#define LVM_EVG_SETUP_FOR_EXTEND_MAX_PV                                    357
#define LVM_EVG_SETUP_FOR_EXTEND_NO_PV                                     358
#define LVM_EVG_SETUP_FOR_EXTEND_PV_ALLREADY                               359
#define LVM_EVG_SETUP_FOR_EXTEND_PV_CHECK_NAME                             360
#define LVM_EVG_SETUP_FOR_EXTEND_PV_CHECK_NEW                              361
#define LVM_EVG_SETUP_FOR_EXTEND_PV_GET_SIZE                               362
#define LVM_EVG_SETUP_FOR_EXTEND_PV_SIZE                                   363
#define LVM_EVG_SETUP_FOR_EXTEND_PV_SIZE_REL                               364
#define LVM_EVG_SETUP_FOR_MERGE_LV_MAX                                     365
#define LVM_EVG_SETUP_FOR_MERGE_PE_SIZE                                    366
#define LVM_EVG_SETUP_FOR_MERGE_PV_MAX                                     367
#define LVM_EVG_SETUP_FOR_MERGE_VG_CHECK_CONSISTENCY_WITH_PV_AND_LV        368
#define LVM_EVG_SETUP_FOR_REDUCE_LAST_PV                                   369
#define LVM_EVG_SETUP_FOR_REDUCE_LAST_PV_NOT_IN_VG                         370
#define LVM_EVG_SETUP_FOR_REDUCE_LV                                        371
#define LVM_EVG_SETUP_FOR_REDUCE_NO_PV_TO_REDUCE                           372
#define LVM_EVG_SETUP_FOR_REDUCE_PV_INVALID                                373
#define LVM_EVG_SETUP_FOR_REDUCE_REALLOC                                   374
#define LVM_EVG_SETUP_FOR_SPLIT_LV_ON_PV                                   375
#define LVM_EVG_SETUP_FOR_SPLIT_MALLOC                                     376
#define LVM_EVG_SETUP_FOR_SPLIT_PV                                         377
#define LVM_EVG_SETUP_FOR_SPLIT_PV_COUNT                                   378
#define LVM_EVG_SETUP_FOR_SPLIT_VG_NUMBER                                  379
#define LVM_EVG_SET_CLEAR_EXTENDABLE_OPEN                                  380
#define LVM_EVG_STATUS_GET_COUNT_OPEN                                      381
#define LVM_EVG_STATUS_GET_NAMELIST_OPEN                                   382
#define LVM_EVG_STATUS_OPEN                                                383
#define LVM_EVG_STORE_LSEEK                                                384
#define LVM_EVG_STORE_OPEN                                                 385
#define LVM_EVG_STORE_WRITE                                                386

#endif /* #ifndef _LIBLVM_H_INCLUDE */
