/*
 * Author: Heinz Mauelshagen, Germany
 *
 * March,November 1997
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

/*
 * Changelog
 *
 *    1997/11/18 - changed formal parameters in lv_status_all_lv_of_vg to
 *                 avoid another vg_read in there
 *
 */

#include <liblvm.h>

int vg_status ( char *vg_name, vg_t **vg) {
   int group = -1;
   int ret = 0;
   static vg_t vg_this;
   char group_file[NAME_LEN];

#ifdef DEBUG
   debug ( "vg_status -- CALLED\n");
#endif

   if ( vg == NULL ||
        vg_name == NULL ||
        vg_check_name ( vg_name) < 0) return -LVM_EPARA;

   *vg = NULL;

   sprintf ( group_file, "/dev/%s/group%c", vg_name, 0);
   if ( ( group = open ( group_file, O_RDONLY)) == -1)
      ret = -LVM_EVG_STATUS_OPEN;
   else ret = ioctl ( group, VG_STATUS, &vg_this);

   if ( ret == -1) ret = -errno;
   else            *vg = &vg_this;

   if ( group != -1) close ( group);

#ifdef DEBUG
   debug ( "vg_status -- LEAVING\n");
#endif
   return ret;
}


int vg_status_get_count ( void) {
   int count = 0;
   int lvm = -1;
   int ret = 0;

#ifdef DEBUG
   debug ( "vg_status_get_count -- CALLED\n");
#endif

   if ( ( lvm = open ( LVM_DEV, O_RDONLY)) == -1)
      ret = -LVM_EVG_STATUS_GET_COUNT_OPEN;
   else {
      ret = ioctl ( lvm, VG_STATUS_GET_COUNT, &count);
      close ( lvm);
   }

#ifdef DEBUG
   debug ( "vg_status_get_count -- LEAVING\n");
#endif
   if ( ret == 0) return count;
   else           return ret;
}


int vg_status_get_namelist ( char *vg_names) {
   int lvm = -1;
   int ret = 0;

#ifdef DEBUG
   debug ( "vg_status_get_namelist -- CALLED\n");
#endif

   if ( vg_names == NULL) return -LVM_EPARA;

   if ( ( lvm = open ( LVM_DEV, O_RDONLY)) == -1)
      ret = -LVM_EVG_STATUS_GET_NAMELIST_OPEN;
   else {
      ret = ioctl ( lvm, VG_STATUS_GET_NAMELIST, vg_names);
      close ( lvm);
   }

#ifdef DEBUG
   debug ( "vg_status_get_namelist -- LEAVING\n");
#endif
   return ret;
}


int vg_status_with_pv_and_lv ( char *vg_name, vg_t **vg, int reread) {
   int p = 0;
   int l = 0;
   int ret = 0;
   pv_t **pv = NULL;
   lv_t **lv = NULL;

#ifdef DEBUG
   debug ( "vg_status_with_pv_and_lv -- CALLED\n");
#endif

   if ( vg_name == NULL ||
        vg_check_name ( vg_name) < 0 ||
        vg == NULL ||
        ( reread != TRUE && reread != FALSE)) return -LVM_EPARA;

   if ( ( ret = vg_status ( vg_name, vg)) != 0) return ret;
   if ( ( ret = pv_status_all_pv_of_vg ( vg_name, &pv, reread)) != 0)
        return ret;
   if ( ( ret = lv_status_all_lv_of_vg ( vg_name, *vg, &lv, reread)) != 0)
        return ret;

   for ( p = 0; pv[p] != NULL; p++) (*vg)->pv[p] = pv[p];
   (*vg)->pv[p] = NULL;

   for ( l = 0; l < (*vg)->lv_max; l++) {
      if ( lv[l] != NULL) (*vg)->lv[l] = lv[l];
      else                (*vg)->lv[l] = NULL;
   }

#ifdef DEBUG
   debug ( "vg_status_with_pv_and_lv -- LEAVING\n");
#endif
   return 0;
}
