/*
 * Author: Heinz Mauelshagen, Germany
 *
 * May 1997
 * January 1998
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

/*
 *
 * Changelog
 *
 *    01/11/98 - added deletion of volume group special file directory
 *
 */

#include <liblvm.h>

int vg_create_dir_and_group ( vg_t *vg) {
   int ret = 0;
   char name[NAME_LEN];

#ifdef DEBUG
   debug ( "vg_create_dir_and_group -- CALLED\n");
#endif

   if ( vg == NULL || vg_check_name ( vg->vg_name) < 0) return -LVM_EPARA;

   sprintf ( name, "rm -fr /dev/%s%c", vg->vg_name, 0);
   system ( name);
   sprintf ( name, "/dev/%s%c", vg->vg_name, 0);
   if ( mkdir ( name, 0555) == -1) ret = -LVM_EVG_CREATE_DIR_AND_GROUP_MKDIR;
   if ( chmod ( name, 0555) == -1)
      ret = -LVM_EVG_CREATE_DIR_AND_GROUP_CHMOD_DIR;
   strcat ( name, "/group");
   if ( mknod ( name, S_IFCHR,
                ( LVM_MAJOR << LVM_MINORBITS) +
                ( vg->vg_number << VG_BITSHIFT)) == -1)
      ret = -LVM_EVG_CREATE_DIR_AND_GROUP_MKNOD;
   if ( chmod ( name, 0640) == -1) 
      ret = -LVM_EVG_CREATE_DIR_AND_GROUP_CHMOD_GROUP;

#ifdef DEBUG
   debug ( "vg_create_dir_and_group -- LEAVING\n");
#endif
   return ret;
}
