/*
 * Author: Heinz Mauelshagen, Germany (mge@ez-darmstadt.telekom.de)
 *
 * October 1997
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

#include <liblvm.h>

int lv_le_remap ( vg_t *vg, le_remap_req_t *le_remap_req) {
   int group = -1;
   int ret = 0;
   char group_file[NAME_LEN];

#ifdef DEBUG
   debug ( "lv_le_remap -- CALLED\n");
#endif

   if ( vg == NULL || vg_check_name ( vg->vg_name) < 0 ||
        le_remap_req == NULL) return -LVM_EPARA;

   sprintf ( group_file, "/dev/%s/group%c", vg->vg_name, 0);

   if ( ( group = open ( group_file, O_RDWR)) == -1)
      ret = -LVM_ELV_LE_REMAP_OPEN;
   else if ( ioctl ( group, LE_REMAP, le_remap_req) == -1) ret = -errno;

   if ( group != -1) close ( group);

#ifdef DEBUG
   debug ( "lv_le_remap -- LEAVING with ret: %d\n", ret);
#endif
   return ret;
}
