// Raw OS interface implementation -*- C++ -*-

// Copyright (C) 1997-1999 Cygnus Solutions
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING.  If not, write to the Free
// Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

// As a special exception, you may use this file as part of a free software
// library without restriction.  Specifically, if other files instantiate
// templates or use macros or inline functions from this file, or you compile
// this file and link it with other files to produce an executable, this
// file does not by itself cause the resulting executable to be covered by
// the GNU General Public License.  This exception does not however
// invalidate any other reasons why the executable file might be covered by
// the GNU General Public License.

#include <bits/os_raw.h>
#include <bits/std_cstdio.h>
#include <bits/std_cstring.h>

namespace std {
  
  file_type* _S_os_open(const char* __name, ios_base::openmode __mode)
    {
#if 1
      char __flag[4]= "";
      file_type* __retval = NULL;
      __mode &= ~ios_base::ate;
      bool __testb = __mode & ios_base::binary;
      bool __testi = __mode & ios_base::in;
      bool __testo = __mode & ios_base::out;
      bool __testt = __mode & ios_base::trunc;
      bool __testa = __mode & ios_base::app;
      
      if (!__testb)
	{
	  if (!__testi && __testo && !__testt && !__testa)
	    strcpy(__flag, "w");
	  if (!__testi && __testo && !__testt && __testa)
	    strcpy(__flag, "a");
	  if (!__testi && __testo && __testt && !__testa)
	    strcpy(__flag, "w");
	  if (__testi && __testo && !__testt && !__testa)
	    strcpy(__flag, "r");
	  if (__testi && __testo && !__testt && !__testa)
	    strcpy(__flag, "r+");
	  if (__testi && __testo && __testt && !__testa)
	    strcpy(__flag, "w+");
	}
      else
	{
	  if (!__testi && __testo && !__testt && !__testa)
	    strcpy(__flag, "wb");
	  if (!__testi && __testo && !__testt && __testa)
	    strcpy(__flag, "ab");
	  if (!__testi && __testo && __testt && !__testa)
	    strcpy(__flag, "wb");
	  if (__testi && __testo && !__testt && !__testa)
	    strcpy(__flag, "rb");
	  if (__testi && __testo && !__testt && !__testa)
	    strcpy(__flag, "r+b");
	  if (__testi && __testo && __testt && !__testa)
	    strcpy(__flag, "w+b");
	}

      if (*__flag) //iff not bunk, try to open it
	__retval = fopen(__name, __flag);
      
      return __retval;
#else
      // XXX Hack, from old _S_os_raw_open
      int unixflags = 0;
      unixflags = (__mode & ios_base::in) ?  
	((__mode & ios_base::out) ? 
	 (O_RDWR|O_CREAT) : O_RDONLY) : (O_WRONLY|O_CREAT);
      if (__mode & ios_base::app) 
	unixflags |= (O_APPEND|O_CREAT);
      else if (__mode & ios_base::out)
	unixflags |= (O_TRUNC|O_CREAT);
      return ::open(name, unixflags);
#endif
    }

  int _S_os_close(file_type* __file)
    {
      return ::fclose(__file);
    }

  size_t 
  _S_os_read(void* __p, size_t __size, size_t __nmem, file_type* __file)
    {
      return fread(__p, __size, __nmem, __file);
    }
  
  size_t 
  _S_os_write(void* __p, size_t __size, size_t __nmem, file_type* __file)
    {
      return fwrite(__p, __size, __nmem, __file);
    }
  
  int _S_os_seek(file_type* __file, long __off, int __where)
    {
      return fseek(__file, __off, __where);
    }

} // namespace std



