/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import de.hunsicker.antlr.collections.AST;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

final class PackagePrinter
extends AbstractPrinter {
    private static final Printer INSTANCE = new PackagePrinter();

    protected PackagePrinter() {
    }

    public static final Printer getInstance() {
        return INSTANCE;
    }

    public void print(AST node, NodeWriter out) throws IOException {
        this.logIssues(node, out);
        this.printCommentsBefore(node, false, out);
        out.printBlankLines(settings.getInt(ConventionKeys.BLANK_LINES_BEFORE_PACKAGE, 1));
        out.print("package ", 54);
        AST identifier = node.getFirstChild();
        PrinterFactory.create(identifier).print(identifier, out);
        AST semi = identifier.getNextSibling();
        PrinterFactory.create(semi).print(semi, out);
        out.printBlankLines(settings.getInt(ConventionKeys.BLANK_LINES_AFTER_PACKAGE, 1));
        out.last = 20;
    }
}

