/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import de.hunsicker.antlr.collections.AST;
import de.hunsicker.jalopy.language.JavaNode;
import de.hunsicker.jalopy.language.JavaNodeModifier;
import de.hunsicker.jalopy.printer.BasicDeclarationPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.printer.PrinterHelper;
import java.io.IOException;

class InterfaceDeclarationPrinter
extends BasicDeclarationPrinter {
    private static final Printer INSTANCE = new InterfaceDeclarationPrinter();

    protected InterfaceDeclarationPrinter() {
    }

    public static final Printer getInstance() {
        return INSTANCE;
    }

    public void print(AST node, NodeWriter out) throws IOException {
        out.state.innerClass = out.getIndentLength() > 0;
        JavaNode n = (JavaNode)node;
        this.addCommentIfNeeded(n, out);
        super.print(node, out);
        AST modifiers = node.getFirstChild();
        if (JavaNodeModifier.isAbstract(modifiers)) {
            PrinterHelper.removeAbstractModifier(modifiers);
        }
        PrinterFactory.create(modifiers).print(modifiers, out);
        AST keyword = modifiers.getNextSibling();
        this.printCommentsBefore(keyword, false, out);
        out.print("interface ", 81);
        if (this.printCommentsAfter(keyword, false, false, out) && !out.newline) {
            out.print(" ", 153);
        }
        AST identifier = keyword.getNextSibling();
        PrinterFactory.create(identifier).print(identifier, out);
        AST extendsClause = identifier.getNextSibling();
        PrinterFactory.create(extendsClause).print(extendsClause, out);
        out.state.extendsWrappedBefore = false;
        this.printCommentsAfter(node, out);
        AST body = extendsClause.getNextSibling();
        PrinterFactory.create(body).print(body, out);
        out.state.innerClass = false;
        out.last = 19;
    }
}

