/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import de.hunsicker.antlr.collections.AST;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.Marker;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.printer.TestNodeWriter;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

final class ExtendsPrinter
extends AbstractPrinter {
    private static final Printer INSTANCE = new ExtendsPrinter();

    protected ExtendsPrinter() {
    }

    public static final Printer getInstance() {
        return INSTANCE;
    }

    public void print(AST node, NodeWriter out) throws IOException {
        AST first = node.getFirstChild();
        if (first != null) {
            boolean forceWrapping;
            boolean wrapAll;
            boolean wrapLines = settings.getBoolean(ConventionKeys.LINE_WRAP, true) && out.mode == 1;
            int lineLength = settings.getInt(ConventionKeys.LINE_LENGTH, 80);
            boolean newlineBefore = settings.getBoolean(ConventionKeys.LINE_WRAP_BEFORE_EXTENDS, false);
            int indentSize = settings.getInt(ConventionKeys.INDENT_SIZE_EXTENDS, -1);
            boolean indentCustom = indentSize > -1;
            boolean wrappedBefore = false;
            if (out.newline || newlineBefore || wrapLines && out.column + 8 + first.getText().length() > lineLength) {
                wrappedBefore = true;
                out.state.extendsWrappedBefore = true;
                if (!out.newline) {
                    out.printNewline();
                }
                if (indentCustom) {
                    out.print(out.getString(indentSize), 153);
                    out.print("extends ", 80);
                } else {
                    out.indent();
                    out.print("extends ", 80);
                }
            } else {
                out.print(" extends ", 80);
            }
            TestNodeWriter tester = null;
            boolean bl = wrapAll = settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_TYPES_EXTENDS_EXCEED, false) && out.mode == 1;
            if (wrapLines || wrapAll) {
                tester = out.testers.get();
            }
            if (!(forceWrapping = settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_TYPES_EXTENDS, false)) && wrapAll) {
                if (wrappedBefore) {
                    forceWrapping = true;
                } else {
                    PrinterFactory.create(node).print(node, tester);
                    if (tester.length - 8 + out.column > lineLength) {
                        forceWrapping = true;
                    }
                    tester.reset();
                }
            }
            boolean indentDeep = settings.getBoolean(ConventionKeys.INDENT_DEEP, false);
            String comma = settings.getBoolean(ConventionKeys.SPACE_AFTER_COMMA, true) ? ", " : ",";
            boolean wrappedAfter = false;
            Marker marker = out.state.markers.add();
            for (AST child = first; child != null; child = child.getNextSibling()) {
                PrinterFactory.create(child).print(child, out);
                AST next = child.getNextSibling();
                if (next == null) continue;
                if (forceWrapping) {
                    out.print(",", 82);
                    out.printNewline();
                    if (!wrappedAfter) {
                        wrappedAfter = true;
                        if (!indentDeep) {
                            out.indent();
                        }
                    }
                    if (indentCustom && wrappedBefore) {
                        this.printIndentation(indentSize, out);
                        continue;
                    }
                    this.printIndentation(out);
                    continue;
                }
                if (wrapLines) {
                    PrinterFactory.create(next).print(next, tester);
                    if (tester.length + out.column > lineLength) {
                        out.print(",", 82);
                        out.printNewline();
                        if (!wrappedAfter) {
                            wrappedAfter = true;
                            if (!indentDeep) {
                                out.indent();
                            }
                        }
                        if (indentCustom && wrappedBefore) {
                            this.printIndentation(indentSize, out);
                        } else {
                            this.printIndentation(out);
                        }
                    } else {
                        out.print(comma, 82);
                    }
                    tester.reset();
                    continue;
                }
                out.print(comma, 82);
            }
            if (wrapLines) {
                out.testers.release(tester);
            }
            out.state.markers.remove(marker);
            if (wrappedBefore && !indentCustom) {
                out.unindent();
            }
            if (wrappedAfter && !indentDeep) {
                out.unindent();
            }
            if (settings.getBoolean(ConventionKeys.BRACE_TREAT_DIFFERENT_IF_WRAPPED, false) && (wrappedBefore || wrappedAfter)) {
                out.state.newlineBeforeLeftBrace = true;
            }
        }
    }
}

