/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import de.hunsicker.antlr.collections.AST;
import de.hunsicker.jalopy.language.JavaNode;
import de.hunsicker.jalopy.printer.BlockStatementPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

final class DoWhilePrinter
extends BlockStatementPrinter {
    private static final Printer INSTANCE = new DoWhilePrinter();

    protected DoWhilePrinter() {
    }

    public static final Printer getInstance() {
        return INSTANCE;
    }

    public void print(AST node, NodeWriter out) throws IOException {
        super.print(node, out);
        int offset = out.print("do", 68);
        this.trackPosition((JavaNode)node, out.line, offset, out);
        this.printCommentsAfter(node, out);
        AST body = node.getFirstChild();
        switch (body.getType()) {
            case 11: {
                out.last = 96;
                PrinterFactory.create(body).print(body, out);
                break;
            }
            default: {
                if (settings.getBoolean(ConventionKeys.BRACE_INSERT_DO_WHILE, false)) {
                    out.printLeftBrace(settings.getBoolean(ConventionKeys.BRACE_NEWLINE_LEFT, false), true);
                    out.last = 68;
                    PrinterFactory.create(body).print(body, out);
                    out.printRightBrace(settings.getBoolean(ConventionKeys.BRACE_NEWLINE_RIGHT, false));
                    break;
                }
                out.printNewline();
                out.indent();
                out.last = 68;
                PrinterFactory.create(body).print(body, out);
                out.unindent();
            }
        }
        if (out.last == 8) {
            out.print(out.getString(settings.getInt(ConventionKeys.INDENT_SIZE_BRACE_RIGHT_AFTER, 1)), 153);
        }
        AST keyword = body.getNextSibling();
        this.printCommentsBefore(keyword, false, out);
        offset = out.print("while", 95);
        this.trackPosition((JavaNode)keyword, out.line, offset, out);
        if (settings.getBoolean(ConventionKeys.SPACE_BEFORE_STATEMENT_PAREN, true)) {
            out.print(" ", 95);
        }
        AST lparen = keyword.getNextSibling();
        JavaNode rparen = this.printExpressionList(lparen, false, out);
        AST semi = rparen.getNextSibling();
        PrinterFactory.create(semi).print(semi, out);
        out.last = 8;
    }
}

