/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.antlr;

import de.hunsicker.antlr.CodeGenerator;
import de.hunsicker.antlr.CommonToken;
import de.hunsicker.antlr.GrammarSymbol;
import de.hunsicker.antlr.LLkGrammarAnalyzer;
import de.hunsicker.antlr.RuleSymbol;
import de.hunsicker.antlr.Token;
import de.hunsicker.antlr.TokenManager;
import de.hunsicker.antlr.Tool;
import de.hunsicker.antlr.collections.impl.Vector;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class Grammar {
    protected Tool antlrTool;
    protected CodeGenerator generator;
    protected LLkGrammarAnalyzer theLLkAnalyzer;
    protected Hashtable symbols;
    protected boolean buildAST = false;
    protected boolean analyzerDebug = false;
    protected boolean interactive = false;
    protected String superClass = null;
    protected TokenManager tokenManager;
    protected String exportVocab = null;
    protected String importVocab = null;
    protected Hashtable options;
    protected Vector rules;
    protected Token preambleAction = new CommonToken(0, "");
    protected String className = null;
    protected String fileName = null;
    protected Token classMemberAction = new CommonToken(0, "");
    protected boolean hasSyntacticPredicate = false;
    protected boolean hasUserErrorHandling = false;
    protected int maxk = 1;
    protected boolean traceRules = false;
    protected boolean debuggingOutput = false;
    protected boolean defaultErrorHandler = true;
    protected String comment = null;

    public Grammar(String className_, Tool tool_, String superClass) {
        this.className = className_;
        this.antlrTool = tool_;
        this.symbols = new Hashtable();
        this.options = new Hashtable();
        this.rules = new Vector(100);
        this.superClass = superClass;
    }

    public void define(RuleSymbol rs) {
        this.rules.appendElement(rs);
        this.symbols.put(rs.getId(), rs);
    }

    public abstract void generate() throws IOException;

    protected String getClassName() {
        return this.className;
    }

    public boolean getDefaultErrorHandler() {
        return this.defaultErrorHandler;
    }

    public String getFilename() {
        return this.fileName;
    }

    public int getIntegerOption(String key) throws NumberFormatException {
        Token t = (Token)this.options.get(key);
        if (t == null || t.getType() != 20) {
            throw new NumberFormatException();
        }
        return Integer.parseInt(t.getText());
    }

    public Token getOption(String key) {
        return (Token)this.options.get(key);
    }

    protected abstract String getSuperClass();

    public GrammarSymbol getSymbol(String s) {
        return (GrammarSymbol)this.symbols.get(s);
    }

    public Enumeration getSymbols() {
        return this.symbols.elements();
    }

    public boolean hasOption(String key) {
        return this.options.containsKey(key);
    }

    public boolean isDefined(String s) {
        return this.symbols.containsKey(s);
    }

    public abstract void processArguments(String[] var1);

    public void setCodeGenerator(CodeGenerator gen) {
        this.generator = gen;
    }

    public void setFilename(String s) {
        this.fileName = s;
    }

    public void setGrammarAnalyzer(LLkGrammarAnalyzer a) {
        this.theLLkAnalyzer = a;
    }

    public boolean setOption(String key, Token value) {
        this.options.put(key, value);
        String s = value.getText();
        if (key.equals("k")) {
            try {
                this.maxk = this.getIntegerOption("k");
            }
            catch (NumberFormatException e) {
                this.antlrTool.error("option 'k' must be an integer (was " + value.getText() + ")", this.getFilename(), value.getLine(), value.getColumn());
            }
            return true;
        }
        if (key.equals("codeGenMakeSwitchThreshold")) {
            try {
                int i = this.getIntegerOption("codeGenMakeSwitchThreshold");
            }
            catch (NumberFormatException e) {
                this.antlrTool.error("option 'codeGenMakeSwitchThreshold' must be an integer", this.getFilename(), value.getLine(), value.getColumn());
            }
            return true;
        }
        if (key.equals("codeGenBitsetTestThreshold")) {
            try {
                int i = this.getIntegerOption("codeGenBitsetTestThreshold");
            }
            catch (NumberFormatException e) {
                this.antlrTool.error("option 'codeGenBitsetTestThreshold' must be an integer", this.getFilename(), value.getLine(), value.getColumn());
            }
            return true;
        }
        if (key.equals("defaultErrorHandler")) {
            if (s.equals("true")) {
                this.defaultErrorHandler = true;
            } else if (s.equals("false")) {
                this.defaultErrorHandler = false;
            } else {
                this.antlrTool.error("Value for defaultErrorHandler must be true or false", this.getFilename(), value.getLine(), value.getColumn());
            }
            return true;
        }
        if (key.equals("analyzerDebug")) {
            if (s.equals("true")) {
                this.analyzerDebug = true;
            } else if (s.equals("false")) {
                this.analyzerDebug = false;
            } else {
                this.antlrTool.error("option 'analyzerDebug' must be true or false", this.getFilename(), value.getLine(), value.getColumn());
            }
            return true;
        }
        if (key.equals("codeGenDebug")) {
            if (s.equals("true")) {
                this.analyzerDebug = true;
            } else if (s.equals("false")) {
                this.analyzerDebug = false;
            } else {
                this.antlrTool.error("option 'codeGenDebug' must be true or false", this.getFilename(), value.getLine(), value.getColumn());
            }
            return true;
        }
        if (key.equals("classHeaderSuffix")) {
            return true;
        }
        if (key.equals("namespaceAntlr")) {
            return true;
        }
        if (key.equals("namespaceStd")) {
            return true;
        }
        if (key.equals("genHashLines")) {
            return true;
        }
        return key.equals("useTokenPrefix");
    }

    public void setTokenManager(TokenManager tokenManager_) {
        this.tokenManager = tokenManager_;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(20000);
        Enumeration ids = this.rules.elements();
        while (ids.hasMoreElements()) {
            RuleSymbol rs = (RuleSymbol)ids.nextElement();
            if (rs.id.equals("mnextToken")) continue;
            buf.append(rs.getBlock().toString());
            buf.append("\n\n");
        }
        return buf.toString();
    }
}

