/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.antlr;

import de.hunsicker.antlr.ANTLRLexer;
import de.hunsicker.antlr.ActionElement;
import de.hunsicker.antlr.ActionTransInfo;
import de.hunsicker.antlr.Alternative;
import de.hunsicker.antlr.AlternativeBlock;
import de.hunsicker.antlr.AlternativeElement;
import de.hunsicker.antlr.BlockEndElement;
import de.hunsicker.antlr.CharLiteralElement;
import de.hunsicker.antlr.CharRangeElement;
import de.hunsicker.antlr.CharStreamException;
import de.hunsicker.antlr.CodeGenerator;
import de.hunsicker.antlr.CppBlockFinishingInfo;
import de.hunsicker.antlr.CppCharFormatter;
import de.hunsicker.antlr.ExceptionHandler;
import de.hunsicker.antlr.ExceptionSpec;
import de.hunsicker.antlr.Grammar;
import de.hunsicker.antlr.GrammarAtom;
import de.hunsicker.antlr.GrammarElement;
import de.hunsicker.antlr.GrammarSymbol;
import de.hunsicker.antlr.LexerGrammar;
import de.hunsicker.antlr.Lookahead;
import de.hunsicker.antlr.MakeGrammar;
import de.hunsicker.antlr.NameSpace;
import de.hunsicker.antlr.OneOrMoreBlock;
import de.hunsicker.antlr.ParserGrammar;
import de.hunsicker.antlr.RecognitionException;
import de.hunsicker.antlr.RuleBlock;
import de.hunsicker.antlr.RuleRefElement;
import de.hunsicker.antlr.RuleSymbol;
import de.hunsicker.antlr.StringLiteralElement;
import de.hunsicker.antlr.StringLiteralSymbol;
import de.hunsicker.antlr.StringUtils;
import de.hunsicker.antlr.SynPredBlock;
import de.hunsicker.antlr.Token;
import de.hunsicker.antlr.TokenManager;
import de.hunsicker.antlr.TokenRangeElement;
import de.hunsicker.antlr.TokenRefElement;
import de.hunsicker.antlr.TokenStreamException;
import de.hunsicker.antlr.TokenSymbol;
import de.hunsicker.antlr.Tool;
import de.hunsicker.antlr.TreeElement;
import de.hunsicker.antlr.TreeWalkerGrammar;
import de.hunsicker.antlr.WildcardElement;
import de.hunsicker.antlr.ZeroOrMoreBlock;
import de.hunsicker.antlr.actions.cpp.ActionLexer;
import de.hunsicker.antlr.collections.impl.BitSet;
import de.hunsicker.antlr.collections.impl.Vector;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;

public class CppCodeGenerator
extends CodeGenerator {
    protected int syntacticPredLevel = 0;
    protected boolean genAST = false;
    protected boolean saveText = false;
    protected boolean genHashLines = true;
    protected int outputLine;
    protected String outputFile;
    boolean usingCustomAST = false;
    String labeledElementType;
    String labeledElementASTType;
    String labeledElementASTInit;
    String labeledElementInit;
    String commonExtraArgs;
    String commonExtraParams;
    String commonLocalVars;
    String lt1Value;
    String exceptionThrown;
    String throwNoViable;
    RuleBlock currentRule;
    String currentASTResult;
    Hashtable treeVariableMap = new Hashtable();
    HashSet declaredASTVariables = new HashSet();
    int astVarNumber = 1;
    protected static final String NONUNIQUE = new String();
    public static final int caseSizeThreshold = 127;
    private Vector semPreds;
    private Vector astTypes;
    private static String namespaceStd = "ANTLR_USE_NAMESPACE(std)";
    private static String namespaceAntlr = "ANTLR_USE_NAMESPACE(antlr)";
    private static NameSpace nameSpace = null;
    private static final String preIncludeCpp = "pre_include_cpp";
    private static final String preIncludeHpp = "pre_include_hpp";
    private static final String postIncludeCpp = "post_include_cpp";
    private static final String postIncludeHpp = "post_include_hpp";

    public CppCodeGenerator() {
        this.charFormatter = new CppCharFormatter();
    }

    protected int addSemPred(String predicate) {
        this.semPreds.appendElement(predicate);
        return this.semPreds.size() - 1;
    }

    public void exitIfError() {
        if (this.antlrTool.hasError()) {
            System.out.println("Exiting due to errors.");
            System.exit(1);
        }
    }

    protected int countLines(String s) {
        int lines = 0;
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == '\n') {
                ++lines;
            }
            ++i;
        }
        return lines;
    }

    protected void _print(String s) {
        if (s != null) {
            this.outputLine += this.countLines(s);
            this.currentOutput.print(s);
        }
    }

    protected void _printAction(String s) {
        if (s != null) {
            this.outputLine += this.countLines(s) + 1;
            super._printAction(s);
        }
    }

    public void printAction(Token t) {
        if (t != null) {
            this.genLineNo(t.getLine());
            this.printTabs();
            this._printAction(this.processActionForTreeSpecifiers(t.getText(), t.getLine(), null, null));
            this.genLineNo2();
        }
    }

    public void printHeaderAction(String name) {
        Token a = (Token)this.behavior.headerActions.get(name);
        if (a != null) {
            this.genLineNo(a.getLine());
            this.println(this.processActionForTreeSpecifiers(a.getText(), a.getLine(), null, null));
            this.genLineNo2();
        }
    }

    protected void _println(String s) {
        if (s != null) {
            this.outputLine += this.countLines(s) + 1;
            this.currentOutput.println(s);
        }
    }

    protected void println(String s) {
        if (s != null) {
            this.printTabs();
            this.outputLine += this.countLines(s) + 1;
            this.currentOutput.println(s);
        }
    }

    public void genLineNo(int line) {
        if (line == 0) {
            ++line;
        }
        if (this.genHashLines) {
            this._println("#line " + line + " \"" + this.antlrTool.fileMinusPath(this.antlrTool.grammarFile) + "\"");
        }
    }

    public void genLineNo(GrammarElement el) {
        if (el != null) {
            this.genLineNo(el.getLine());
        }
    }

    public void genLineNo(Token t) {
        if (t != null) {
            this.genLineNo(t.getLine());
        }
    }

    public void genLineNo2() {
        if (this.genHashLines) {
            this._println("#line " + (this.outputLine + 1) + " \"" + this.outputFile + "\"");
        }
    }

    public void gen() {
        try {
            Enumeration grammarIter = this.behavior.grammars.elements();
            while (grammarIter.hasMoreElements()) {
                Grammar g = (Grammar)grammarIter.nextElement();
                g.setGrammarAnalyzer(this.analyzer);
                g.setCodeGenerator(this);
                this.analyzer.setGrammar(g);
                this.setupGrammarParameters(g);
                g.generate();
                this.exitIfError();
            }
            Enumeration tmIter = this.behavior.tokenManagers.elements();
            while (tmIter.hasMoreElements()) {
                TokenManager tm = (TokenManager)tmIter.nextElement();
                if (!tm.isReadOnly()) {
                    this.genTokenTypes(tm);
                    this.genTokenInterchange(tm);
                }
                this.exitIfError();
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    public void gen(ActionElement action) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genAction(" + action + ")");
        }
        if (action.isSemPred) {
            this.genSemPred(action.actionText, action.line);
        } else {
            if (this.grammar.hasSyntacticPredicate) {
                this.println("if ( inputState->guessing==0 ) {");
                ++this.tabs;
            }
            ActionTransInfo tInfo = new ActionTransInfo();
            String actionStr = this.processActionForTreeSpecifiers(action.actionText, action.getLine(), this.currentRule, tInfo);
            if (tInfo.refRuleRoot != null) {
                this.println(tInfo.refRuleRoot + " = " + this.labeledElementASTType + "(currentAST.root);");
            }
            this.genLineNo(action);
            this.printAction(actionStr);
            this.genLineNo2();
            if (tInfo.assignToRoot) {
                this.println("currentAST.root = " + tInfo.refRuleRoot + ";");
                this.println("if ( " + tInfo.refRuleRoot + "!=" + this.labeledElementASTInit + " &&");
                ++this.tabs;
                this.println(tInfo.refRuleRoot + "->getFirstChild() != " + this.labeledElementASTInit + " )");
                this.println("  currentAST.child = " + tInfo.refRuleRoot + "->getFirstChild();");
                --this.tabs;
                this.println("else");
                ++this.tabs;
                this.println("currentAST.child = " + tInfo.refRuleRoot + ";");
                --this.tabs;
                this.println("currentAST.advanceChildToEnd();");
            }
            if (this.grammar.hasSyntacticPredicate) {
                --this.tabs;
                this.println("}");
            }
        }
    }

    public void gen(AlternativeBlock blk) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("gen(" + blk + ")");
        }
        this.println("{");
        this.genBlockPreamble(blk);
        this.genBlockInitAction(blk);
        String saveCurrentASTResult = this.currentASTResult;
        if (blk.getLabel() != null) {
            this.currentASTResult = blk.getLabel();
        }
        boolean ok = this.grammar.theLLkAnalyzer.deterministic(blk);
        CppBlockFinishingInfo howToFinish = this.genCommonBlock(blk, true);
        this.genBlockFinish(howToFinish, this.throwNoViable);
        this.println("}");
        this.currentASTResult = saveCurrentASTResult;
    }

    public void gen(BlockEndElement end) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genRuleEnd(" + end + ")");
        }
    }

    public void gen(CharLiteralElement atom) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genChar(" + atom + ")");
        }
        if (atom.getLabel() != null) {
            this.println(atom.getLabel() + " = " + this.lt1Value + ";");
        }
        boolean oldsaveText = this.saveText;
        this.saveText = this.saveText && atom.getAutoGenType() == 1;
        this.genMatch(atom);
        this.saveText = oldsaveText;
    }

    public void gen(CharRangeElement r) {
        boolean save;
        if (r.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(r.getLabel() + " = " + this.lt1Value + ";");
        }
        boolean bl = save = this.grammar instanceof LexerGrammar && (!this.saveText || r.getAutoGenType() == 3);
        if (save) {
            this.println("_saveIndex=text.length();");
        }
        this.println("matchRange(" + this.textOrChar(r.beginText) + "," + this.textOrChar(r.endText) + ");");
        if (save) {
            this.println("text.setLength(_saveIndex);");
        }
    }

    public void gen(LexerGrammar g) throws IOException {
        if (g.debuggingOutput) {
            this.semPreds = new Vector();
        }
        this.setGrammar(g);
        if (!(this.grammar instanceof LexerGrammar)) {
            this.antlrTool.panic("Internal error generating lexer");
        }
        this.genBody(g);
        this.genInclude(g);
    }

    public void gen(OneOrMoreBlock blk) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("gen+(" + blk + ")");
        }
        this.println("{ // ( ... )+");
        this.genBlockPreamble(blk);
        String cnt = blk.getLabel() != null ? "_cnt_" + blk.getLabel() : "_cnt" + blk.ID;
        this.println("int " + cnt + "=0;");
        String label = blk.getLabel() != null ? blk.getLabel() : "_loop" + blk.ID;
        this.println("for (;;) {");
        ++this.tabs;
        this.genBlockInitAction(blk);
        String saveCurrentASTResult = this.currentASTResult;
        if (blk.getLabel() != null) {
            this.currentASTResult = blk.getLabel();
        }
        boolean ok = this.grammar.theLLkAnalyzer.deterministic(blk);
        boolean generateNonGreedyExitPath = false;
        int nonGreedyExitDepth = this.grammar.maxk;
        if (!blk.greedy && blk.exitLookaheadDepth <= this.grammar.maxk && blk.exitCache[blk.exitLookaheadDepth].containsEpsilon()) {
            generateNonGreedyExitPath = true;
            nonGreedyExitDepth = blk.exitLookaheadDepth;
        } else if (!blk.greedy && blk.exitLookaheadDepth == Integer.MAX_VALUE) {
            generateNonGreedyExitPath = true;
        }
        if (generateNonGreedyExitPath) {
            if (this.DEBUG_CODE_GENERATOR) {
                System.out.println("nongreedy (...)+ loop; exit depth is " + blk.exitLookaheadDepth);
            }
            String predictExit = this.getLookaheadTestExpression(blk.exitCache, nonGreedyExitDepth);
            this.println("// nongreedy exit test");
            this.println("if ( " + cnt + ">=1 && " + predictExit + ") goto " + label + ";");
        }
        CppBlockFinishingInfo howToFinish = this.genCommonBlock(blk, false);
        this.genBlockFinish(howToFinish, "if ( " + cnt + ">=1 ) { goto " + label + "; } else {" + this.throwNoViable + "}");
        this.println(cnt + "++;");
        --this.tabs;
        this.println("}");
        this.println(label + ":;");
        this.println("}  // ( ... )+");
        this.currentASTResult = saveCurrentASTResult;
    }

    public void gen(ParserGrammar g) throws IOException {
        if (g.debuggingOutput) {
            this.semPreds = new Vector();
        }
        this.setGrammar(g);
        if (!(this.grammar instanceof ParserGrammar)) {
            this.antlrTool.panic("Internal error generating parser");
        }
        this.genBody(g);
        this.genInclude(g);
    }

    public void gen(RuleRefElement rr) {
        RuleSymbol rs;
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genRR(" + rr + ")");
        }
        if ((rs = (RuleSymbol)this.grammar.getSymbol(rr.targetRule)) == null || !rs.isDefined()) {
            this.antlrTool.error("Rule '" + rr.targetRule + "' is not defined", this.grammar.getFilename(), rr.getLine(), rr.getColumn());
            return;
        }
        if (!(rs instanceof RuleSymbol)) {
            this.antlrTool.error("'" + rr.targetRule + "' does not name a grammar rule", this.grammar.getFilename(), rr.getLine(), rr.getColumn());
            return;
        }
        this.genErrorTryForElement(rr);
        if (this.grammar instanceof TreeWalkerGrammar && rr.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(rr.getLabel() + " = (_t == ASTNULL) ? " + this.labeledElementASTInit + " : " + this.lt1Value + ";");
        }
        if (this.grammar instanceof LexerGrammar && (!this.saveText || rr.getAutoGenType() == 3)) {
            this.println("_saveIndex = text.length();");
        }
        this.printTabs();
        if (rr.idAssign != null) {
            if (rs.block.returnAction == null) {
                this.antlrTool.warning("Rule '" + rr.targetRule + "' has no return type", this.grammar.getFilename(), rr.getLine(), rr.getColumn());
            }
            this._print(rr.idAssign + "=");
        } else if (!(this.grammar instanceof LexerGrammar) && this.syntacticPredLevel == 0 && rs.block.returnAction != null) {
            this.antlrTool.warning("Rule '" + rr.targetRule + "' returns a value", this.grammar.getFilename(), rr.getLine(), rr.getColumn());
        }
        this.GenRuleInvocation(rr);
        if (this.grammar instanceof LexerGrammar && (!this.saveText || rr.getAutoGenType() == 3)) {
            this.println("text.erase(_saveIndex);");
        }
        if (this.syntacticPredLevel == 0) {
            boolean doNoGuessTest;
            boolean bl = doNoGuessTest = this.grammar.hasSyntacticPredicate && (this.grammar.buildAST && rr.getLabel() != null || this.genAST && rr.getAutoGenType() == 1);
            if (doNoGuessTest) {
                this.println("if (inputState->guessing==0) {");
                ++this.tabs;
            }
            if (this.grammar.buildAST && rr.getLabel() != null) {
                this.println(rr.getLabel() + "_AST = returnAST;");
            }
            if (this.genAST) {
                switch (rr.getAutoGenType()) {
                    case 1: {
                        if (this.usingCustomAST) {
                            this.println("astFactory->addASTChild(currentAST, static_cast<" + namespaceAntlr + "RefAST>(returnAST));");
                            break;
                        }
                        this.println("astFactory->addASTChild( currentAST, returnAST );");
                        break;
                    }
                    case 2: {
                        this.antlrTool.error("Internal: encountered ^ after rule reference");
                        break;
                    }
                }
            }
            if (this.grammar instanceof LexerGrammar && rr.getLabel() != null) {
                this.println(rr.getLabel() + "=_returnToken;");
            }
            if (doNoGuessTest) {
                --this.tabs;
                this.println("}");
            }
        }
        this.genErrorCatchForElement(rr);
    }

    public void gen(StringLiteralElement atom) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genString(" + atom + ")");
        }
        if (atom.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(atom.getLabel() + " = " + this.lt1Value + ";");
        }
        this.genElementAST(atom);
        boolean oldsaveText = this.saveText;
        this.saveText = this.saveText && atom.getAutoGenType() == 1;
        this.genMatch(atom);
        this.saveText = oldsaveText;
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("_t = _t->getNextSibling();");
        }
    }

    public void gen(TokenRangeElement r) {
        this.genErrorTryForElement(r);
        if (r.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(r.getLabel() + " = " + this.lt1Value + ";");
        }
        this.genElementAST(r);
        this.println("matchRange(" + r.beginText + "," + r.endText + ");");
        this.genErrorCatchForElement(r);
    }

    public void gen(TokenRefElement atom) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genTokenRef(" + atom + ")");
        }
        if (this.grammar instanceof LexerGrammar) {
            this.antlrTool.panic("Token reference found in lexer");
        }
        this.genErrorTryForElement(atom);
        if (atom.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(atom.getLabel() + " = " + this.lt1Value + ";");
        }
        this.genElementAST(atom);
        this.genMatch(atom);
        this.genErrorCatchForElement(atom);
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("_t = _t->getNextSibling();");
        }
    }

    public void gen(TreeElement t) {
        this.println(this.labeledElementType + " __t" + t.ID + " = _t;");
        if (t.root.getLabel() != null) {
            this.println(t.root.getLabel() + " = (_t == ASTNULL) ? " + this.labeledElementASTInit + " : _t;");
        }
        if (t.root.getAutoGenType() == 3) {
            this.antlrTool.error("Suffixing a root node with '!' is not implemented", this.grammar.getFilename(), t.getLine(), t.getColumn());
            t.root.setAutoGenType(1);
        }
        if (t.root.getAutoGenType() == 2) {
            this.antlrTool.warning("Suffixing a root node with '^' is redundant; already a root", this.grammar.getFilename(), t.getLine(), t.getColumn());
            t.root.setAutoGenType(1);
        }
        this.genElementAST(t.root);
        if (this.grammar.buildAST) {
            this.println(namespaceAntlr + "ASTPair __currentAST" + t.ID + " = currentAST;");
            this.println("currentAST.root = currentAST.child;");
            this.println("currentAST.child = " + this.labeledElementASTInit + ";");
        }
        if (t.root instanceof WildcardElement) {
            this.println("if ( _t == ASTNULL ) throw MismatchedTokenException();");
        } else {
            this.genMatch(t.root);
        }
        this.println("_t = _t->getFirstChild();");
        int i = 0;
        while (i < t.getAlternatives().size()) {
            Alternative a = t.getAlternativeAt(i);
            AlternativeElement e = a.head;
            while (e != null) {
                e.generate();
                e = e.next;
            }
            ++i;
        }
        if (this.grammar.buildAST) {
            this.println("currentAST = __currentAST" + t.ID + ";");
        }
        this.println("_t = __t" + t.ID + ";");
        this.println("_t = _t->getNextSibling();");
    }

    public void gen(TreeWalkerGrammar g) throws IOException {
        this.setGrammar(g);
        if (!(this.grammar instanceof TreeWalkerGrammar)) {
            this.antlrTool.panic("Internal error generating tree-walker");
        }
        this.genBody(g);
        this.genInclude(g);
    }

    public void gen(WildcardElement wc) {
        if (wc.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(wc.getLabel() + " = " + this.lt1Value + ";");
        }
        this.genElementAST(wc);
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("if ( _t == " + this.labeledElementASTInit + " ) throw " + namespaceAntlr + "MismatchedTokenException();");
        } else if (this.grammar instanceof LexerGrammar) {
            if (this.grammar instanceof LexerGrammar && (!this.saveText || wc.getAutoGenType() == 3)) {
                this.println("_saveIndex = text.length();");
            }
            this.println("matchNot(EOF/*_CHAR*/);");
            if (this.grammar instanceof LexerGrammar && (!this.saveText || wc.getAutoGenType() == 3)) {
                this.println("text.erase(_saveIndex);");
            }
        } else {
            this.println("matchNot(" + this.getValueString(1) + ");");
        }
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("_t = _t->getNextSibling();");
        }
    }

    public void gen(ZeroOrMoreBlock blk) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("gen*(" + blk + ")");
        }
        this.println("{ // ( ... )*");
        this.genBlockPreamble(blk);
        String label = blk.getLabel() != null ? blk.getLabel() : "_loop" + blk.ID;
        this.println("for (;;) {");
        ++this.tabs;
        this.genBlockInitAction(blk);
        String saveCurrentASTResult = this.currentASTResult;
        if (blk.getLabel() != null) {
            this.currentASTResult = blk.getLabel();
        }
        boolean ok = this.grammar.theLLkAnalyzer.deterministic(blk);
        boolean generateNonGreedyExitPath = false;
        int nonGreedyExitDepth = this.grammar.maxk;
        if (!blk.greedy && blk.exitLookaheadDepth <= this.grammar.maxk && blk.exitCache[blk.exitLookaheadDepth].containsEpsilon()) {
            generateNonGreedyExitPath = true;
            nonGreedyExitDepth = blk.exitLookaheadDepth;
        } else if (!blk.greedy && blk.exitLookaheadDepth == Integer.MAX_VALUE) {
            generateNonGreedyExitPath = true;
        }
        if (generateNonGreedyExitPath) {
            if (this.DEBUG_CODE_GENERATOR) {
                System.out.println("nongreedy (...)* loop; exit depth is " + blk.exitLookaheadDepth);
            }
            String predictExit = this.getLookaheadTestExpression(blk.exitCache, nonGreedyExitDepth);
            this.println("// nongreedy exit test");
            this.println("if (" + predictExit + ") goto " + label + ";");
        }
        CppBlockFinishingInfo howToFinish = this.genCommonBlock(blk, false);
        this.genBlockFinish(howToFinish, "goto " + label + ";");
        --this.tabs;
        this.println("}");
        this.println(label + ":;");
        this.println("} // ( ... )*");
        this.currentASTResult = saveCurrentASTResult;
    }

    protected void genAlt(Alternative alt, AlternativeBlock blk) {
        boolean savegenAST = this.genAST;
        this.genAST = this.genAST && alt.getAutoGen();
        boolean oldsaveTest = this.saveText;
        this.saveText = this.saveText && alt.getAutoGen();
        Hashtable saveMap = this.treeVariableMap;
        this.treeVariableMap = new Hashtable();
        if (alt.exceptionSpec != null) {
            this.println("try {      // for error handling");
            ++this.tabs;
        }
        AlternativeElement elem = alt.head;
        while (!(elem instanceof BlockEndElement)) {
            elem.generate();
            elem = elem.next;
        }
        if (this.genAST) {
            if (blk instanceof RuleBlock) {
                RuleBlock rblk = (RuleBlock)blk;
                if (this.usingCustomAST) {
                    this.println(rblk.getRuleName() + "_AST = static_cast<" + this.labeledElementASTType + ">(currentAST.root);");
                } else {
                    this.println(rblk.getRuleName() + "_AST = currentAST.root;");
                }
            } else if (blk.getLabel() != null) {
                this.antlrTool.warning("Labeled subrules are not implemented", this.grammar.getFilename(), blk.getLine(), blk.getColumn());
            }
        }
        if (alt.exceptionSpec != null) {
            --this.tabs;
            this.println("}");
            this.genErrorHandler(alt.exceptionSpec);
        }
        this.genAST = savegenAST;
        this.saveText = oldsaveTest;
        this.treeVariableMap = saveMap;
    }

    protected void genBitsets(Vector bitsetList, int maxVocabulary, String prefix) {
        TokenManager tm = this.grammar.tokenManager;
        this.println("");
        int i = 0;
        while (i < bitsetList.size()) {
            BitSet p = (BitSet)bitsetList.elementAt(i);
            p.growToInclude(maxVocabulary);
            this.println("const unsigned long " + prefix + this.getBitsetName(i) + "_data_" + "[] = { " + p.toStringOfHalfWords() + " };");
            String t = "// ";
            int j = 0;
            while (j < tm.getVocabulary().size()) {
                if (p.member(j) && (t = this.grammar instanceof LexerGrammar ? t + tm.getVocabulary().elementAt(j) + " " : t + tm.getTokenStringAt(j) + " ").length() > 70) {
                    this.println(t);
                    t = "// ";
                }
                ++j;
            }
            if (t != "// ") {
                this.println(t);
            }
            this.println("const " + namespaceAntlr + "BitSet " + prefix + this.getBitsetName(i) + "(" + this.getBitsetName(i) + "_data_," + p.size() / 32 + ");");
            ++i;
        }
    }

    protected void genBitsetsHeader(Vector bitsetList, int maxVocabulary) {
        this.println("");
        int i = 0;
        while (i < bitsetList.size()) {
            BitSet p = (BitSet)bitsetList.elementAt(i);
            p.growToInclude(maxVocabulary);
            this.println("static const unsigned long " + this.getBitsetName(i) + "_data_" + "[];");
            this.println("static const " + namespaceAntlr + "BitSet " + this.getBitsetName(i) + ";");
            ++i;
        }
    }

    private void genBlockFinish(CppBlockFinishingInfo howToFinish, String noViableAction) {
        if (howToFinish.needAnErrorClause && (howToFinish.generatedAnIf || howToFinish.generatedSwitch)) {
            if (howToFinish.generatedAnIf) {
                this.println("else {");
            } else {
                this.println("{");
            }
            ++this.tabs;
            this.println(noViableAction);
            --this.tabs;
            this.println("}");
        }
        if (howToFinish.postscript != null) {
            this.println(howToFinish.postscript);
        }
    }

    protected void genBlockInitAction(AlternativeBlock blk) {
        if (blk.initAction != null) {
            this.genLineNo(blk);
            this.printAction(this.processActionForTreeSpecifiers(blk.initAction, blk.line, this.currentRule, null));
            this.genLineNo2();
        }
    }

    protected void genBlockPreamble(AlternativeBlock blk) {
        if (blk instanceof RuleBlock) {
            RuleBlock rblk = (RuleBlock)blk;
            if (rblk.labeledElements != null) {
                int i = 0;
                while (i < rblk.labeledElements.size()) {
                    AlternativeElement a = (AlternativeElement)rblk.labeledElements.elementAt(i);
                    if (a instanceof RuleRefElement || a instanceof AlternativeBlock && !(a instanceof RuleBlock) && !(a instanceof SynPredBlock)) {
                        if (!(a instanceof RuleRefElement) && ((AlternativeBlock)a).not && this.analyzer.subruleCanBeInverted((AlternativeBlock)a, this.grammar instanceof LexerGrammar)) {
                            this.println(this.labeledElementType + " " + a.getLabel() + " = " + this.labeledElementInit + ";");
                            if (this.grammar.buildAST) {
                                this.genASTDeclaration(a);
                            }
                        } else {
                            if (this.grammar.buildAST) {
                                this.genASTDeclaration(a);
                            }
                            if (this.grammar instanceof LexerGrammar) {
                                this.println(namespaceAntlr + "RefToken " + a.getLabel() + ";");
                            }
                            if (this.grammar instanceof TreeWalkerGrammar) {
                                this.println(this.labeledElementType + " " + a.getLabel() + " = " + this.labeledElementInit + ";");
                            }
                        }
                    } else {
                        this.println(this.labeledElementType + " " + a.getLabel() + " = " + this.labeledElementInit + ";");
                        if (this.grammar.buildAST) {
                            if (a instanceof GrammarAtom && ((GrammarAtom)a).getASTNodeType() != null) {
                                GrammarAtom ga = (GrammarAtom)a;
                                this.genASTDeclaration(a, ga.getASTNodeType());
                            } else {
                                this.genASTDeclaration(a);
                            }
                        }
                    }
                    ++i;
                }
            }
        }
    }

    public void genBody(LexerGrammar g) throws IOException {
        GrammarSymbol sym;
        Enumeration ids;
        this.outputFile = this.grammar.getClassName() + ".cpp";
        this.outputLine = 1;
        this.currentOutput = this.antlrTool.openOutputFile(this.outputFile);
        this.genAST = false;
        this.saveText = true;
        this.tabs = 0;
        this.genHeader(this.outputFile);
        this.printHeaderAction(preIncludeCpp);
        this.println("#include \"" + this.grammar.getClassName() + ".hpp\"");
        this.println("#include <antlr/CharBuffer.hpp>");
        this.println("#include <antlr/TokenStreamException.hpp>");
        this.println("#include <antlr/TokenStreamIOException.hpp>");
        this.println("#include <antlr/TokenStreamRecognitionException.hpp>");
        this.println("#include <antlr/CharStreamException.hpp>");
        this.println("#include <antlr/CharStreamIOException.hpp>");
        this.println("#include <antlr/NoViableAltForCharException.hpp>");
        if (this.grammar.debuggingOutput) {
            this.println("#include <antlr/DebuggingInputBuffer.hpp>");
        }
        this.println("");
        this.printHeaderAction(postIncludeCpp);
        if (nameSpace != null) {
            nameSpace.emitDeclarations(this.currentOutput);
        }
        this.printAction(this.grammar.preambleAction);
        String sup = null;
        if (this.grammar.superClass != null) {
            sup = this.grammar.superClass;
        } else {
            sup = this.grammar.getSuperClass();
            if (sup.lastIndexOf(46) != -1) {
                sup = sup.substring(sup.lastIndexOf(46) + 1);
            }
            sup = namespaceAntlr + sup;
        }
        this.println(this.grammar.getClassName() + "::" + this.grammar.getClassName() + "(" + namespaceStd + "istream& in)");
        ++this.tabs;
        if (this.grammar.debuggingOutput) {
            this.println(": " + sup + "(new " + namespaceAntlr + "DebuggingInputBuffer(new " + namespaceAntlr + "CharBuffer(in)))");
        } else {
            this.println(": " + sup + "(new " + namespaceAntlr + "CharBuffer(in))");
        }
        --this.tabs;
        this.println("{");
        ++this.tabs;
        if (this.grammar.debuggingOutput) {
            this.println("setRuleNames(_ruleNames);");
            this.println("setSemPredNames(_semPredNames);");
            this.println("setupDebugging();");
        }
        this.println("setCaseSensitive(" + g.caseSensitive + ");");
        this.println("initLiterals();");
        --this.tabs;
        this.println("}");
        this.println("");
        this.println(this.grammar.getClassName() + "::" + this.grammar.getClassName() + "(" + namespaceAntlr + "InputBuffer& ib)");
        ++this.tabs;
        if (this.grammar.debuggingOutput) {
            this.println(": " + sup + "(new " + namespaceAntlr + "DebuggingInputBuffer(ib))");
        } else {
            this.println(": " + sup + "(ib)");
        }
        --this.tabs;
        this.println("{");
        ++this.tabs;
        if (this.grammar.debuggingOutput) {
            this.println("setRuleNames(_ruleNames);");
            this.println("setSemPredNames(_semPredNames);");
            this.println("setupDebugging();");
        }
        this.println("setCaseSensitive(" + g.caseSensitive + ");");
        this.println("initLiterals();");
        --this.tabs;
        this.println("}");
        this.println("");
        this.println(this.grammar.getClassName() + "::" + this.grammar.getClassName() + "(const " + namespaceAntlr + "LexerSharedInputState& state)");
        ++this.tabs;
        this.println(": " + sup + "(state)");
        --this.tabs;
        this.println("{");
        ++this.tabs;
        if (this.grammar.debuggingOutput) {
            this.println("setRuleNames(_ruleNames);");
            this.println("setSemPredNames(_semPredNames);");
            this.println("setupDebugging();");
        }
        this.println("setCaseSensitive(" + g.caseSensitive + ");");
        this.println("initLiterals();");
        --this.tabs;
        this.println("}");
        this.println("");
        this.println("void " + this.grammar.getClassName() + "::initLiterals()");
        this.println("{");
        ++this.tabs;
        Enumeration keys = this.grammar.tokenManager.getTokenSymbolKeys();
        while (keys.hasMoreElements()) {
            TokenSymbol sym2;
            String key = (String)keys.nextElement();
            if (key.charAt(0) != '\"' || !((sym2 = this.grammar.tokenManager.getTokenSymbol(key)) instanceof StringLiteralSymbol)) continue;
            StringLiteralSymbol s = (StringLiteralSymbol)sym2;
            this.println("literals[" + s.getId() + "] = " + s.getTokenType() + ";");
        }
        --this.tabs;
        this.println("}");
        this.println("bool " + this.grammar.getClassName() + "::getCaseSensitiveLiterals() const");
        this.println("{");
        ++this.tabs;
        this.println("return " + g.caseSensitiveLiterals + ";");
        --this.tabs;
        this.println("}");
        if (this.grammar.debuggingOutput) {
            this.println("const char* " + this.grammar.getClassName() + "::_ruleNames[] = {");
            ++this.tabs;
            ids = this.grammar.rules.elements();
            boolean ruleNum = false;
            while (ids.hasMoreElements()) {
                sym = (GrammarSymbol)ids.nextElement();
                if (!(sym instanceof RuleSymbol)) continue;
                this.println("\"" + sym.getId() + "\",");
            }
            this.println("0");
            --this.tabs;
            this.println("};");
        }
        this.genNextToken();
        ids = this.grammar.rules.elements();
        int ruleNum = 0;
        while (ids.hasMoreElements()) {
            sym = (RuleSymbol)ids.nextElement();
            if (!sym.getId().equals("mnextToken")) {
                this.genRule((RuleSymbol)sym, false, ruleNum++, this.grammar.getClassName() + "::");
            }
            this.exitIfError();
        }
        if (this.grammar.debuggingOutput) {
            this.genSemPredMap(this.grammar.getClassName() + "::");
        }
        this.genBitsets(this.bitsetsUsed, ((LexerGrammar)this.grammar).charVocabulary.size(), this.grammar.getClassName() + "::");
        this.println("");
        if (nameSpace != null) {
            nameSpace.emitClosures(this.currentOutput);
        }
        this.currentOutput.close();
        this.currentOutput = null;
    }

    public void genBody(ParserGrammar g) throws IOException {
        GrammarSymbol sym;
        int ruleNum;
        Enumeration ids;
        this.outputFile = this.grammar.getClassName() + ".cpp";
        this.outputLine = 1;
        this.currentOutput = this.antlrTool.openOutputFile(this.outputFile);
        this.genAST = this.grammar.buildAST;
        this.tabs = 0;
        this.genHeader(this.outputFile);
        this.printHeaderAction(preIncludeCpp);
        this.println("#include \"" + this.grammar.getClassName() + ".hpp\"");
        this.println("#include <antlr/NoViableAltException.hpp>");
        this.println("#include <antlr/SemanticException.hpp>");
        this.println("#include <antlr/ASTFactory.hpp>");
        this.printHeaderAction(postIncludeCpp);
        if (nameSpace != null) {
            nameSpace.emitDeclarations(this.currentOutput);
        }
        this.printAction(this.grammar.preambleAction);
        String sup = null;
        if (this.grammar.superClass != null) {
            sup = this.grammar.superClass;
        } else {
            sup = this.grammar.getSuperClass();
            if (sup.lastIndexOf(46) != -1) {
                sup = sup.substring(sup.lastIndexOf(46) + 1);
            }
            sup = namespaceAntlr + sup;
        }
        if (this.grammar.debuggingOutput) {
            this.println("const char* " + this.grammar.getClassName() + "::_ruleNames[] = {");
            ++this.tabs;
            ids = this.grammar.rules.elements();
            ruleNum = 0;
            while (ids.hasMoreElements()) {
                sym = (GrammarSymbol)ids.nextElement();
                if (!(sym instanceof RuleSymbol)) continue;
                this.println("\"" + ((RuleSymbol)sym).getId() + "\",");
            }
            this.println("0");
            --this.tabs;
            this.println("};");
        }
        this.println("void " + this.grammar.getClassName() + "::_initialize(void)");
        this.println("{");
        ++this.tabs;
        if (this.grammar.buildAST) {
            this.println("initializeFactory();");
        }
        if (this.grammar.debuggingOutput) {
            this.println("setRuleNames(_ruleNames);");
            this.println("setSemPredNames(_semPredNames);");
            this.println("setupDebugging();");
        }
        --this.tabs;
        this.println("}");
        this.print(this.grammar.getClassName() + "::" + this.grammar.getClassName());
        this.println("(" + namespaceAntlr + "TokenBuffer& tokenBuf, int k)");
        this.println(": " + sup + "(tokenBuf,k)");
        this.println("{");
        ++this.tabs;
        this.println("_initialize();");
        --this.tabs;
        this.println("}");
        this.println("");
        this.print(this.grammar.getClassName() + "::" + this.grammar.getClassName());
        this.println("(" + namespaceAntlr + "TokenBuffer& tokenBuf)");
        this.println(": " + sup + "(tokenBuf," + this.grammar.maxk + ")");
        this.println("{");
        ++this.tabs;
        this.println("_initialize();");
        --this.tabs;
        this.println("}");
        this.println("");
        this.print(this.grammar.getClassName() + "::" + this.grammar.getClassName());
        this.println("(" + namespaceAntlr + "TokenStream& lexer, int k)");
        this.println(": " + sup + "(lexer,k)");
        this.println("{");
        ++this.tabs;
        this.println("_initialize();");
        --this.tabs;
        this.println("}");
        this.println("");
        this.print(this.grammar.getClassName() + "::" + this.grammar.getClassName());
        this.println("(" + namespaceAntlr + "TokenStream& lexer)");
        this.println(": " + sup + "(lexer," + this.grammar.maxk + ")");
        this.println("{");
        ++this.tabs;
        this.println("_initialize();");
        --this.tabs;
        this.println("}");
        this.println("");
        this.print(this.grammar.getClassName() + "::" + this.grammar.getClassName());
        this.println("(const " + namespaceAntlr + "ParserSharedInputState& state)");
        this.println(": " + sup + "(state," + this.grammar.maxk + ")");
        this.println("{");
        ++this.tabs;
        this.println("_initialize();");
        --this.tabs;
        this.println("}");
        this.println("");
        this.astTypes = new Vector();
        ids = this.grammar.rules.elements();
        ruleNum = 0;
        while (ids.hasMoreElements()) {
            sym = (GrammarSymbol)ids.nextElement();
            if (sym instanceof RuleSymbol) {
                RuleSymbol rs = (RuleSymbol)sym;
                this.genRule(rs, rs.references.size() == 0, ruleNum++, this.grammar.getClassName() + "::");
            }
            this.exitIfError();
        }
        if (this.usingCustomAST) {
            this.println(this.labeledElementASTType + " " + this.grammar.getClassName() + "::getAST()");
            this.println("{");
            this.println("\treturn returnAST;");
            this.println("}");
            this.println("");
        }
        this.println("void " + this.grammar.getClassName() + "::initializeFactory( void )");
        this.println("{");
        ++this.tabs;
        if (this.grammar.buildAST) {
            this.println("if( ! astFactory )");
            ++this.tabs;
            if (this.usingCustomAST) {
                String nodetype = this.labeledElementASTType.substring(3, this.labeledElementASTType.length());
                this.println("astFactory = new " + namespaceAntlr + "ASTFactory(\"" + nodetype + "\", " + nodetype + "::factory);");
            } else {
                this.println("astFactory = new " + namespaceAntlr + "ASTFactory();");
            }
            --this.tabs;
            Enumeration e = this.astTypes.elements();
            while (e.hasMoreElements()) {
                this.println((String)e.nextElement());
            }
            this.println("astFactory->setMaxNodeType(" + this.grammar.tokenManager.maxTokenType() + ");");
        }
        --this.tabs;
        this.println("}");
        this.genTokenStrings(this.grammar.getClassName() + "::");
        this.genBitsets(this.bitsetsUsed, this.grammar.tokenManager.maxTokenType(), this.grammar.getClassName() + "::");
        if (this.grammar.debuggingOutput) {
            this.genSemPredMap(this.grammar.getClassName() + "::");
        }
        this.println("");
        this.println("");
        if (nameSpace != null) {
            nameSpace.emitClosures(this.currentOutput);
        }
        this.currentOutput.close();
        this.currentOutput = null;
    }

    public void genBody(TreeWalkerGrammar g) throws IOException {
        this.outputFile = this.grammar.getClassName() + ".cpp";
        this.outputLine = 1;
        this.currentOutput = this.antlrTool.openOutputFile(this.outputFile);
        this.genAST = this.grammar.buildAST;
        this.tabs = 0;
        this.genHeader(this.outputFile);
        this.printHeaderAction(preIncludeCpp);
        this.println("#include \"" + this.grammar.getClassName() + ".hpp\"");
        this.println("#include <antlr/Token.hpp>");
        this.println("#include <antlr/AST.hpp>");
        this.println("#include <antlr/NoViableAltException.hpp>");
        this.println("#include <antlr/MismatchedTokenException.hpp>");
        this.println("#include <antlr/SemanticException.hpp>");
        this.println("#include <antlr/BitSet.hpp>");
        this.printHeaderAction(postIncludeCpp);
        if (nameSpace != null) {
            nameSpace.emitDeclarations(this.currentOutput);
        }
        this.printAction(this.grammar.preambleAction);
        String sup = null;
        if (this.grammar.superClass != null) {
            sup = this.grammar.superClass;
        } else {
            sup = this.grammar.getSuperClass();
            if (sup.lastIndexOf(46) != -1) {
                sup = sup.substring(sup.lastIndexOf(46) + 1);
            }
            sup = namespaceAntlr + sup;
        }
        this.println(this.grammar.getClassName() + "::" + this.grammar.getClassName() + "()");
        this.println("\t: " + namespaceAntlr + "TreeParser() {");
        ++this.tabs;
        --this.tabs;
        this.println("}");
        this.println("");
        Enumeration ids = this.grammar.rules.elements();
        int ruleNum = 0;
        String ruleNameInits = "";
        while (ids.hasMoreElements()) {
            GrammarSymbol sym = (GrammarSymbol)ids.nextElement();
            if (sym instanceof RuleSymbol) {
                RuleSymbol rs = (RuleSymbol)sym;
                this.genRule(rs, rs.references.size() == 0, ruleNum++, this.grammar.getClassName() + "::");
            }
            this.exitIfError();
        }
        if (this.usingCustomAST) {
            this.println(this.labeledElementASTType + " " + this.grammar.getClassName() + "::getAST()");
            this.println("{");
            this.println("\treturn returnAST;");
            this.println("}");
            this.println("");
        }
        this.genTokenStrings(this.grammar.getClassName() + "::");
        this.genBitsets(this.bitsetsUsed, this.grammar.tokenManager.maxTokenType(), this.grammar.getClassName() + "::");
        this.println("");
        this.println("");
        if (nameSpace != null) {
            nameSpace.emitClosures(this.currentOutput);
        }
        this.currentOutput.close();
        this.currentOutput = null;
    }

    protected void genCases(BitSet p) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genCases(" + p + ")");
        }
        int[] elems = p.toArray();
        int wrap = 1;
        int j = 1;
        boolean startOfLine = true;
        int i = 0;
        while (i < elems.length) {
            if (j == 1) {
                this.print("");
            } else {
                this._print("  ");
            }
            this._print("case " + this.getValueString(elems[i]) + ":");
            if (j == wrap) {
                this._println("");
                startOfLine = true;
                j = 1;
            } else {
                ++j;
                startOfLine = false;
            }
            ++i;
        }
        if (!startOfLine) {
            this._println("");
        }
    }

    public CppBlockFinishingInfo genCommonBlock(AlternativeBlock blk, boolean noTestForSingle) {
        int startDepth;
        int nIF = 0;
        boolean createdLL1Switch = false;
        int closingBracesOfIFSequence = 0;
        CppBlockFinishingInfo finishingInfo = new CppBlockFinishingInfo();
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genCommonBlk(" + blk + ")");
        }
        boolean savegenAST = this.genAST;
        this.genAST = this.genAST && blk.getAutoGen();
        boolean oldsaveTest = this.saveText;
        boolean bl = this.saveText = this.saveText && blk.getAutoGen();
        if (blk.not && this.analyzer.subruleCanBeInverted(blk, this.grammar instanceof LexerGrammar)) {
            Lookahead p = this.analyzer.look(1, blk);
            if (blk.getLabel() != null && this.syntacticPredLevel == 0) {
                this.println(blk.getLabel() + " = " + this.lt1Value + ";");
            }
            this.genElementAST(blk);
            String astArgs = "";
            if (this.grammar instanceof TreeWalkerGrammar) {
                astArgs = this.usingCustomAST ? "static_cast<" + namespaceAntlr + "RefAST" + ">(_t)," : "_t,";
            }
            this.println("match(" + astArgs + this.getBitsetName(this.markBitsetForGen(p.fset)) + ");");
            if (this.grammar instanceof TreeWalkerGrammar) {
                this.println("_t = _t->getNextSibling();");
            }
            return finishingInfo;
        }
        if (blk.getAlternatives().size() == 1) {
            Alternative alt = blk.getAlternativeAt(0);
            if (alt.synPred != null) {
                this.antlrTool.warning("Syntactic predicate superfluous for single alternative", this.grammar.getFilename(), blk.getAlternativeAt((int)0).synPred.getLine(), blk.getAlternativeAt((int)0).synPred.getColumn());
            }
            if (noTestForSingle) {
                if (alt.semPred != null) {
                    this.genSemPred(alt.semPred, blk.line);
                }
                this.genAlt(alt, blk);
                return finishingInfo;
            }
        }
        int nLL1 = 0;
        int i = 0;
        while (i < blk.getAlternatives().size()) {
            Alternative a = blk.getAlternativeAt(i);
            if (CppCodeGenerator.suitableForCaseExpression(a)) {
                ++nLL1;
            }
            ++i;
        }
        if (nLL1 >= this.makeSwitchThreshold) {
            String testExpr = this.lookaheadString(1);
            createdLL1Switch = true;
            if (this.grammar instanceof TreeWalkerGrammar) {
                this.println("if (_t == " + this.labeledElementASTInit + " )");
                ++this.tabs;
                this.println("_t = ASTNULL;");
                --this.tabs;
            }
            this.println("switch ( " + testExpr + ") {");
            int i2 = 0;
            while (i2 < blk.alternatives.size()) {
                Alternative alt = blk.getAlternativeAt(i2);
                if (CppCodeGenerator.suitableForCaseExpression(alt)) {
                    Lookahead p = alt.cache[1];
                    if (p.fset.degree() == 0 && !p.containsEpsilon()) {
                        this.antlrTool.warning("Alternate omitted due to empty prediction set", this.grammar.getFilename(), alt.head.getLine(), alt.head.getColumn());
                    } else {
                        this.genCases(p.fset);
                        this.println("{");
                        ++this.tabs;
                        this.genAlt(alt, blk);
                        this.println("break;");
                        --this.tabs;
                        this.println("}");
                    }
                }
                ++i2;
            }
            this.println("default:");
            ++this.tabs;
        }
        int altDepth = startDepth = this.grammar instanceof LexerGrammar ? this.grammar.maxk : 0;
        while (altDepth >= 0) {
            if (this.DEBUG_CODE_GENERATOR) {
                System.out.println("checking depth " + altDepth);
            }
            int i3 = 0;
            while (i3 < blk.alternatives.size()) {
                block46: {
                    String e;
                    boolean unpredicted;
                    Alternative alt;
                    block49: {
                        block47: {
                            int effectiveDepth;
                            block48: {
                                block45: {
                                    alt = blk.getAlternativeAt(i3);
                                    if (this.DEBUG_CODE_GENERATOR) {
                                        System.out.println("genAlt: " + i3);
                                    }
                                    if (!createdLL1Switch || !CppCodeGenerator.suitableForCaseExpression(alt)) break block45;
                                    if (this.DEBUG_CODE_GENERATOR) {
                                        System.out.println("ignoring alt because it was in the switch");
                                    }
                                    break block46;
                                }
                                unpredicted = false;
                                if (!(this.grammar instanceof LexerGrammar)) break block47;
                                effectiveDepth = alt.lookaheadDepth;
                                if (effectiveDepth == Integer.MAX_VALUE) {
                                    effectiveDepth = this.grammar.maxk;
                                }
                                while (effectiveDepth >= 1 && alt.cache[effectiveDepth].containsEpsilon()) {
                                    --effectiveDepth;
                                }
                                if (effectiveDepth == altDepth) break block48;
                                if (this.DEBUG_CODE_GENERATOR) {
                                    System.out.println("ignoring alt because effectiveDepth!=altDepth;" + effectiveDepth + "!=" + altDepth);
                                }
                                break block46;
                            }
                            unpredicted = this.lookaheadIsEmpty(alt, effectiveDepth);
                            e = this.getLookaheadTestExpression(alt, effectiveDepth);
                            break block49;
                        }
                        unpredicted = this.lookaheadIsEmpty(alt, this.grammar.maxk);
                        e = this.getLookaheadTestExpression(alt, this.grammar.maxk);
                    }
                    if (alt.cache[1].fset.degree() > 127 && CppCodeGenerator.suitableForCaseExpression(alt)) {
                        if (nIF == 0) {
                            if (this.grammar instanceof TreeWalkerGrammar) {
                                this.println("if (_t == " + this.labeledElementASTInit + " )");
                                ++this.tabs;
                                this.println("_t = ASTNULL;");
                                --this.tabs;
                            }
                            this.println("if " + e + " {");
                        } else {
                            this.println("else if " + e + " {");
                        }
                    } else if (unpredicted && alt.semPred == null && alt.synPred == null) {
                        if (nIF == 0) {
                            this.println("{");
                        } else {
                            this.println("else {");
                        }
                        finishingInfo.needAnErrorClause = false;
                    } else {
                        if (alt.semPred != null) {
                            ActionTransInfo tInfo = new ActionTransInfo();
                            String actionStr = this.processActionForTreeSpecifiers(alt.semPred, blk.line, this.currentRule, tInfo);
                            e = (this.grammar instanceof ParserGrammar || this.grammar instanceof LexerGrammar) && this.grammar.debuggingOutput ? "(" + e + "&& fireSemanticPredicateEvaluated(de.hunsicker.antlr.debug.SemanticPredicateEvent.PREDICTING," + this.addSemPred(this.charFormatter.escapeString(actionStr)) + "," + actionStr + "))" : "(" + e + "&&(" + actionStr + "))";
                        }
                        if (nIF > 0) {
                            if (alt.synPred != null) {
                                this.println("else {");
                                ++this.tabs;
                                this.genSynPred(alt.synPred, e);
                                ++closingBracesOfIFSequence;
                            } else {
                                this.println("else if " + e + " {");
                            }
                        } else if (alt.synPred != null) {
                            this.genSynPred(alt.synPred, e);
                        } else {
                            if (this.grammar instanceof TreeWalkerGrammar) {
                                this.println("if (_t == " + this.labeledElementASTInit + " )");
                                ++this.tabs;
                                this.println("_t = ASTNULL;");
                                --this.tabs;
                            }
                            this.println("if " + e + " {");
                        }
                    }
                    ++nIF;
                    ++this.tabs;
                    this.genAlt(alt, blk);
                    --this.tabs;
                    this.println("}");
                }
                ++i3;
            }
            --altDepth;
        }
        String ps = "";
        int i4 = 1;
        while (i4 <= closingBracesOfIFSequence) {
            --this.tabs;
            ps = ps + "}";
            ++i4;
        }
        this.genAST = savegenAST;
        this.saveText = oldsaveTest;
        if (createdLL1Switch) {
            --this.tabs;
            finishingInfo.postscript = ps + "}";
            finishingInfo.generatedSwitch = true;
            finishingInfo.generatedAnIf = nIF > 0;
        } else {
            finishingInfo.postscript = ps;
            finishingInfo.generatedSwitch = false;
            finishingInfo.generatedAnIf = nIF > 0;
        }
        return finishingInfo;
    }

    private static boolean suitableForCaseExpression(Alternative a) {
        return a.lookaheadDepth == 1 && a.semPred == null && !a.cache[1].containsEpsilon() && a.cache[1].fset.degree() <= 127;
    }

    private void genElementAST(AlternativeElement el) {
        if (this.grammar instanceof TreeWalkerGrammar && !this.grammar.buildAST) {
            if (el.getLabel() == null) {
                String elementRef = this.lt1Value;
                String astName = "tmp" + this.astVarNumber + "_AST";
                ++this.astVarNumber;
                this.mapTreeVariable(el, astName);
                this.println(this.labeledElementASTType + " " + astName + "_in = " + elementRef + ";");
            }
            return;
        }
        if (this.grammar.buildAST && this.syntacticPredLevel == 0) {
            String astNameBase;
            String elementRef;
            boolean doNoGuessTest;
            boolean needASTDecl;
            boolean bl = needASTDecl = this.genAST && (el.getLabel() != null || el.getAutoGenType() != 3);
            if (el.getAutoGenType() != 3 && el instanceof TokenRefElement) {
                needASTDecl = true;
            }
            boolean bl2 = doNoGuessTest = this.grammar.hasSyntacticPredicate && needASTDecl;
            if (el.getLabel() != null) {
                elementRef = el.getLabel();
                astNameBase = el.getLabel();
            } else {
                elementRef = this.lt1Value;
                astNameBase = "tmp" + this.astVarNumber;
                ++this.astVarNumber;
            }
            if (needASTDecl) {
                if (el instanceof GrammarAtom) {
                    GrammarAtom ga = (GrammarAtom)el;
                    if (ga.getASTNodeType() != null) {
                        this.genASTDeclaration(el, astNameBase, "Ref" + ga.getASTNodeType());
                    } else {
                        this.genASTDeclaration(el, astNameBase, this.labeledElementASTType);
                    }
                } else {
                    this.genASTDeclaration(el, astNameBase, this.labeledElementASTType);
                }
            }
            String astName = astNameBase + "_AST";
            this.mapTreeVariable(el, astName);
            if (this.grammar instanceof TreeWalkerGrammar) {
                this.println(this.labeledElementASTType + " " + astName + "_in = " + this.labeledElementASTInit + ";");
            }
            if (doNoGuessTest) {
                this.println("if ( inputState->guessing == 0 ) {");
                ++this.tabs;
            }
            if (el.getLabel() != null) {
                if (el instanceof GrammarAtom) {
                    this.println(astName + " = " + this.getASTCreateString((GrammarAtom)el, elementRef) + ";");
                } else {
                    this.println(astName + " = " + this.getASTCreateString(elementRef) + ";");
                }
            }
            if (el.getLabel() == null && needASTDecl) {
                elementRef = this.lt1Value;
                if (el instanceof GrammarAtom) {
                    this.println(astName + " = " + this.getASTCreateString((GrammarAtom)el, elementRef) + ";");
                } else {
                    this.println(astName + " = " + this.getASTCreateString(elementRef) + ";");
                }
                if (this.grammar instanceof TreeWalkerGrammar) {
                    this.println(astName + "_in = " + elementRef + ";");
                }
            }
            if (this.genAST) {
                switch (el.getAutoGenType()) {
                    case 1: {
                        if (this.usingCustomAST || el instanceof GrammarAtom && ((GrammarAtom)el).getASTNodeType() != null) {
                            this.println("astFactory->addASTChild(currentAST, static_cast<" + namespaceAntlr + "RefAST>(" + astName + "));");
                            break;
                        }
                        this.println("astFactory->addASTChild(currentAST, " + astName + ");");
                        break;
                    }
                    case 2: {
                        if (this.usingCustomAST || el instanceof GrammarAtom && ((GrammarAtom)el).getASTNodeType() != null) {
                            this.println("astFactory->makeASTRoot(currentAST, static_cast<" + namespaceAntlr + "RefAST>(" + astName + "));");
                            break;
                        }
                        this.println("astFactory->makeASTRoot(currentAST, " + astName + ");");
                        break;
                    }
                }
            }
            if (doNoGuessTest) {
                --this.tabs;
                this.println("}");
            }
        }
    }

    private void genErrorCatchForElement(AlternativeElement el) {
        ExceptionSpec ex;
        RuleSymbol rs;
        if (el.getLabel() == null) {
            return;
        }
        String r = el.enclosingRuleName;
        if (this.grammar instanceof LexerGrammar) {
            r = CodeGenerator.encodeLexerRuleName(el.enclosingRuleName);
        }
        if ((rs = (RuleSymbol)this.grammar.getSymbol(r)) == null) {
            this.antlrTool.panic("Enclosing rule not found!");
        }
        if ((ex = rs.block.findExceptionSpec(el.getLabel())) != null) {
            --this.tabs;
            this.println("}");
            this.genErrorHandler(ex);
        }
    }

    private void genErrorHandler(ExceptionSpec ex) {
        int i = 0;
        while (i < ex.handlers.size()) {
            ExceptionHandler handler = (ExceptionHandler)ex.handlers.elementAt(i);
            this.println("catch (" + handler.exceptionTypeAndName.getText() + ") {");
            ++this.tabs;
            if (this.grammar.hasSyntacticPredicate) {
                this.println("if (inputState->guessing==0) {");
                ++this.tabs;
            }
            ActionTransInfo tInfo = null;
            if (this.currentRule != null && this.grammar instanceof ParserGrammar) {
                String followSetName;
                tInfo = new ActionTransInfo();
                Lookahead follow = this.grammar.theLLkAnalyzer.FOLLOW(1, this.currentRule.endNode);
                tInfo.lookaheadSetName = followSetName = this.getBitsetName(this.markBitsetForGen(follow.fset));
            }
            this.genLineNo(handler.action);
            this.printAction(this.processActionForTreeSpecifiers(handler.action.getText(), handler.action.getLine(), this.currentRule, tInfo));
            this.genLineNo2();
            if (this.grammar.hasSyntacticPredicate) {
                --this.tabs;
                this.println("} else {");
                ++this.tabs;
                this.println("throw " + this.extractIdOfAction(handler.exceptionTypeAndName) + ";");
                --this.tabs;
                this.println("}");
            }
            --this.tabs;
            this.println("}");
            ++i;
        }
    }

    private void genErrorTryForElement(AlternativeElement el) {
        ExceptionSpec ex;
        RuleSymbol rs;
        if (el.getLabel() == null) {
            return;
        }
        String r = el.enclosingRuleName;
        if (this.grammar instanceof LexerGrammar) {
            r = CodeGenerator.encodeLexerRuleName(el.enclosingRuleName);
        }
        if ((rs = (RuleSymbol)this.grammar.getSymbol(r)) == null) {
            this.antlrTool.panic("Enclosing rule not found!");
        }
        if ((ex = rs.block.findExceptionSpec(el.getLabel())) != null) {
            this.println("try { // for error handling");
            ++this.tabs;
        }
    }

    protected void genHeader(String fileName) {
        this.println("/* $ANTLR " + Tool.version + ": " + "\"" + this.antlrTool.fileMinusPath(this.antlrTool.grammarFile) + "\"" + " -> " + "\"" + fileName + "\"$ */");
    }

    public void genInclude(LexerGrammar g) throws IOException {
        String suffix;
        this.outputFile = this.grammar.getClassName() + ".hpp";
        this.outputLine = 1;
        this.currentOutput = this.antlrTool.openOutputFile(this.outputFile);
        this.genAST = false;
        this.saveText = true;
        this.tabs = 0;
        this.println("#ifndef INC_" + this.grammar.getClassName() + "_hpp_");
        this.println("#define INC_" + this.grammar.getClassName() + "_hpp_");
        this.println("");
        this.printHeaderAction(preIncludeHpp);
        this.println("#include <antlr/config.hpp>");
        this.genHeader(this.outputFile);
        this.println("#include <antlr/CommonToken.hpp>");
        this.println("#include <antlr/InputBuffer.hpp>");
        this.println("#include <antlr/BitSet.hpp>");
        this.println("#include \"" + this.grammar.tokenManager.getName() + CodeGenerator.TokenTypesFileSuffix + ".hpp\"");
        String sup = null;
        if (this.grammar.superClass != null) {
            sup = this.grammar.superClass;
            this.println("#include \"" + sup + ".hpp\"");
        } else {
            sup = this.grammar.getSuperClass();
            if (sup.lastIndexOf(46) != -1) {
                sup = sup.substring(sup.lastIndexOf(46) + 1);
            }
            this.println("#include <antlr/" + sup + ".hpp>");
            sup = namespaceAntlr + sup;
        }
        this.printHeaderAction(postIncludeHpp);
        if (nameSpace != null) {
            nameSpace.emitDeclarations(this.currentOutput);
        }
        this.printHeaderAction("");
        if (this.grammar.comment != null) {
            this._println(this.grammar.comment);
        }
        this.print("class " + this.grammar.getClassName() + " : public " + sup);
        this.println(", public " + this.grammar.tokenManager.getName() + CodeGenerator.TokenTypesFileSuffix);
        Token tsuffix = (Token)this.grammar.options.get("classHeaderSuffix");
        if (tsuffix != null && (suffix = StringUtils.stripFrontBack(tsuffix.getText(), "\"", "\"")) != null) {
            this.print(", " + suffix);
        }
        this.println("{");
        if (this.grammar.classMemberAction != null) {
            this.genLineNo(this.grammar.classMemberAction);
            this.print(this.processActionForTreeSpecifiers(this.grammar.classMemberAction.getText(), this.grammar.classMemberAction.getLine(), this.currentRule, null));
            this.genLineNo2();
        }
        this.tabs = 0;
        this.println("private:");
        this.tabs = 1;
        this.println("void initLiterals();");
        this.tabs = 0;
        this.println("public:");
        this.tabs = 1;
        this.println("bool getCaseSensitiveLiterals() const;");
        this.tabs = 0;
        this.println("public:");
        this.tabs = 1;
        this.println(this.grammar.getClassName() + "(" + namespaceStd + "istream& in);");
        this.println(this.grammar.getClassName() + "(" + namespaceAntlr + "InputBuffer& ib);");
        this.println(this.grammar.getClassName() + "(const " + namespaceAntlr + "LexerSharedInputState& state);");
        this.println(namespaceAntlr + "RefToken nextToken();");
        Enumeration ids = this.grammar.rules.elements();
        while (ids.hasMoreElements()) {
            RuleSymbol sym = (RuleSymbol)ids.nextElement();
            if (!sym.getId().equals("mnextToken")) {
                this.genRuleHeader(sym, false);
            }
            this.exitIfError();
        }
        this.tabs = 0;
        this.println("private:");
        this.tabs = 1;
        if (this.grammar.debuggingOutput) {
            this.println("static const char* _ruleNames[];");
        }
        if (this.grammar.debuggingOutput) {
            this.println("static const char* _semPredNames[];");
        }
        this.genBitsetsHeader(this.bitsetsUsed, ((LexerGrammar)this.grammar).charVocabulary.size());
        this.tabs = 0;
        this.println("};");
        this.println("");
        if (nameSpace != null) {
            nameSpace.emitClosures(this.currentOutput);
        }
        this.println("#endif /*INC_" + this.grammar.getClassName() + "_hpp_*/");
        this.currentOutput.close();
        this.currentOutput = null;
    }

    public void genInclude(ParserGrammar g) throws IOException {
        String suffix;
        this.outputFile = this.grammar.getClassName() + ".hpp";
        this.outputLine = 1;
        this.currentOutput = this.antlrTool.openOutputFile(this.outputFile);
        this.genAST = this.grammar.buildAST;
        this.tabs = 0;
        this.println("#ifndef INC_" + this.grammar.getClassName() + "_hpp_");
        this.println("#define INC_" + this.grammar.getClassName() + "_hpp_");
        this.println("");
        this.printHeaderAction(preIncludeHpp);
        this.println("#include <antlr/config.hpp>");
        this.genHeader(this.outputFile);
        this.println("#include <antlr/TokenStream.hpp>");
        this.println("#include <antlr/TokenBuffer.hpp>");
        this.println("#include \"" + this.grammar.tokenManager.getName() + CodeGenerator.TokenTypesFileSuffix + ".hpp\"");
        String sup = null;
        if (this.grammar.superClass != null) {
            sup = this.grammar.superClass;
            this.println("#include \"" + sup + ".hpp\"");
        } else {
            sup = this.grammar.getSuperClass();
            if (sup.lastIndexOf(46) != -1) {
                sup = sup.substring(sup.lastIndexOf(46) + 1);
            }
            this.println("#include <antlr/" + sup + ".hpp>");
            sup = namespaceAntlr + sup;
        }
        this.println("");
        this.printHeaderAction(postIncludeHpp);
        if (nameSpace != null) {
            nameSpace.emitDeclarations(this.currentOutput);
        }
        this.printHeaderAction("");
        if (this.grammar.comment != null) {
            this._println(this.grammar.comment);
        }
        this.print("class " + this.grammar.getClassName() + " : public " + sup);
        this.println(", public " + this.grammar.tokenManager.getName() + CodeGenerator.TokenTypesFileSuffix);
        Token tsuffix = (Token)this.grammar.options.get("classHeaderSuffix");
        if (tsuffix != null && (suffix = StringUtils.stripFrontBack(tsuffix.getText(), "\"", "\"")) != null) {
            this.print(", " + suffix);
        }
        this.println("{");
        if (this.grammar.debuggingOutput) {
            this.println("public: static const char* _ruleNames[];");
        }
        if (this.grammar.classMemberAction != null) {
            this.genLineNo(this.grammar.classMemberAction.getLine());
            this.print(this.processActionForTreeSpecifiers(this.grammar.classMemberAction.getText(), this.grammar.classMemberAction.getLine(), this.currentRule, null));
            this.genLineNo2();
        }
        this.println("public:");
        this.tabs = 1;
        this.println("void initializeFactory( void );");
        this.println("// called from constructors");
        this.println("void _initialize( void );");
        this.tabs = 0;
        this.println("protected:");
        this.tabs = 1;
        this.println(this.grammar.getClassName() + "(" + namespaceAntlr + "TokenBuffer& tokenBuf, int k);");
        this.tabs = 0;
        this.println("public:");
        this.tabs = 1;
        this.println(this.grammar.getClassName() + "(" + namespaceAntlr + "TokenBuffer& tokenBuf);");
        this.tabs = 0;
        this.println("protected:");
        this.tabs = 1;
        this.println(this.grammar.getClassName() + "(" + namespaceAntlr + "TokenStream& lexer, int k);");
        this.tabs = 0;
        this.println("public:");
        this.tabs = 1;
        this.println(this.grammar.getClassName() + "(" + namespaceAntlr + "TokenStream& lexer);");
        this.println(this.grammar.getClassName() + "(const " + namespaceAntlr + "ParserSharedInputState& state);");
        this.println("int getNumTokens() const");
        this.println("{");
        ++this.tabs;
        this.println("return " + this.grammar.getClassName() + "::NUM_TOKENS;");
        --this.tabs;
        this.println("}");
        this.println("const char* getTokenName( int type ) const");
        this.println("{");
        ++this.tabs;
        this.println("if( type > getNumTokens() ) return 0;");
        this.println("return " + this.grammar.getClassName() + "::tokenNames[type];");
        --this.tabs;
        this.println("}");
        this.println("const char* const* getTokenNames() const");
        this.println("{");
        ++this.tabs;
        this.println("return " + this.grammar.getClassName() + "::tokenNames;");
        --this.tabs;
        this.println("}");
        Enumeration ids = this.grammar.rules.elements();
        while (ids.hasMoreElements()) {
            GrammarSymbol sym = (GrammarSymbol)ids.nextElement();
            if (sym instanceof RuleSymbol) {
                RuleSymbol rs = (RuleSymbol)sym;
                this.genRuleHeader(rs, rs.references.size() == 0);
            }
            this.exitIfError();
        }
        if (this.usingCustomAST) {
            this.tabs = 0;
            this.println("public:");
            this.tabs = 1;
            this.println(this.labeledElementASTType + " getAST();");
            this.println("");
            this.tabs = 0;
            this.println("protected:");
            this.tabs = 1;
            this.println(this.labeledElementASTType + " returnAST;");
        }
        this.tabs = 0;
        this.println("private:");
        this.tabs = 1;
        this.println("static const char* tokenNames[];");
        this._println("#ifndef NO_STATIC_CONSTS");
        this.println("static const int NUM_TOKENS = " + this.grammar.tokenManager.getVocabulary().size() + ";");
        this._println("#else");
        this.println("enum {");
        this.println("\tNUM_TOKENS = " + this.grammar.tokenManager.getVocabulary().size());
        this.println("};");
        this._println("#endif");
        this.genBitsetsHeader(this.bitsetsUsed, this.grammar.tokenManager.maxTokenType());
        if (this.grammar.debuggingOutput) {
            this.println("static const char* _semPredNames[];");
        }
        this.tabs = 0;
        this.println("};");
        this.println("");
        if (nameSpace != null) {
            nameSpace.emitClosures(this.currentOutput);
        }
        this.println("#endif /*INC_" + this.grammar.getClassName() + "_hpp_*/");
        this.currentOutput.close();
        this.currentOutput = null;
    }

    public void genInclude(TreeWalkerGrammar g) throws IOException {
        String suffix;
        this.outputFile = this.grammar.getClassName() + ".hpp";
        this.outputLine = 1;
        this.currentOutput = this.antlrTool.openOutputFile(this.outputFile);
        this.genAST = this.grammar.buildAST;
        this.tabs = 0;
        this.println("#ifndef INC_" + this.grammar.getClassName() + "_hpp_");
        this.println("#define INC_" + this.grammar.getClassName() + "_hpp_");
        this.println("");
        this.printHeaderAction(preIncludeHpp);
        this.println("#include <antlr/config.hpp>");
        this.println("#include \"" + this.grammar.tokenManager.getName() + CodeGenerator.TokenTypesFileSuffix + ".hpp\"");
        this.genHeader(this.outputFile);
        String sup = null;
        if (this.grammar.superClass != null) {
            sup = this.grammar.superClass;
            this.println("#include \"" + sup + ".hpp\"");
        } else {
            sup = this.grammar.getSuperClass();
            if (sup.lastIndexOf(46) != -1) {
                sup = sup.substring(sup.lastIndexOf(46) + 1);
            }
            this.println("#include <antlr/" + sup + ".hpp>");
            sup = namespaceAntlr + sup;
        }
        this.println("");
        this.printHeaderAction(postIncludeHpp);
        if (nameSpace != null) {
            nameSpace.emitDeclarations(this.currentOutput);
        }
        this.printHeaderAction("");
        if (this.grammar.comment != null) {
            this._println(this.grammar.comment);
        }
        this.print("class " + this.grammar.getClassName() + " : public " + sup);
        this.println(", public " + this.grammar.tokenManager.getName() + CodeGenerator.TokenTypesFileSuffix);
        Token tsuffix = (Token)this.grammar.options.get("classHeaderSuffix");
        if (tsuffix != null && (suffix = StringUtils.stripFrontBack(tsuffix.getText(), "\"", "\"")) != null) {
            this.print(", " + suffix);
        }
        this.println("{");
        if (this.grammar.classMemberAction != null) {
            this.genLineNo(this.grammar.classMemberAction.getLine());
            this.print(this.processActionForTreeSpecifiers(this.grammar.classMemberAction.getText(), this.grammar.classMemberAction.getLine(), this.currentRule, null));
            this.genLineNo2();
        }
        this.tabs = 0;
        this.println("public:");
        this.tabs = 1;
        this.println(this.grammar.getClassName() + "();");
        this.println("int getNumTokens() const");
        this.println("{");
        ++this.tabs;
        this.println("return " + this.grammar.getClassName() + "::NUM_TOKENS;");
        --this.tabs;
        this.println("}");
        this.println("const char* getTokenName( int type ) const");
        this.println("{");
        ++this.tabs;
        this.println("if( type > getNumTokens() ) return 0;");
        this.println("return " + this.grammar.getClassName() + "::tokenNames[type];");
        --this.tabs;
        this.println("}");
        Enumeration ids = this.grammar.rules.elements();
        String ruleNameInits = "";
        while (ids.hasMoreElements()) {
            GrammarSymbol sym = (GrammarSymbol)ids.nextElement();
            if (sym instanceof RuleSymbol) {
                RuleSymbol rs = (RuleSymbol)sym;
                this.genRuleHeader(rs, rs.references.size() == 0);
            }
            this.exitIfError();
        }
        if (this.usingCustomAST) {
            this.tabs = 0;
            this.println("public:");
            this.tabs = 1;
            this.println(this.labeledElementASTType + " getAST();");
            this.println("");
            this.tabs = 0;
            this.println("protected:");
            this.tabs = 1;
            this.println(this.labeledElementASTType + " returnAST;");
            this.println(this.labeledElementASTType + " _retTree;");
        }
        this.tabs = 0;
        this.println("private:");
        this.tabs = 1;
        this.println("static const char* tokenNames[];");
        this._println("#ifndef NO_STATIC_CONSTS");
        this.println("static const int NUM_TOKENS = " + this.grammar.tokenManager.getVocabulary().size() + ";");
        this._println("#else");
        this.println("enum {");
        this.println("\tNUM_TOKENS = " + this.grammar.tokenManager.getVocabulary().size());
        this.println("};");
        this._println("#endif");
        this.genBitsetsHeader(this.bitsetsUsed, this.grammar.tokenManager.maxTokenType());
        this.tabs = 0;
        this.println("};");
        this.println("");
        if (nameSpace != null) {
            nameSpace.emitClosures(this.currentOutput);
        }
        this.println("#endif /*INC_" + this.grammar.getClassName() + "_hpp_*/");
        this.currentOutput.close();
        this.currentOutput = null;
    }

    protected void genASTDeclaration(AlternativeElement el) {
        this.genASTDeclaration(el, this.labeledElementASTType);
    }

    protected void genASTDeclaration(AlternativeElement el, String node_type) {
        this.genASTDeclaration(el, el.getLabel(), node_type);
    }

    protected void genASTDeclaration(AlternativeElement el, String var_name, String node_type) {
        if (this.declaredASTVariables.contains(el)) {
            return;
        }
        String init = this.labeledElementASTInit;
        if (el instanceof GrammarAtom && ((GrammarAtom)el).getASTNodeType() != null) {
            init = "static_cast<Ref" + ((GrammarAtom)el).getASTNodeType() + ">(" + this.labeledElementASTInit + ")";
        }
        this.println(node_type + " " + var_name + "_AST = " + init + ";");
        this.declaredASTVariables.add(el);
    }

    private void genLiteralsTest() {
        this.println("_ttype = testLiteralsTable(_ttype);");
    }

    private void genLiteralsTestForPartialToken() {
        this.println("_ttype = testLiteralsTable(text.substr(_begin, text.length()-_begin),_ttype);");
    }

    protected void genMatch(BitSet b) {
    }

    protected void genMatch(GrammarAtom atom) {
        if (atom instanceof StringLiteralElement) {
            if (this.grammar instanceof LexerGrammar) {
                this.genMatchUsingAtomText(atom);
            } else {
                this.genMatchUsingAtomTokenType(atom);
            }
        } else if (atom instanceof CharLiteralElement) {
            if (this.grammar instanceof LexerGrammar) {
                this.genMatchUsingAtomText(atom);
            } else {
                this.antlrTool.error("cannot ref character literals in grammar: " + atom);
            }
        } else if (atom instanceof TokenRefElement) {
            this.genMatchUsingAtomText(atom);
        } else if (atom instanceof WildcardElement) {
            this.gen((WildcardElement)atom);
        }
    }

    protected void genMatchUsingAtomText(GrammarAtom atom) {
        String astArgs = "";
        if (this.grammar instanceof TreeWalkerGrammar) {
            astArgs = this.usingCustomAST ? "static_cast<" + namespaceAntlr + "RefAST" + ">(_t)," : "_t,";
        }
        if (this.grammar instanceof LexerGrammar && (!this.saveText || atom.getAutoGenType() == 3)) {
            this.println("_saveIndex=text.length();");
        }
        this.print(atom.not ? "matchNot(" : "match(");
        this._print(astArgs);
        if (atom.atomText.equals("EOF")) {
            this._print(namespaceAntlr + "Token::EOF_TYPE");
        } else {
            this._print(this.textOrChar(atom.atomText));
        }
        this._println(");");
        if (this.grammar instanceof LexerGrammar && (!this.saveText || atom.getAutoGenType() == 3)) {
            this.println("text.erase(_saveIndex);");
        }
    }

    protected void genMatchUsingAtomTokenType(GrammarAtom atom) {
        String astArgs = "";
        if (this.grammar instanceof TreeWalkerGrammar) {
            astArgs = this.usingCustomAST ? "static_cast<" + namespaceAntlr + "RefAST" + ">(_t)," : "_t,";
        }
        Object mangledName = null;
        String s = astArgs + this.getValueString(atom.getType());
        this.println((atom.not ? "matchNot(" : "match(") + s + ");");
    }

    public void genNextToken() {
        boolean hasPublicRules = false;
        int i = 0;
        while (i < this.grammar.rules.size()) {
            RuleSymbol rs = (RuleSymbol)this.grammar.rules.elementAt(i);
            if (rs.isDefined() && rs.access.equals("public")) {
                hasPublicRules = true;
                break;
            }
            ++i;
        }
        if (!hasPublicRules) {
            this.println("");
            this.println(namespaceAntlr + "RefToken " + this.grammar.getClassName() + "::nextToken() { return " + namespaceAntlr + "RefToken(new " + namespaceAntlr + "CommonToken(" + namespaceAntlr + "Token::EOF_TYPE, \"\")); }");
            this.println("");
            return;
        }
        RuleBlock nextTokenBlk = MakeGrammar.createNextTokenRule(this.grammar, this.grammar.rules, "nextToken");
        RuleSymbol nextTokenRs = new RuleSymbol("mnextToken");
        nextTokenRs.setDefined();
        nextTokenRs.setBlock(nextTokenBlk);
        nextTokenRs.access = "private";
        this.grammar.define(nextTokenRs);
        boolean ok = this.grammar.theLLkAnalyzer.deterministic(nextTokenBlk);
        String filterRule = null;
        if (((LexerGrammar)this.grammar).filterMode) {
            filterRule = ((LexerGrammar)this.grammar).filterRule;
        }
        this.println("");
        this.println(namespaceAntlr + "RefToken " + this.grammar.getClassName() + "::nextToken()");
        this.println("{");
        ++this.tabs;
        this.println(namespaceAntlr + "RefToken theRetToken;");
        this.println("for (;;) {");
        ++this.tabs;
        this.println(namespaceAntlr + "RefToken theRetToken;");
        this.println("int _ttype = " + namespaceAntlr + "Token::INVALID_TYPE;");
        if (((LexerGrammar)this.grammar).filterMode) {
            this.println("setCommitToPath(false);");
            if (filterRule != null) {
                if (!this.grammar.isDefined(CodeGenerator.encodeLexerRuleName(filterRule))) {
                    this.grammar.antlrTool.error("Filter rule " + filterRule + " does not exist in this lexer");
                } else {
                    RuleSymbol rs = (RuleSymbol)this.grammar.getSymbol(CodeGenerator.encodeLexerRuleName(filterRule));
                    if (!rs.isDefined()) {
                        this.grammar.antlrTool.error("Filter rule " + filterRule + " does not exist in this lexer");
                    } else if (rs.access.equals("public")) {
                        this.grammar.antlrTool.error("Filter rule " + filterRule + " must be protected");
                    }
                }
                this.println("int _m;");
                this.println("_m = mark();");
            }
        }
        this.println("resetText();");
        this.println("try {   // for lexical and char stream error handling");
        ++this.tabs;
        int i2 = 0;
        while (i2 < nextTokenBlk.getAlternatives().size()) {
            Alternative a = nextTokenBlk.getAlternativeAt(i2);
            if (a.cache[1].containsEpsilon()) {
                this.antlrTool.warning("found optional path in nextToken()");
            }
            ++i2;
        }
        String newline = System.getProperty("line.separator");
        CppBlockFinishingInfo howToFinish = this.genCommonBlock(nextTokenBlk, false);
        String errFinish = "if (LA(1)==EOF_CHAR)" + newline + "\t\t\t\t{" + newline + "\t\t\t\t\tuponEOF();" + newline + "\t\t\t\t\t_returnToken = makeToken(" + namespaceAntlr + "Token::EOF_TYPE);" + newline + "\t\t\t\t}";
        errFinish = errFinish + newline + "\t\t\t\t";
        errFinish = ((LexerGrammar)this.grammar).filterMode ? (filterRule == null ? errFinish + "else {consume(); goto tryAgain;}" : errFinish + "else {" + newline + "\t\t\t\t\tcommit();" + newline + "\t\t\t\t\ttry {m" + filterRule + "(false);}" + newline + "\t\t\t\t\tcatch(" + namespaceAntlr + "RecognitionException& e) {" + newline + "\t\t\t\t\t\t// catastrophic failure" + newline + "\t\t\t\t\t\treportError(e);" + newline + "\t\t\t\t\t\tconsume();" + newline + "\t\t\t\t\t}" + newline + "\t\t\t\t\tgoto tryAgain;" + newline + "\t\t\t\t}") : errFinish + "else {" + this.throwNoViable + "}";
        this.genBlockFinish(howToFinish, errFinish);
        if (((LexerGrammar)this.grammar).filterMode && filterRule != null) {
            this.println("commit();");
        }
        this.println("if ( !_returnToken )" + newline + "\t\t\t\tgoto tryAgain; // found SKIP token" + newline);
        this.println("_ttype = _returnToken->getType();");
        if (((LexerGrammar)this.grammar).getTestLiterals()) {
            this.genLiteralsTest();
        }
        this.println("_returnToken->setType(_ttype);");
        this.println("return _returnToken;");
        --this.tabs;
        this.println("}");
        this.println("catch (" + namespaceAntlr + "RecognitionException& e) {");
        ++this.tabs;
        if (((LexerGrammar)this.grammar).filterMode) {
            if (filterRule == null) {
                this.println("if ( !getCommitToPath() ) {");
                ++this.tabs;
                this.println("consume();");
                this.println("goto tryAgain;");
                --this.tabs;
                this.println("}");
            } else {
                this.println("if ( !getCommitToPath() ) {");
                ++this.tabs;
                this.println("rewind(_m);");
                this.println("resetText();");
                this.println("try {m" + filterRule + "(false);}");
                this.println("catch(" + namespaceAntlr + "RecognitionException& ee) {");
                this.println("\t// horrendous failure: error in filter rule");
                this.println("\treportError(ee);");
                this.println("\tconsume();");
                this.println("}");
                this.println("goto tryAgain;");
                --this.tabs;
                this.println("}");
            }
        }
        if (nextTokenBlk.getDefaultErrorHandler()) {
            this.println("reportError(e);");
            this.println("consume();");
        } else {
            this.println("throw " + namespaceAntlr + "TokenStreamRecognitionException(e);");
        }
        --this.tabs;
        this.println("}");
        this.println("catch (" + namespaceAntlr + "CharStreamIOException& csie) {");
        this.println("\tthrow " + namespaceAntlr + "TokenStreamIOException(csie.io);");
        this.println("}");
        this.println("catch (" + namespaceAntlr + "CharStreamException& cse) {");
        this.println("\tthrow " + namespaceAntlr + "TokenStreamException(cse.getMessage());");
        this.println("}");
        this._println("tryAgain:;");
        --this.tabs;
        this.println("}");
        --this.tabs;
        this.println("}");
        this.println("");
    }

    public void genRule(RuleSymbol s, boolean startSymbol, int ruleNum, String prefix) {
        RuleBlock rblk;
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genRule(" + s.getId() + ")");
        }
        if (!s.isDefined()) {
            this.antlrTool.error("undefined rule: " + s.getId());
            return;
        }
        this.currentRule = rblk = s.getBlock();
        this.currentASTResult = s.getId();
        this.declaredASTVariables.clear();
        boolean savegenAST = this.genAST;
        this.genAST = this.genAST && rblk.getAutoGen();
        this.saveText = rblk.getAutoGen();
        if (s.comment != null) {
            this._println(s.comment);
        }
        if (rblk.returnAction != null) {
            this._print(this.extractTypeOfAction(rblk.returnAction, rblk.getLine(), rblk.getColumn()) + " ");
        } else {
            this._print("void ");
        }
        this._print(prefix + s.getId() + "(");
        this._print(this.commonExtraParams);
        if (this.commonExtraParams.length() != 0 && rblk.argAction != null) {
            this._print(",");
        }
        if (rblk.argAction != null) {
            this._println("");
            ++this.tabs;
            this.println(rblk.argAction);
            --this.tabs;
            this.print(") ");
        } else {
            this._print(") ");
        }
        this._println("{");
        ++this.tabs;
        if (this.grammar.traceRules) {
            if (this.grammar instanceof TreeWalkerGrammar) {
                if (this.usingCustomAST) {
                    this.println("Tracer traceInOut(this,\"" + s.getId() + "\",static_cast<" + namespaceAntlr + "RefAST" + ">(_t));");
                } else {
                    this.println("Tracer traceInOut(this,\"" + s.getId() + "\",_t);");
                }
            } else {
                this.println("Tracer traceInOut(this, \"" + s.getId() + "\");");
            }
        }
        if (rblk.returnAction != null) {
            this.genLineNo(rblk);
            this.println(rblk.returnAction + ";");
            this.genLineNo2();
        }
        if (!this.commonLocalVars.equals("")) {
            this.println(this.commonLocalVars);
        }
        if (this.grammar instanceof LexerGrammar) {
            if (s.getId().equals("mEOF")) {
                this.println("_ttype = " + namespaceAntlr + "Token::EOF_TYPE;");
            } else {
                this.println("_ttype = " + s.getId().substring(1) + ";");
            }
            this.println("int _saveIndex;");
        }
        if (this.grammar.debuggingOutput) {
            if (this.grammar instanceof ParserGrammar) {
                this.println("fireEnterRule(" + ruleNum + ",0);");
            } else if (this.grammar instanceof LexerGrammar) {
                this.println("fireEnterRule(" + ruleNum + ",_ttype);");
            }
        }
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println(this.labeledElementASTType + " " + s.getId() + "_AST_in = _t;");
        }
        if (this.grammar.buildAST) {
            this.println("returnAST = " + this.labeledElementASTInit + ";");
            this.println(namespaceAntlr + "ASTPair currentAST;");
            this.println(this.labeledElementASTType + " " + s.getId() + "_AST = " + this.labeledElementASTInit + ";");
        }
        this.genBlockPreamble(rblk);
        this.genBlockInitAction(rblk);
        this.println("");
        ExceptionSpec unlabeledUserSpec = rblk.findExceptionSpec("");
        if (unlabeledUserSpec != null || rblk.getDefaultErrorHandler()) {
            this.println("try {      // for error handling");
            ++this.tabs;
        }
        if (rblk.alternatives.size() == 1) {
            Alternative alt = rblk.getAlternativeAt(0);
            String pred = alt.semPred;
            if (pred != null) {
                this.genSemPred(pred, this.currentRule.line);
            }
            if (alt.synPred != null) {
                this.antlrTool.warning("Syntactic predicate ignored for single alternative", this.grammar.getFilename(), alt.synPred.getLine(), alt.synPred.getColumn());
            }
            this.genAlt(alt, rblk);
        } else {
            boolean ok = this.grammar.theLLkAnalyzer.deterministic(rblk);
            CppBlockFinishingInfo howToFinish = this.genCommonBlock(rblk, false);
            this.genBlockFinish(howToFinish, this.throwNoViable);
        }
        if (unlabeledUserSpec != null || rblk.getDefaultErrorHandler()) {
            --this.tabs;
            this.println("}");
        }
        if (unlabeledUserSpec != null) {
            this.genErrorHandler(unlabeledUserSpec);
        } else if (rblk.getDefaultErrorHandler()) {
            this.println("catch (" + this.exceptionThrown + "& ex) {");
            ++this.tabs;
            if (this.grammar.hasSyntacticPredicate) {
                this.println("if( inputState->guessing == 0 ) {");
                ++this.tabs;
            }
            this.println("reportError(ex);");
            if (!(this.grammar instanceof TreeWalkerGrammar)) {
                Lookahead follow = this.grammar.theLLkAnalyzer.FOLLOW(1, rblk.endNode);
                String followSetName = this.getBitsetName(this.markBitsetForGen(follow.fset));
                this.println("consume();");
                this.println("consumeUntil(" + followSetName + ");");
            } else {
                this.println("if ( _t != " + this.labeledElementASTInit + " )");
                ++this.tabs;
                this.println("_t = _t->getNextSibling();");
                --this.tabs;
            }
            if (this.grammar.hasSyntacticPredicate) {
                --this.tabs;
                this.println("} else {");
                ++this.tabs;
                this.println("throw ex;");
                --this.tabs;
                this.println("}");
            }
            --this.tabs;
            this.println("}");
        }
        if (this.grammar.buildAST) {
            this.println("returnAST = " + s.getId() + "_AST;");
        }
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("_retTree = _t;");
        }
        if (rblk.getTestLiterals()) {
            if (s.access.equals("protected")) {
                this.genLiteralsTestForPartialToken();
            } else {
                this.genLiteralsTest();
            }
        }
        if (this.grammar instanceof LexerGrammar) {
            this.println("if ( _createToken && _token==" + namespaceAntlr + "nullToken && _ttype!=" + namespaceAntlr + "Token::SKIP ) {");
            this.println("   _token = makeToken(_ttype);");
            this.println("   _token->setText(text.substr(_begin, text.length()-_begin));");
            this.println("}");
            this.println("_returnToken = _token;");
            this.println("_saveIndex=0;");
        }
        if (rblk.returnAction != null) {
            this.println("return " + this.extractIdOfAction(rblk.returnAction, rblk.getLine(), rblk.getColumn()) + ";");
        }
        --this.tabs;
        this.println("}");
        this.println("");
        this.genAST = savegenAST;
    }

    public void genRuleHeader(RuleSymbol s, boolean startSymbol) {
        RuleBlock rblk;
        this.tabs = 1;
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genRuleHeader(" + s.getId() + ")");
        }
        if (!s.isDefined()) {
            this.antlrTool.error("undefined rule: " + s.getId());
            return;
        }
        this.currentRule = rblk = s.getBlock();
        this.currentASTResult = s.getId();
        boolean savegenAST = this.genAST;
        this.genAST = this.genAST && rblk.getAutoGen();
        this.saveText = rblk.getAutoGen();
        this.print(s.access + ": ");
        if (rblk.returnAction != null) {
            this._print(this.extractTypeOfAction(rblk.returnAction, rblk.getLine(), rblk.getColumn()) + " ");
        } else {
            this._print("void ");
        }
        this._print(s.getId() + "(");
        this._print(this.commonExtraParams);
        if (this.commonExtraParams.length() != 0 && rblk.argAction != null) {
            this._print(",");
        }
        if (rblk.argAction != null) {
            this._println("");
            ++this.tabs;
            this.println(rblk.argAction);
            --this.tabs;
            this.print(")");
        } else {
            this._print(")");
        }
        this._println(";");
        --this.tabs;
        this.genAST = savegenAST;
    }

    private void GenRuleInvocation(RuleRefElement rr) {
        this._print(rr.targetRule + "(");
        if (this.grammar instanceof LexerGrammar) {
            if (rr.getLabel() != null) {
                this._print("true");
            } else {
                this._print("false");
            }
            if (this.commonExtraArgs.length() != 0 || rr.args != null) {
                this._print(",");
            }
        }
        this._print(this.commonExtraArgs);
        if (this.commonExtraArgs.length() != 0 && rr.args != null) {
            this._print(",");
        }
        RuleSymbol rs = (RuleSymbol)this.grammar.getSymbol(rr.targetRule);
        if (rr.args != null) {
            ActionTransInfo tInfo = new ActionTransInfo();
            String args = this.processActionForTreeSpecifiers(rr.args, rr.line, this.currentRule, tInfo);
            if (tInfo.assignToRoot || tInfo.refRuleRoot != null) {
                this.antlrTool.error("Arguments of rule reference '" + rr.targetRule + "' cannot set or ref #" + this.currentRule.getRuleName() + " on line " + rr.getLine());
            }
            this._print(args);
            if (rs.block.argAction == null) {
                this.antlrTool.warning("Rule '" + rr.targetRule + "' accepts no arguments", this.grammar.getFilename(), rr.getLine(), rr.getColumn());
            }
        }
        this._println(");");
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("_t = _retTree;");
        }
    }

    protected void genSemPred(String pred, int line) {
        ActionTransInfo tInfo = new ActionTransInfo();
        pred = this.processActionForTreeSpecifiers(pred, line, this.currentRule, tInfo);
        String escapedPred = this.charFormatter.escapeString(pred);
        if (this.grammar.debuggingOutput && (this.grammar instanceof ParserGrammar || this.grammar instanceof LexerGrammar)) {
            pred = "fireSemanticPredicateEvaluated(de.hunsicker.antlr.debug.SemanticPredicateEvent.VALIDATING," + this.addSemPred(escapedPred) + "," + pred + ")";
        }
        this.println("if (!(" + pred + "))");
        ++this.tabs;
        this.println("throw " + namespaceAntlr + "SemanticException(\"" + escapedPred + "\");");
        --this.tabs;
    }

    protected void genSemPredMap(String prefix) {
        Enumeration e = this.semPreds.elements();
        this.println("const char* " + prefix + "_semPredNames[] = {");
        ++this.tabs;
        while (e.hasMoreElements()) {
            this.println("\"" + e.nextElement() + "\",");
        }
        this.println("0");
        --this.tabs;
        this.println("};");
    }

    protected void genSynPred(SynPredBlock blk, String lookaheadExpr) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("gen=>(" + blk + ")");
        }
        this.println("bool synPredMatched" + blk.ID + " = false;");
        this.println("if (" + lookaheadExpr + ") {");
        ++this.tabs;
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println(this.labeledElementType + " __t" + blk.ID + " = _t;");
        } else {
            this.println("int _m" + blk.ID + " = mark();");
        }
        this.println("synPredMatched" + blk.ID + " = true;");
        this.println("inputState->guessing++;");
        if (this.grammar.debuggingOutput && (this.grammar instanceof ParserGrammar || this.grammar instanceof LexerGrammar)) {
            this.println("fireSyntacticPredicateStarted();");
        }
        ++this.syntacticPredLevel;
        this.println("try {");
        ++this.tabs;
        this.gen(blk);
        --this.tabs;
        this.println("}");
        this.println("catch (" + this.exceptionThrown + "& pe) {");
        ++this.tabs;
        this.println("synPredMatched" + blk.ID + " = false;");
        --this.tabs;
        this.println("}");
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("_t = __t" + blk.ID + ";");
        } else {
            this.println("rewind(_m" + blk.ID + ");");
        }
        this.println("inputState->guessing--;");
        if (this.grammar.debuggingOutput && (this.grammar instanceof ParserGrammar || this.grammar instanceof LexerGrammar)) {
            this.println("if (synPredMatched" + blk.ID + ")");
            this.println("  fireSyntacticPredicateSucceeded();");
            this.println("else");
            this.println("  fireSyntacticPredicateFailed();");
        }
        --this.syntacticPredLevel;
        --this.tabs;
        this.println("}");
        this.println("if ( synPredMatched" + blk.ID + " ) {");
    }

    public void genTokenStrings(String prefix) {
        this.println("const char* " + prefix + "tokenNames[] = {");
        ++this.tabs;
        Vector v = this.grammar.tokenManager.getVocabulary();
        int i = 0;
        while (i < v.size()) {
            TokenSymbol ts;
            String s = (String)v.elementAt(i);
            if (s == null) {
                s = "<" + String.valueOf(i) + ">";
            }
            if (!s.startsWith("\"") && !s.startsWith("<") && (ts = this.grammar.tokenManager.getTokenSymbol(s)) != null && ts.getParaphrase() != null) {
                s = StringUtils.stripFrontBack(ts.getParaphrase(), "\"", "\"");
            }
            this.print(this.charFormatter.literalString(s));
            this._println(",");
            ++i;
        }
        this.println("0");
        --this.tabs;
        this.println("};");
    }

    protected void genTokenTypes(TokenManager tm) throws IOException {
        this.outputFile = tm.getName() + CodeGenerator.TokenTypesFileSuffix + ".hpp";
        this.outputLine = 1;
        this.currentOutput = this.antlrTool.openOutputFile(this.outputFile);
        this.tabs = 0;
        this.println("#ifndef INC_" + tm.getName() + CodeGenerator.TokenTypesFileSuffix + "_hpp_");
        this.println("#define INC_" + tm.getName() + CodeGenerator.TokenTypesFileSuffix + "_hpp_");
        this.println("");
        if (nameSpace != null) {
            nameSpace.emitDeclarations(this.currentOutput);
        }
        this.genHeader(this.outputFile);
        this.println("struct " + tm.getName() + CodeGenerator.TokenTypesFileSuffix + " {");
        ++this.tabs;
        this.println("enum {");
        ++this.tabs;
        Vector v = tm.getVocabulary();
        this.println("EOF_ = 1,");
        int i = 4;
        while (i < v.size()) {
            String s = (String)v.elementAt(i);
            if (s != null) {
                if (s.startsWith("\"")) {
                    StringLiteralSymbol sl = (StringLiteralSymbol)tm.getTokenSymbol(s);
                    if (sl == null) {
                        this.antlrTool.panic("String literal " + s + " not in symbol table");
                    } else if (sl.label != null) {
                        this.println(sl.label + " = " + i + ",");
                    } else {
                        String mangledName = this.mangleLiteral(s);
                        if (mangledName != null) {
                            this.println(mangledName + " = " + i + ",");
                            sl.label = mangledName;
                        } else {
                            this.println("// " + s + " = " + i);
                        }
                    }
                } else if (!s.startsWith("<")) {
                    this.println(s + " = " + i + ",");
                }
            }
            ++i;
        }
        this.println("NULL_TREE_LOOKAHEAD = 3");
        --this.tabs;
        this.println("};");
        --this.tabs;
        this.println("};");
        if (nameSpace != null) {
            nameSpace.emitClosures(this.currentOutput);
        }
        this.println("#endif /*INC_" + tm.getName() + CodeGenerator.TokenTypesFileSuffix + "_hpp_*/");
        this.currentOutput.close();
        this.currentOutput = null;
        this.exitIfError();
    }

    public String processStringForASTConstructor(String str) {
        if (this.usingCustomAST && (this.grammar instanceof TreeWalkerGrammar || this.grammar instanceof ParserGrammar) && !this.grammar.tokenManager.tokenDefined(str)) {
            return "static_cast<" + namespaceAntlr + "RefAST>(" + str + ")";
        }
        return str;
    }

    public String getASTCreateString(Vector v) {
        if (v.size() == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        buf.append(this.labeledElementASTType + "(astFactory->make((new " + namespaceAntlr + "ASTArray(" + v.size() + "))");
        int i = 0;
        while (i < v.size()) {
            buf.append("->add(" + v.elementAt(i) + ")");
            ++i;
        }
        buf.append("))");
        return buf.toString();
    }

    public String getASTCreateString(GrammarAtom atom, String str) {
        if (atom != null && atom.getASTNodeType() != null) {
            this.astTypes.appendElement("astFactory->registerFactory(" + atom.getType() + ", \"" + atom.getASTNodeType() + "\", " + atom.getASTNodeType() + "::factory);");
            return "astFactory->create(" + str + ")";
        }
        boolean is_constructor = false;
        if (str.indexOf(44) != -1) {
            is_constructor = this.grammar.tokenManager.tokenDefined(str.substring(0, str.indexOf(44)));
        }
        if (this.usingCustomAST && this.grammar instanceof TreeWalkerGrammar && !this.grammar.tokenManager.tokenDefined(str) && !is_constructor) {
            return "astFactory->create(static_cast<" + namespaceAntlr + "RefAST>(" + str + "))";
        }
        return "astFactory->create(" + str + ")";
    }

    public String getASTCreateString(String str) {
        if (this.usingCustomAST) {
            return "static_cast<" + this.labeledElementASTType + ">(astFactory->create(static_cast<" + namespaceAntlr + "RefAST>(" + str + ")))";
        }
        return "astFactory->create(" + str + ")";
    }

    protected String getLookaheadTestExpression(Lookahead[] look, int k) {
        StringBuffer e = new StringBuffer(100);
        boolean first = true;
        e.append("(");
        int i = 1;
        while (i <= k) {
            BitSet p = look[i].fset;
            if (!first) {
                e.append(") && (");
            }
            first = false;
            if (look[i].containsEpsilon()) {
                e.append("true");
            } else {
                e.append(this.getLookaheadTestTerm(i, p));
            }
            ++i;
        }
        e.append(")");
        return e.toString();
    }

    protected String getLookaheadTestExpression(Alternative alt, int maxDepth) {
        int depth = alt.lookaheadDepth;
        if (depth == Integer.MAX_VALUE) {
            depth = this.grammar.maxk;
        }
        if (maxDepth == 0) {
            return "true";
        }
        return "(" + this.getLookaheadTestExpression(alt.cache, depth) + ")";
    }

    protected String getLookaheadTestTerm(int k, BitSet p) {
        String ts = this.lookaheadString(k);
        int[] elems = p.toArray();
        if (CodeGenerator.elementsAreRange(elems)) {
            return this.getRangeExpression(k, elems);
        }
        int degree = p.degree();
        if (degree == 0) {
            return "true";
        }
        if (degree >= this.bitsetTestThreshold) {
            int bitsetIdx = this.markBitsetForGen(p);
            return this.getBitsetName(bitsetIdx) + ".member(" + ts + ")";
        }
        StringBuffer e = new StringBuffer();
        int i = 0;
        while (i < elems.length) {
            String cs = this.getValueString(elems[i]);
            if (i > 0) {
                e.append(" || ");
            }
            e.append(ts);
            e.append(" == ");
            e.append(cs);
            ++i;
        }
        return e.toString();
    }

    public String getRangeExpression(int k, int[] elems) {
        if (!CodeGenerator.elementsAreRange(elems)) {
            this.antlrTool.panic("getRangeExpression called with non-range");
        }
        int begin = elems[0];
        int end = elems[elems.length - 1];
        return "(" + this.lookaheadString(k) + " >= " + this.getValueString(begin) + " && " + this.lookaheadString(k) + " <= " + this.getValueString(end) + ")";
    }

    private String getValueString(int value) {
        String cs;
        if (this.grammar instanceof LexerGrammar) {
            cs = this.charFormatter.literalChar(value);
        } else {
            TokenSymbol ts = this.grammar.tokenManager.getTokenSymbolAt(value);
            if (ts == null) {
                return "" + value;
            }
            String tId = ts.getId();
            if (ts instanceof StringLiteralSymbol) {
                StringLiteralSymbol sl = (StringLiteralSymbol)ts;
                String label = sl.getLabel();
                if (label != null) {
                    cs = label;
                } else {
                    cs = this.mangleLiteral(tId);
                    if (cs == null) {
                        cs = String.valueOf(value);
                    }
                }
            } else {
                cs = tId.equals("EOF") ? namespaceAntlr + "Token::EOF_TYPE" : tId;
            }
        }
        return cs;
    }

    protected boolean lookaheadIsEmpty(Alternative alt, int maxDepth) {
        int depth = alt.lookaheadDepth;
        if (depth == Integer.MAX_VALUE) {
            depth = this.grammar.maxk;
        }
        int i = 1;
        while (i <= depth && i <= maxDepth) {
            BitSet p = alt.cache[i].fset;
            if (p.degree() != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private String lookaheadString(int k) {
        if (this.grammar instanceof TreeWalkerGrammar) {
            return "_t->getType()";
        }
        return "LA(" + k + ")";
    }

    private String mangleLiteral(String s) {
        String mangled = Tool.literalsPrefix;
        int i = 1;
        while (i < s.length() - 1) {
            if (!Character.isLetter(s.charAt(i)) && s.charAt(i) != '_') {
                return null;
            }
            mangled = mangled + s.charAt(i);
            ++i;
        }
        if (Tool.upperCaseMangledLiterals) {
            mangled = mangled.toUpperCase();
        }
        return mangled;
    }

    public String mapTreeId(String idParam, ActionTransInfo transInfo) {
        if (this.currentRule == null) {
            return idParam;
        }
        boolean in_var = false;
        String id = idParam;
        if (this.grammar instanceof TreeWalkerGrammar) {
            if (!this.grammar.buildAST) {
                in_var = true;
            }
            if (id.length() > 3 && id.lastIndexOf("_in") == id.length() - 3) {
                id = id.substring(0, id.length() - 3);
                in_var = true;
            }
        }
        int i = 0;
        while (i < this.currentRule.labeledElements.size()) {
            AlternativeElement elt = (AlternativeElement)this.currentRule.labeledElements.elementAt(i);
            if (elt.getLabel().equals(id)) {
                return in_var ? id : id + "_AST";
            }
            ++i;
        }
        String s = (String)this.treeVariableMap.get(id);
        if (s != null) {
            if (s == NONUNIQUE) {
                return null;
            }
            if (s.equals(this.currentRule.getRuleName())) {
                return null;
            }
            return in_var ? s + "_in" : s;
        }
        if (id.equals(this.currentRule.getRuleName())) {
            String r;
            String string = r = in_var ? id + "_AST_in" : id + "_AST";
            if (transInfo != null && !in_var) {
                transInfo.refRuleRoot = r;
            }
            return r;
        }
        return id;
    }

    private void mapTreeVariable(AlternativeElement e, String name) {
        if (e instanceof TreeElement) {
            this.mapTreeVariable(((TreeElement)e).root, name);
            return;
        }
        String elName = null;
        if (e.getLabel() == null) {
            if (e instanceof TokenRefElement) {
                elName = ((TokenRefElement)e).atomText;
            } else if (e instanceof RuleRefElement) {
                elName = ((RuleRefElement)e).targetRule;
            }
        }
        if (elName != null) {
            if (this.treeVariableMap.get(elName) != null) {
                this.treeVariableMap.remove(elName);
                this.treeVariableMap.put(elName, NONUNIQUE);
            } else {
                this.treeVariableMap.put(elName, name);
            }
        }
    }

    protected String processActionForTreeSpecifiers(String actionStr, int line, RuleBlock currentRule, ActionTransInfo tInfo) {
        if (actionStr == null || actionStr.length() == 0) {
            return null;
        }
        if (this.grammar == null) {
            return actionStr;
        }
        if (this.grammar.buildAST && actionStr.indexOf(35) != -1 || this.grammar instanceof TreeWalkerGrammar || (this.grammar instanceof LexerGrammar || this.grammar instanceof ParserGrammar) && actionStr.indexOf(36) != -1) {
            ActionLexer lexer = new ActionLexer(actionStr, currentRule, this, tInfo);
            lexer.setLineOffset(line);
            lexer.setFilename(this.grammar.getFilename());
            lexer.setTool(this.antlrTool);
            try {
                lexer.mACTION(true);
                actionStr = lexer.getTokenObject().getText();
            }
            catch (RecognitionException ex) {
                lexer.reportError(ex);
                return actionStr;
            }
            catch (TokenStreamException tex) {
                this.antlrTool.panic("Error reading action:" + actionStr);
                return actionStr;
            }
            catch (CharStreamException io) {
                this.antlrTool.panic("Error reading action:" + actionStr);
                return actionStr;
            }
        }
        return actionStr;
    }

    private String fixNameSpaceOption(String ns) {
        if ((ns = StringUtils.stripFrontBack(ns, "\"", "\"")).length() > 2 && !ns.substring(ns.length() - 2, ns.length()).equals("::")) {
            ns = ns + "::";
        }
        return ns;
    }

    private void setupGrammarParameters(Grammar g) {
        String suffix;
        Token tsuffix;
        if (g instanceof ParserGrammar || g instanceof LexerGrammar || g instanceof TreeWalkerGrammar) {
            String ns;
            Token t;
            if (this.antlrTool.nameSpace != null) {
                nameSpace = this.antlrTool.nameSpace;
            }
            if (this.antlrTool.namespaceStd != null) {
                namespaceStd = this.fixNameSpaceOption(this.antlrTool.namespaceStd);
            }
            if (this.antlrTool.namespaceAntlr != null) {
                namespaceAntlr = this.fixNameSpaceOption(this.antlrTool.namespaceAntlr);
            }
            this.genHashLines = this.antlrTool.genHashLines;
            if (g.hasOption("namespace") && (t = g.getOption("namespace")) != null) {
                nameSpace = new NameSpace(t.getText());
            }
            if (g.hasOption("namespaceAntlr") && (t = g.getOption("namespaceAntlr")) != null && (ns = StringUtils.stripFrontBack(t.getText(), "\"", "\"")) != null) {
                if (ns.length() > 2 && !ns.substring(ns.length() - 2, ns.length()).equals("::")) {
                    ns = ns + "::";
                }
                namespaceAntlr = ns;
            }
            if (g.hasOption("namespaceStd") && (t = g.getOption("namespaceStd")) != null && (ns = StringUtils.stripFrontBack(t.getText(), "\"", "\"")) != null) {
                if (ns.length() > 2 && !ns.substring(ns.length() - 2, ns.length()).equals("::")) {
                    ns = ns + "::";
                }
                namespaceStd = ns;
            }
            if (g.hasOption("genHashLines") && (t = g.getOption("genHashLines")) != null) {
                String val = StringUtils.stripFrontBack(t.getText(), "\"", "\"");
                this.genHashLines = val.equals("true");
            }
        }
        if (g instanceof ParserGrammar) {
            this.labeledElementASTType = namespaceAntlr + "RefAST";
            this.labeledElementASTInit = namespaceAntlr + "nullAST";
            if (g.hasOption("ASTLabelType") && (tsuffix = g.getOption("ASTLabelType")) != null && (suffix = StringUtils.stripFrontBack(tsuffix.getText(), "\"", "\"")) != null) {
                this.usingCustomAST = true;
                this.labeledElementASTType = suffix;
                this.labeledElementASTInit = "static_cast<" + suffix + ">(" + namespaceAntlr + "nullAST)";
            }
            this.labeledElementType = namespaceAntlr + "RefToken ";
            this.labeledElementInit = namespaceAntlr + "nullToken";
            this.commonExtraArgs = "";
            this.commonExtraParams = "";
            this.commonLocalVars = "";
            this.lt1Value = "LT(1)";
            this.exceptionThrown = namespaceAntlr + "RecognitionException";
            this.throwNoViable = "throw " + namespaceAntlr + "NoViableAltException(LT(1), getFilename());";
        } else if (g instanceof LexerGrammar) {
            this.labeledElementType = "char ";
            this.labeledElementInit = "'\\0'";
            this.commonExtraArgs = "";
            this.commonExtraParams = "bool _createToken";
            this.commonLocalVars = "int _ttype; " + namespaceAntlr + "RefToken _token; int _begin=text.length();";
            this.lt1Value = "LA(1)";
            this.exceptionThrown = namespaceAntlr + "RecognitionException";
            this.throwNoViable = "throw " + namespaceAntlr + "NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());";
        } else if (g instanceof TreeWalkerGrammar) {
            this.labeledElementInit = namespaceAntlr + "nullAST";
            this.labeledElementASTInit = namespaceAntlr + "nullAST";
            this.labeledElementASTType = namespaceAntlr + "RefAST";
            this.labeledElementType = namespaceAntlr + "RefAST";
            this.commonExtraParams = namespaceAntlr + "RefAST _t";
            this.throwNoViable = "throw " + namespaceAntlr + "NoViableAltException(_t);";
            this.lt1Value = "_t";
            if (g.hasOption("ASTLabelType") && (tsuffix = g.getOption("ASTLabelType")) != null && (suffix = StringUtils.stripFrontBack(tsuffix.getText(), "\"", "\"")) != null) {
                this.usingCustomAST = true;
                this.labeledElementASTType = suffix;
                this.labeledElementType = suffix;
                this.labeledElementASTInit = this.labeledElementInit = "static_cast<" + suffix + ">(" + namespaceAntlr + "nullAST)";
                this.commonExtraParams = suffix + " _t";
                this.throwNoViable = "throw " + namespaceAntlr + "NoViableAltException(static_cast<" + namespaceAntlr + "RefAST>(_t));";
                this.lt1Value = "_t";
            }
            if (!g.hasOption("ASTLabelType")) {
                g.setOption("ASTLabelType", new Token(6, namespaceAntlr + "RefAST"));
            }
            this.commonExtraArgs = "_t";
            this.commonLocalVars = "";
            this.exceptionThrown = namespaceAntlr + "RecognitionException";
        } else {
            this.antlrTool.panic("Unknown grammar type");
        }
    }

    private String textOrChar(String text) {
        if (text.startsWith("'")) {
            return this.charFormatter.literalChar(ANTLRLexer.tokenTypeForCharLiteral(text));
        }
        return text;
    }
}

