/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.swing.syntax;

import de.hunsicker.jalopy.swing.syntax.SyntaxDocument;
import de.hunsicker.jalopy.swing.syntax.SyntaxUtilities;
import de.hunsicker.jalopy.swing.syntax.TokenMarker;
import java.awt.Color;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;

public class DefaultSyntaxDocument
extends PlainDocument
implements SyntaxDocument {
    protected TokenMarker tokenMarker;
    protected Color[] colors = SyntaxUtilities.getDefaultSyntaxColors();

    public DefaultSyntaxDocument() {
        this.addDocumentListener(new DocumentHandler());
    }

    public void setColors(Color[] colors) {
        this.colors = colors;
    }

    public Color[] getColors() {
        return this.colors;
    }

    public void setTokenMarker(TokenMarker tm) {
        this.tokenMarker = tm;
        if (tm == null) {
            return;
        }
        this.tokenMarker.insertLines(0, this.getDefaultRootElement().getElementCount());
        this.tokenizeLines();
    }

    public TokenMarker getTokenMarker() {
        return this.tokenMarker;
    }

    public void tokenizeLines() {
        this.tokenizeLines(0, this.getDefaultRootElement().getElementCount());
    }

    public void tokenizeLines(int start, int len) {
        if (this.tokenMarker == null) {
            return;
        }
        Segment lineSegment = new Segment();
        Element map = this.getDefaultRootElement();
        len += start;
        try {
            for (int i = start; i < len; ++i) {
                Element lineElement = map.getElement(i);
                int lineStart = lineElement.getStartOffset();
                this.getText(lineStart, lineElement.getEndOffset() - lineStart - 1, lineSegment);
                this.tokenMarker.markTokens(lineSegment, i);
            }
        }
        catch (BadLocationException bl) {
            // empty catch block
        }
    }

    public final class DocumentHandler
    implements DocumentListener {
        public void changedUpdate(DocumentEvent evt) {
        }

        public void insertUpdate(DocumentEvent evt) {
            if (DefaultSyntaxDocument.this.tokenMarker == null) {
                return;
            }
            DocumentEvent.ElementChange ch = evt.getChange(DefaultSyntaxDocument.this.getDefaultRootElement());
            if (ch == null) {
                return;
            }
            DefaultSyntaxDocument.this.tokenMarker.insertLines(ch.getIndex() + 1, ch.getChildrenAdded().length - ch.getChildrenRemoved().length);
        }

        public void removeUpdate(DocumentEvent evt) {
            if (DefaultSyntaxDocument.this.tokenMarker == null) {
                return;
            }
            DocumentEvent.ElementChange ch = evt.getChange(DefaultSyntaxDocument.this.getDefaultRootElement());
            if (ch == null) {
                return;
            }
            Element[] children = ch.getChildrenRemoved();
            if (children == null) {
                return;
            }
            DefaultSyntaxDocument.this.tokenMarker.deleteLines(ch.getIndex() + 1, ch.getChildrenRemoved().length - ch.getChildrenAdded().length);
        }
    }
}

