/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import de.hunsicker.antlr.collections.AST;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.Marker;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.printer.TestNodeWriter;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

final class ThrowsPrinter
extends AbstractPrinter {
    private static final Printer INSTANCE = new ThrowsPrinter();

    protected ThrowsPrinter() {
    }

    public static final Printer getInstance() {
        return INSTANCE;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void print(AST node, NodeWriter out) throws IOException {
        boolean indentCustom;
        int indentSize;
        boolean indentDeep;
        int lineLength;
        boolean wrapLines;
        boolean wrappedAfter;
        boolean wrappedBefore;
        block27: {
            Marker marker;
            block28: {
                int deepIndent;
                int indentLength;
                AST firstType;
                block29: {
                    firstType = node.getFirstChild();
                    wrappedBefore = false;
                    wrappedAfter = false;
                    marker = null;
                    wrapLines = settings.getBoolean(ConventionKeys.LINE_WRAP, true) && out.mode == 1;
                    lineLength = settings.getInt(ConventionKeys.LINE_LENGTH, 80);
                    indentDeep = settings.getBoolean(ConventionKeys.INDENT_DEEP, false);
                    indentLength = out.getIndentLength();
                    deepIndent = settings.getInt(ConventionKeys.INDENT_SIZE_DEEP, 55);
                    indentSize = settings.getInt(ConventionKeys.INDENT_SIZE_THROWS, -1);
                    boolean bl = indentCustom = indentSize > -1;
                    if (out.mode != 1) break block28;
                    if (out.newline) break block29;
                    if (!settings.getBoolean(ConventionKeys.LINE_WRAP_BEFORE_THROWS, false) && (!wrapLines || !this.exceedsBarriers(node, firstType, lineLength, deepIndent, out))) break block28;
                }
                wrappedBefore = true;
                if (!out.newline) {
                    out.printNewline();
                }
                if (indentCustom) {
                    out.print(out.getString(indentSize), 153);
                    out.print("throws ", 90);
                    marker = out.state.markers.add();
                    break block27;
                } else if (indentDeep && this.canAlign(firstType, lineLength, deepIndent, out)) {
                    marker = out.state.markers.getLast();
                    out.print(out.getString(marker.column - indentLength - 7), 153);
                    out.print("throws ", 90);
                    break block27;
                } else {
                    indentDeep = false;
                    out.indent();
                    out.print("throws ", 90);
                    marker = out.state.markers.add();
                }
                break block27;
            }
            out.print(" throws ", 90);
            marker = out.state.markers.add();
        }
        boolean spaceAfterComma = settings.getBoolean(ConventionKeys.SPACE_AFTER_COMMA, true);
        boolean forceWrapping = settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_TYPES_THROWS, false);
        boolean wrapAll = settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_TYPES_THROWS_EXCEED, false) && out.mode == 1;
        TestNodeWriter tester = null;
        if (wrapLines || wrapAll) {
            tester = out.testers.get();
        }
        if (!forceWrapping && wrapAll) {
            PrinterFactory.create(node).print(node, tester);
            if (tester.length - 7 + out.column > lineLength) {
                forceWrapping = true;
            }
            tester.reset();
        }
        block3: for (AST child = firstType; child != null; child = child.getNextSibling()) {
            switch (child.getType()) {
                case 82: {
                    AST next;
                    out.print(",", 82);
                    if (spaceAfterComma) {
                        out.print(" ", 153);
                    }
                    if (forceWrapping) {
                        out.printNewline();
                        if (!wrappedAfter) {
                            wrappedAfter = true;
                            if (!indentDeep) {
                                out.indent();
                            }
                        }
                        if (indentCustom && wrappedBefore) {
                            this.printIndentation(indentSize, out);
                            continue block3;
                        }
                        this.printIndentation(out);
                        continue block3;
                    }
                    if (!wrapLines || (next = child.getNextSibling()) == null) continue block3;
                    PrinterFactory.create(next).print(next, tester);
                    if (tester.length + out.column > lineLength) {
                        out.printNewline();
                        if (!wrappedAfter) {
                            wrappedAfter = true;
                            if (!indentDeep) {
                                out.indent();
                            }
                        }
                        if (indentCustom && wrappedBefore) {
                            this.printIndentation(indentSize, out);
                        } else {
                            this.printIndentation(out);
                        }
                    }
                    tester.reset();
                    continue block3;
                }
                default: {
                    PrinterFactory.create(child).print(child, out);
                }
            }
        }
        if (tester != null) {
            out.testers.release(tester);
        }
        if (!indentDeep) {
            if (!indentCustom && wrappedBefore) {
                out.unindent();
            }
            if (wrappedAfter) {
                out.unindent();
            }
        }
        if (settings.getBoolean(ConventionKeys.BRACE_TREAT_DIFFERENT_IF_WRAPPED, false) && (wrappedBefore || wrappedAfter || out.state.parametersWrapped)) {
            out.state.newlineBeforeLeftBrace = true;
        }
    }

    private boolean canAlign(AST node, int lineLength, int deepIndent, NodeWriter out) throws IOException {
        TestNodeWriter tester = out.testers.get();
        PrinterFactory.create(node).print(node, tester);
        Marker marker = out.state.markers.getLast();
        if (marker.column - 7 < deepIndent && marker.column + tester.length < lineLength && marker.column - out.getIndentLength() - 7 > 0) {
            out.testers.release(tester);
            return true;
        }
        out.testers.release(tester);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exceedsBarriers(AST node, AST firstType, int lineLength, int deepIndent, NodeWriter out) throws IOException {
        if (out.column + 1 > deepIndent) {
            return true;
        }
        TestNodeWriter tester = out.testers.get();
        try {
            PrinterFactory.create(node).print(node, tester);
            if (out.column + tester.length > lineLength) {
                boolean bl = true;
                return bl;
            }
            tester.reset();
            PrinterFactory.create(firstType).print(firstType, tester);
            if (out.column + 7 + tester.length > lineLength) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            out.testers.release(tester);
        }
    }
}

