/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.plugin.console;

import de.hunsicker.io.DirectoryScanner;
import de.hunsicker.io.ExtensionFilter;
import de.hunsicker.io.FileFormat;
import de.hunsicker.jalopy.Jalopy;
import de.hunsicker.jalopy.VersionMismatchException;
import de.hunsicker.jalopy.language.ClassRepository;
import de.hunsicker.jalopy.storage.Convention;
import de.hunsicker.jalopy.storage.ConventionDefaults;
import de.hunsicker.jalopy.storage.ConventionKeys;
import de.hunsicker.jalopy.storage.History;
import de.hunsicker.jalopy.storage.Loggers;
import de.hunsicker.util.StringHelper;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.oro.io.Perl5FilenameFilter;
import org.apache.oro.text.regex.Perl5Compiler;

public final class ConsolePlugin {
    private static final int OPT_NOBACKUP = -10;
    private static final int OPT_FORCE = -100;
    private static final int OPT_DISCLAIMER = -1000;
    private static final int OPT_CLASSPATH = -10000;
    private static final int IO_FILE = 1;
    private static final int IO_SYSTEM = 2;
    private static String _argString;
    private static final Object _lock;
    private static final Logger _logger;
    private static volatile int _numFiles;
    private static DirectoryScanner _scanner;
    private static int _threadCount;
    private static int _threads;
    private static final LongOpt[] LONG_OPTIONS;
    private static final ResourceBundle BUNDLE;
    private static String CONSOLE_APPENDER_NAME;
    private File _destDir;
    private FileFormat _fileFormat = FileFormat.AUTO;
    private Level _loglevel;
    private String _convention;
    private String _encoding;
    private boolean _force;
    private boolean _noBackup;
    private int _exitCode;
    private int _ioMode = 1;

    private ConsolePlugin() {
    }

    public static String getVersion() {
        return Package.getPackage("de.hunsicker.jalopy.plugin.console").getImplementationVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        long start = System.currentTimeMillis();
        ConsolePlugin console = new ConsolePlugin();
        console.parseArgs(argv);
        console.initializeLogging();
        if (console._ioMode != 2 && !console.scan()) {
            if (_argString != null) {
                Object[] args = new Object[]{_argString};
                System.err.println(MessageFormat.format(BUNDLE.getString("NON_MATCHING_EXPRESSION"), args));
                System.exit(1);
            }
        } else {
            try {
                Jalopy.checkCompatibility(StringHelper.getPackageName(console.getClass().getName()));
            }
            catch (VersionMismatchException ex) {
                Object[] args = new Object[]{ex.getExpected(), ex.getFound()};
                System.err.println(MessageFormat.format(BUNDLE.getString("VERSION_MISMATCH"), args));
                System.exit(1);
            }
            if (_threads == 1) {
                console.format();
            } else {
                _threadCount = _threads;
                for (int i = 0; i < _threads; ++i) {
                    new FormatThread(console).start();
                }
                try {
                    Object i = _lock;
                    synchronized (i) {
                        while (_threadCount > 0) {
                            _lock.wait();
                        }
                    }
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
            }
            Object[] objectArray = new Object[3];
            objectArray[0] = new Integer(_numFiles);
            objectArray[1] = new Integer(_numFiles);
            objectArray[2] = console.getRuntime(System.currentTimeMillis() - start);
            Object[] args = objectArray;
            _logger.l7dlog((Priority)Level.INFO, "RUN_INFO", args, null);
        }
    }

    private void setExitCode(int code) {
        this._exitCode = code;
    }

    private int getExitCode() {
        return this._exitCode;
    }

    private LongOpt[] getLongOptions() {
        return LONG_OPTIONS;
    }

    private String getOptString() {
        return "c:d:e:f:hl:s:r::t:v";
    }

    private String getRuntime(long time) {
        StringBuffer buf = new StringBuffer(8);
        long hour = time / 3600000L;
        long min = (time -= hour * 3600000L) / 60000L;
        long sec = (time -= min * 60000L) / 1000L;
        long msec = time -= sec * 1000L;
        if (hour > 0L) {
            if (hour < 10L) {
                buf.append('0');
            }
            buf.append(hour);
            buf.append(':');
        }
        if (min > 0L) {
            if (min < 10L) {
                buf.append('0');
            }
            buf.append(min);
            if (hour == 0L) {
                buf.append(':');
            }
        }
        if (hour == 0L && sec > 0L) {
            if (min > 0L && sec < 10L) {
                buf.append('0');
            }
            buf.append(sec);
            if (min == 0L && sec < 2L) {
                buf.append('.');
            }
        }
        if (min == 0L && sec < 2L) {
            if (msec < 100L) {
                buf.append('0');
            }
            if (msec < 10L) {
                buf.append('0');
            }
            buf.append(msec);
        }
        if (hour > 0L) {
            buf.append(" hours");
        } else if (min > 0L) {
            buf.append(" min");
        } else if (sec > 0L) {
            buf.append(" sec");
        } else {
            buf.append(" msec");
        }
        return buf.toString();
    }

    private boolean isValidEncoding(String enc) {
        try {
            new String(new byte[0], enc);
            return true;
        }
        catch (UnsupportedEncodingException ex) {
            return false;
        }
    }

    private void displayCopyright() {
        System.out.println(" Jalopy Java Source Code Formatter " + Jalopy.getVersion() + " Console Plug-in " + ConsolePlugin.getVersion());
        System.out.println(" Copyright (c) " + BUNDLE.getString("COPYRIGHT_YEAR") + " " + BUNDLE.getString("AUTHOR.1"));
        System.out.println();
        System.out.println(" Jalopy comes with ABSOLUTELY NO WARRANTY");
        System.out.println(" Use '--disclaimer' to show the disclaimer");
    }

    private void displayHelp() {
        this.displayCopyright();
        System.out.println();
        this.displayUsage();
        System.exit(this.getExitCode());
    }

    private void displayHint() {
        Object[] args = new Object[]{"'java " + BUNDLE.getString("PROGRAM_CMD") + " -h'"};
        System.out.println(MessageFormat.format(BUNDLE.getString("HINT"), args));
        System.out.println();
        System.exit(this.getExitCode());
    }

    private void displayLicence() {
        System.out.println(" Jalopy Java Source Code Formatter " + Jalopy.getVersion() + " Console Plug-in " + ConsolePlugin.getVersion());
        System.out.println(" Copyright (c) " + BUNDLE.getString("COPYRIGHT_YEAR") + " " + BUNDLE.getString("AUTHOR.1"));
        System.out.println();
        System.out.println(" This program is free software; you can redistribute it and/or modify\n it under the terms of the GNU General Public License as published by\n the Free Software Foundation; either version 2 of the License, or\n (at your option) any later version.\n\n This program is distributed in the hope that it will be useful,\n but WITHOUT ANY WARRANTY; without even the implied warranty of\n MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the\n GNU General Public License for more details.\n\n You should have received a copy of the GNU General Public License\n along with this program; if not, write to the Free Software Foundation,\n Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.");
        System.out.println();
        System.exit(this.getExitCode());
    }

    private void displayUsage() {
        System.out.println("Usage: java " + BUNDLE.getString("PROGRAM_CMD") + " [-options] [args...]");
        System.out.println();
        System.out.println("   or  java -jar jalopy-<version>.jar [-options] [args...]");
        System.out.println();
        System.out.println("where options include:");
        System.out.println("  -c, --convention=FILE   load code convention from FILE");
        System.out.println("  -d, --dest=DIR          use DIR as base output directory");
        System.out.println("      --disclaimer        print software disclaimer");
        System.out.println("  -e, --encoding=WORD     assume WORD as encoding of input files where WORD");
        System.out.println("                          describes one of the JDK supported encodings");
        System.out.println("                          (defaults to " + System.getProperty("file.encoding") + " if omitted)");
        System.out.println("  -f, --format=WORD       use WORD as output file format where WORD can be");
        System.out.println("                          either UNIX, DOS, MAC, AUTO (the default) or DEFAULT");
        System.out.println("                          (all case-insensitive)");
        System.out.println("      --force             force formatting even if file up-to-date");
        System.out.println("  -h, --help              display this help");
        System.out.println("  -l, --loglevel=WORD     specifies the logging level where WORD can be");
        System.out.println("                          either DEBUG, INFO (the default), WARN or DEBUG");
        System.out.println("                          (all case-insensitive)");
        System.out.println("      --nobackup          indicates that no backups should be kept");
        System.out.println("  -r, --recursive{=NUM}   recurse into directories, up to NUM levels;");
        System.out.println("                          if NUM is omitted, recurses indefinitely");
        System.out.println("  -t, --thread=NUM        use NUM processing threads");
        System.out.println("  -v, --version           print product version and exit");
        System.out.println();
        System.exit(this.getExitCode());
    }

    private void displayVersion() {
        this.displayCopyright();
        System.out.println();
        System.exit(this.getExitCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void format() {
        Jalopy jalopy;
        block30: {
            Convention settings;
            block31: {
                jalopy = new Jalopy();
                if (this._convention != null) {
                    try {
                        Jalopy.setConvention(this._convention);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        return;
                    }
                }
                jalopy.setFileFormat(this._fileFormat);
                if (this._encoding != null) {
                    jalopy.setEncoding(this._encoding);
                }
                settings = Convention.getInstance();
                jalopy.setInspect(settings.getBoolean(ConventionKeys.INSPECTOR, false));
                if (this._ioMode != 2) break block31;
                jalopy.setForce(true);
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter(System.out));
                try {
                    jalopy.setInput(System.in, "System.in");
                    jalopy.setOutput(out);
                    jalopy.format();
                    if (jalopy.getState() == Jalopy.State.ERROR) {
                        System.exit(1);
                    }
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    try {
                        if (System.in != null) {
                            System.in.close();
                        }
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                    try {
                        if (out != null) {
                            ((Writer)out).close();
                        }
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    if (System.in != null) {
                        System.in.close();
                    }
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                try {
                    if (out != null) {
                        ((Writer)out).close();
                    }
                    break block30;
                }
                catch (IOException ignored) {}
                break block30;
            }
            int backupLevel = settings.getInt(ConventionKeys.BACKUP_LEVEL, 0);
            if (this._noBackup) {
                jalopy.setBackup(false);
            } else {
                jalopy.setBackup(backupLevel > 0);
                jalopy.setBackupLevel(backupLevel);
            }
            jalopy.setInspect(settings.getBoolean(ConventionKeys.INSPECTOR, false));
            jalopy.setHistoryPolicy(History.Policy.valueOf(settings.get(ConventionKeys.HISTORY_POLICY, ConventionDefaults.HISTORY_POLICY)));
            jalopy.setHistoryMethod(History.Method.valueOf(settings.get(ConventionKeys.HISTORY_METHOD, ConventionDefaults.HISTORY_METHOD)));
            if (this._force) {
                jalopy.setForce(this._force);
            } else {
                jalopy.setForce(settings.getBoolean(ConventionKeys.FORCE_FORMATTING, false));
            }
            jalopy.setBackupDirectory(settings.get(ConventionKeys.BACKUP_DIRECTORY, Convention.getBackupDirectory().getAbsolutePath()));
            if (this._destDir != null) {
                jalopy.setDestination(this._destDir);
            }
            while (!_scanner.isFinished() || !_scanner.isEmpty()) {
                File source = null;
                try {
                    source = _scanner.take();
                    jalopy.setInput(source);
                    jalopy.setOutput(source);
                    boolean success = jalopy.format();
                    if (jalopy.getState() == Jalopy.State.ERROR) {
                        System.exit(1);
                    }
                    if (!success) continue;
                    ++_numFiles;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                catch (InterruptedException ex) {
                    return;
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        }
        jalopy.cleanupBackupDirectory();
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)jalopy.getProfileTimes());
        }
    }

    private void initializeLogger(Logger logger, Appender appender, Level level) {
        Appender currentAppender = logger.getAppender(CONSOLE_APPENDER_NAME);
        if (currentAppender == null) {
            logger.addAppender(appender);
        }
        logger.setLevel(level);
    }

    private void initializeLogging() {
        ConsoleAppender appender = new ConsoleAppender((Layout)new PatternLayout("[%p] %m\n"), this._ioMode == 1 ? "System.out" : "System.err");
        appender.setName(CONSOLE_APPENDER_NAME);
        if (this._loglevel == null) {
            Loggers.initialize((Appender)appender);
            this.initializeLogger(Loggers.IO, (Appender)appender, Level.INFO);
        } else {
            Loggers.ALL.removeAllAppenders();
            ResourceBundle bundle = ResourceBundle.getBundle("de.hunsicker.jalopy.storage.Bundle", Convention.getInstance().getLocale());
            Loggers.ALL.setResourceBundle(bundle);
            this.initializeLogger(Loggers.IO, (Appender)appender, this._loglevel);
            this.initializeLogger(Loggers.PARSER, (Appender)appender, this._loglevel);
            this.initializeLogger(Loggers.PRINTER, (Appender)appender, this._loglevel);
            this.initializeLogger(Loggers.TRANSFORM, (Appender)appender, this._loglevel);
            this.initializeLogger(Loggers.PARSER_JAVADOC, (Appender)appender, this._loglevel);
            this.initializeLogger(Loggers.PRINTER_JAVADOC, (Appender)appender, this._loglevel);
        }
    }

    private void loadRepository(List files) {
        block4: {
            ClassRepository repository = ClassRepository.getInstance();
            try {
                repository.loadAll(files);
            }
            catch (Exception ex) {
                if (repository == null || repository.isEmpty()) break block4;
                try {
                    repository.unloadAll(files);
                }
                catch (Exception e) {
                    _logger.error((Object)"Error cleaning up repository", (Throwable)e);
                }
                _logger.warn((Object)"Could not load the import repository", (Throwable)ex);
            }
        }
    }

    private void parseArgs(String[] argv) {
        Object[] args;
        _scanner = new DirectoryScanner();
        Getopt g = new Getopt("Jalopy", argv, this.getOptString(), this.getLongOptions());
        int c = -1;
        while ((c = g.getopt()) != -1) {
            switch (c) {
                case 100: {
                    Object[] args2;
                    this._destDir = new File(g.getOptarg());
                    if (!this._destDir.exists()) {
                        if (this._destDir.mkdirs()) break;
                        args2 = new Object[]{this._destDir};
                        System.err.println(MessageFormat.format(BUNDLE.getString("ERROR_CREATING_DESTINATION_DIRECTORY"), args2));
                        System.exit(1);
                        break;
                    }
                    if (!this._destDir.isFile()) break;
                    args2 = new Object[]{this._destDir};
                    System.err.println(MessageFormat.format(BUNDLE.getString("INVALID_DESTINATION_DIRECTORY"), args2));
                    System.exit(1);
                    break;
                }
                case 99: {
                    this._convention = g.getOptarg();
                    break;
                }
                case 115: {
                    this._convention = g.getOptarg();
                    break;
                }
                case 101: {
                    if (this.isValidEncoding(g.getOptarg())) {
                        this._encoding = g.getOptarg();
                        break;
                    }
                    Object[] args2 = new Object[]{g.getOptarg()};
                    System.err.println(MessageFormat.format(BUNDLE.getString("INVALID_ENCODING"), args2));
                    System.exit(1);
                    break;
                }
                case 102: {
                    String format = g.getOptarg().trim().toLowerCase();
                    if (format.equals("dos") || format.equals(FileFormat.DOS.getLineSeparator())) {
                        this._fileFormat = FileFormat.DOS;
                        break;
                    }
                    if (format.equals("default") || format.equals(FileFormat.DEFAULT.toString())) {
                        this._fileFormat = FileFormat.DEFAULT;
                        break;
                    }
                    if (format.equals("unix") || format.equals(FileFormat.UNIX.getLineSeparator())) {
                        this._fileFormat = FileFormat.UNIX;
                        break;
                    }
                    if (format.equals("mac") || format.equals(FileFormat.MAC.getLineSeparator())) {
                        this._fileFormat = FileFormat.MAC;
                        break;
                    }
                    if (format.equals("auto") || format.equals(FileFormat.AUTO.toString())) {
                        this._fileFormat = FileFormat.AUTO;
                        break;
                    }
                    Object[] args3 = new Object[]{format};
                    System.err.println(MessageFormat.format(BUNDLE.getString("INVALID_FILE_FORMAT"), args3));
                    this.setExitCode(1);
                    this.displayHint();
                    break;
                }
                case 108: {
                    String level = g.getOptarg().trim().toUpperCase();
                    if (level.equals("INFO")) {
                        this._loglevel = Level.INFO;
                        break;
                    }
                    if (level.equals("DEBUG")) {
                        this._loglevel = Level.DEBUG;
                        break;
                    }
                    if (level.equals("WARN")) {
                        this._loglevel = Level.WARN;
                        break;
                    }
                    if (level.equals("ERROR")) {
                        this._loglevel = Level.ERROR;
                        break;
                    }
                    Object[] args4 = new Object[]{level};
                    System.err.println(MessageFormat.format(BUNDLE.getString("INVALID_LOGLEVEL"), args4));
                    System.exit(1);
                    break;
                }
                case -100: {
                    this._force = true;
                    break;
                }
                case -1000: {
                    this.displayLicence();
                    break;
                }
                case -10000: {
                    ArrayList<File> files = new ArrayList<File>();
                    StringTokenizer tokens = new StringTokenizer(g.getOptarg(), ";");
                    while (tokens.hasMoreElements()) {
                        File file = new File(tokens.nextToken()).getAbsoluteFile();
                        if (!file.exists()) {
                            args = new Object[]{file};
                            System.err.println(MessageFormat.format(BUNDLE.getString("INVALID_CLASSPATH"), args));
                            System.exit(1);
                        }
                        files.add(file);
                    }
                    this.loadRepository(files);
                    break;
                }
                case 104: {
                    this.displayHelp();
                    break;
                }
                case 114: {
                    String depth = g.getOptarg();
                    if (depth == null) {
                        _scanner.setMaxLevels(Integer.MAX_VALUE);
                        break;
                    }
                    try {
                        int number = Integer.parseInt(depth);
                        if (number > 0) {
                            _scanner.setMaxLevels(number);
                            break;
                        }
                        args = new Object[]{depth};
                        System.err.println(MessageFormat.format(BUNDLE.getString("INVALID_RECURSION_NUMBER"), args));
                        this.setExitCode(1);
                        this.displayHint();
                    }
                    catch (NumberFormatException ex) {
                        args = new Object[]{depth};
                        System.err.println(MessageFormat.format(BUNDLE.getString("INVALID_RECURSION_LEVEL"), args));
                        this.setExitCode(1);
                        this.displayHint();
                    }
                    break;
                }
                case 116: {
                    try {
                        int threads = Integer.parseInt(g.getOptarg());
                        if (threads > 0) {
                            _threads = threads;
                            break;
                        }
                        args = new Object[]{new Integer(threads)};
                        System.err.println(MessageFormat.format(BUNDLE.getString("INVALID_THREAD_NUMBER"), args));
                        this.setExitCode(1);
                        this.displayHint();
                    }
                    catch (NumberFormatException ex) {
                        args = new Object[]{g.getOptarg()};
                        System.err.println(MessageFormat.format(BUNDLE.getString("INVALID_THREAD_NUMBER"), args));
                        this.setExitCode(1);
                        this.displayHint();
                    }
                    break;
                }
                case 118: {
                    this.displayVersion();
                    break;
                }
                case -10: {
                    this._noBackup = true;
                    break;
                }
                case 63: {
                    this.setExitCode(1);
                    this.displayUsage();
                }
            }
        }
        Perl5Compiler compiler = new Perl5Compiler();
        if (argv.length > 0 && g.getOptind() != argv.length) {
            ArrayList<Object> targets = new ArrayList<Object>(5);
            for (int i = g.getOptind(); i < argv.length; ++i) {
                block49: {
                    File target = new File(argv[i]);
                    if (target.exists()) {
                        targets.add(target);
                        continue;
                    }
                    try {
                        _argString = argv[i];
                        if (argv[i].indexOf(File.separatorChar) > -1) {
                            String path = argv[i].substring(0, argv[i].lastIndexOf(File.separatorChar) + 1);
                            target = new File(path);
                            if (target.exists()) {
                                String pattern = argv[i].substring(path.length());
                                compiler.compile(argv[i]);
                                _scanner.addFilter((FilenameFilter)new Perl5FilenameFilter(pattern));
                                targets.add(target);
                                continue;
                            }
                            break block49;
                        }
                        compiler.compile(argv[i]);
                        _scanner.addFilter((FilenameFilter)new Perl5FilenameFilter(argv[i]));
                        targets.add(new File(".").getAbsolutePath());
                        continue;
                    }
                    catch (Throwable ex) {
                        args = new Object[]{ex.getMessage(), argv[i]};
                        System.err.println(MessageFormat.format(BUNDLE.getString("MALFORMED_EXPRESSION"), args));
                        System.exit(1);
                    }
                }
                Object[] args5 = new Object[]{argv[i]};
                System.err.println(MessageFormat.format(BUNDLE.getString("INPUT_SOURCE_NOT_EXIST"), args5));
            }
            _scanner.setTargets(targets);
        } else {
            try {
                if (System.in.available() == 0) {
                    this.displayUsage();
                }
            }
            catch (IOException ignored) {
                // empty catch block
            }
            System.err.println(BUNDLE.getString("LISTEN_ON_STDIN"));
            this._ioMode = 2;
            _numFiles = 1;
        }
    }

    private boolean scan() {
        _scanner.addFilter(new ExtensionFilter(".java"));
        _scanner.run();
        return !_scanner.isEmpty();
    }

    static {
        _lock = new Object();
        _logger = Loggers.IO;
        _scanner = new DirectoryScanner();
        _threads = 1;
        LONG_OPTIONS = new LongOpt[]{new LongOpt("convention", 1, null, 99), new LongOpt("classpath", 1, null, -10000), new LongOpt("destination", 1, null, 100), new LongOpt("disclaimer", 0, null, -1000), new LongOpt("encoding", 1, null, 101), new LongOpt("format", 1, null, 102), new LongOpt("force", 0, null, -100), new LongOpt("loglevel", 1, null, 108), new LongOpt("nobackup", 0, null, -10), new LongOpt("thread", 1, null, 116), new LongOpt("recursive", 2, null, 114), new LongOpt("style", 1, null, 115), new LongOpt("version", 0, null, 118), new LongOpt("help", 0, null, 104)};
        BUNDLE = ResourceBundle.getBundle("de.hunsicker.jalopy.plugin.console.Bundle", Convention.getInstance().getLocale());
        CONSOLE_APPENDER_NAME = "ConsoleAppender";
    }

    private static class FormatThread
    extends Thread {
        ConsolePlugin console;

        public FormatThread(ConsolePlugin console) {
            this.console = console;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.console.format();
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                Object object = _lock;
                synchronized (object) {
                    _threadCount--;
                    _lock.notify();
                }
                throw throwable;
            }
            Object object = _lock;
            synchronized (object) {
                _threadCount--;
                _lock.notify();
            }
        }
    }
}

