/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import de.hunsicker.antlr.CommonHiddenStreamToken;
import de.hunsicker.antlr.collections.AST;
import de.hunsicker.jalopy.language.JavaNode;
import de.hunsicker.jalopy.language.ModifierType;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

final class ModifiersPrinter
extends AbstractPrinter {
    private static final Comparator COMP_MODIFIERS = new ModifiersComparator();
    private static final Printer INSTANCE = new ModifiersPrinter();

    protected ModifiersPrinter() {
    }

    public static final Printer getInstance() {
        return INSTANCE;
    }

    public void print(AST node, NodeWriter out) throws IOException {
        block4: {
            block3: {
                if (!settings.getBoolean(ConventionKeys.SORT_MODIFIERS, false)) break block3;
                JavaNode firstModifier = (JavaNode)node.getFirstChild();
                if (firstModifier == null) break block4;
                CommonHiddenStreamToken firstComment = firstModifier.getHiddenBefore();
                firstModifier.setHiddenBefore(null);
                ArrayList<JavaNode> modifiers = new ArrayList<JavaNode>(5);
                for (AST modifier = firstModifier; modifier != null; modifier = modifier.getNextSibling()) {
                    modifiers.add((JavaNode)modifier);
                }
                Collections.sort(modifiers, COMP_MODIFIERS);
                firstModifier = (JavaNode)modifiers.get(0);
                firstModifier.setHiddenBefore(firstComment);
                int size = modifiers.size();
                for (int i = 0; i < size; ++i) {
                    AST modifier = (AST)modifiers.get(i);
                    PrinterFactory.create(modifier).print(modifier, out);
                }
                break block4;
            }
            for (AST modifier = node.getFirstChild(); modifier != null; modifier = modifier.getNextSibling()) {
                PrinterFactory.create(modifier).print(modifier, out);
            }
        }
    }

    private static final class ModifiersComparator
    implements Comparator {
        private ModifiersComparator() {
        }

        public int compare(Object o1, Object o2) {
            AST node1 = (AST)o1;
            AST node2 = (AST)o2;
            ModifierType modifier1 = ModifierType.valueOf(node1.getText());
            ModifierType modifier2 = ModifierType.valueOf(node2.getText());
            return modifier1.compareTo(modifier2);
        }

        public boolean equals(Object o) {
            return o instanceof ModifiersComparator;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

