#!/usr/bin/env python
# -*- Mode: Python; py-indent-offset: 4 -*-

# as always, my Python is ripped off of James Henstridge 

try:
    import cString
    string = cString
except:
    import string
    
import sys
import os
import re
import exceptions
import errno
import getopt
import message
#import docobjects
#import docoutput
from declarations import *
import doctemplate
import cgi



#########################################


def declalpha (a, b):
    return cmp (a.qualified_name, b.qualified_name)

def declunqualifiedalpha (a, b):
    return cmp (a.name, b.name)

def escape (str):
    return cgi.escape (str)

link_template = "<link linkend=\"%(linkend)s\">%(linktext)s</link>"

def make_link_from_decl (decl):
    linkend = decl.get_xref_id ()
    linktext = escape (decl.qualified_name)

    return link_template % vars ()

def make_unqualified_link_from_decl (decl):
    linkend = decl.get_xref_id ()
    linktext = escape (decl.name)

    return link_template % vars ()

def make_named_link_from_decl (decl, name):
    linkend = decl.get_xref_id ()
    linktext = escape (name)

    return link_template % vars ()    

typesplitter = re.compile ('([A-Za-z0-9_]+)(.*)')

def split_type (type):
    type = strip (type)
    match = typesplitter.match (type)
    if match:
        name = match.group (1)
        other = match.group (2)
        return (name, other)
    else:
        return (type, '')

def make_funcname_with_links (decl):
    if hasattr (decl, 'linked_name'):
        return decl.linked_name
    
    linked_name = escape (decl.template_goo) + '\n'
    if decl.type == 'method' and decl.is_virtual:
        linked_name = linked_name = 'virtual '

    retlink = None
    typepair = split_type (decl.returns)
    retdecl = decl.lookup (typepair[0], ['typedef','enum','class','struct'])
    if retdecl and not retdecl.is_private:
        linkend = retdecl.get_xref_id ()
        linktext = escape (typepair[0])
        retlink = link_template % vars ()
        retlink = retlink + escape (typepair[1])
    else:
        retlink = escape (decl.returns)
        
    linked_name = linked_name + retlink + ' '

    linkend = decl.get_xref_id ()
    linktext = escape (decl.name)
    link = link_template % vars ()
    
    linked_name = linked_name + link
    linked_name = linked_name + ' ('
    
    for (type, name, default) in decl.args:
        if linked_name[-1] != '(':
            linked_name = linked_name + ', '

        typelink = None

        typepair = split_type (type)
        typedecl = decl.lookup (typepair[0], \
                                ['typedef','enum','class','struct'])
        if typedecl and not typedecl.is_private:
            linkend = typedecl.get_xref_id ()
            linktext = escape (typepair[0])
            typelink = link_template % vars ()
            typelink = typelink + escape (typepair[1])
        else:
            typelink = escape (type)
            
        linked_name = linked_name + typelink + ' ' + escape (name)
        if default:
            linked_name = linked_name + ' = ' + escape (default)
    linked_name = linked_name + ')'
    if decl.type == 'method' and decl.is_const:
        linked_name = linked_name + ' const'
    if decl.type == 'method' and decl.is_pure_virtual:
        linked_name = linked_name + ' = 0'

    decl.linked_name = strip (linked_name)

    return decl.linked_name
    
def make_synopsis_link_from_decl (decl):
    if decl.type == 'method' or decl.type == 'function':
        return make_funcname_with_links (decl)
    
    linkend = decl.get_xref_id ()
    linktext = None
    if decl.type == 'class':
        linktext = 'class ' + decl.name
    elif decl.type == 'struct':
        linktext = 'struct ' + decl.name
    elif decl.type == 'typedef':
        linktext = 'typedef ' + decl.name
    elif decl.type == 'variable':
        linktext = decl.long_name
    elif decl.type == 'enum':
        linktext = 'enum ' + decl.name
    elif decl.type == 'header':
        linktext = decl.name
    else:
        message.die ("didn't handle type %s" % decl.type)

    linktext = escape (linktext)

    return link_template % vars ()

def resolve_magic_links (entry, str):
    return str # FIXME
    
header_template = """
    <refentry id="%(id)s">

      <refmeta>
        <refentrytitle>%(name)s</refentrytitle>
        <manvolnum>3</manvolnum>
      </refmeta>
      
      <refnamediv>
        <refname>%(name)s</refname>

        <refpurpose>
        %(short)s
        </refpurpose>

      </refnamediv>

      <refsynopsisdiv>
      <title>Declared in this header</title>

%(synopsis)s
      
      </refsynopsisdiv>

      <refsect1>
      <title>Description</title>
      %(long)s
      </refsect1>

"""
klass_template = """
    <refentry id="%(id)s">

      <refmeta>
        <refentrytitle>%(name)s</refentrytitle>
        <manvolnum>3</manvolnum>
      </refmeta>
      
      <refnamediv>
        <refname>%(name)s</refname>

        <refpurpose>
        %(short)s
        </refpurpose>

      </refnamediv>

      <refsynopsisdiv>
      <title>Synopsis</title>

      <para>
      %(name)s is declared in the header %(header_link)s.
      </para>

      %(abstract)s
      
      <formalpara>
      <title>Superclasses</title>
      <para>
      %(supers)s
      </para>
      </formalpara>

      <formalpara>
      <title>Subclasses</title>
      <para>
      %(subs)s
      </para>
      </formalpara>
      
      <refsect2>
      <title>Class members</title>

%(synopsis)s

      </refsect2>
      
      </refsynopsisdiv>

      <refsect1>
      <title>Description</title>
      %(long)s
      </refsect1>

"""

refsect_template = """
<refsect%(level)s id="%(id)s">
<title>%(name)s</title>
%(long)s
%(table)s
</refsect%(level)s>
"""
listing_refsect_template = """
<refsect%(level)s id="%(id)s">
<title>%(name)s</title>
<para>
<programlisting>
%(long_name)s
</programlisting>
</para>
%(long)s
%(table)s
</refsect%(level)s>
"""

def get_generic_vals (entry, vals):
    vals['id'] = entry.decl.get_xref_id ()
    vals['name'] = escape (entry.decl.type + ' ' +  entry.decl.qualified_name)
    short = entry.short
    if not short:
        short = ''
    vals['short'] = resolve_magic_links (entry, short)
    long = entry.long
    if not long:
        long = '<para>\n\n</para>'
    vals['long'] = long 

table_headers = """
<informaltable pgwide=1 frame="none" role="enum">
<tgroup cols="2">
<colspec colwidth="2*">
<colspec colwidth="8*">
<tbody>
"""
table_footers = """
</tbody>
</tgroup>
</informaltable>
"""

entry_template = """
<row>
<entry><literal>%(name)s</literal></entry>
<entry>%(docs)s
</entry>
</row>
"""

def make_param_table (entry):
    if len (entry.params) == 0:
        return ''
    
    table = table_headers
    for (name, docs) in entry.params:
        name = escape (name)
        docs = escape (docs)
        table = table + (entry_template % vars ())
    table = table + table_footers

    return table

def make_enumval_table (entry):
    if len (entry.vals) == 0:
        return ''
    
    table = table_headers
    for (name, docs) in entry.vals:
        name = escape (name)
        docs = escape (docs)
        table = table + (entry_template % vars ())
    table = table + table_footers

    return table

def refsect_from_decl (entries, decl, level):
    if decl.type == 'namespace':
        return None
    
    entry = entries.get (decl.get_xref_id ())
    if not entry:
        message.warn ("Not outputting decl %s (no entry in template file)" % decl.qualified_name)
        return None

    if not entry.long:
        entry.long = '<para>\n\n</para>'

    if not entry.short:
        entry.short = ''

    vals = {
        'level' : level,
        'table' : ''
        }

    get_generic_vals (entry, vals)

    sect = None
    
    if entry.type == 'method':
        vals['long_name'] = make_funcname_with_links (decl)

        vals['table'] = make_param_table (entry)
        
        sect = listing_refsect_template % vals

    elif entry.type ==  'variable' or entry.type == 'typedef':
        vals['long_name'] = escape (decl.long_name)
        sect = listing_refsect_template % vals
    elif entry.type == 'enum':
        vals['table'] = make_enumval_table (entry)
        
        sect = refsect_template % vals
    else:
        sect = refsect_template % vals
    
    return sect

def output_refsect1 (title, list, outfile):
    if len (list) > 0:
        outfile.write ('<refsect1><title>%s</title>\n' % title)

        for g in list:
            outfile.write (g)
        
        outfile.write ('</refsect1>')

def make_synopsis (title, list):
    retval = ''
    if len (list) > 0:
        retval = '<formalpara><title>%s</title>\n<para><synopsis>\n' % title

        retval = retval + join (list, '\n')
        
        retval = retval + '</synopsis></para>\n</formalpara>'

    return retval

def output_header (header, entries, xref_id_dict, outfile):
    entry = entries.get (header.get_xref_id ())
    if not entry:
        message.warn ("Not outputting header %s (no entry in template file)" % klass.name)
    vals = {}
    get_generic_vals (entry, vals)

    ## get global stuff in this header, and output it
    decls = entry.decl.get_children_recursively ()
    globals = []
    for d in decls:
        if not d.is_private and d.is_global ():
            globals.append (d)

    functions = []
    variables = []
    typedefs = []
    enums = []
    functions_syns = []
    variables_syns = []
    typedefs_syns = []
    enums_syns = []
    class_syns = []
    struct_syns = []
    globals.sort (declalpha)
    for g in globals:
        if g.type == 'class':
            class_syns.append (make_synopsis_link_from_decl (g))
        elif g.type == 'struct':
            struct_syns.append (make_synopsis_link_from_decl (g))
        else:
            sect = refsect_from_decl (entries, g, '2')
            if sect:
                if g.type == 'function':
                    functions.append (sect)
                    functions_syns.append (make_synopsis_link_from_decl (g))
                elif g.type == 'typedef':
                    typedefs.append (sect)
                    typedefs_syns.append (make_synopsis_link_from_decl (g))
                elif g.type == 'enum':
                    enums.append (sect)
                    enums_syns.append (make_synopsis_link_from_decl (g))
                elif g.type == 'variable':
                    variables.append (sect)
                    variables_syns.append (make_synopsis_link_from_decl (g))
                else:
                    message.warn ("Unhandled type %s" % g.type)

    synopsis = ''
    synopsis = synopsis + make_synopsis ('Classes', class_syns)
    synopsis = synopsis + make_synopsis ('Structs', struct_syns)
    synopsis = synopsis + make_synopsis ('Typedefs', typedefs_syns)
    synopsis = synopsis + make_synopsis ('Enumerations', enums_syns)
    synopsis = synopsis + make_synopsis ('Variables', variables_syns)
    synopsis = synopsis + make_synopsis ('Functions', functions_syns)

    if synopsis == '':
        synopsis = '<para>There are no declarations in this header file.</para>'

    vals['synopsis'] = synopsis

    outfile.write (header_template % vals)

    output_refsect1 ('Global functions', functions, outfile)
    output_refsect1 ('Global variables', variables, outfile)
    output_refsect1 ('Global typedefs', typedefs, outfile)
    output_refsect1 ('Global enumerations', enums, outfile)

    outfile.write ('</refentry>\n')    
    
def output_class (klass, entries, xref_id_dict, outfile):
    entry = entries.get (klass.get_xref_id ())
    if not entry:
        message.warn ("Not outputting class %s (no entry in template file)" % klass.name)
    vals = {}
    get_generic_vals (entry, vals)

    if klass.is_abstract:
        vals['abstract'] = '<para>This is an abstract base class, and may not be instantiated.</para>'
    else:
        vals['abstract'] = ''

    supers = ''
    i = 0
    while i < len (klass.supers):
        s = klass.supers[i]
        sname = klass.linkable_super_names[i]
        supers = supers + make_named_link_from_decl (s, sname) + ', '
        i = i + 1

    for s in klass.unlinkable_super_names:
        supers = supers + escape (s) + ', '

    if supers != '':
        # drop comma
        supers = supers[:-2]
    else:
        supers = 'none'
        
    subs = ''
    for s in klass.subs:
        subs = subs + make_unqualified_link_from_decl (s) + ', '
    
    if subs != '':
        # drop comma
        subs = subs[:-2]
    else:
        subs = 'none'
        
    vals['supers'] = supers
    vals['subs'] = subs
    vals['header_link'] = make_link_from_decl (klass.get_header ())

    section_hash = {
        'public' : {},
        'protected' : {}
        }

    section_hash['public'] = { 'important' : {}, 'lame' : {} }
    section_hash['protected'] = { 'important' : {}, 'lame' : {} }

    synop_hash = {
        'public' : {},
        'protected' : {}
        }

    synop_hash['public'] = { 'important' : {}, 'lame' : {} }
    synop_hash['protected'] = { 'important' : {}, 'lame' : {} }

    entities = ['typedefs', 'enums', \
                'constructors', 'destructors', 'virtuals', \
                'methods', 'functions', \
                'variables']
    ent_names = {
        'typedefs' : 'Typedefs',
        'enums' : 'Enumerations',
        'constructors' : 'Constructors',
        'destructors' : 'Destructor',
        'virtuals' : 'Virtual Methods',
        'methods' : 'Methods',
        'functions' : 'Functions',
        'variables' : 'Variables'
        }

    for e in entities:
        section_hash['public']['important'][e] = []
        section_hash['protected']['important'][e] = []
        section_hash['public']['lame'][e] = []
        section_hash['protected']['lame'][e] = []

        synop_hash['public']['important'][e] = []
        synop_hash['protected']['important'][e] = []
        synop_hash['public']['lame'][e] = []
        synop_hash['protected']['lame'][e] = []

    klass_synopses = []
    struct_synopses = []

    decls = entry.decl.children
    for d in decls:
        if d.type == 'class':
            klass_synopses.append (make_synopsis_link_from_decl (d))
        elif d.type == 'struct':
            struct_synopses.append (make_synopsis_link_from_decl (d))
        else:
           if not d.is_private:
            sect = refsect_from_decl (entries, d, '2')
            if sect:
                importance = 'lame'
                child_entry = entries.get (d.get_xref_id ())
                if child_entry and child_entry.is_important:
                    importance = 'important'

                ent = None
                if d.type == 'method':
                    if d.is_constructor:
                        ent = 'constructors'
                    elif d.is_destructor:
                        ent = 'destructors'
                    elif d.is_virtual:
                        ent = 'virtuals'
                    else:
                        ent = 'methods'
                elif d.type == 'function':
                    ent = 'functions'
                elif d.type == 'typedef':
                    ent = 'typedefs'
                elif d.type == 'enum':
                    ent = 'enums'
                elif d.type == 'variable':
                    ent = 'variables'
                else:
                    message.die ("unknown type %s" % d.type)
                    
                section_hash[d.access][importance][ent].append (sect)
                synop = make_synopsis_link_from_decl (d)
                synop_hash[d.access][importance][ent].append (synop)

    synopsis = ''

    synopsis = synopsis + \
               make_synopsis ('Inner Classes', klass_synopses)

    synopsis = synopsis + \
               make_synopsis ('Inner Structs', struct_synopses)

    for e in entities:
        synopsis = synopsis + \
                   make_synopsis ('Important Public %s' % ent_names[e], \
                                  synop_hash['public']['important'][e])

    for e in entities:
        synopsis = synopsis + \
                   make_synopsis ('Important Protected %s' % ent_names[e], \
                                  synop_hash['protected']['important'][e])


    for e in entities:
        synopsis = synopsis + \
                   make_synopsis ('Public %s' % ent_names[e], \
                                  synop_hash['public']['lame'][e])


    for e in entities:
        synopsis = synopsis + \
                   make_synopsis ('Protected %s' % ent_names[e], \
                                  synop_hash['protected']['lame'][e])

    if synopsis == '':
        synopsis = '<para>This class has no members.</para>'

    vals['synopsis'] = synopsis

    outfile.write (klass_template % vals)

    for e in entities:
        output_refsect1 ('Important Public %s' % ent_names[e], \
                         section_hash['public']['important'][e], \
                         outfile)

    for e in entities:
        output_refsect1 ('Important Protected %s' % ent_names[e], \
                         section_hash['protected']['important'][e], \
                         outfile)

    for e in entities:
        output_refsect1 ('Public %s' % ent_names[e], \
                         section_hash['public']['lame'][e], \
                         outfile)

    for e in entities:
        output_refsect1 ('Protected %s' % ent_names[e], \
                         section_hash['protected']['lame'][e], \
                         outfile)
                
    outfile.write ('</refentry>\n')    

def output_hierarchy (decl, indent, outfile):
    link = make_link_from_decl (decl)
    outfile.write (indent + link + '\n')
    if decl.subs and len (decl.subs) > 0:
        decl.subs.sort (declalpha)
        for s in decl.subs:
            output_hierarchy (s, indent + '   ', outfile)

#########################################




def listdir_recursive (dir, parent_dirname):
    # yeah so rewrite it if it bothers you that much ;-)
    os.chdir (dir)
    entries = os.listdir ('.')
    subentries = []
    for e in entries:
        child_name = os.path.join (parent_dirname, e)
        if os.path.isdir (e):
            subentries = subentries + listdir_recursive (e, child_name)
            os.chdir ('..')
        else:
            subentries.append (child_name)

    return subentries

script_dir = None
docs_dir = None
doc_template_dir = None

opts, args = getopt.getopt(sys.argv[1:], 'v', ['script-dir=','docs-dir=', 'doc-template-dir='])
for opt, val in opts:
    if opt == '-v':
        verbose = 1
    elif opt == '--script-dir':
        script_dir = val
    elif opt == '--docs-dir':
        docs_dir = val
    elif opt == '--doc-template-dir':
        doc_template_dir = val

if not script_dir:
    message.die ("must specify script dir")

if not docs_dir:
    message.die ("must specify docs dir")

if not doc_template_dir:
    message.die ("must specify doc template dir")

cwd = os.getcwd ()
templates = listdir_recursive (doc_template_dir, '')
os.chdir (cwd)

cwd = os.getcwd ()
pyobjects = listdir_recursive (docs_dir, '')
os.chdir (cwd)

def istemplate (str):
    i = len ('.template.sgml')
    return str[-i:] == '.template.sgml'

def ispyobjects (str):
    i = len ('.pyobjects')
    return str[-i:] == '.pyobjects'

templates = filter (istemplate, templates)
pyobjects = filter (ispyobjects, pyobjects)

#print templates
#print pyobjects

for p in pyobjects:
    load_decls (os.path.join (docs_dir, p))

full_postprocess ()

headers = []
klasses = []
funcs = []
variables = []
types = []
for decl in xref_id_dict.values ():
    if not decl.is_private:
        if decl.type == 'header':
            # print "Declarations from header %s loaded" % decl.name
            headers.append (decl)
        elif decl.type == 'class' or decl.type == 'struct':
            klasses.append (decl)
        elif decl.type == 'method' or decl.type == 'function':
            funcs.append (decl)
        elif decl.type == 'variable':
            variables.append (decl)
        elif decl.type == 'enum' or decl.type == 'typedef':
            types.append (decl)        
        
entries = {}
for t in templates:
    # print "Loading template %s" % t
    doctemplate.load_template (entries, os.path.join (doc_template_dir, t), \
                               xref_id_dict)

doctemplate.merge_entries (entries, xref_id_dict)

for k in entries.keys ():
    if entries[k].not_documented:
        print "Not documenting %s as requested" % entries[k].decl_xref
        del entries[k]

headers.sort (declalpha)
klasses.sort (declalpha)
funcs.sort (declunqualifiedalpha)
variables.sort (declunqualifiedalpha)
types.sort (declunqualifiedalpha)

header_reference_file = os.path.join (docs_dir, 'headers.sgml')
outfile = open (header_reference_file, 'w')

for h in headers:
    output_header (h, entries, xref_id_dict, outfile)

klass_reference_file = os.path.join (docs_dir, 'classes.sgml')
outfile = open (klass_reference_file, 'w')

for k in klasses:
    if not k.is_private:
        output_class (k, entries, xref_id_dict, outfile)
    
class_hierarchy_file = os.path.join (docs_dir, 'hierarchy.sgml')
outfile = open (class_hierarchy_file, 'w')

toplevels = []
for k in klasses:
    if not k.is_private:
        if len (k.supers) == 0:
            toplevels.append (k)

toplevels.sort (declalpha)

outfile.write ('<literallayout>\n')
for t in toplevels:
    output_hierarchy (t, '', outfile)
outfile.write ('</literallayout>\n')

    
function_index_file = os.path.join (docs_dir, 'functions.sgml')
outfile = open (function_index_file, 'w')

outfile.write ('<literallayout>\n')
for f in funcs:
    outfile.write (make_link_from_decl (f) + '\n')
outfile.write ('</literallayout>\n')


    
variable_index_file = os.path.join (docs_dir, 'variables.sgml')
outfile = open (variable_index_file, 'w')

outfile.write ('<literallayout>\n')
for v in variables:
    outfile.write (make_link_from_decl (v) + '\n')
outfile.write ('</literallayout>\n')



    
types_index_file = os.path.join (docs_dir, 'types.sgml')
outfile = open (types_index_file, 'w')

outfile.write ('<literallayout>\n')
for t in types:
    outfile.write (make_link_from_decl (t) + '\n')
outfile.write ('</literallayout>\n')

