// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_BASE_UTF_STRING_H_
#define _INTI_BASE_UTF_STRING_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <string>

namespace Inti
{  
  class ustring
  {
  public:

    ustring ()
    {
    }

    ustring (const ustring & s)
      : str_ (s.str ())
    {
    }
    
    ustring (const string & s)
      : str_ (s)
    {
    }

    ustring (const string & s,
             size_t         length_in_bytes)
      : str_ (s, length_in_bytes)
    {
    }
    
    ustring (const char * p)
      : str_ (p)
    {
    }

    ustring (const char * p,
             size_t       length_in_bytes)
      : str_ (p, length_in_bytes)
    {
    }
    
    const string & str () const { return str_; }
    const char * c_str () const { return str_.c_str (); }
    
  private:
    string str_;
    
  }; // class ustring
  
}; // namespace Inti

#endif // _INTI_BASE_UTF_STRING_H_
