// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This source file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
#include "timedate.h"

Inti::TimeStamp
Inti::current_timestamp ()
{
  GTimeVal val;
  
  g_get_current_time (&val);

  return TimeStamp (&val);
}

long
Inti::TimeStamp::microseconds_since (const TimeStamp & ts) const
{
  return
    ((seconds () - ts.seconds ()) * G_USEC_PER_SEC) +
    (microseconds () - ts.microseconds ());
}

bool
Inti::TimeStamp::operator== (const TimeStamp & rhs)
{
  return seconds () == rhs.seconds () &&
    microseconds () == rhs.microseconds ();
}

bool
Inti::TimeStamp::operator< (const TimeStamp & rhs)
{
  if (seconds () < rhs.seconds ())
    return true;
  else if (seconds () == rhs.seconds () &&
           microseconds () < rhs.microseconds ())
    return true;
  else
    return false;
}

bool
Inti::TimeStamp::operator<= (const TimeStamp & rhs)
{
  return operator== (rhs) || operator< (rhs);
}

bool
Inti::TimeStamp::operator> (const TimeStamp & rhs)
{
  if (seconds () > rhs.seconds ())
    return true;
  else if (seconds () == rhs.seconds () &&
           microseconds () > rhs.microseconds ())
    return true;
  else
    return false;
}

bool
Inti::TimeStamp::operator>= (const TimeStamp & rhs)
{
  return operator == (rhs) || operator> (rhs);
}

const unsigned int Inti::Date::INVALID_JULIAN = G_DATE_BAD_JULIAN;
const unsigned int Inti::Date::INVALID_DAY = G_DATE_BAD_DAY;
const unsigned int Inti::Date::INVALID_YEAR = G_DATE_BAD_YEAR;

bool
Inti::Date::valid_day (unsigned int day)
{
  return g_date_valid_day (day);
}

bool
Inti::Date::valid_month (Month m)
{
  return g_date_valid_month ((GDateMonth) m);
}

bool
Inti::Date::valid_year (unsigned int year)
{
  return g_date_valid_year (year);
}

bool
Inti::Date::valid_weekday (Weekday w)
{
  return g_date_valid_weekday ((GDateWeekday) w);
}

bool
Inti::Date::valid_julian (unsigned int julian)
{
  return g_date_valid_julian (julian);
}

bool
Inti::Date::valid_dmy (unsigned int day, Month m, unsigned int year)
{
  return g_date_valid_dmy (day, (GDateMonth) m, year);
}

bool
Inti::Date::leap_year (unsigned int year)
{
  return g_date_is_leap_year (year);
}

unsigned int
Inti::Date::days_in_month (Month m, unsigned int year)
{
  return g_date_days_in_month ((GDateMonth) m, year);
}

unsigned int
Inti::Date::monday_weeks_in_year (unsigned int year)
{
  return g_date_monday_weeks_in_year (year);
}

unsigned int
Inti::Date::sunday_weeks_in_year (unsigned int year)
{
  return g_date_sunday_weeks_in_year (year);
}

Inti::Date::Date ()
{
  g_date_clear (&date_, 1);
}

Inti::Date::Date (unsigned int dayx, Month m, unsigned int yearx)
{
  g_date_clear (&date_, 1);
  set_dmy (dayx, m, yearx);
}
    
bool
Inti::Date::valid () const
{
  return g_date_valid (&date_);
}

Inti::Date::Weekday
Inti::Date::weekday () const
{
  return (Weekday) g_date_weekday (&date_);
}

unsigned int
Inti::Date::julian () const
{
  return g_date_julian (&date_);
}

unsigned int
Inti::Date::year () const
{
  return g_date_year (&date_);
}

unsigned int
Inti::Date::day () const
{
  return g_date_day (&date_);
}

Inti::Date::Month
Inti::Date::month () const
{
  return (Month) g_date_month (&date_);
}

unsigned int
Inti::Date::day_of_year () const
{
  return g_date_day_of_year (&date_);
}

unsigned int
Inti::Date::monday_week_of_year () const
{
  return g_date_monday_week_of_year (&date_);
}

unsigned int
Inti::Date::sunday_week_of_year () const
{
  return g_date_sunday_week_of_year (&date_);
}

bool
Inti::Date::first_of_month () const
{
  return g_date_is_first_of_month (&date_);
}

bool
Inti::Date::last_of_month () const
{
  return g_date_is_last_of_month (&date_);
}
    
void
Inti::Date::parse (const ustring & text)
{
  parse (text.c_str ());
}
    
void
Inti::Date::parse (const char * text)
{
  g_date_set_parse (&date_, text);
}


void
Inti::Date::set_time (GTime t)
{
  g_date_set_time (&date_, t);
}

void
Inti::Date::set_month (Month m)
{
  g_date_set_month (&date_, (GDateMonth) m);
}

void
Inti::Date::set_day (unsigned int dayx)
{
  g_date_set_day (&date_, dayx);
}
void
Inti::Date::set_year (unsigned int yearx)
{
  g_date_set_year (&date_, yearx);
}

void
Inti::Date::set_dmy (unsigned int dayx, Month m, unsigned int yearx)
{
  g_date_set_dmy (&date_, dayx, (GDateMonth) m, yearx);
}

void
Inti::Date::set_julian (unsigned int julianx)
{
  g_date_set_julian (&date_, julianx);
}
    
void
Inti::Date::add_days (unsigned int n_days)
{
  g_date_add_days (&date_, n_days);
}

void
Inti::Date::subtract_days (unsigned int n_days)
{
  g_date_subtract_days (&date_, n_days);
}

void
Inti::Date::add_months (unsigned int n_months)
{
  g_date_add_months (&date_, n_months);
}

void
Inti::Date::subtract_months (unsigned int n_months)
{
  g_date_subtract_months (&date_, n_months);
}

void
Inti::Date::add_years (unsigned int n_years)
{
  g_date_add_years (&date_, n_years);
}

void
Inti::Date::subtract_years (unsigned int n_years)
{
  g_date_subtract_years (&date_, n_years);
}

bool
Inti::Date::operator==(const Date & rhs) const
{
  return g_date_compare (&date_, &rhs.date_) == 0;
}

bool
Inti::Date::operator!=(const Date & rhs) const
{
  return g_date_compare (&date_, &rhs.date_) != 0;
}

bool
Inti::Date::operator<(const Date & rhs) const
{
  return g_date_compare (&date_, &rhs.date_) < 0;
}

bool
Inti::Date::operator<=(const Date & rhs) const
{
  return g_date_compare (&date_, &rhs.date_) <= 0;
}

bool
Inti::Date::operator>(const Date & rhs) const
{
  return g_date_compare (&date_, &rhs.date_) > 0;
}

bool
Inti::Date::operator>=(const Date & rhs) const
{
  return g_date_compare (&date_, &rhs.date_) >= 0;
}

void
Inti::Date::to_struct_tm (struct tm * tm)
{
  g_date_to_struct_tm (&date_, tm);
}

Inti::ustring
Inti::Date::strftime (const ustring & format)
{
  int size = format.str ().size () + 10; 
  char * buf = (char*) g_malloc (size * 2); // should be big enough, hey
  
  g_date_strftime (buf, size-1, format.c_str (), &date_);

  ustring s (buf);

  g_free (buf);

  return s;
}

Inti::ustring
Inti::Date::strftime (const char * format)
{
  return strftime (string (format));
}


/////////// Everything below here is machine-generated
