// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_BASE_TEXT_H_
#define _INTI_BASE_TEXT_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/utf-string.h>
#include <glib.h>

/*$ doc header
  $short Text processing and ustrings
  $*/

namespace Inti
{
  typedef enum
  {
    UNICODE_CONTROL = G_UNICODE_CONTROL,
    UNICODE_FORMAT = G_UNICODE_FORMAT,
    UNICODE_UNASSIGNED = G_UNICODE_UNASSIGNED,
    UNICODE_PRIVATE_USE = G_UNICODE_PRIVATE_USE,
    UNICODE_SURROGATE = G_UNICODE_SURROGATE,
    UNICODE_LOWERCASE_LETTER = G_UNICODE_LOWERCASE_LETTER,
    UNICODE_MODIFIER_LETTER = G_UNICODE_MODIFIER_LETTER,
    UNICODE_OTHER_LETTER = G_UNICODE_OTHER_LETTER,
    UNICODE_TITLECASE_LETTER = G_UNICODE_TITLECASE_LETTER,
    UNICODE_UPPERCASE_LETTER = G_UNICODE_UPPERCASE_LETTER,
    UNICODE_COMBININMARK = G_UNICODE_COMBINING_MARK,
    UNICODE_ENCLOSINMARK = G_UNICODE_ENCLOSING_MARK,
    UNICODE_NON_SPACINMARK = G_UNICODE_NON_SPACING_MARK,
    UNICODE_DECIMAL_NUMBER = G_UNICODE_DECIMAL_NUMBER,
    UNICODE_LETTER_NUMBER = G_UNICODE_LETTER_NUMBER,
    UNICODE_OTHER_NUMBER = G_UNICODE_OTHER_NUMBER,
    UNICODE_CONNECT_PUNCTUATION = G_UNICODE_CONNECT_PUNCTUATION,
    UNICODE_DASH_PUNCTUATION = G_UNICODE_DASH_PUNCTUATION,
    UNICODE_CLOSE_PUNCTUATION = G_UNICODE_CLOSE_PUNCTUATION,
    UNICODE_FINAL_PUNCTUATION = G_UNICODE_FINAL_PUNCTUATION,
    UNICODE_INITIAL_PUNCTUATION = G_UNICODE_INITIAL_PUNCTUATION,
    UNICODE_OTHER_PUNCTUATION = G_UNICODE_OTHER_PUNCTUATION,
    UNICODE_OPEN_PUNCTUATION = G_UNICODE_OPEN_PUNCTUATION,
    UNICODE_CURRENCY_SYMBOL = G_UNICODE_CURRENCY_SYMBOL,
    UNICODE_MODIFIER_SYMBOL = G_UNICODE_MODIFIER_SYMBOL,
    UNICODE_MATH_SYMBOL = G_UNICODE_MATH_SYMBOL,
    UNICODE_OTHER_SYMBOL = G_UNICODE_OTHER_SYMBOL,
    UNICODE_LINE_SEPARATOR = G_UNICODE_LINE_SEPARATOR,
    UNICODE_PARAGRAPH_SEPARATOR = G_UNICODE_PARAGRAPH_SEPARATOR,
    UNICODE_SPACE_SEPARATOR = G_UNICODE_SPACE_SEPARATOR
  } UnicodeType;
  
  /// Some text-processing utility functions

  namespace Text
  {
    // there's some evil overloading-on-int-and-pointer here, but you
    // never want to pass the literal "0" for either the int or the
    // pointer, so there should not be any ambiguous cases.

    int to_int (const ustring & s, int base = 0);
    int to_int (const char * s, int base = 0);
    int to_int (const ustring & s, int * length_used, int base = 0);
    int to_int (const char * s, int * length_used, int base = 0);

    unsigned int to_uint (const ustring & s, int base = 0);
    unsigned int to_uint (const char * s, int base = 0);
    unsigned int to_uint (const ustring & s, int * length_used, int base = 0);
    unsigned int to_uint (const char * s, int * length_used, int base = 0);
    
    long to_long (const ustring & s, int base = 0);
    long to_long (const char * s, int base = 0);
    long to_long (const ustring & s, int * length_used, int base = 0);
    long to_long (const char * s, int * length_used, int base = 0);
    
    unsigned long to_ulong (const ustring & s, int base = 0);
    unsigned long to_ulong (const char * s, int base = 0);
    unsigned long to_ulong (const ustring & s, int * length_used, int base = 0);
    unsigned long to_ulong (const char * s, int * length_used, int base = 0);
    
    float to_float (const ustring & s);
    float to_float (const char * s);
    float to_float (const ustring & s, int * length_used);
    float to_float (const char * s, int * length_used);
    
    double to_double (const ustring & s);
    double to_double (const char * s);
    double to_double (const ustring & s, int * length_used);
    double to_double (const char * s, int * length_used);

    ustring to_string (int i);
    ustring to_string (unsigned int i);
    ustring to_string (long i);
    ustring to_string (unsigned long i);
    ustring to_string (float f);
    ustring to_string (double d);    

    //    wstring to_wstring (const ustring & s);
    
    ustring lstrip (const ustring & s);
    ustring lstrip (const char * s);
    ustring rstrip (const ustring & s);
    ustring rstrip (const char * s);
    ustring strip (const ustring & s);
    ustring strip (const char * s);
    
    ustring printf_format (const char * printf_format, ...) G_GNUC_PRINTF (1, 2);

    UnicodeType type (gunichar c);
    
    bool is_alnum (gunichar c);
    bool is_alpha (gunichar c);
    bool is_cntrl (gunichar c);
    bool is_digit (gunichar c);
    bool is_graph (gunichar c);
    bool is_lower (gunichar c);
    bool is_print (gunichar c);
    bool is_punct (gunichar c);
    bool is_space (gunichar c);
    bool is_upper (gunichar c);
    bool is_xdigit (gunichar c);
    bool is_title (gunichar c);
    bool is_defined (gunichar c);
    bool is_wide (gunichar c);

    gunichar to_upper (gunichar c);
    gunichar to_lower (gunichar c);
    gunichar to_title (gunichar c);

    ustring upper (const ustring & str);
    ustring upper (const char *str);

    ustring lower (const ustring & str);
    ustring lower (const char *str);
    
  }; // namespace Text
  
}; // namespace Inti

#endif // _INTI_BASE_TEXT_H_
