// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This source file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
#include "text.h"
#include <stdlib.h>
#include <errno.h>
#include <glib.h>

int
Inti::Text::to_int (const ustring & s, int base)
{
  return to_int (s.c_str (), 0, base);
}

int
Inti::Text::to_int (const char * s, int base)
{
  return to_int (s, 0, base);
}

int
Inti::Text::to_int (const ustring & s, int * length_used, int base)
{
  return to_int (s.c_str (), length_used, base);
}

int
Inti::Text::to_int (const char * s, int * length_used, int base)
{
  long val = to_long (s, length_used, base);

  // emulate strtol's range checking, for ints
  if (val > G_MAXINT)
    {
      val = G_MAXINT;
      errno = ERANGE;
    }
  else if (val < G_MININT)
    {
      val = G_MININT;
      errno = ERANGE;
    }

  return val;
}

unsigned int
Inti::Text::to_uint (const ustring & s, int base)
{
  return to_uint (s.c_str (), 0, base);
}

unsigned int
Inti::Text::to_uint (const char * s, int base)
{
  return to_uint (s, 0, base);
}

unsigned int
Inti::Text::to_uint (const ustring & s, int * length_used, int base)
{
  return to_uint (s.c_str (), length_used, base);
}

unsigned int
Inti::Text::to_uint (const char * s, int * length_used, int base)
{
  unsigned long val = to_ulong (s, length_used, base);

  // emulate strtoul's range checking, for ints
  if (val > G_MAXUINT)
    {
      val = G_MAXUINT;
      errno = ERANGE;
    }

  return val;
}
    
long
Inti::Text::to_long (const ustring & s, int base)
{
  return to_long (s.c_str (), 0, base);
}

long
Inti::Text::to_long (const char * s, int base)
{
  return to_long (s, 0, base);
}

long
Inti::Text::to_long (const ustring & s, int * length_used, int base)
{
  return to_long (s.c_str (), length_used, base);
}

long
Inti::Text::to_long (const char * s, int * length_used, int base)
{
  char * endptr = 0;

  long val = strtol (s, &endptr, base);

  if (length_used)
    *length_used = endptr - s;

  return val;
}
    
unsigned long
Inti::Text::to_ulong (const ustring & s, int base)
{
  return to_ulong (s.c_str (), 0, base);
}

unsigned long
Inti::Text::to_ulong (const char * s, int base)
{
  return to_ulong (s, 0, base);
}

unsigned long
Inti::Text::to_ulong (const ustring & s, int * length_used, int base)
{
  return to_ulong (s.c_str (), length_used, base);
}

unsigned long
Inti::Text::to_ulong (const char * s, int * length_used, int base)
{
  char * endptr = 0;

  unsigned long val = strtoul (s, &endptr, base);

  if (length_used)
    *length_used = endptr - s;

  return val;
}
    
float
Inti::Text::to_float (const ustring & s)
{
  return to_float (s.c_str (), 0);
}

float
Inti::Text::to_float (const char * s)
{
  return to_float (s, 0);
}

float
Inti::Text::to_float (const ustring & s, int * length_used)
{
  return to_float (s.c_str (), length_used);
}

float
Inti::Text::to_float (const char * s, int * length_used)
{
  /* Just drop some precision */
  return to_double (s, length_used);
}
    
double
Inti::Text::to_double (const ustring & s)
{
  return to_double (s.c_str (), 0);
}

double
Inti::Text::to_double (const char * s)
{
  return to_double (s, 0);
}

double
Inti::Text::to_double (const ustring & s, int * length_used)
{
  return to_double (s.c_str (), length_used);
}

double
Inti::Text::to_double (const char * s, int * length_used)
{
  char * endptr = 0;

  double val = g_strtod (s, &endptr);

  if (length_used)
    *length_used = endptr - s;

  return val;
}

///////// I'm sure you could make all these faster.

Inti::ustring
Inti::Text::to_string (int i)
{
  char * s = g_strdup_printf ("%d", i);
  ustring ret (s);
  g_free (s);
  return ret;
}

Inti::ustring
Inti::Text::to_string (unsigned int i)
{
  char * s = g_strdup_printf ("%u", i);
  ustring ret (s);
  g_free (s);
  return ret;
}

Inti::ustring
Inti::Text::to_string (long i)
{
  char * s = g_strdup_printf ("%ld", i);
  ustring ret (s);
  g_free (s);
  return ret;
}

Inti::ustring
Inti::Text::to_string (unsigned long i)
{
  char * s = g_strdup_printf ("%lu", i);
  ustring ret (s);
  g_free (s);
  return ret;
}

Inti::ustring
Inti::Text::to_string (float f)
{
  char * s = g_strdup_printf ("%g", f);
  ustring ret (s);
  g_free (s);
  return ret;
}

Inti::ustring
Inti::Text::to_string (double d)
{
  char * s = g_strdup_printf ("%g", d);
  ustring ret (s);
  g_free (s);
  return ret;
}

#if 0
wstring
Inti::to_wstring (const ustring & s)
{
  

}
#endif

Inti::ustring
Inti::Text::printf_format (const char * printf_format, ...)
{
  char *buf;
  va_list args;

  va_start (args, printf_format);
  buf = g_strdup_vprintf (printf_format, args);
  va_end (args);

  ustring ret (buf);
  g_free (buf);

  return ret;
}

Inti::ustring
Inti::Text::lstrip (const ustring & s)
{
  
}

Inti::ustring
Inti::Text::lstrip (const char * s)
{


}


Inti::ustring
Inti::Text::rstrip (const ustring & s)
{
  ustring retval;
  
  
}

Inti::ustring
Inti::Text::rstrip (const char * s)
{


}


Inti::ustring
Inti::Text::strip (const ustring & s)
{

  
  
}

Inti::ustring
Inti::Text::strip (const char * s)
{


}

Inti::UnicodeType
Inti::Text::type (gunichar c)
{
  return (Inti::UnicodeType) g_unichar_type (c);
}

bool
Inti::Text::is_alnum (gunichar c)
{
  return g_unichar_isalnum (c);
}

bool
Inti::Text::is_alpha (gunichar c)
{
  return g_unichar_isalpha (c);
}

bool
Inti::Text::is_cntrl (gunichar c)
{
  return g_unichar_iscntrl (c);
}

bool
Inti::Text::is_digit (gunichar c)
{
  return g_unichar_isdigit (c);
}

bool
Inti::Text::is_graph (gunichar c)
{
  return g_unichar_isgraph (c);
}

bool
Inti::Text::is_lower (gunichar c)
{
  return g_unichar_islower (c);
}

bool
Inti::Text::is_print (gunichar c)
{
  return g_unichar_isprint (c);
}

bool
Inti::Text::is_punct (gunichar c)
{
  return g_unichar_ispunct (c);
}

bool
Inti::Text::is_space (gunichar c)
{
  return g_unichar_isspace (c);
}

bool
Inti::Text::is_upper (gunichar c)
{
  return g_unichar_isupper (c);
}

bool
Inti::Text::is_xdigit (gunichar c)
{
  return g_unichar_isxdigit (c);
}

bool
Inti::Text::is_title (gunichar c)
{
  return g_unichar_istitle (c);
}

bool
Inti::Text::is_defined (gunichar c)
{
  return g_unichar_isdefined (c);
}

bool
Inti::Text::is_wide (gunichar c)
{
  return g_unichar_iswide (c);
}


gunichar
Inti::Text::to_upper (gunichar c)
{
  return g_unichar_toupper (c);
}

gunichar
Inti::Text::to_lower (gunichar c)
{
  return g_unichar_tolower (c);
}

gunichar
Inti::Text::to_title (gunichar c)
{
  return g_unichar_totitle (c);
}


/////////// Everything below here is machine-generated
