// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_PANGO_LAYOUT_H_
#define _INTI_PANGO_LAYOUT_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <pango/pango.h>
#include <inti/object.h>
#include <inti/utf-string.h>

namespace Inti
{  
  namespace Pango
  {
    class Context;
    
    class LogicalAttributes : private PangoLogAttr
    {
    private:
      typedef PangoLogAttr Base;
      
    public:
      LogicalAttributes (bool is_break_setting, bool is_white_setting,
                         bool is_char_stop_setting, bool is_word_stop_setting)
      {
        set_is_break (is_break_setting);
        set_is_white (is_white_setting);
        set_is_char_stop (is_char_stop_setting);
        set_is_word_stop (is_word_stop_setting);
      }

      LogicalAttributes ()
      {
        set_is_break (false);
        set_is_white (false);
        set_is_char_stop (false);
        set_is_word_stop (false);
      }        

      // The obvious "Base::is_break" etc. confused the compiler...
      bool is_break () const { return ((PangoLogAttr*)this)->is_break; }
      bool is_white () const { return ((PangoLogAttr*)this)->is_white; }
      bool is_char_stop () const { return ((PangoLogAttr*)this)->is_char_stop; }
      bool is_word_stop () const { return ((PangoLogAttr*)this)->is_word_stop; }

      void set_is_break (bool setting) { ((PangoLogAttr*)this)->is_break = setting; }
      void set_is_white (bool setting) { ((PangoLogAttr*)this)->is_white = setting; }
      void set_is_char_stop (bool setting) { ((PangoLogAttr*)this)->is_char_stop = setting; }
      void set_is_word_stop (bool setting) { ((PangoLogAttr*)this)->is_word_stop = setting; }
      
    private:

    };

    int pixels_to_pango (int pixels);
    int pango_to_pixels (int pango_coords);
    
    class Rectangle : private PangoRectangle
    {
    private:
      typedef PangoRectangle Base;
    public:
      Rectangle ();
      Rectangle (int x, int y, int width, int height);
      
      static inline Rectangle * wrap (PangoRectangle * src) { return (Rectangle*) src; }
      
      // using default destructor
      // using default copy constructor and assignment
      
      int x () const { return Base::x; }
      int y () const { return Base::y; }
      int width () const { return Base::width; }
      int height () const { return Base::height; }

      void set_x (int x) { Base::x = x; }
      void set_y (int y) { Base::y = y; }
      void set_width (int w) { Base::width = w; }
      void set_height (int h) { Base::height = h; }

      int ascent () const { return PANGO_ASCENT (*pango_rectangle ()); }
      int descent () const { return PANGO_DESCENT (*pango_rectangle ()); }
      int lbearing () const { return PANGO_LBEARING (*pango_rectangle ()); }
      int rbearing () const { return PANGO_RBEARING (*pango_rectangle ()); }
      
      PangoRectangle * pango_rectangle () const
      {
        return (PangoRectangle*) this;
      }
      
    }; // class Rectangle
    
    namespace Private
    {
      class LayoutClass;
    }; // namespace Private

    typedef enum
    {
      ALIGN_LEFT = PANGO_ALIGN_LEFT,
      ALIGN_CENTER = PANGO_ALIGN_CENTER,
      ALIGN_RIGHT = PANGO_ALIGN_RIGHT
    } Alignment;

    class AttributeList;
    
    class Layout : public Object
    {
    public:
      PangoLayout * pango_layout () const { return (PangoLayout*)g_object (); }

      Layout (Context *context);
      
      void set_attributes (const AttributeList & attr_list);
      
      void set_text (const char * text, int length = -1);
      void set_text (const ustring & str);
      
      void set_width (int width);
      int width () const;

      void set_indent (int indent);
      int indent () const;

      void set_spacing (int spacing);
      int spacing () const;

      void set_justify (bool justify);
      bool justify () const;

      void set_alignment (Alignment alignment);
      Alignment alignment () const;

      void context_changed ();

      void get_logical_attributes (vector<LogicalAttributes> *attributes);
      
      void index_to_position (int index,
                              Rectangle *position);
      
      void get_cursor_position (int index,
                                Rectangle *strong_position,
                                Rectangle *weak_position);
      
      void move_cursor_visually (int old_index,
                                 int old_trailing,
                                 int direction,
                                 int *new_index,
                                 int *new_trailing);
      
      bool xy_to_index (int x, int y,
                        int *index, int *trailing);

      void get_extents(Rectangle *ink_rect,
                       Rectangle *logical_rect);

      void get_pixel_extents (Rectangle *ink_rect,
                              Rectangle *logical_rect);

      void get_size (int *width, int *height);

      void get_pixel_size (int *width, int *height);
      
      // FIXME all the methods relating to getting/setting the glyph
      // ustring are omitted right now.

      // FIXME PangoLayoutLine stuff
      
    protected:
      friend class Private::LayoutClass;
      virtual ~Layout ();
      Layout (PangoLayout * src, PangoLayoutClass * orig);

    private:
      Layout (const Layout&);
      Layout& operator=(const Layout&);
      Layout ();
      
    }; // class Layout
    
  }; // namespace Pango
  
}; // namespace Inti

#endif // _INTI_PANGO_LAYOUT_H_
