// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This source file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
#include "layout.h"
#include "attributes.h"
#include "context.h"
#include <string.h>

int
Inti::Pango::pixels_to_pango (int pixels)
{
  return pixels * PANGO_SCALE;
}

int
Inti::Pango::pango_to_pixels (int pango_coords)
{
  return PANGO_PIXELS (pango_coords);
}

Inti::Pango::Layout::Layout (PangoLayout * src, PangoLayoutClass * orig)
  : Object ((GObject*)src, (GObjectClass*)orig)
{


}

Inti::Pango::Layout::Layout (Context *context)
{
  PangoLayout * layout = pango_layout_new (context->pango_context ());

  init_from_g_object (G_OBJECT (layout), G_OBJECT_GET_CLASS (layout));
}

Inti::Pango::Layout::~Layout ()
{
  

}
      
void
Inti::Pango::Layout::set_attributes (const AttributeList & attr_list)
{
  PangoAttrList *new_list = pango_attr_list_copy (attr_list.pango_attr_list ());
  pango_layout_set_attributes (pango_layout (), new_list);

  pango_attr_list_unref (new_list);
}
      
void
Inti::Pango::Layout::set_text (const char * text, int length)
{
  pango_layout_set_text (pango_layout (), text, length);
}
  
void
Inti::Pango::Layout::set_text (const ustring & str)
{
  pango_layout_set_text (pango_layout (), str.c_str (), str.str ().size ());
}

void
Inti::Pango::Layout::set_width (int width)
{
  pango_layout_set_width (pango_layout (), width);
}

int
Inti::Pango::Layout::width () const
{
  return pango_layout_get_width (pango_layout ());
}

void
Inti::Pango::Layout::set_indent (int indent)
{
  pango_layout_set_indent (pango_layout (), indent);
}

int
Inti::Pango::Layout::indent () const
{
  return pango_layout_get_indent (pango_layout ());
}

void
Inti::Pango::Layout::set_spacing (int spacing)
{
  pango_layout_set_spacing (pango_layout (), spacing);
}

int
Inti::Pango::Layout::spacing () const
{
  return pango_layout_get_spacing (pango_layout ());
}

void
Inti::Pango::Layout::set_justify (bool justify)
{
  pango_layout_set_justify (pango_layout (), justify);
}

bool
Inti::Pango::Layout::justify () const
{
  return pango_layout_get_justify (pango_layout ());
}

void
Inti::Pango::Layout::set_alignment (Alignment alignment)
{
  pango_layout_set_alignment (pango_layout (),
                              (PangoAlignment) alignment);

}

Inti::Pango::Alignment
Inti::Pango::Layout::alignment () const
{
  return (Alignment) pango_layout_get_alignment (pango_layout ());
}

void
Inti::Pango::Layout::context_changed ()
{
  pango_layout_context_changed (pango_layout ());
}

void
Inti::Pango::Layout::get_logical_attributes (vector<LogicalAttributes> *attributes)
{
  gint len = 0;
  gint i;
  PangoLogAttr *array = NULL;
  LogicalAttributes *mem;
  
  pango_layout_get_log_attrs (pango_layout (),
                              &array, &len);
  
  attributes->reserve (len);

  // according to comp.lang.c++.moderated, this is OK.
  mem = &(*attributes)[0];

  // depend on private inheritance of LogicalAttributes from PangoLogAttr
  memcpy ((void*)mem, (void*)array, sizeof (PangoLogAttr) * len);

  // Tell vector it really has those elements (we reserve first to
  // avoid default construction of elements)
  attributes->resize (len);
  
  g_free (array);
}

      
void
Inti::Pango::Layout::index_to_position (int index,
                                        Rectangle *position)
{
  pango_layout_index_to_pos (pango_layout (), index, position->pango_rectangle ());
}
      
void
Inti::Pango::Layout::get_cursor_position (int index,
                                          Rectangle *strong_position,
                                          Rectangle *weak_position)
{
  pango_layout_get_cursor_pos (pango_layout (), index,
                               strong_position ? strong_position->pango_rectangle () : 0,
                               weak_position ? weak_position->pango_rectangle () : 0);
}

void
Inti::Pango::Layout::move_cursor_visually (int old_index,
                                           int old_trailing,
                                           int direction,
                                           int *new_index,
                                           int *new_trailing)
{
  pango_layout_move_cursor_visually (pango_layout (),
                                     old_index, old_trailing,
                                     direction,
                                     new_index, new_trailing);
}
      
bool
Inti::Pango::Layout::xy_to_index (int x, int y,
                                  int *index, int *trailing)
{
  return pango_layout_xy_to_index (pango_layout (), x, y, index, trailing);
}

void
Inti::Pango::Layout::get_extents(Rectangle *ink_rect,
                                 Rectangle *logical_rect)
{
  pango_layout_get_extents (pango_layout (),
                            ink_rect ? ink_rect->pango_rectangle () : 0,
                            logical_rect ? logical_rect->pango_rectangle () : 0);
}

void
Inti::Pango::Layout::get_pixel_extents (Rectangle *ink_rect,
                                        Rectangle *logical_rect)
{
  pango_layout_get_pixel_extents (pango_layout (),
                                  ink_rect ? ink_rect->pango_rectangle () : 0,
                                  logical_rect ? logical_rect->pango_rectangle () : 0);
}

void
Inti::Pango::Layout::get_size (int *width, int *height)
{
  pango_layout_get_size (pango_layout (), width, height);
}

void
Inti::Pango::Layout::get_pixel_size (int *width, int *height)
{
  pango_layout_get_pixel_size (pango_layout (), width, height);
}



/////////// Everything below here is machine-generated
