// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This source file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
#include "context.h"
#include "attributes.h"
#include "font.h"
  
Inti::Pango::Context::Context (PangoContext * src, PangoContextClass * orig)
  : Object ((GObject*)src, (GObjectClass*)orig)
{
  

}

Inti::Pango::Context::Context ()
{
  PangoContext * context = pango_context_new ();

  init_from_g_object (G_OBJECT (context), G_OBJECT_GET_CLASS (context));
}

Inti::Pango::Context::~Context ()
{
  

}

vector<Inti::Pango::FontDescription>
Inti::Pango::Context::list_fonts (const char * family)
{
  vector<FontDescription> retval;

  PangoFontDescription ** descs = 0;
  int n_descs = 0;

  pango_context_list_fonts (pango_context (),
                            family,
                            &descs, &n_descs);


  retval.reserve (n_descs);
  
  int i = 0;
  while (i < n_descs)
    {
      retval.push_back (Pango::FontDescription (descs[i]));

      pango_font_description_free (descs[i]);

      ++i;
    }

  g_free (descs);

  return retval;
}

vector<Inti::Pango::FontDescription>
Inti::Pango::Context::list_fonts (const ustring & family)
{
  return list_fonts (family.c_str ());
}

vector<Inti::Pango::FontDescription>
Inti::Pango::Context::list_fonts ()
{
  return list_fonts (0);
}

vector<Inti::ustring>
Inti::Pango::Context::list_font_families ()
{
  vector<ustring> retval;
  
  gchar **families = 0;
  int n_families = 0;

  pango_context_list_families (pango_context (), &families, &n_families);

  retval.reserve (n_families);
  
  int i = 0;
  while (i < n_families)
    {
      retval.push_back (string (families[i]));
      g_free (families [i]);

      ++i;
    }

  g_free (families);

  return retval;
}

void
Inti::Pango::Context::set_font_description (const FontDescription & desc)
{
  pango_context_set_font_description (pango_context (),
                                      desc.pango_font_description ());
}

Inti::Pango::FontDescription
Inti::Pango::Context::font_description () const
{
  return FontDescription (pango_context_get_font_description (pango_context ()));
}

void
Inti::Pango::Context::set_language (const char * lang)
{
  pango_context_set_lang (pango_context (), lang);
}

void
Inti::Pango::Context::set_language (const ustring & lang)
{
  set_language (lang.c_str ());
}

Inti::ustring
Inti::Pango::Context::language () const
{
  gchar * lang = pango_context_get_lang (pango_context ());
  ustring s (lang);
  g_free (lang);

  return s;
}

void
Inti::Pango::Context::set_base_direction (Direction d)
{
  pango_context_set_base_dir (pango_context (), (PangoDirection) d);
}

Inti::Pango::Direction
Inti::Pango::Context::base_direction () const  
{
  return (Direction) pango_context_get_base_dir (pango_context ());
}


/////////// Everything below here is machine-generated
