// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This source file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
#include "attributes.h"

Inti::Pango::Attribute::Attribute (PangoAttribute * attr)
  : attr_ (attr)
{

}

Inti::Pango::Attribute::~Attribute ()
{
  pango_attribute_destroy (attr_);
}

Inti::Pango::Attribute::Attribute (const Attribute & src)
  : attr_ (pango_attribute_copy (src.attr_))
{

}

Inti::Pango::Attribute &
Inti::Pango::Attribute::operator= (const Attribute & src)
{
  if (attr_ == src.attr_)
    return *this;

  pango_attribute_destroy (attr_);

  attr_ = pango_attribute_copy (src.attr_);
  
  return *this;
}

int
Inti::Pango::Attribute::type_id () const
{
  return int (attr_->klass->type);
}

unsigned int
Inti::Pango::Attribute::start () const
{
  return attr_->start_index;
}

unsigned int
Inti::Pango::Attribute::end () const
{
  return attr_->end_index;
}

void
Inti::Pango::Attribute::set_start (unsigned int start)
{
  attr_->start_index = start;
}

void
Inti::Pango::Attribute::set_end (unsigned int end)
{
  attr_->end_index = end;  
}

void
Inti::Pango::Attribute::set (unsigned int start, unsigned int end)
{
  attr_->start_index = start;
  attr_->end_index = end;
}

Inti::Pango::Attribute *
Inti::Pango::Attribute::wrap (PangoAttribute * src, bool copy)
{
  PangoAttribute * wrapme;

  if (src == 0)
    return 0;
  
  if (copy)
    wrapme = pango_attribute_copy (src);
  else
    wrapme = src;
  
  switch (wrapme->klass->type)
    {
    case PANGO_ATTR_LANG:
      return new LanguageAttribute (wrapme);
      break;

    case PANGO_ATTR_FAMILY:
      return new FontFamilyAttribute (wrapme);
      break;

    case PANGO_ATTR_STYLE:
      return new StyleAttribute (wrapme);
      break;
      
    case PANGO_ATTR_WEIGHT:
      return new WeightAttribute (wrapme);
      break;
      
    case PANGO_ATTR_VARIANT:
      return new VariantAttribute (wrapme);
      break;
      
    case PANGO_ATTR_STRETCH:
      return new StretchAttribute (wrapme);
      break;
      
    case PANGO_ATTR_SIZE:
      return new SizeAttribute (wrapme);
      break;
      
    case PANGO_ATTR_FONT_DESC:
      return new FontDescriptionAttribute (wrapme);
      break;
      
    case PANGO_ATTR_FOREGROUND:
      return new ForegroundAttribute (wrapme);
      break;
      
    case PANGO_ATTR_BACKGROUND:
      return new BackgroundAttribute (wrapme);
      break;
      
    case PANGO_ATTR_UNDERLINE:
      return new UnderlineAttribute (wrapme);
      break;
      
    case PANGO_ATTR_STRIKETHROUGH:
      return new StrikethroughAttribute (wrapme);
      break;
      
    case PANGO_ATTR_RISE:
      return new RiseAttribute (wrapme);
      break;

    default:
      return new Attribute (wrapme);
      break;
    }
}

PangoAttribute *
Inti::Pango::Attribute::pango_attribute (bool create_new_copy) const
{
  if (create_new_copy)
    return pango_attribute_copy (attr_);
  else
    return attr_;
}

Inti::Pango::LanguageAttribute::LanguageAttribute (PangoAttribute * attr)
  : Attribute (attr)
{


}

Inti::Pango::LanguageAttribute::LanguageAttribute (const ustring & language)
  : Attribute (pango_attr_lang_new (language.c_str ()))
{
  
}

Inti::Pango::LanguageAttribute::LanguageAttribute (const char * language)
  : Attribute (pango_attr_lang_new (language))
{

}

Inti::ustring
Inti::Pango::LanguageAttribute::language () const
{
  return ustring (pango_attribute_string ()->value);
}

void
Inti::Pango::LanguageAttribute::set_language (const ustring & language)
{
  set_language (language.c_str ());
}

void
Inti::Pango::LanguageAttribute::set_language (const char * language)
{
  g_free (pango_attribute_string ()->value);
  pango_attribute_string ()->value = g_strdup (language);
}

const int
Inti::Pango::LanguageAttribute::TYPE_ID = int (PANGO_ATTR_LANG);
      


Inti::Pango::FontFamilyAttribute::FontFamilyAttribute (PangoAttribute * attr)
  : Attribute (attr)
{


}

Inti::Pango::FontFamilyAttribute::FontFamilyAttribute (const ustring & font_family)
  : Attribute (pango_attr_family_new (font_family.c_str ()))
{
  
}

Inti::Pango::FontFamilyAttribute::FontFamilyAttribute (const char * font_family)
  : Attribute (pango_attr_family_new (font_family))
{
  
}

Inti::ustring
Inti::Pango::FontFamilyAttribute::font_family () const
{
  return ustring (pango_attribute_string ()->value);
}

void
Inti::Pango::FontFamilyAttribute::set_font_family (const ustring & font_family)
{
  set_font_family (font_family.c_str ());
}

void
Inti::Pango::FontFamilyAttribute::set_font_family (const char * font_family)
{
  g_free (pango_attribute_string ()->value);
  pango_attribute_string ()->value = g_strdup (font_family);
}

const int
Inti::Pango::FontFamilyAttribute::TYPE_ID = int (PANGO_ATTR_FAMILY);


Inti::Pango::StyleAttribute::StyleAttribute (PangoAttribute * attr)
  : Attribute (attr)
{


}

Inti::Pango::StyleAttribute::StyleAttribute (Style style)
  : Attribute (pango_attr_style_new ((PangoStyle) style))
{
}

Inti::Pango::Style
Inti::Pango::StyleAttribute::style () const
{
  return Style (pango_attribute_int ()->value);
}

void
Inti::Pango::StyleAttribute::set_style (Style style)
{
  pango_attribute_int ()->value = int (style);
}

const int
Inti::Pango::StyleAttribute::TYPE_ID = int (PANGO_ATTR_STYLE);


Inti::Pango::WeightAttribute::WeightAttribute (PangoAttribute * attr)
  : Attribute (attr)
{


}

Inti::Pango::WeightAttribute::WeightAttribute (int weight)
  : Attribute (pango_attr_weight_new ((PangoWeight)weight))
{
}

int
Inti::Pango::WeightAttribute::weight () const
{
  return pango_attribute_int ()->value;
}

void
Inti::Pango::WeightAttribute::set_weight (int weight)
{
  pango_attribute_int ()->value = weight;
}

const int
Inti::Pango::WeightAttribute::TYPE_ID = int (PANGO_ATTR_WEIGHT);


Inti::Pango::VariantAttribute::VariantAttribute (PangoAttribute * attr)
  : Attribute (attr)
{


}

Inti::Pango::VariantAttribute::VariantAttribute (Variant v)
  : Attribute (pango_attr_variant_new ((PangoVariant) v))
{
}

Inti::Pango::Variant
Inti::Pango::VariantAttribute::variant () const
{
  return Variant (pango_attribute_int ()->value);
}

void
Inti::Pango::VariantAttribute::set_variant (Variant v)
{
  pango_attribute_int ()->value = int (v);
}

const int
Inti::Pango::VariantAttribute::TYPE_ID = int (PANGO_ATTR_VARIANT);


Inti::Pango::StretchAttribute::StretchAttribute (PangoAttribute * attr)
  : Attribute (attr)
{


}

Inti::Pango::StretchAttribute::StretchAttribute (Stretch str)
  : Attribute (pango_attr_stretch_new ((PangoStretch) str))
{
}

Inti::Pango::Stretch
Inti::Pango::StretchAttribute::stretch () const
{
  return Stretch (pango_attribute_int ()->value);
}

void
Inti::Pango::StretchAttribute::set_stretch (Stretch s)
{
  pango_attribute_int ()->value = int (s);
}

const int
Inti::Pango::StretchAttribute::TYPE_ID = int (PANGO_ATTR_STRETCH);


Inti::Pango::SizeAttribute::SizeAttribute (PangoAttribute * attr)
  : Attribute (attr)
{


}

Inti::Pango::SizeAttribute::SizeAttribute (int size)
  : Attribute (pango_attr_size_new (size))
{
}

int
Inti::Pango::SizeAttribute::size () const
{
  return pango_attribute_int ()->value;
}

void
Inti::Pango::SizeAttribute::set_size (int s)
{
  pango_attribute_int ()->value = s;
}

const int
Inti::Pango::SizeAttribute::TYPE_ID = int (PANGO_ATTR_SIZE);

Inti::Pango::FontDescriptionAttribute::FontDescriptionAttribute (PangoAttribute * attr)
  : Attribute (attr)
{


}

Inti::Pango::FontDescriptionAttribute::FontDescriptionAttribute (const FontDescription & description)
  : Attribute (pango_attr_font_desc_new (description.pango_font_description ()))
{
}

Inti::Pango::FontDescription
Inti::Pango::FontDescriptionAttribute::font_description () const
{
  return FontDescription (&pango_attribute_font_desc ()->desc);
}

void
Inti::Pango::FontDescriptionAttribute::set_font_description (const FontDescription & description)
{
  pango_attribute_font_desc ()->desc = * description.pango_font_description ();
}

const int
Inti::Pango::FontDescriptionAttribute::TYPE_ID = int (PANGO_ATTR_FONT_DESC);


Inti::Pango::ForegroundAttribute::ForegroundAttribute (PangoAttribute * attr)
  : Attribute (attr)
{


}

Inti::Pango::ForegroundAttribute::ForegroundAttribute (guint16 red,
                                                       guint16 green,
                                                       guint16 blue)
  : Attribute (pango_attr_foreground_new (red, green, blue))
{
}

guint16
Inti::Pango::ForegroundAttribute::red () const
{
  return pango_attribute_color ()->red;
}

guint16
Inti::Pango::ForegroundAttribute::green () const
{
  return pango_attribute_color ()->green;
}

guint16
Inti::Pango::ForegroundAttribute::blue () const
{
  return pango_attribute_color ()->blue;
}

void Inti::Pango::ForegroundAttribute::set (guint16 red,
                                            guint16 green,
                                            guint16 blue)
{
  pango_attribute_color ()->red = red;
  pango_attribute_color ()->green = green;
  pango_attribute_color ()->blue = blue;
}

void
Inti::Pango::ForegroundAttribute::set_red (guint16 red)
{
  pango_attribute_color ()->red = red;
}

void
Inti::Pango::ForegroundAttribute::set_blue (guint16 blue)
{
  pango_attribute_color ()->blue = blue;
}

void
Inti::Pango::ForegroundAttribute::set_green (guint16 green)
{
  pango_attribute_color ()->green = green;
}

const int
Inti::Pango::ForegroundAttribute::TYPE_ID = int (PANGO_ATTR_FOREGROUND);


Inti::Pango::BackgroundAttribute::BackgroundAttribute (PangoAttribute * attr)
  : Attribute (attr)
{


}

Inti::Pango::BackgroundAttribute::BackgroundAttribute (guint16 red,
                                                       guint16 green,
                                                       guint16 blue)
  : Attribute (pango_attr_background_new (red, green, blue))
{
  
}

guint16
Inti::Pango::BackgroundAttribute::red () const
{
  return pango_attribute_color ()->red;
}

guint16
Inti::Pango::BackgroundAttribute::green () const
{
  return pango_attribute_color ()->green;
}

guint16
Inti::Pango::BackgroundAttribute::blue () const
{
  return pango_attribute_color ()->blue;
}

void Inti::Pango::BackgroundAttribute::set (guint16 red,
                                            guint16 green,
                                            guint16 blue)
{
  pango_attribute_color ()->red = red;
  pango_attribute_color ()->green = green;
  pango_attribute_color ()->blue = blue;
}

void
Inti::Pango::BackgroundAttribute::set_red (guint16 red)
{
  pango_attribute_color ()->red = red;
}

void
Inti::Pango::BackgroundAttribute::set_blue (guint16 blue)
{
  pango_attribute_color ()->blue = blue;
}

void
Inti::Pango::BackgroundAttribute::set_green (guint16 green)
{
  pango_attribute_color ()->green = green;
}

const int
Inti::Pango::BackgroundAttribute::TYPE_ID = int (PANGO_ATTR_BACKGROUND);


Inti::Pango::UnderlineAttribute::UnderlineAttribute (PangoAttribute * attr)
  : Attribute (attr)
{


}

Inti::Pango::UnderlineAttribute::UnderlineAttribute (Underline uline)
  : Attribute (pango_attr_underline_new ((PangoUnderline) uline))
{
}

Inti::Pango::Underline
Inti::Pango::UnderlineAttribute::underline () const
{
  return Underline (pango_attribute_int ()->value);
}

void Inti::Pango::UnderlineAttribute::set_underline (Underline uline)
{
  pango_attribute_int ()->value = int (uline);
}

const int
Inti::Pango::UnderlineAttribute::TYPE_ID = int (PANGO_ATTR_UNDERLINE);


Inti::Pango::StrikethroughAttribute::StrikethroughAttribute (PangoAttribute * attr)
  : Attribute (attr)
{


}

Inti::Pango::StrikethroughAttribute::StrikethroughAttribute (bool is_stricken)
  : Attribute (pango_attr_strikethrough_new (is_stricken))
{
}

bool
Inti::Pango::StrikethroughAttribute::strikethrough () const
{
  return pango_attribute_int ()->value;
}

void
Inti::Pango::StrikethroughAttribute::set_strikethrough (bool is_stricken)
{
  pango_attribute_int ()->value = is_stricken;
}

const int
Inti::Pango::StrikethroughAttribute::TYPE_ID = int (PANGO_ATTR_STRIKETHROUGH);


Inti::Pango::RiseAttribute::RiseAttribute (PangoAttribute * attr)
  : Attribute (attr)
{


}

Inti::Pango::RiseAttribute::RiseAttribute (int rise)
  : Attribute (pango_attr_rise_new (rise))
{
}

int
Inti::Pango::RiseAttribute::rise () const
{
  return pango_attribute_int ()->value;
}

void
Inti::Pango::RiseAttribute::set_rise (int rise)
{
  pango_attribute_int ()->value = rise;
}

const int
Inti::Pango::RiseAttribute::TYPE_ID = int (PANGO_ATTR_RISE);


//////////////////////////////////////////////////////



Inti::Pango::AttributeList::Range::Range ()
  : iter_ (0)
{
  

}

Inti::Pango::AttributeList::Range::Range (PangoAttrIterator * iter)
  : iter_ (iter)
{ 

}

Inti::Pango::AttributeList::Range::~Range ()
{
  if (iter_)
    pango_attr_iterator_destroy (iter_);
}

Inti::Pango::AttributeList::Range::Range (const Range& src)
{
  if (src.iter_)
    iter_ = pango_attr_iterator_copy (const_cast<PangoAttrIterator*>(src.iter_));
  else
    iter_ = 0;
}

Inti::Pango::AttributeList::Range &
Inti::Pango::AttributeList::Range::operator= (const Range& src)
{
  if (iter_ == src.iter_)
    return *this;

  if (iter_)
    pango_attr_iterator_destroy (iter_);

  if (src.iter_)
    iter_ = pango_attr_iterator_copy (const_cast<PangoAttrIterator*>(src.iter_));
  else
    iter_ = 0;

  return *this;
}

bool
Inti::Pango::AttributeList::Range::next ()
{
  if (iter_)
    return pango_attr_iterator_next (iter_);
  else
    return false;
}

unsigned int
Inti::Pango::AttributeList::Range::start () const
{
  int s = 0;
  
  if (iter_)
    pango_attr_iterator_range (iter_, &s, 0);

  return s;
}

unsigned int
Inti::Pango::AttributeList::Range::end () const
{
  int e = 0;
  
  if (iter_)
    pango_attr_iterator_range (iter_, 0, &e);

  return e;
}

Inti::Pango::Attribute*
Inti::Pango::AttributeList::Range::get (int type_id) const
{
  if (iter_ == 0)
    return 0;
  
  PangoAttribute * attr =
    pango_attr_iterator_get (iter_, PangoAttrType (type_id));

  return Attribute::wrap (attr, true);
}

void
Inti::Pango::AttributeList::Range::get_all (const FontDescription & default_font,
                                            FontDescription * current_font,
                                            vector<Attribute*> * nonfont_attributes) const
{
  if (iter_ == 0)
    return;

  GSList * attrs = NULL;
  PangoFontDescription desc;
  
  pango_attr_iterator_get_font (iter_,
                                const_cast<PangoFontDescription*>(default_font.pango_font_description ()),
                                &desc,
                                &attrs);

  if (current_font)
    current_font->set (&desc);

  if (nonfont_attributes)
    {
      GSList * tmp = attrs;
      while (tmp != NULL)
        {
          PangoAttribute * attr = (PangoAttribute*) tmp->data;
          
          nonfont_attributes->push_back (Attribute::wrap (attr, true));
          
          tmp = g_slist_next (tmp);
        }
    }

  g_slist_free (attrs);
}  

Inti::Pango::AttributeList::AttributeList ()
  : list_ (pango_attr_list_new ())
{

}


Inti::Pango::AttributeList::~AttributeList ()
{
  pango_attr_list_unref (list_);
}

Inti::Pango::AttributeList::AttributeList (const AttributeList & src)
  : list_ (pango_attr_list_copy (src.list_))
{
  
}

Inti::Pango::AttributeList &
Inti::Pango::AttributeList::operator= (const AttributeList & src)
{
  if (list_ == src.list_)
    return *this;

  pango_attr_list_unref (list_);

  list_ = pango_attr_list_copy (src.list_);

  return *this;
}

PangoAttrList *
Inti::Pango::AttributeList::pango_attr_list () const
{
  return list_;
}

void
Inti::Pango::AttributeList::insert (const Attribute & attr)
{
  pango_attr_list_insert (list_, attr.pango_attribute (true));
}

void
Inti::Pango::AttributeList::change (const Attribute & attr)
{
  pango_attr_list_change (list_, attr.pango_attribute (true));
}

Inti::Pango::AttributeList::Range
Inti::Pango::AttributeList::first_range () const
{
  // FIXME I think you might have to call iterator_next here 
  return Range (pango_attr_list_get_iterator (list_));
}


/////////// Everything below here is machine-generated
