// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This source file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
#include "widget.h"
#include "widget-class.h"
#include <inti/proxies.h>
#include "marshal.h"
#include "container.h"
#include <inti/private-util.h>
#include <inti/gdk/bitmap.h>
#include <inti/gdk/window.h>
#include <inti/gdk/event.h>
#include <inti/gdk/visual.h>
#include <inti/gdk/colormap.h>
#include <inti/gtk/selection.h>
#include "rc.h"
#include "dnd.h"
#include "style.h"
#include "rc.h"
#include <gtk/gtkdnd.h>
#include <algorithm>

Inti::Gtk::Allocation::Allocation ()
{

}

Inti::Gtk::Allocation::Allocation (int x, int y, int width, int height)
  : Gdk::Rectangle (x, y, width, height)
{

}

Inti::Gtk::Requisition::Requisition ()
{
  Base::width = Base::height = 0;
}

Inti::Gtk::Requisition::Requisition (int w, int h)
{
  Base::width = w;
  Base::height = h;
}

void
Inti::Gtk::Requisition::set (int w, int h)
{
  Base::width = w;
  Base::height = h;
}

bool
Inti::Gtk::Requisition::operator== (const Requisition & rhs) const
{
  return
    rhs.width () == width () &&
    rhs.height () == height ();
}

bool
Inti::Gtk::Requisition::operator!= (const Requisition & rhs) const
{
  return !(*this == rhs);
}

/////////// Object

const Inti::Gtk::Widget::DestroySignalType
Inti::Gtk::Widget::destroy_signal;

Inti::Gtk::Widget::Widget ()
  : Object (Private::WidgetClass::make_proxy(),
            Private::WidgetClass::original_class())
{
  if (!GTK_OBJECT_CONSTRUCTED (g_object ()))
    gtk_object_default_construct (GTK_OBJECT (g_object ()));
}

Inti::Gtk::Widget::Widget (GtkWidget *obj, GtkWidgetClass * orig)
  : Object ((GObject*)obj,
            (GObjectClass*)orig)
{
  if (!GTK_OBJECT_CONSTRUCTED (g_object ()))
    gtk_object_default_construct (GTK_OBJECT (g_object ()));
}

void
Inti::Gtk::Widget::sink_impl ()
{
  gtk_object_sink (GTK_OBJECT (g_object ()));
}

bool
Inti::Gtk::Widget::floating () const
{
  return GTK_OBJECT_FLOATING (g_object ());
}

Inti::Gtk::Widget::~Widget ()
{

}

void
Inti::Gtk::Widget::destroy ()
{
  gtk_object_destroy (GTK_OBJECT (g_object ()));
}

void
Inti::Gtk::Widget::toggle_flag (Flags flag, bool setting)
{
  if (setting)
    set_flags ((FlagsField)flag);
  else
    unset_flags ((FlagsField)flag);
}

Inti::Gdk::Window *
Inti::Gtk::Widget::window () const
{
  Gdk::Window * win =
    dynamic_cast<Gdk::Window*>(Object::_private_wrap ((GObject*)gtk_widget ()->window,
                                                      false));
  return win;
}

//! Returns the widget's parent container.
/*!
  Widgets are typically placed inside container widgets. If a widget
  is currently inside a container, this method returns the parent
  container. Otherwise it returns 0. The caller of parent() does not
  own a reference to the returned container.

  \return the widget's parent.
*/
Inti::Gtk::Container *
Inti::Gtk::Widget::parent () const
{
  Object * parent = Object::wrap ((GObject*)gtk_widget ()->parent);

  return dynamic_cast<Container*> (parent);
}

void
Inti::Gtk::Widget::drag_get_data (Gtk::DragContext * context,
                                  Gdk::Atom target,
                                  guint32 time)
{
  gtk_drag_get_data (gtk_widget (),
                     context->gdk_drag_context (),
                     target, time);
}

void
Inti::Gtk::Widget::drag_highlight ()
{
  gtk_drag_highlight (gtk_widget ());
}

void
Inti::Gtk::Widget::drag_unhighlight ()
{
  gtk_drag_unhighlight (gtk_widget ());
}

void
Inti::Gtk::Widget::drag_dest_set (DestDefaultsField defaults,
                                  const vector<DragTargetEntry> & targets,
                                  Gdk::DragActionField actions)
{
  g_return_if_fail (!targets.empty ());
  
  GtkTargetEntry * array =
    new GtkTargetEntry[targets.size ()];

  int i = 0;
  int count = targets.size ();
  while (i < count)
    {
      const DragTargetEntry & entry (targets[i]);
      array[i].target = const_cast<char*>(entry.target ().c_str ());
      array[i].info = entry.info ();
      array[i].flags = entry.flags ();
      
      ++i;
    }
  
  gtk_drag_dest_set (gtk_widget (),
                     (GtkDestDefaults) defaults,
                     array,
                     count,
                     (GdkDragAction) actions);
  
  delete [] array;
}

void
Inti::Gtk::Widget::drag_dest_unset ()
{
  gtk_drag_dest_unset (gtk_widget ());
}

void
Inti::Gtk::Widget::drag_dest_set_proxy (Gdk::Window * proxy_window,
                                           Gdk::DragProtocol protocol,
                                           bool use_coordinates)
{
  gtk_drag_dest_set_proxy (gtk_widget (),
                           proxy_window ? proxy_window->gdk_window () : 0,
                           (GdkDragProtocol) protocol,
                           use_coordinates);
}

void
Inti::Gtk::Widget::drag_source_set (Gdk::ModifierTypeField start_button_mask,
                                       const vector<DragTargetEntry> & targets,
                                       Gdk::DragActionField actions)
{
  g_return_if_fail (!targets.empty ());
  
  GtkTargetEntry * array =
    new GtkTargetEntry[targets.size ()];

  int i = 0;
  int count = targets.size ();
  while (i < count)
    {
      const DragTargetEntry & entry (targets[i]);
      array[i].target = const_cast<char*>(entry.target ().c_str ());
      array[i].info = entry.info ();
      array[i].flags = entry.flags ();
      
      ++i;
    }
  
  gtk_drag_source_set (gtk_widget (),
                       (GdkModifierType) start_button_mask,
                       array,
                       count,
                       (GdkDragAction) actions);
  
  delete [] array;
}

void
Inti::Gtk::Widget::drag_source_unset ()
{
  gtk_drag_source_unset (gtk_widget ());
}

bool
Inti::Gtk::Widget::event (const Gdk::Event & event)
{
  return gtk_widget_event (gtk_widget (), event.gdk_event ()) != FALSE;
}

//! For use in custom Container implementations; installs the parent of a child widget
/*!
  Widgets that override Container::add_impl() may need to call this method
  when a child is added to the container, to notify the child that it
  has a new parent.

  \param new_parent The container the child has been added to.     
*/

void
Inti::Gtk::Widget::set_parent (Container * new_parent)
{
  gtk_widget_set_parent (gtk_widget (),
                         new_parent ? new_parent->gtk_widget () : 0);
}

//! Moves a widget from one container to another.
/*!
  Reparents the widget from its current container, if any, to \a
  new_parent. If the widget has no current container, then this method
  is equivalent to new_parent->add (this).  If \a new_parent is 0,
  then the widget ends up without a parent container. Be careful; the
  widget's current container may have held the last outstanding
  reference to the widget, so unparenting a widget can result in its
  destruction.

  \param new_parent New parent container.
*/

void
Inti::Gtk::Widget::reparent (Container * new_parent)
{
  ref ();
  if (new_parent)
    new_parent->ref ();
  
  Container * p = parent ();

  if (p)
    p->remove (this);

  if (new_parent)
    new_parent->add (this);

  if (new_parent)
    new_parent->unref ();
  
  unref ();
}

bool
Inti::Gtk::Widget::intersect (const Gdk::Rectangle & area,
                              Gdk::Rectangle * intersection)
{
  return gtk_widget_intersect (gtk_widget (),
                               area.gdk_rectangle (),
                               intersection ? intersection->gdk_rectangle () : 0);
}

Inti::ustring
Inti::Gtk::Widget::name () const
{
  ustring s (gtk_widget_get_name (gtk_widget ()));

  return s;
}

void
Inti::Gtk::Widget::set_events (Gdk::EventMaskField mask)
{
  gtk_widget_set_events (gtk_widget (), mask);
}

void
Inti::Gtk::Widget::add_events (Gdk::EventMaskField mask)
{
  gtk_widget_add_events (gtk_widget (), mask);
}

Inti::Gdk::EventMaskField
Inti::Gtk::Widget::events () const
{
  return gtk_widget_get_events (gtk_widget ());
}

void
Inti::Gtk::Widget::set_extension_events (Gdk::ExtensionModeField extension_events)
{
  gtk_widget_set_extension_events (gtk_widget (), (GdkExtensionMode)extension_events);

}

Inti::Gdk::ExtensionModeField
Inti::Gtk::Widget::extension_events () const
{
  return (Gdk::ExtensionModeField) gtk_widget_get_extension_events (gtk_widget ());
}

//! Get the toplevel container for a widget.
/*!

  This method returns the Window containing a widget (the widget's
  farthest-removed ancestor container, i.e. the parent of its parent
  of its parent... etc.). It returns 0 if a widget is not inside
  a toplevel container. The caller of the method does not own a reference
  to the returned container.

  \return Toplevel container the widget is inside.
*/

Inti::Gtk::Container *
Inti::Gtk::Widget::toplevel_container () const
{
  GtkWidget * top = gtk_widget_get_toplevel (gtk_widget ());

  if (top)
    {
      Object * o = Object::wrap ((GObject*)top);
      return dynamic_cast<Container*> (o);
    }
  else
    return 0;
}

//! Returns the colormap for a widget.
/*!

  Returns the colormap used to display a widget. The caller of the
  method does not own a reference to the returned colormap.

  \return The widget's colormap.
*/

Inti::Gdk::Colormap *
Inti::Gtk::Widget::colormap () const
{
  return
    dynamic_cast<Gdk::Colormap*>(Object::_private_wrap ((GObject*)gtk_widget_get_colormap (gtk_widget ()), false));
}

const Inti::Gdk::Visual &
Inti::Gtk::Widget::visual () const
{
  return * Gdk::Visual::wrap (gtk_widget_get_visual (gtk_widget ()));
}

//! Gets the mouse pointer location. 
/*!
  Retrieves the location of the mouse pointer in widget-relative
  pixel coordinates. The return locations \a x and \a y will be filled
  with the pointer location. Either or both of \a x and \a y may be 0,
  if you aren't interested in one of the axes. As always, Inti coordinates
  begin in the top-left (northwest) corner of the screen.

  \param x Return location for X coordinate.
  \param y Return location for Y coordinate.
*/
void
Inti::Gtk::Widget::get_pointer (int * x, int * y) const
{
  gtk_widget_get_pointer (gtk_widget (), x, y);
}

bool
Inti::Gtk::Widget::contained_by (Container * ancestor) const
{
  return gtk_widget_is_ancestor (gtk_widget (), ancestor->gtk_widget ());
}

Inti::Gtk::Style *
Inti::Gtk::Widget::style ()
{
  return (Style*) Object::_private_wrap ((GObject*) gtk_widget ()->style,
                                         false);
}

const Inti::Gtk::Style *
Inti::Gtk::Widget::style () const
{
  return (Style*) Object::_private_wrap ((GObject*) gtk_widget ()->style,
                                         false);
}

void
Inti::Gtk::Widget::set_style (Style * style)
{
  gtk_widget_set_style (gtk_widget (),
                        style ? style->gtk_style () : 0);
  if (style)
    style->sink ();
}

void
Inti::Gtk::Widget::ensure_style ()
{
  gtk_widget_ensure_style (gtk_widget ());
}

void
Inti::Gtk::Widget::restore_default_style ()
{
  gtk_widget_restore_default_style (gtk_widget ());
}

void
Inti::Gtk::Widget::modify_style (RcStyle * rc_style)
{
  gtk_widget_modify_style (gtk_widget (),
                           rc_style ? rc_style->gtk_rc_style () : 0);
  if (rc_style)
    rc_style->sink ();
}

void
Inti::Gtk::Widget::push_style (Style * style)
{
  gtk_widget_push_style (style->gtk_style ());
  style->sink ();
}

void
Inti::Gtk::Widget::pop_style ()
{
  gtk_widget_pop_style ();
}

void
Inti::Gtk::Widget::push_colormap (Gdk::Colormap * colormap)
{
  gtk_widget_push_colormap (colormap->gdk_colormap ());
  colormap->sink ();
}

void
Inti::Gtk::Widget::pop_colormap ()
{
  gtk_widget_pop_colormap ();
}

void
Inti::Gtk::Widget::push_composite_child ()
{
  gtk_widget_push_composite_child ();
}

void
Inti::Gtk::Widget::pop_composite_child ()
{
  gtk_widget_pop_composite_child ();
}

void
Inti::Gtk::Widget::shape_combine_mask (Gdk::Bitmap * mask,
                                          int x_offset,
                                          int y_offset)
{
  gtk_widget_shape_combine_mask (gtk_widget (),
                                 mask ? mask->gdk_bitmap () : 0,
                                 x_offset,
                                 y_offset);
}



void
Inti::Gtk::Widget::set_colormap (Gdk::Colormap * cmap)
{
  gtk_widget_set_colormap (gtk_widget (), cmap->gdk_colormap ());
  cmap->sink ();
}

void
Inti::Gtk::Widget::set_window (Gdk::Window * window)
{
  GdkWindow * gdkwin = window ? window->gdk_window () : 0;

  if (gtk_widget ()->window == gdkwin)
    return;
  
  if (gtk_widget ()->window)
    g_object_unref (G_OBJECT (gtk_widget ()->window));

  gtk_widget ()->window = gdkwin;

  if (gdkwin)
    g_object_ref (G_OBJECT (gdkwin));
}

void
Inti::Gtk::Widget::grab_add ()
{
  gtk_grab_add (gtk_widget ());
}

void
Inti::Gtk::Widget::grab_remove ()
{
  gtk_grab_remove (gtk_widget ());
}

Inti::Gtk::Widget *
Inti::Gtk::Widget::grab_get_current ()
{
  return dynamic_cast<Widget*>(Object::wrap ((GObject*) gtk_grab_get_current ()));
}

Inti::Gtk::Widget *
Inti::Gtk::Widget::event_widget (const Gdk::Event & event)
{
  return dynamic_cast<Widget*>(Object::wrap ((GObject*) gtk_get_event_widget (event.gdk_event ())));
}

////////////////////////

void
Inti::Gtk::Widget::map_proxy (GtkWidget * w)
{
  Inti::Private::proxy_implementation_0 (w, &Widget::map_impl);
}

void
Inti::Gtk::Widget::unmap_proxy (GtkWidget * w)
{
  Inti::Private::proxy_implementation_0 (w, &Widget::unmap_impl);
}

void
Inti::Gtk::Widget::show_all_proxy (GtkWidget * w)
{
  Inti::Private::proxy_implementation_0 (w,
                                            &Widget::show_all_impl);
}


void
Inti::Gtk::Widget::hide_all_proxy (GtkWidget * w)
{
  Inti::Private::proxy_implementation_0 (w,
                                            &Widget::hide_all_impl);
}


void
Inti::Gtk::Widget::destroy_proxy (GtkObject * obj)
{
  Gtk::Widget *o = (Gtk::Widget*)
    gtk_object_get_data_by_id (obj, Inti::Private::quark ());

  // Note that the destroy signal is a special case,
  // because it is not connect_after (it emits
  // the signal _before_ calling _impl()) - because _impl()
  // disconnects all the signal handlers.
  
  // we know the object still has refcount > 0 due to signal emission
  o->on_destroy ();

  // connect_after() doesn't work on the destroy signal, since destroy()
  // disconnects all signal handlers. So we have to use this native
  // signal instead.
  destroy_signal.emit (o);
  
  o->destroy_impl ();
}

void
Inti::Gtk::Widget::show_proxy (GtkWidget * w)
{
  Inti::Private::proxy_implementation_0 (w,
                                            &Widget::show_impl,
                                            &Widget::on_show);
}

void
Inti::Gtk::Widget::hide_proxy (GtkWidget * w)
{
  Inti::Private::proxy_implementation_0 (w,
                                            &Widget::hide_impl,
                                            &Widget::on_hide);
}

void
Inti::Gtk::Widget::realize_proxy (GtkWidget * w)
{
  Inti::Private::proxy_implementation_0 (w,
                                            &Widget::realize_impl,
                                            &Widget::on_realize);
}

void
Inti::Gtk::Widget::unrealize_proxy (GtkWidget * w)
{
  Inti::Private::proxy_implementation_0 (w,
                                            &Widget::unrealize_impl,
                                            &Widget::on_unrealize);
}

void
Inti::Gtk::Widget::draw_proxy (GtkWidget * w, GdkRectangle * area)
{
  const Gdk::Rectangle * rect =
    const_cast<const Gdk::Rectangle*>(Gdk::Rectangle::wrap (area));

  Widget *o = (Widget*)
    gtk_object_get_data_by_id ((GtkObject*)w, Inti::Private::quark ());

  o->draw_impl (*rect);
  o->on_draw (*rect);
}

void
Inti::Gtk::Widget::draw_focus_proxy (GtkWidget * w)
{
  Inti::Private::proxy_implementation_0 (w,
                                            &Widget::draw_focus_impl,
                                            &Widget::on_draw_focus);
}

void
Inti::Gtk::Widget::draw_default_proxy (GtkWidget * w)
{
  Inti::Private::proxy_implementation_0 (w,
                                            &Widget::draw_default_impl,
                                            &Widget::on_draw_default);
}

void
Inti::Gtk::Widget::size_request_proxy (GtkWidget * w, GtkRequisition * requisition)
{
  Inti::Private::proxy_implementation_1 (w,
                                            &Widget::size_request_impl,
                                            &Widget::on_size_request,
                                            Requisition::wrap (requisition));
}

void
Inti::Gtk::Widget::size_allocate_proxy (GtkWidget *w,
                                           GtkAllocation * allocation)
{
  const Allocation * a = Allocation::wrap (allocation);

  Widget * o = (Widget*)
    gtk_object_get_data_by_id ((GtkObject*)w, Inti::Private::quark ());

  o->size_allocate_impl (*a);
}

void
Inti::Gtk::Widget::state_changed_proxy (GtkWidget * w, GtkStateType state)
{
  Inti::Private::proxy_implementation_1 (w,
                                            &Widget::state_changed_impl,
                                            &Widget::on_state_changed,
                                            (StateType) state);
}

void
Inti::Gtk::Widget::parent_set_proxy (GtkWidget * w, GtkWidget * parent)
{
  Inti::Private::proxy_implementation_1 (w,
                                            &Widget::parent_set_impl,
                                            &Widget::on_parent_set,
                                            dynamic_cast<Widget*>(Object::wrap ((GObject*)parent)));
}

void
Inti::Gtk::Widget::style_set_proxy (GtkWidget * w, GtkStyle * previous)
{
  Inti::Private::proxy_implementation_1 (w,
                                         &Widget::style_set_impl,
                                         &Widget::on_style_set,
                                         dynamic_cast<Style*>(Object::_private_wrap ((GObject*)previous, false)));
}

void
Inti::Gtk::Widget::grab_focus_proxy (GtkWidget * w)
{
  Inti::Private::proxy_implementation_0 (w,
                                            &Widget::grab_focus_impl,
                                            &Widget::on_grab_focus);
}

namespace Inti
{
  namespace Gtk
  {
    template <class CEventType, class CppEventType>
    gint
    event_proxy_implementation (GtkWidget * obj,
                                CEventType * event,
                                bool (Widget::* method_impl)(const CppEventType&),
                                bool (Widget::* on_method)(const CppEventType&))
    {
      Gtk::Widget *o = (Gtk::Widget*)
        gtk_object_get_data_by_id ((GtkObject*)obj, Inti::Private::quark ());

      CppEventType * e = CppEventType::wrap (event);

      if ( ! (o->*method_impl) (*e))
        return (o->*on_method) (*e);
      else
        return true;
    }
  } // namespace Gtk
} // namespace Inti

gint
Inti::Gtk::Widget::event_proxy (GtkWidget *obj,
                                   GdkEvent *event)
{
  return event_proxy_implementation (obj, event,
                                     &Widget::event_impl,
                                     &Widget::on_event);
}


gint
Inti::Gtk::Widget::button_press_event_proxy (GtkWidget *obj,
                                                GdkEventButton *event)
{
  return event_proxy_implementation (obj, event,
                                     &Widget::button_press_event_impl,
                                     &Widget::on_button_press_event);
}

gint
Inti::Gtk::Widget::button_release_event_proxy (GtkWidget *obj,
                                                  GdkEventButton *event)
{
  return event_proxy_implementation (obj, event,
                                     &Widget::button_release_event_impl,
                                     &Widget::on_button_release_event);
}

gint
Inti::Gtk::Widget::scroll_event_proxy (GtkWidget *obj,
                                          GdkEventScroll *event)
{
  return event_proxy_implementation (obj, event,
                                     &Widget::scroll_event_impl,
                                     &Widget::on_scroll_event);
}

gint
Inti::Gtk::Widget::motion_notify_event_proxy (GtkWidget *obj,
                                                 GdkEventMotion *event)
{
  return event_proxy_implementation (obj, event,
                                     &Widget::motion_notify_event_impl,
                                     &Widget::on_motion_notify_event);
}

gint
Inti::Gtk::Widget::delete_event_proxy (GtkWidget *obj,
                                          GdkEventAny *event)
{
  return event_proxy_implementation (obj, event,
                                     &Widget::delete_event_impl,
                                     &Widget::on_delete_event);
}

gint
Inti::Gtk::Widget::expose_event_proxy (GtkWidget *obj,
                                          GdkEventExpose *event)
{
  return event_proxy_implementation (obj, event,
                                     &Widget::expose_event_impl,
                                     &Widget::on_expose_event);
}

gint
Inti::Gtk::Widget::key_press_event_proxy (GtkWidget *obj,
                                             GdkEventKey *event)
{
  return event_proxy_implementation (obj, event,
                                     &Widget::key_press_event_impl,
                                     &Widget::on_key_press_event);
}

gint
Inti::Gtk::Widget::key_release_event_proxy (GtkWidget *obj,
                                               GdkEventKey *event)
{
  return event_proxy_implementation (obj, event,
                                     &Widget::key_release_event_impl,
                                     &Widget::on_key_release_event);
}

gint
Inti::Gtk::Widget::enter_notify_event_proxy (GtkWidget *obj,
                                                GdkEventCrossing *event)
{
  return event_proxy_implementation (obj, event,
                                     &Widget::enter_notify_event_impl,
                                     &Widget::on_enter_notify_event);
}

gint
Inti::Gtk::Widget::leave_notify_event_proxy (GtkWidget *obj,
                                                GdkEventCrossing *event)
{
  return event_proxy_implementation (obj, event,
                                     &Widget::leave_notify_event_impl,
                                     &Widget::on_leave_notify_event);
}

gint
Inti::Gtk::Widget::configure_event_proxy (GtkWidget *obj,
                                             GdkEventConfigure *event)
{
  return event_proxy_implementation (obj, event,
                                     &Widget::configure_event_impl,
                                     &Widget::on_configure_event);
}

gint
Inti::Gtk::Widget::focus_in_event_proxy (GtkWidget *obj,
                                            GdkEventFocus *event)
{
  return event_proxy_implementation (obj, event,
                                     &Widget::focus_in_event_impl,
                                     &Widget::on_focus_in_event);
}

gint
Inti::Gtk::Widget::focus_out_event_proxy (GtkWidget *obj,
                                             GdkEventFocus *event)
{
  return event_proxy_implementation (obj, event,
                                     &Widget::focus_out_event_impl,
                                     &Widget::on_focus_out_event);
}

gint
Inti::Gtk::Widget::map_event_proxy (GtkWidget *obj,
                                       GdkEventAny *event)
{
  return event_proxy_implementation (obj, event,
                                     &Widget::map_event_impl,
                                     &Widget::on_map_event);
}

gint
Inti::Gtk::Widget::unmap_event_proxy (GtkWidget *obj,
                                         GdkEventAny *event)
{
  return event_proxy_implementation (obj, event,
                                     &Widget::unmap_event_impl,
                                     &Widget::on_unmap_event);
}

gint
Inti::Gtk::Widget::property_notify_event_proxy (GtkWidget *obj,
                                                   GdkEventProperty *event)
{
  return event_proxy_implementation (obj, event,
                                     &Widget::property_notify_event_impl,
                                     &Widget::on_property_notify_event);
}

gint
Inti::Gtk::Widget::selection_clear_event_proxy (GtkWidget *obj,
                                                   GdkEventSelection *event)
{
  return event_proxy_implementation (obj, event,
                                     &Widget::selection_clear_event_impl,
                                     &Widget::on_selection_clear_event);
}

gint
Inti::Gtk::Widget::selection_request_event_proxy (GtkWidget *obj,
                                                     GdkEventSelection *event)
{
  return event_proxy_implementation (obj, event,
                                     &Widget::selection_request_event_impl,
                                     &Widget::on_selection_request_event);
}

gint
Inti::Gtk::Widget::selection_notify_event_proxy (GtkWidget *obj,
                                                    GdkEventSelection *event)
{
  return event_proxy_implementation (obj, event,
                                     &Widget::selection_notify_event_impl,
                                     &Widget::on_selection_notify_event);
}

gint
Inti::Gtk::Widget::proximity_in_event_proxy (GtkWidget *obj,
                                                GdkEventProximity *event)
{
  return event_proxy_implementation (obj, event,
                                     &Widget::proximity_in_event_impl,
                                     &Widget::on_proximity_in_event);
}

gint
Inti::Gtk::Widget::proximity_out_event_proxy (GtkWidget *obj,
                                                 GdkEventProximity *event)
{
  return event_proxy_implementation (obj, event,
                                     &Widget::proximity_out_event_impl,
                                     &Widget::on_proximity_out_event);
}

gint
Inti::Gtk::Widget::visibility_notify_event_proxy (GtkWidget *obj,
                                                     GdkEventVisibility *event)
{
  return event_proxy_implementation (obj, event,
                                     &Widget::visibility_notify_event_impl,
                                     &Widget::on_visibility_notify_event);
}

gint
Inti::Gtk::Widget::client_event_proxy (GtkWidget *obj,
                                          GdkEventClient *event)
{
  return event_proxy_implementation (obj, event,
                                     &Widget::client_event_impl,
                                     &Widget::on_client_event);
}

gint
Inti::Gtk::Widget::no_expose_event_proxy (GtkWidget *obj,
                                             GdkEventAny *event)
{
  return event_proxy_implementation (obj, event,
                                     &Widget::no_expose_event_impl,
                                     &Widget::on_no_expose_event);
}

void
Inti::Gtk::Widget::selection_get_proxy (GtkWidget *widget,
                                           GtkSelectionData *selection_data,
                                           guint info,
                                           guint time)
{
  Widget * o =
    (Widget*) Object::wrap ((GObject*)widget);

  o->selection_get_impl ((Gtk::SelectionData*) selection_data,
                         info, time);
  o->on_selection_get ((Gtk::SelectionData*) selection_data,
                       info, time);
}

void
Inti::Gtk::Widget::selection_received_proxy (GtkWidget *widget,
                                                GtkSelectionData *selection_data,
                                                guint time)
{
  Widget * o =
    (Widget*) Object::wrap ((GObject*)widget);

  o->selection_received_impl (*(Gtk::SelectionData*) selection_data,
                              time);
  o->on_selection_received (*(Gtk::SelectionData*) selection_data,
                            time);
}

void
Inti::Gtk::Widget::drag_begin_proxy (GtkWidget *widget,
                                        GdkDragContext *context)
{
  Widget * o =
    (Widget*) Object::wrap ((GObject*)widget);

  Gtk::DragContext * oc =
    (Gtk::DragContext*) Object::_private_wrap ((GObject*)context, false);

  o->drag_begin_impl (oc);
  o->on_drag_begin (oc);
}

void
Inti::Gtk::Widget::drag_end_proxy (GtkWidget *widget,
                                      GdkDragContext *context)
{
  Widget * o =
    (Widget*) Object::wrap ((GObject*)widget);

  Gtk::DragContext * oc =
    (Gtk::DragContext*) Object::_private_wrap ((GObject*)context, false);

  o->drag_end_impl (oc);
  o->on_drag_end (oc);
}

void
Inti::Gtk::Widget::drag_data_get_proxy (GtkWidget *widget,
                                           GdkDragContext *context,
                                           GtkSelectionData *selection_data,
                                           guint info,
                                           guint time)
{
  Widget * o =
    (Widget*) Object::wrap ((GObject*)widget);

  Gtk::DragContext * oc =
    (Gtk::DragContext*) Object::_private_wrap ((GObject*)context, false);

  Gtk::SelectionData * sd = (Gtk::SelectionData*) selection_data;
  
  o->drag_data_get_impl (oc, sd, info, time);
  o->on_drag_data_get (oc, sd, info, time);
}

void
Inti::Gtk::Widget::drag_data_delete_proxy (GtkWidget *widget,
                                              GdkDragContext *context)
{
  Widget * o =
    (Widget*) Object::wrap ((GObject*)widget);

  Gtk::DragContext * oc =
    (Gtk::DragContext*) Object::_private_wrap ((GObject*)context, false);

  o->drag_data_delete_impl (oc);
  o->on_drag_data_delete (oc);
}

void
Inti::Gtk::Widget::drag_leave_proxy (GtkWidget *widget,
                                        GdkDragContext *context,
                                        guint time)
{
  Widget * o =
    (Widget*) Object::wrap ((GObject*)widget);

  Gtk::DragContext * oc =
    (Gtk::DragContext*) Object::_private_wrap ((GObject*)context, false);

  o->drag_leave_impl (oc, time);
  o->on_drag_leave (oc, time);
}

gboolean
Inti::Gtk::Widget::drag_motion_proxy (GtkWidget *widget,
                                         GdkDragContext *context,
                                         gint x,
                                         gint y,
                                         guint time)
{
  Widget * o =
    (Widget*) Object::wrap ((GObject*)widget);

  Gtk::DragContext * oc =
    (Gtk::DragContext*) Object::_private_wrap ((GObject*)context, false);

  if (!o->drag_motion_impl (oc, x, y, time))
    return o->on_drag_motion (oc, x, y, time);
  else
    return true;
}

gboolean
Inti::Gtk::Widget::drag_drop_proxy (GtkWidget *widget,
                                       GdkDragContext *context,
                                       gint x,
                                       gint y,
                                       guint time)
{
  Widget * o =
    (Widget*) Object::wrap ((GObject*)widget);

  Gtk::DragContext * oc =
    (Gtk::DragContext*) Object::_private_wrap ((GObject*)context, false);

  if (!o->drag_drop_impl (oc, x, y, time))
    return o->on_drag_drop (oc, x, y, time);
  else
    return true;
}

void
Inti::Gtk::Widget::drag_data_received_proxy (GtkWidget *widget,
                                                GdkDragContext *context,
                                                gint x,
                                                gint y,
                                                GtkSelectionData *selection_data,
                                                guint info,
                                                guint time)
{
  Widget * o =
    (Widget*) Object::wrap ((GObject*)widget);

  Gtk::DragContext * oc =
    (Gtk::DragContext*) Object::_private_wrap ((GObject*)context, false);

  const Gtk::SelectionData & sd (* (Gtk::SelectionData*) selection_data);  
  
  o->drag_data_received_impl (oc, x, y, sd, info, time);
  o->on_drag_data_received (oc, x, y, sd, info, time);
}

/////////////

void
Inti::Gtk::Widget::map_impl ()
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class();

  if (orig->map)
    (* orig->map) (gtk_widget ());
}

void
Inti::Gtk::Widget::unmap_impl ()
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class();

  if (orig->unmap)
    (* orig->unmap) (gtk_widget ());
}

///////////

void
Inti::Gtk::Widget::destroy_impl ()
{
  GtkObjectClass * orig =
    (GtkObjectClass *) original_class ();

  g_assert (GTK_IS_OBJECT_CLASS (orig));

  // remember we have a native signal that's synced
  // with the GTK signal
  Inti::Object::disconnect_native_connections ();
  
  if (orig->destroy)
    (* orig->destroy) (GTK_OBJECT (g_object ()));
}

void
Inti::Gtk::Widget::show_impl ()
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class();

  if (orig->show)
    (* orig->show) (gtk_widget ());
}

void
Inti::Gtk::Widget::show_all_impl ()
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class();

  if (orig->show_all)
    (* orig->show_all) (gtk_widget ());
}

void
Inti::Gtk::Widget::hide_impl ()
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class();

  if (orig->hide)
    (* orig->hide) (gtk_widget ());
}

void
Inti::Gtk::Widget::hide_all_impl ()
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class();

  if (orig->hide_all)
    (* orig->hide_all) (gtk_widget ());
}

void
Inti::Gtk::Widget::realize_impl ()
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class();

  if (orig->realize)
    (* orig->realize) (gtk_widget ());
}

void
Inti::Gtk::Widget::unrealize_impl ()
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class();

  if (orig->unrealize)
    (* orig->unrealize) (gtk_widget ());
}

void
Inti::Gtk::Widget::draw_impl (const Gdk::Rectangle & area)
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class();

  if (orig->draw)
    (* orig->draw) (gtk_widget (), area.gdk_rectangle ());
}

void
Inti::Gtk::Widget::draw_focus_impl ()
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class();

  if (orig->draw_focus)
    (* orig->draw_focus) (gtk_widget ());
}

void
Inti::Gtk::Widget::draw_default_impl ()
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class();

  if (orig->draw_default)
    (* orig->draw_default) (gtk_widget ());
}

void
Inti::Gtk::Widget::size_request_impl (Requisition * requisition)
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class();

  if (orig->size_request)
    (* orig->size_request) (gtk_widget (), requisition->gtk_requisition ());
}

void
Inti::Gtk::Widget::size_allocate_impl (const Allocation & allocation)
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class();

  if (orig->size_allocate)
    (* orig->size_allocate) (gtk_widget (),
                             allocation.gtk_allocation());
}


void
Inti::Gtk::Widget::state_changed_impl (StateType previous_state)
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class();

  if (orig->state_changed)
    (* orig->state_changed) (gtk_widget (), (GtkStateType)previous_state);
}

void
Inti::Gtk::Widget::parent_set_impl (Widget * parent)
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class();

  if (orig->parent_set)
    (* orig->parent_set) (gtk_widget (), parent->gtk_widget ());
}

void
Inti::Gtk::Widget::style_set_impl (Style * previous)
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class();

  if (orig->style_set)
    (* orig->style_set) (gtk_widget (), previous ? previous->gtk_style () : 0);
}

void
Inti::Gtk::Widget::grab_focus_impl ()
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class();

  if (orig->grab_focus)
    (* orig->grab_focus) (gtk_widget ());
}

bool
Inti::Gtk::Widget::event_impl (const Gdk::Event & event)
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class();

  if (orig->event)
    return (* orig->event) (gtk_widget (),
                            event.gdk_event());
  else
    return false;
}

bool
Inti::Gtk::Widget::button_press_event_impl (const Gdk::EventButton & event)
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class();

  if (orig->button_press_event)
    return (* orig->button_press_event) (gtk_widget (),
                                         event.gdk_event_button());
  else
    return false;
}

bool
Inti::Gtk::Widget::button_release_event_impl (const Gdk::EventButton & event)
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class();

  if (orig->button_release_event)
    return (* orig->button_release_event) (gtk_widget (),
                                           event.gdk_event_button());
  else
    return false;
}

bool
Inti::Gtk::Widget::scroll_event_impl (const Gdk::EventScroll & event)
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class();

  if (orig->scroll_event)
    return (* orig->scroll_event) (gtk_widget (),
                                   event.gdk_event_scroll());
  else
    return false;
}

bool
Inti::Gtk::Widget::motion_notify_event_impl (const Gdk::EventMotion & event)
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class();

  if (orig->motion_notify_event)
    return (* orig->motion_notify_event) (gtk_widget (),
                                          event.gdk_event_motion());
  else
    return false;
}

bool
Inti::Gtk::Widget::delete_event_impl (const Gdk::Event & event)
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class();

  if (orig->delete_event)
    return (* orig->delete_event) (gtk_widget (),
                                   event.gdk_event_any());
  else
    return false;
}

bool
Inti::Gtk::Widget::expose_event_impl (const Gdk::EventExpose & event)
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class ();

  if (orig->expose_event)
    return (* orig->expose_event) (gtk_widget (),
                                   event.gdk_event_expose ());
  else
    return false;
}

bool
Inti::Gtk::Widget::key_press_event_impl (const Gdk::EventKey & event)
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class ();

  if (orig->key_press_event)
    return (* orig->key_press_event) (gtk_widget (),
                                      event.gdk_event_key ());
  else
    return false;
}

bool
Inti::Gtk::Widget::key_release_event_impl (const Gdk::EventKey & event)
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class ();

  if (orig->key_release_event)
    return (* orig->key_release_event) (gtk_widget (),
                                        event.gdk_event_key ());
  else
    return false;
}

bool
Inti::Gtk::Widget::enter_notify_event_impl (const Gdk::EventCrossing & event)
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class ();

  if (orig->enter_notify_event)
    return (* orig->enter_notify_event) (gtk_widget (),
                                         event.gdk_event_crossing ());
  else
    return false;
}

bool
Inti::Gtk::Widget::leave_notify_event_impl (const Gdk::EventCrossing & event)
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class ();

  if (orig->leave_notify_event)
    return (* orig->leave_notify_event) (gtk_widget (),
                                         event.gdk_event_crossing ());
  else
    return false;
}

bool
Inti::Gtk::Widget::configure_event_impl (const Gdk::EventConfigure & event)
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class ();

  if (orig->configure_event)
    return (* orig->configure_event) (gtk_widget (),
                                      event.gdk_event_configure ());
  else
    return false;
}

bool
Inti::Gtk::Widget::focus_in_event_impl (const Gdk::EventFocus & event)
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class ();

  if (orig->focus_in_event)
    return (* orig->focus_in_event) (gtk_widget (),
                                     event.gdk_event_focus ());
  else
    return false;
}

bool
Inti::Gtk::Widget::focus_out_event_impl (const Gdk::EventFocus & event)
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class ();

  if (orig->focus_out_event)
    return (* orig->focus_out_event) (gtk_widget (),
                                      event.gdk_event_focus ());
  else
    return false;
}

bool
Inti::Gtk::Widget::map_event_impl (const Gdk::Event & event)
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class ();

  if (orig->map_event)
    return (* orig->map_event) (gtk_widget (),
                                event.gdk_event_any ());
  else
    return false;
}

bool
Inti::Gtk::Widget::unmap_event_impl (const Gdk::Event & event)
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class ();

  if (orig->unmap_event)
    return (* orig->unmap_event) (gtk_widget (),
                                  event.gdk_event_any ());
  else
    return false;
}

bool
Inti::Gtk::Widget::property_notify_event_impl (const Gdk::EventProperty & event)
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class ();

  if (orig->property_notify_event)
    return (* orig->property_notify_event) (gtk_widget (),
                                            event.gdk_event_property ());
  else
    return false;
}

bool
Inti::Gtk::Widget::selection_clear_event_impl (const Gdk::EventSelection & event)
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class ();

  if (orig->selection_clear_event)
    return (* orig->selection_clear_event) (gtk_widget (),
                                            event.gdk_event_selection ());
  else
    return false;
}

bool
Inti::Gtk::Widget::selection_request_event_impl (const Gdk::EventSelection & event)
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class ();

  if (orig->selection_request_event)
    return (* orig->selection_request_event) (gtk_widget (),
                                              event.gdk_event_selection ());
  else
    return false;
}

bool
Inti::Gtk::Widget::selection_notify_event_impl (const Gdk::EventSelection & event)
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class ();

  if (orig->selection_notify_event)
    return (* orig->selection_notify_event) (gtk_widget (),
                                             event.gdk_event_selection ());
  else
    return false;
}

bool
Inti::Gtk::Widget::proximity_in_event_impl (const Gdk::EventProximity & event)
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class ();

  if (orig->proximity_in_event)
    return (* orig->proximity_in_event) (gtk_widget (),
                                         event.gdk_event_proximity ());
  else
    return false;
}

bool
Inti::Gtk::Widget::proximity_out_event_impl (const Gdk::EventProximity & event)
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class ();

  if (orig->proximity_out_event)
    return (* orig->proximity_out_event) (gtk_widget (),
                                          event.gdk_event_proximity ());
  else
    return false;
}

bool
Inti::Gtk::Widget::visibility_notify_event_impl (const Gdk::EventVisibility & event)
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class ();

  if (orig->visibility_notify_event)
    return (* orig->visibility_notify_event) (gtk_widget (),
                                              event.gdk_event_visibility ());
  else
    return false;
}

bool
Inti::Gtk::Widget::client_event_impl (const Gdk::EventClient & event)
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class ();

  if (orig->client_event)
    return (* orig->client_event) (gtk_widget (),
                                   event.gdk_event_client ());
  else
    return false;
}

bool
Inti::Gtk::Widget::no_expose_event_impl (const Gdk::Event & event)
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class ();

  if (orig->no_expose_event)
    return (* orig->no_expose_event) (gtk_widget (),
                                      event.gdk_event_any ());
  else
    return false;
}

void
Inti::Gtk::Widget::selection_get_impl (Gtk::SelectionData * data,
                                          unsigned int info,
                                          unsigned int time)
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class ();
  
  if (orig->selection_get)
    (* orig->selection_get) (gtk_widget (),
                             data->gtk_selection_data (),
                             info, time);
}

void
Inti::Gtk::Widget::selection_received_impl (const Gtk::SelectionData & data,
                                               unsigned int time)
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class ();
  
  if (orig->selection_received)
    (* orig->selection_received) (gtk_widget (),
                                  data.gtk_selection_data (),
                                  time);
}

void
Inti::Gtk::Widget::drag_begin_impl (Gtk::DragContext * context)
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class ();

  if (orig->drag_begin)
    (* orig->drag_begin) (gtk_widget (), context->gdk_drag_context ());
}

void
Inti::Gtk::Widget::drag_end_impl (Gtk::DragContext * context)
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class ();

  if (orig->drag_end)
    (* orig->drag_end) (gtk_widget (), context->gdk_drag_context ());
}

void
Inti::Gtk::Widget::drag_data_get_impl (Gtk::DragContext * context,
                                          Gtk::SelectionData * data,
                                          unsigned int info,
                                          unsigned int time)
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class ();

  if (orig->drag_data_get)
    (* orig->drag_data_get) (gtk_widget (), context->gdk_drag_context (),
                             data->gtk_selection_data (),
                             info, time);
}

void
Inti::Gtk::Widget::drag_data_delete_impl (Gtk::DragContext * context)
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class ();

  if (orig->drag_data_delete)
    (* orig->drag_data_delete) (gtk_widget (), context->gdk_drag_context ());
}

void
Inti::Gtk::Widget::drag_leave_impl (Gtk::DragContext * context,
                                       unsigned int time)
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class ();

  if (orig->drag_leave)
    (* orig->drag_leave) (gtk_widget (), context->gdk_drag_context (),
                          time);
}

bool
Inti::Gtk::Widget::drag_motion_impl (Gtk::DragContext * context,
                                        int x,
                                        int y,
                                        unsigned int time)
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class ();

  if (orig->drag_motion)
    return (* orig->drag_motion) (gtk_widget (), context->gdk_drag_context (),
                                  x, y, time);
  else
    return false;
}

bool
Inti::Gtk::Widget::drag_drop_impl (Gtk::DragContext * context,
                                      int x, int y,
                                      unsigned int time)
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class ();

  if (orig->drag_drop)
    return (* orig->drag_drop) (gtk_widget (), context->gdk_drag_context (),
                                x, y, time);
  else
    return false;
}

void
Inti::Gtk::Widget::drag_data_received_impl (Gtk::DragContext * context,
                                               int x, int y,
                                               const Gtk::SelectionData & sel_data,
                                               unsigned int info,
                                               unsigned int time)
{
  GtkWidgetClass * orig =
    (GtkWidgetClass *) original_class ();

  if (orig->drag_data_received)
    (* orig->drag_data_received) (gtk_widget (), context->gdk_drag_context (),
                                  x, y, sel_data.gtk_selection_data (),
                                  info, time);
}


///////////

void
Inti::Gtk::Widget::on_destroy ()
{
  // nothing
}

void
Inti::Gtk::Widget::on_show ()
{
  // nothing
}

void
Inti::Gtk::Widget::on_hide ()
{
  // nothing
}

void
Inti::Gtk::Widget::on_realize ()
{
  // nothing
}

void
Inti::Gtk::Widget::on_unrealize ()
{
  // nothing
}

void
Inti::Gtk::Widget::on_draw (const Gdk::Rectangle & area)
{
  // nothing
}

void
Inti::Gtk::Widget::on_draw_focus ()
{
  // nothing
}

void
Inti::Gtk::Widget::on_draw_default ()
{
  // nothing
}

void
Inti::Gtk::Widget::on_size_request (Requisition * requisition)
{
  // nothing
}

void
Inti::Gtk::Widget::on_size_allocate (const Allocation & allocation)
{
  // nothing
}


void
Inti::Gtk::Widget::on_state_changed (StateType previous_state)
{
  // nothing
}

void
Inti::Gtk::Widget::on_parent_set (Widget * parent)
{
  // nothing
}

void
Inti::Gtk::Widget::on_style_set (Style * previous)
{
  // nothing
}

void
Inti::Gtk::Widget::on_grab_focus ()
{
  // nothing
}

bool
Inti::Gtk::Widget::on_event (const Gdk::Event & event)
{
  // nothing
  return false;
}

bool
Inti::Gtk::Widget::on_button_press_event (const Gdk::EventButton & event)
{
  // nothing
  return false;
}

bool
Inti::Gtk::Widget::on_button_release_event (const Gdk::EventButton & event)
{
  // nothing
  return false;
}

bool
Inti::Gtk::Widget::on_scroll_event (const Gdk::EventScroll & event)
{
  // nothing
  return false;
}

bool
Inti::Gtk::Widget::on_motion_notify_event (const Gdk::EventMotion & event)
{
  // nothing
  return false;
}

bool
Inti::Gtk::Widget::on_delete_event (const Gdk::Event & event)
{
  // nothing
  return false;
}

bool
Inti::Gtk::Widget::on_expose_event (const Gdk::EventExpose & event)
{
  // nothing
  return false;
}

bool
Inti::Gtk::Widget::on_key_press_event (const Gdk::EventKey & event)
{
  // nothing
  return false;
}

bool
Inti::Gtk::Widget::on_key_release_event (const Gdk::EventKey & event)
{
  // nothing
  return false;
}

bool
Inti::Gtk::Widget::on_enter_notify_event (const Gdk::EventCrossing & event)
{
  // nothing
  return false;
}

bool
Inti::Gtk::Widget::on_leave_notify_event (const Gdk::EventCrossing & event)
{
  // nothing
  return false;
}

bool
Inti::Gtk::Widget::on_configure_event (const Gdk::EventConfigure & event)
{
  // nothing
  return false;
}

bool
Inti::Gtk::Widget::on_focus_in_event (const Gdk::EventFocus & event)
{
  // nothing
  return false;
}

bool
Inti::Gtk::Widget::on_focus_out_event (const Gdk::EventFocus & event)
{
  // nothing
  return false;
}

bool
Inti::Gtk::Widget::on_map_event (const Gdk::Event & event)
{
  // nothing
  return false;
}

bool
Inti::Gtk::Widget::on_unmap_event (const Gdk::Event & event)
{
  // nothing
  return false;
}

bool
Inti::Gtk::Widget::on_property_notify_event (const Gdk::EventProperty & event)
{
  // nothing
  return false;
}

bool
Inti::Gtk::Widget::on_selection_clear_event (const Gdk::EventSelection & event)
{
  // nothing
  return false;
}

bool
Inti::Gtk::Widget::on_selection_request_event (const Gdk::EventSelection & event)
{
  // nothing
  return false;
}

bool
Inti::Gtk::Widget::on_selection_notify_event (const Gdk::EventSelection & event)
{
  // nothing
  return false;
}

bool
Inti::Gtk::Widget::on_proximity_in_event (const Gdk::EventProximity & event)
{
  // nothing
  return false;
}

bool
Inti::Gtk::Widget::on_proximity_out_event (const Gdk::EventProximity & event)
{
  // nothing
  return false;
}

bool
Inti::Gtk::Widget::on_visibility_notify_event (const Gdk::EventVisibility & event)
{
  // nothing
  return false;
}

bool
Inti::Gtk::Widget::on_client_event (const Gdk::EventClient & event)
{
  // nothing
  return false;
}

bool
Inti::Gtk::Widget::on_no_expose_event (const Gdk::Event & event)
{
  // nothing
  return false;
}

void
Inti::Gtk::Widget::on_selection_get (Gtk::SelectionData * data,
                                        unsigned int info,
                                        unsigned int time)
{
  // nothing
}

void
Inti::Gtk::Widget::on_selection_received (const Gtk::SelectionData & data,
                                             unsigned int time)
{
  // nothing
}

void
Inti::Gtk::Widget::on_drag_begin (Gtk::DragContext * context)
{
  // nothing
}

void
Inti::Gtk::Widget::on_drag_end (Gtk::DragContext * context)
{
  // nothing
}

void
Inti::Gtk::Widget::on_drag_data_get (Gtk::DragContext * context,
                                        Gtk::SelectionData * data,
                                        unsigned int info,
                                        unsigned int time)
{
  // nothing
}

void
Inti::Gtk::Widget::on_drag_data_delete (Gtk::DragContext * context)
{
  // nothing
}

void
Inti::Gtk::Widget::on_drag_leave (Gtk::DragContext * context,
                                     unsigned int time)
{
  // nothing
}

bool
Inti::Gtk::Widget::on_drag_motion (Gtk::DragContext * context,
                                      int x,
                                      int y,
                                      unsigned int time)
{
  // nothing
  return false;
}

bool
Inti::Gtk::Widget::on_drag_drop (Gtk::DragContext * context,
                                    int x, int y,
                                    unsigned int time)
{
  // nothing
  return false;
}

void
Inti::Gtk::Widget::on_drag_data_received (Gtk::DragContext * context,
                                             int x, int y,
                                             const Gtk::SelectionData & sel_data,
                                             unsigned int info,
                                             unsigned int time)
{
  // nothing  
}

/////////// Everything below here is machine-generated
void
Inti::Gtk::Widget::show ()
{
   gtk_widget_show (gtk_widget ());
}
void
Inti::Gtk::Widget::show_now ()
{
   gtk_widget_show_now (gtk_widget ());
}
void
Inti::Gtk::Widget::show_all ()
{
   gtk_widget_show_all (gtk_widget ());
}
void
Inti::Gtk::Widget::hide ()
{
   gtk_widget_hide (gtk_widget ());
}
void
Inti::Gtk::Widget::hide_all ()
{
   gtk_widget_hide_all (gtk_widget ());
}
void
Inti::Gtk::Widget::realize ()
{
   gtk_widget_realize (gtk_widget ());
}
void
Inti::Gtk::Widget::unrealize ()
{
   gtk_widget_unrealize (gtk_widget ());
}
void
Inti::Gtk::Widget::queue_draw ()
{
   gtk_widget_queue_draw (gtk_widget ());
}
void
Inti::Gtk::Widget::queue_draw_area (int x, int y, int width, int height)
{
   gtk_widget_queue_draw_area (gtk_widget (), x, y, width, height);
}
void
Inti::Gtk::Widget::queue_clear ()
{
   gtk_widget_queue_clear (gtk_widget ());
}
void
Inti::Gtk::Widget::queue_clear_area (int x, int y, int width, int height)
{
   gtk_widget_queue_clear_area (gtk_widget (), x, y, width, height);
}
void
Inti::Gtk::Widget::queue_resize ()
{
   gtk_widget_queue_resize (gtk_widget ());
}
void
Inti::Gtk::Widget::draw (const Inti::Gdk::Rectangle& area)
{
   gtk_widget_draw (gtk_widget (), area.gdk_rectangle ());
}
void
Inti::Gtk::Widget::draw_focus ()
{
   gtk_widget_draw_focus (gtk_widget ());
}
void
Inti::Gtk::Widget::draw_default ()
{
   gtk_widget_draw_default (gtk_widget ());
}
void
Inti::Gtk::Widget::size_request (const Inti::Gtk::Requisition& requisition)
{
   gtk_widget_size_request (gtk_widget (), requisition.gtk_requisition ());
}
void
Inti::Gtk::Widget::size_allocate (const Inti::Gtk::Allocation& allocation)
{
   gtk_widget_size_allocate (gtk_widget (), allocation.gtk_allocation ());
}
void
Inti::Gtk::Widget::get_child_requisition (const Inti::Gtk::Requisition& requisition)
{
   gtk_widget_get_child_requisition (gtk_widget (), requisition.gtk_requisition ());
}
void
Inti::Gtk::Widget::popup (int x, int y)
{
   gtk_widget_popup (gtk_widget (), x, y);
}
void
Inti::Gtk::Widget::grab_focus ()
{
   gtk_widget_grab_focus (gtk_widget ());
}
void
Inti::Gtk::Widget::grab_default ()
{
   gtk_widget_grab_default (gtk_widget ());
}
void
Inti::Gtk::Widget::set_name (const ustring& name)
{
   gtk_widget_set_name (gtk_widget (), name.c_str ());
}
void
Inti::Gtk::Widget::set_state (Gtk::StateType state)
{
   gtk_widget_set_state (gtk_widget (), (GtkStateType) state);
}
void
Inti::Gtk::Widget::set_sensitive (bool sensitive)
{
   gtk_widget_set_sensitive (gtk_widget (), sensitive);
}
void
Inti::Gtk::Widget::set_app_paintable (bool app_paintable)
{
   gtk_widget_set_app_paintable (gtk_widget (), app_paintable);
}
void
Inti::Gtk::Widget::set_uposition (int x, int y)
{
   gtk_widget_set_uposition (gtk_widget (), x, y);
}
void
Inti::Gtk::Widget::set_usize (int width, int height)
{
   gtk_widget_set_usize (gtk_widget (), width, height);
}
const Inti::Gtk::Widget::ShowSignalType
Inti::Gtk::Widget::show_signal ("show", (Private::SignalFunc)Private::slot0_void_callback);

const Inti::Gtk::Widget::HideSignalType
Inti::Gtk::Widget::hide_signal ("hide", (Private::SignalFunc)Private::slot0_void_callback);

const Inti::Gtk::Widget::RealizeSignalType
Inti::Gtk::Widget::realize_signal ("realize", (Private::SignalFunc)Private::slot0_void_callback);

const Inti::Gtk::Widget::UnrealizeSignalType
Inti::Gtk::Widget::unrealize_signal ("unrealize", (Private::SignalFunc)Private::slot0_void_callback);

const Inti::Gtk::Widget::DrawSignalType
Inti::Gtk::Widget::draw_signal ("draw", (Private::SignalFunc)Private::slot1_void_rectangle_callback);

const Inti::Gtk::Widget::DrawFocusSignalType
Inti::Gtk::Widget::draw_focus_signal ("draw_focus", (Private::SignalFunc)Private::slot0_void_callback);

const Inti::Gtk::Widget::DrawDefaultSignalType
Inti::Gtk::Widget::draw_default_signal ("draw_default", (Private::SignalFunc)Private::slot0_void_callback);

const Inti::Gtk::Widget::SizeRequestSignalType
Inti::Gtk::Widget::size_request_signal ("size_request", (Private::SignalFunc)Private::slot1_void_requisitionptr_callback);

const Inti::Gtk::Widget::SizeAllocateSignalType
Inti::Gtk::Widget::size_allocate_signal ("size_allocate", (Private::SignalFunc)Private::slot1_void_allocation_callback);

const Inti::Gtk::Widget::StateChangedSignalType
Inti::Gtk::Widget::state_changed_signal ("state_changed", (Private::SignalFunc)Private::slot1_void_statetype_callback);

const Inti::Gtk::Widget::ParentSetSignalType
Inti::Gtk::Widget::parent_set_signal ("parent_set", (Private::SignalFunc)Private::slot1_void_widget_callback);

const Inti::Gtk::Widget::StyleSetSignalType
Inti::Gtk::Widget::style_set_signal ("style_set", (Private::SignalFunc)Private::slot1_void_style_callback);

const Inti::Gtk::Widget::GrabFocusSignalType
Inti::Gtk::Widget::grab_focus_signal ("grab_focus", (Private::SignalFunc)Private::slot0_void_callback);

const Inti::Gtk::Widget::EventSignalType
Inti::Gtk::Widget::event_signal ("event", (Private::SignalFunc)Private::slot1_bool_event_callback);

const Inti::Gtk::Widget::ButtonPressEventSignalType
Inti::Gtk::Widget::button_press_event_signal ("button_press_event", (Private::SignalFunc)Private::slot1_bool_buttonevent_callback);

const Inti::Gtk::Widget::ButtonReleaseEventSignalType
Inti::Gtk::Widget::button_release_event_signal ("button_release_event", (Private::SignalFunc)Private::slot1_bool_buttonevent_callback);

const Inti::Gtk::Widget::ScrollEventSignalType
Inti::Gtk::Widget::scroll_event_signal ("scroll_event", (Private::SignalFunc)Private::slot1_bool_scrollevent_callback);

const Inti::Gtk::Widget::MotionNotifyEventSignalType
Inti::Gtk::Widget::motion_notify_event_signal ("motion_notify_event", (Private::SignalFunc)Private::slot1_bool_motionevent_callback);

const Inti::Gtk::Widget::DeleteEventSignalType
Inti::Gtk::Widget::delete_event_signal ("delete_event", (Private::SignalFunc)Private::slot1_bool_event_callback);

const Inti::Gtk::Widget::ExposeEventSignalType
Inti::Gtk::Widget::expose_event_signal ("expose_event", (Private::SignalFunc)Private::slot1_bool_exposeevent_callback);

const Inti::Gtk::Widget::KeyPressEventSignalType
Inti::Gtk::Widget::key_press_event_signal ("key_press_event", (Private::SignalFunc)Private::slot1_bool_keyevent_callback);

const Inti::Gtk::Widget::KeyReleaseEventSignalType
Inti::Gtk::Widget::key_release_event_signal ("key_release_event", (Private::SignalFunc)Private::slot1_bool_keyevent_callback);

const Inti::Gtk::Widget::EnterNotifyEventSignalType
Inti::Gtk::Widget::enter_notify_event_signal ("enter_notify_event", (Private::SignalFunc)Private::slot1_bool_crossingevent_callback);

const Inti::Gtk::Widget::LeaveNotifyEventSignalType
Inti::Gtk::Widget::leave_notify_event_signal ("leave_notify_event", (Private::SignalFunc)Private::slot1_bool_crossingevent_callback);

const Inti::Gtk::Widget::ConfigureEventSignalType
Inti::Gtk::Widget::configure_event_signal ("configure_event", (Private::SignalFunc)Private::slot1_bool_configureevent_callback);

const Inti::Gtk::Widget::FocusInEventSignalType
Inti::Gtk::Widget::focus_in_event_signal ("focus_in_event", (Private::SignalFunc)Private::slot1_bool_focusevent_callback);

const Inti::Gtk::Widget::FocusOutEventSignalType
Inti::Gtk::Widget::focus_out_event_signal ("focus_out_event", (Private::SignalFunc)Private::slot1_bool_focusevent_callback);

const Inti::Gtk::Widget::MapEventSignalType
Inti::Gtk::Widget::map_event_signal ("map_event", (Private::SignalFunc)Private::slot1_bool_event_callback);

const Inti::Gtk::Widget::UnmapEventSignalType
Inti::Gtk::Widget::unmap_event_signal ("unmap_event", (Private::SignalFunc)Private::slot1_bool_event_callback);

const Inti::Gtk::Widget::PropertyNotifyEventSignalType
Inti::Gtk::Widget::property_notify_event_signal ("property_notify_event", (Private::SignalFunc)Private::slot1_bool_propertyevent_callback);

const Inti::Gtk::Widget::SelectionClearEventSignalType
Inti::Gtk::Widget::selection_clear_event_signal ("selection_clear_event", (Private::SignalFunc)Private::slot1_bool_selectionevent_callback);

const Inti::Gtk::Widget::SelectionRequestEventSignalType
Inti::Gtk::Widget::selection_request_event_signal ("selection_request_event", (Private::SignalFunc)Private::slot1_bool_selectionevent_callback);

const Inti::Gtk::Widget::SelectionNotifyEventSignalType
Inti::Gtk::Widget::selection_notify_event_signal ("selection_notify_event", (Private::SignalFunc)Private::slot1_bool_selectionevent_callback);

const Inti::Gtk::Widget::ProximityInEventSignalType
Inti::Gtk::Widget::proximity_in_event_signal ("proximity_in_event", (Private::SignalFunc)Private::slot1_bool_proximityevent_callback);

const Inti::Gtk::Widget::ProximityOutEventSignalType
Inti::Gtk::Widget::proximity_out_event_signal ("proximity_out_event", (Private::SignalFunc)Private::slot1_bool_proximityevent_callback);

const Inti::Gtk::Widget::VisibilityNotifyEventSignalType
Inti::Gtk::Widget::visibility_notify_event_signal ("visibility_notify_event", (Private::SignalFunc)Private::slot1_bool_visibilityevent_callback);

const Inti::Gtk::Widget::ClientEventSignalType
Inti::Gtk::Widget::client_event_signal ("client_event", (Private::SignalFunc)Private::slot1_bool_clientevent_callback);

const Inti::Gtk::Widget::NoExposeEventSignalType
Inti::Gtk::Widget::no_expose_event_signal ("no_expose_event", (Private::SignalFunc)Private::slot1_bool_event_callback);

const Inti::Gtk::Widget::SelectionGetSignalType
Inti::Gtk::Widget::selection_get_signal ("selection_get", (Private::SignalFunc)Private::slot3_void_selectiondata_uint_uint_callback);

const Inti::Gtk::Widget::SelectionReceivedSignalType
Inti::Gtk::Widget::selection_received_signal ("selection_received", (Private::SignalFunc)Private::slot2_void_constselectiondata_uint_callback);

const Inti::Gtk::Widget::DragBeginSignalType
Inti::Gtk::Widget::drag_begin_signal ("drag_begin", (Private::SignalFunc)Private::slot1_void_dragcontext_callback);

const Inti::Gtk::Widget::DragEndSignalType
Inti::Gtk::Widget::drag_end_signal ("drag_end", (Private::SignalFunc)Private::slot1_void_dragcontext_callback);

const Inti::Gtk::Widget::DragDataGetSignalType
Inti::Gtk::Widget::drag_data_get_signal ("drag_data_get", (Private::SignalFunc)Private::slot4_void_dragcontext_selectiondata_uint_uint_callback);

const Inti::Gtk::Widget::DragDataDeleteSignalType
Inti::Gtk::Widget::drag_data_delete_signal ("drag_data_delete", (Private::SignalFunc)Private::slot1_void_dragcontext_callback);

const Inti::Gtk::Widget::DragLeaveSignalType
Inti::Gtk::Widget::drag_leave_signal ("drag_leave", (Private::SignalFunc)Private::slot2_void_dragcontext_uint_callback);

const Inti::Gtk::Widget::DragMotionSignalType
Inti::Gtk::Widget::drag_motion_signal ("drag_motion", (Private::SignalFunc)Private::slot4_bool_dragcontext_int_int_uint_callback);

const Inti::Gtk::Widget::DragDropSignalType
Inti::Gtk::Widget::drag_drop_signal ("drag_drop", (Private::SignalFunc)Private::slot4_bool_dragcontext_int_int_uint_callback);

const Inti::Gtk::Widget::DragDataReceivedSignalType
Inti::Gtk::Widget::drag_data_received_signal ("drag_data_received", (Private::SignalFunc)Private::slot6_void_dragcontext_int_int_selectiondata_uint_uint_callback);

void
Inti::Gtk::Widget::map ()
{
   gtk_widget_map (gtk_widget ());
}
void
Inti::Gtk::Widget::unmap ()
{
   gtk_widget_unmap (gtk_widget ());
}
