// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_GTK_TEXTBUFFER_H_
#define _INTI_GTK_TEXTBUFFER_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/object.h>
#include <inti/utf-string.h>
#include <inti/gtk/gtk-signals.h>
#include <gtk/gtktextbuffer.h>
#include <vector>

namespace Inti
{
  namespace Gdk
  {
    class Pixbuf;
  }
  
  namespace Gtk
  {
    class TextTag;
    class TextMark;
    class TextBuffer;
    class TagTable;
    
    namespace Private
    {
      class TextBufferClass;
    };
      
    class TextIterator : private GtkTextIter
    {
    private:
      typedef GtkTextIter Base;

    public:
      typedef random_access_iterator_tag iterator_category;
      typedef const gunichar value_type;
      typedef int difference_type;
      typedef const gunichar * pointer;
      typedef const gunichar & reference;
        
      GtkTextIter *gtk_text_iter () { return (GtkTextIter*) this; }
      const GtkTextIter *gtk_text_iter () const { (const GtkTextIter*) this; }
        
      explicit TextIterator (const GtkTextIter *src)
        : Base (*src) {}
        
      TextIterator () {}

      // using default copy and assignment      
        
      gunichar operator* () const;
      
      TextBuffer * buffer () const;
        
      int offset () const;
      int line () const;
      int line_offset () const;
      int line_index () const;

      bool at_pixbuf () const;
      const Gdk::Pixbuf * pixbuf () const;

      vector<TextMark*> marks () const;
        
      vector<TextTag*> toggled_tags (bool toggled_on) const;

      bool begins_tag (const TextTag * tag) const;
      bool ends_tag (const TextTag * tag) const;
      bool toggles_tag (const TextTag * tag) const;
      bool has_tag (const TextTag * tag) const;
      vector<TextTag*> tags () const;

      bool editable (bool default_setting) const;
      
      bool starts_line () const;
      bool ends_line () const;

      int chars_in_line () const;

      // FIXME get_attributes ()

      bool is_last () const;
      bool is_first () const;
      
      TextIterator & operator+= (int chars);
      TextIterator operator+ (int chars);
      TextIterator & operator-= (int chars);
      TextIterator operator- (int chars);
      TextIterator & operator++ ();
      TextIterator operator++ (int postfix);
      TextIterator & operator-- ();
      TextIterator operator-- (int postfix);        

      bool forward_char ();
      bool backward_char ();
      bool forward_chars (int chars);
      bool backward_chars (int chars);
      bool forward_line ();
      bool backward_line ();
      bool forward_lines (int lines);
      bool backward_lines (int lines);
      bool forward_word_ends (int words);
      bool backward_word_starts (int words);
        
      void set_offset (int offset);
      void set_line (int line);
      void set_line_offset (int offset);
      void set_line_index (int index);

      void forward_to_newline ();
      void forward_to_end ();

      bool forward_to_tag_toggle (const TextTag * tag);
      bool backward_to_tag_toggle (const TextTag * tag);

      bool forward_find_char (Slot1<bool,gunichar> * predicate);
      bool backward_find_char (Slot1<bool,gunichar> * predicate);
      bool forward_find_char (Slot1<bool,gunichar> * predicate,
                              const TextIterator & limit);
      bool backward_find_char (Slot1<bool,gunichar> * predicate,
                               const TextIterator & limit);

      bool forward_search (const char * str);
      bool backward_search (const char * str);

      bool forward_search (const char * str,
                           const TextIterator & limit);
      bool backward_search (const char * str,
                            const TextIterator & limit);
      
      bool forward_search (const char * str,                  
                           bool visible_only,
                           bool slice,
                           TextIterator *match_start,
                           TextIterator *match_end);

      bool backward_search (const char * str,
                            bool visible_only,
                            bool slice,
                            TextIterator * match_start,
                            TextIterator * match_end);

      bool forward_search (const char * str,                  
                           bool visible_only,
                           bool slice,
                           TextIterator * match_start,
                           TextIterator * match_end,
                           const TextIterator & limit);

      bool backward_search (const char * str,
                            bool visible_only,
                            bool slice,
                            TextIterator * match_start,
                            TextIterator * match_end,
                            const TextIterator & limit);      

      bool forward_search (const ustring & str);
      bool backward_search (const ustring & str);

      bool forward_search (const ustring & str,
                           const TextIterator & limit);
      bool backward_search (const ustring & str,
                            const TextIterator & limit);
      
      bool forward_search (const ustring & str,                  
                           bool visible_only,
                           bool slice,
                           TextIterator *match_start,
                           TextIterator *match_end);

      bool backward_search (const ustring & str,
                            bool visible_only,
                            bool slice,
                            TextIterator * match_start,
                            TextIterator * match_end);

      bool forward_search (const ustring & str,                  
                           bool visible_only,
                           bool slice,
                           TextIterator * match_start,
                           TextIterator * match_end,
                           const TextIterator & limit);

      bool backward_search (const ustring & str,
                            bool visible_only,
                            bool slice,
                            TextIterator * match_start,
                            TextIterator * match_end,
                            const TextIterator & limit);
      
      bool operator!= (const TextIterator & rhs);
      bool operator== (const TextIterator & rhs);        
      bool operator< (const TextIterator & rhs);
      bool operator> (const TextIterator & rhs);
      bool operator<= (const TextIterator & rhs);
      bool operator>= (const TextIterator & rhs);

      bool in_range (const TextIterator & start,
                     const TextIterator & end) const;      
    };

    void reorder (TextIterator * first,
                  TextIterator * second);
    
    class TextBuffer : public Object
    {
    public:
        
      GtkTextBuffer * gtk_text_buffer () const
      {
        return (GtkTextBuffer*)g_object ();
      }
      
      TextBuffer ();

      ustring slice (const TextIterator & start,
                     const TextIterator & end,
                     bool include_hidden_chars = true) const;
      
      ustring text (const TextIterator & start,
                    const TextIterator & end,
                    bool include_hidden_chars = true) const;

      int line_count () const;
      int char_count () const;

      TagTable* tag_table ();
      const TagTable* tag_table () const;

      TextIterator insert (TextIterator *i, const char *text, int length = -1);
      TextIterator insert (TextIterator *i, const ustring & text);
      TextIterator insert (TextIterator *i, gunichar c);
      
      TextIterator insert (const TextIterator & i, const char *text, int length = -1);
      TextIterator insert (const TextIterator & i, const ustring & text);
      TextIterator insert (const TextIterator & i, gunichar c);
      
      TextIterator insert_at_cursor (const char *text, int length = -1);
      TextIterator insert_at_cursor (const ustring & text);
      TextIterator insert_at_cursor (gunichar c);

      TextIterator insert_interactive (TextIterator *i, bool default_editable, 
                                       const char *text, int length = -1);
      TextIterator insert_interactive (TextIterator *i,
                                       bool default_editable,
                                       const ustring & text);
      TextIterator insert_interactive (TextIterator *i,
                                       bool default_editable,
                                       gunichar c);
      
      TextIterator insert_interactive (const TextIterator & i,
                                       bool default_editable,
                                       const char *text, int length = -1);

      TextIterator insert_interactive (const TextIterator & i,
                                       bool default_editable,
                                       const ustring & text);

      TextIterator insert_interactive (const TextIterator & i,
                                       bool default_editable,
                                       gunichar c);
      
      
      TextIterator insert_interactive_at_cursor (bool default_editable,
                                                 const char *text,
                                                 int length = -1);
      TextIterator insert_interactive_at_cursor (bool default_editable,
                                                 const ustring & text);
      TextIterator insert_interactive_at_cursor (bool default_editable,
                                                 gunichar c);


      TextIterator insert_range (TextIterator * i,
                                 const TextIterator & start,
                                 const TextIterator & end);

      TextIterator insert_range_interactive (TextIterator * i,
                                             bool default_editable,
                                             const TextIterator & start,
                                             const TextIterator & end);
      
      ////// Erase
      
      TextIterator erase (TextIterator * start,
                          TextIterator * end);
      TextIterator erase (const TextIterator & start,
                          const TextIterator & end);
      TextIterator erase_interactive (TextIterator * start,
                                      TextIterator * end,
                                      bool default_editable);
      TextIterator erase_interactive (const TextIterator & start,
                                      const TextIterator & end,
                                      bool default_editable);


      // insert pixbufs

      // FIXME

      // Marks
      
      TextMark *create_mark (const char *mark_name,
                             const TextIterator & where,
                             bool left_gravity);

      TextMark *create_mark (const TextIterator & where,
                             bool left_gravity);
      
      void move_mark (TextMark *mark,
                      const TextIterator & where);

      void delete_mark (TextMark * mark);

      void move_mark (const char *mark_name,
                      const TextIterator & where);
      void delete_mark (const char *mark_name);
      
      TextMark *get_mark (const char * name) const;
      TextMark *get_mark (const ustring & name) const;

      TextMark *insert () const;
      TextMark *selection_bound () const;
      
      void place_cursor (const TextIterator & where);
      
      void apply_tag (TextTag *tag,
                      const TextIterator & start,
                      const TextIterator & end);
      void remove_tag (TextTag *tag,
                       const TextIterator & start,
                       const TextIterator & end);
      void apply_tag (const char *tag_name,
                      const TextIterator & start,
                      const TextIterator & end);
      void remove_tag (const char *tag_name,
                       const TextIterator & start,
                       const TextIterator & end);
      
      TextTag *create_tag ();
      TextTag *create_tag (const char *name);
      TextTag *create_tag (const ustring &name);

      TextIterator iter_at_mark (TextMark *mark);
      TextIterator iter_at_mark (const char *mark_name);
      TextIterator iter_at_line_offset (int line, int char_on_line);
      TextIterator iter_at_line_index (int line, int byte_on_line);
      TextIterator iter_at_line (int line);
      TextIterator iter_at_offset (int char_index);

      TextIterator begin ();
      TextIterator end ();

      void bounds (TextIterator *start,
                   TextIterator *end);
      
      vector<TextTag*> get_tags (const TextIterator & where);

      bool modified () const;
      void set_modified (bool setting);

      void paste_primary (TextIterator *override_location,
                          bool default_editable);

      void cut_clipboard (bool default_editable);
      void copy_clipboard ();
      void paste_clipboard (bool default_editable);

      void selection_bounds (TextIterator *start,
                             TextIterator *end);
      
      void erase_selection (bool interactive,
                            bool default_editable);
      
    protected:
      typedef WrapSignal0<void> ChangedSignalType;
      static const ChangedSignalType changed_signal;

    public:
      typedef SignalProxy<Object,ChangedSignalType> ChangedProxyType;
      const ChangedProxyType sig_changed ()
      {
        return ChangedProxyType (this, &changed_signal);
      }
    protected:
      typedef WrapSignal0<void> ModifiedChangedSignalType;
      static const ModifiedChangedSignalType modified_changed_signal;

    public:
      typedef SignalProxy<Object,ModifiedChangedSignalType> ModifiedChangedProxyType;
      const ModifiedChangedProxyType sig_modified_changed ()
      {
        return ModifiedChangedProxyType (this, &modified_changed_signal);
      }
    protected:
      typedef WrapSignal2<void,const TextIterator &,TextMark* > MarkSetSignalType;
      static const MarkSetSignalType mark_set_signal;

    public:
      typedef SignalProxy<Object,MarkSetSignalType> MarkSetProxyType;
      const MarkSetProxyType sig_mark_set ()
      {
        return MarkSetProxyType (this, &mark_set_signal);
      }
    protected:
      typedef WrapSignal1<void,TextMark* > MarkDeletedSignalType;
      static const MarkDeletedSignalType mark_deleted_signal;

    public:
      typedef SignalProxy<Object,MarkDeletedSignalType> MarkDeletedProxyType;
      const MarkDeletedProxyType sig_mark_deleted ()
      {
        return MarkDeletedProxyType (this, &mark_deleted_signal);
      }
    protected:
      typedef WrapSignal3<void,TextTag* ,const TextIterator &,const TextIterator&> ApplyTagSignalType;
      static const ApplyTagSignalType apply_tag_signal;

    public:
      typedef SignalProxy<Object,ApplyTagSignalType> ApplyTagProxyType;
      const ApplyTagProxyType sig_apply_tag ()
      {
        return ApplyTagProxyType (this, &apply_tag_signal);
      }
    protected:
      typedef WrapSignal3<void,TextTag* ,const TextIterator&,const TextIterator&> RemoveTagSignalType;
      static const RemoveTagSignalType remove_tag_signal;

    public:
      typedef SignalProxy<Object,RemoveTagSignalType> RemoveTagProxyType;
      const RemoveTagProxyType sig_remove_tag ()
      {
        return RemoveTagProxyType (this, &remove_tag_signal);
      }
      
      // FIXME wrap insert_text, delete_text as virtual funcs only
      
    protected:
      friend class Private::TextBufferClass;
      
      TextBuffer (GtkTextBuffer *src, GtkTextBufferClass * orig);
      virtual ~TextBuffer ();
      
    private:
      TextBuffer(const TextBuffer&);
      TextBuffer& operator=(const TextBuffer&);
      
    }; // class TextBuffer

  }; // namespace Gtk
  
}; // namespace Inti

#endif // _INTI_GTK_TEXTBUFFER_H_
