// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_GTK_TABLE_H_
#define _INTI_GTK_TABLE_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/gtk/container.h>
#include <gtk/gtktable.h>

/*$ doc header
  $short The #Inti::Gtk::Table abstract base class
  $*/

namespace Inti
{  
  namespace Gtk
  {
    namespace Private
    {
      class TableClass;
    };
    
    class Table : public Container
    {
    public:
      /*$ doc class Table
        $short Layout container that arranges objects in a grid

        $copy none
        $memory floating
        
        $long

        <para>

        </para>

        <para>

        </para>
        
        $*/
        
      GtkTable * gtk_table () const
      {
        return (GtkTable*)g_object ();
      }
      
      /*$ doc constructor
        $short Construct a new Table
        $long

        <para>

        </para>
        
        $*/
      Table (unsigned int rows,
             unsigned int columns,
             bool homogeneous = false);

      void resize (unsigned int rows, unsigned int columns);

      void attach (Widget * child,
                   unsigned int left_attach,
                   unsigned int right_attach,
                   unsigned int top_attach,
                   unsigned int bottom_attach,
                   AttachOptionsField x_options,
                   AttachOptionsField y_options,
                   unsigned int x_padding = 0,
                   unsigned int y_padding = 0);
      
      // attach_defaults omitted on purpose
      
      void set_row_spacing (unsigned int row,
                            unsigned int spacing);

      void set_column_spacing (unsigned int column,
                               unsigned int spacing);

      void set_row_spacings (unsigned int spacing);
      void set_column_spacings (unsigned int spacing);

      void set_homogeneous (bool setting);

      unsigned int row_spacings () const;
      unsigned int column_spacings () const;
      unsigned int row_spacing (unsigned int row) const;
      unsigned int column_spacing (unsigned int column) const;
      bool homogeneous () const;
      
    protected:
      friend class Private::TableClass;
      
      explicit Table (GtkTable *src, GtkTableClass * orig);
      virtual ~Table ();
      
    private:
      Table(const Table&);
      Table& operator=(const Table&);
      
    }; // class Table

  }; // namespace Gtk
  
}; // namespace Inti

#endif // _INTI_GTK_TABLE_H_
