// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_GTK_NOTEBOOK_H_
#define _INTI_GTK_NOTEBOOK_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/gtk/container.h>
#include <inti/gtk/gtkbase.h>
#include <gtk/gtknotebook.h>
#include <string>

/*$ doc header
  $short FIXME
  $*/

namespace Inti
{
  namespace Gtk
  {
    namespace Private
    {
      class NotebookClass;

      extern "C" void slot2_notebook_callback (GtkNotebook * notebook,
                                               GtkNotebookPage * page,
                                               unsigned int page_num,
                                               gpointer data);
    };

    class Notebook : public Container
    {
    public:
      /*$ doc class Notebook
        $short FIXME

        $copy none
        $memory floating

        $long

        <para>

        </para>

        $*/

      GtkNotebook * gtk_notebook () const
      {
        return (GtkNotebook*)g_object ();
      }

      /*$ doc constructor
        $short Construct a new Notebook
        $long

        <para>

        </para>

        $*/
      Notebook ();

    protected:
      typedef WrapSignal2<void,int,Widget * > SwitchPageSignalType;
      static const SwitchPageSignalType switch_page_signal;

    public:
      typedef SignalProxy<Object,SwitchPageSignalType> SwitchPageProxyType;
      const SwitchPageProxyType sig_switch_page ()
      {
        return SwitchPageProxyType (this, &switch_page_signal);
      }

      // These return the page number of the just-added page.

      int append_page (Widget * child,
                       const ustring & tab_label);
      int append_page (Widget * child,
                       const ustring & tab_label,
                       const ustring & menu_label);
      int append_page (Widget * child,
                       const char * tab_label,
                       const char * menu_label = 0);
      int append_page (Widget * child,
                       Widget * tab_label,
                       Widget * menu_label = 0);

      int insert_page (Widget * child,
                       int position,
                       const ustring & tab_label);
      int insert_page (Widget * child,
                       int position,
                       const ustring & tab_label,
                       const ustring & menu_label);
      int insert_page (Widget * child,
                       int position,
                       const char * tab_label,
                       const char * menu_label = 0);
      int insert_page (Widget * child,
                       int position,
                       Widget * tab_label,
                       Widget * menu_label = 0);

      // prepend_page not wrapped, it seems pretty easy to insert at
      // position 0.

      void remove_page (int page_number);

      Widget * child (int page_number) const;
      int page_number (Widget * child) const;

      void set_current_page (int page_number);
      int current_page () const;

      void next_page ();
      void previous_page ();

      void set_show_border (bool show_border);
      bool show_border () const;

      void set_show_tabs (bool show_tabs);
      bool show_tabs () const;

      void set_tab_position (PositionType pos);
      PositionType tab_position () const;

      void set_homogeneous_tabs (bool homogeneous);
      bool homogeneous_tabs () const;

      // Not wrapping methods to set the tab border or packing;
      // pretty sure they are useless, but maybe not.

      void set_scrollable (bool setting);
      bool scrollable () const;

      void set_has_popup (bool setting);
      bool has_popup () const;

      // These are changed from GTK; we make the page number the
      // consistent, standard way to refer to a page, instead of
      // alternating between page number and child pointer.
      void set_tab_label (int page, Widget * tab_label);
      void set_tab_label (int page, const char * tab_label);
      void set_tab_label (int page, const ustring & tab_label);
      Widget * tab_label (int page) const;

      void set_menu_label (int page, Widget * menu_label);
      void set_menu_label (int page, const char * menu_label);
      void set_menu_label (int page, const ustring & menu_label);
      Widget * menu_label (int page) const;

      void move_page (int old_page_number, int new_page_number);

    protected:
      friend class Private::NotebookClass;

      explicit Notebook (GtkNotebook *src, GtkNotebookClass *orig);
      virtual ~Notebook ();

      virtual void switch_page_impl (int page_number, Widget * child);
      virtual void on_switch_page (int page_number, Widget * child);

    private:
      Notebook(const Notebook&);
      Notebook& operator=(const Notebook&);

      static void switch_page_proxy (GtkNotebook *notebook,
                                     GtkNotebookPage *page,
                                     guint page_num);

    }; // class Notebook

  }; // namespace Gtk

}; // namespace Inti

#endif // _INTI_GTK_NOTEBOOK_H_
