// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_GTK_LABEL_H_
#define _INTI_GTK_LABEL_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/gtk/misc.h>
#include <gtk/gtklabel.h>
#include <string>

/*$ doc header
  $short The #Inti::Gtk::Label widget, which displays uneditable text
  $*/

namespace Inti
{  
  namespace Gtk
  {
    namespace Private
    {
      class LabelClass;
    };
    
    class Label : public Misc
    {
    public:
      /*$ doc class Label
        $short widget for labelling a UI element, such as a #Button or a #Frame

        $copy none
        $memory floating
        
        $long

        <para>

        </para>

        <para>

        </para>
        
        $*/
        
      GtkLabel * gtk_label () const
      {
        return (GtkLabel*)g_object ();
      }
      
      /*$ doc constructor
        $short Construct a new label with no text
        $long

        <para>

        </para>
        
        $*/
      Label ();

      /*$ doc constructor
        $short Construct a new label with the given @text
        @text text the label should display
        $long

        <para>

        </para>
        
        $*/
      Label (const ustring & text);
      Label (const char * text);

      void set_text (const ustring& str);
      void set_text (const char * text);
      void set_justify (Gtk::Justification jtype);

      unsigned int parse_uline (const ustring& string);
      
      ustring text () const;

      Justification justify () const { return (Justification)gtk_label ()->jtype; }
      void set_line_wrap (bool setting);
      bool line_wrap () const { return gtk_label ()->wrap; }
      
    protected:
      friend class Private::LabelClass;
      
      explicit Label (GtkLabel *src, GtkLabelClass* orig);
      virtual ~Label ();
      
    private:
      Label(const Label&);
      Label& operator=(const Label&);
      
    }; // class Label

  }; // namespace Gtk
  
}; // namespace Inti

#endif // _INTI_GTK_LABEL_H_
