// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This source file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
#include "gtk-signals.h"
#include <inti/object.h>
#include <gtk/gtksignal.h>

namespace Inti
{

}; // namespace Inti

extern "C" void inti_gtk_connection_destroy_notify (gpointer data)
{
  Inti::Gtk::Private::ConnectionImpl * impl =
    (Inti::Gtk::Private::ConnectionImpl *) data;

  // We are already disconnected; we just want to
  // unref this thing, and set the disconnected flag for
  // the benefit of Connection objects that may still
  // hold a handle to it.
  impl->set_disconnected (true);
  impl->unref ();
}

Inti::Gtk::Private::ConnectionImpl::ConnectionImpl (const WrapSignal * signal,
                                                       Object * object,
                                                       Slot * slot,
                                                       DestroyNotifier * alive_object,
                                                       Private::SignalFunc callback)
  : slot_ (slot),
    object_ (object),
    alive_object_ (alive_object)
{
  slot_->ref ();
  slot_->sink ();
  
  connection_id_ =
    gtk_signal_connect_full (GTK_OBJECT (object_->g_object ()),
                             signal->name(),
                             (GtkSignalFunc)callback,
                             0, // signal marshal
                             this, // user data
                             inti_gtk_connection_destroy_notify,
                             false, // object signal
                             true); // connect after
  
  if (alive_object_)
    alive_object_->add_destroy_listener (this);
}

Inti::Gtk::Private::ConnectionImpl::~ConnectionImpl ()
{
  // mop this up, if it didn't happen (typically it doesn't happen
  // if you destroy a SignalEmitter, which sets the disconnected
  // flag but doesn't call disconnect ())
  if (alive_object_)
    alive_object_->remove_destroy_listener (this);

  slot_->unref ();
}

void
Inti::Gtk::Private::ConnectionImpl::disconnect ()
{
  if (disconnected())
    return;

  ref ();
  
  set_disconnected (true);

  if (alive_object_)
    {
      alive_object_->remove_destroy_listener (this);
      alive_object_ = 0;
    }
  
  gtk_signal_disconnect (GTK_OBJECT (object_->g_object ()),
                         connection_id_);

  unref ();
}

void
Inti::Gtk::Private::ConnectionImpl::block ()
{
  gtk_signal_handler_block (GTK_OBJECT (object_->g_object ()),
                            connection_id_);
}

void
Inti::Gtk::Private::ConnectionImpl::unblock ()
{
  gtk_signal_handler_unblock (GTK_OBJECT (object_->g_object ()),
                              connection_id_);
}

void
Inti::Gtk::Private::ConnectionImpl::notifier_destroyed (const DestroyNotifier * notifier)
{
  alive_object_ = 0;
  disconnect ();
}

/////////////////////////////////////////////////

Inti::Connection
Inti::Gtk::WrapSignal::real_connect (Object * object,
                                        Slot * slot,
                                        DestroyNotifier * alive_object) const
{
  Gtk::Private::ConnectionImpl * impl;

  impl = new Gtk::Private::ConnectionImpl (this, object, slot, alive_object,
                                           callback_);

  // The impl object owns itself (destroy notify from gtk will unref it)
  
  return Inti::Connection (impl);
}

/////////// Everything below here is machine-generated
