// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_GTK_ENTRY_H_
#define _INTI_GTK_ENTRY_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/gtk/widget.h>
#include <gtk/gtkentry.h>
#include <inti/utf-string.h>

namespace Inti
{  
  namespace Gtk
  {
    namespace Private
    {
      class EntryClass;
    };
    
    class Entry : public Widget
    {
    public:
        
      GtkEntry * gtk_entry () const
      {
        return (GtkEntry*)g_object ();
      }

      Entry ();

      ////////////////// Entry methods 
      
      void set_text (const ustring& text);
      void append_text (const ustring& text);
      void prepend_text (const ustring& text);
      void set_max_length (guint16 max);
      void set_visibility (bool visible);
      bool visibility () const;
      void set_invisible_char (gunichar ch);
      gunichar invisible_char () const;
      
      ustring text () const;
      
      int max_length () const;

      ///////////////// From GtkEditable

      void select_region (int start, int end);
      void insert_text (const ustring & text, int * position);
      void insert_text (const char * text, int * position);
      void delete_text (int start_pos, int end_pos);
      ustring get_chars (int start_pos, int end_pos);
      void cut_clipboard ();
      void copy_clipboard ();
      void paste_clipboard ();

      void delete_selection ();
      void set_position (int position);
      int position () const;

      void set_editable (bool is_editable);

      bool editable () const;

    protected:
      typedef WrapSignal0<void> ChangedSignalType;
      static const ChangedSignalType changed_signal;

    public:
      typedef SignalProxy<Object,ChangedSignalType> ChangedProxyType;
      const ChangedProxyType sig_changed ()
      {
        return ChangedProxyType (this, &changed_signal);
      }
    protected:
      typedef WrapSignal2<void,const ustring &,int * > InsertTextSignalType;
      static const InsertTextSignalType insert_text_signal;

    public:
      typedef SignalProxy<Object,InsertTextSignalType> InsertTextProxyType;
      const InsertTextProxyType sig_insert_text ()
      {
        return InsertTextProxyType (this, &insert_text_signal);
      }
    protected:
      typedef WrapSignal2<void,int,int> DeleteTextSignalType;
      static const DeleteTextSignalType delete_text_signal;

    public:
      typedef SignalProxy<Object,DeleteTextSignalType> DeleteTextProxyType;
      const DeleteTextProxyType sig_delete_text ()
      {
        return DeleteTextProxyType (this, &delete_text_signal);
      }
    protected:
      typedef WrapSignal0<void> ActivateSignalType;
      static const ActivateSignalType activate_signal;

    public:
      typedef SignalProxy<Object,ActivateSignalType> ActivateProxyType;
      const ActivateProxyType sig_activate ()
      {
        return ActivateProxyType (this, &activate_signal);
      }
      
    protected:
      friend class Private::EntryClass;
      
      explicit Entry (GtkEntry *src, GtkEntryClass* orig);
      virtual ~Entry ();
      
      // Non-signal virtual functions
      
      virtual void cut_clipboard_impl ();
      virtual void copy_clipboard_impl ();
      virtual void paste_clipboard_impl ();
      
      // Signals

      virtual void changed_impl ();
      virtual void insert_text_impl (const ustring & text, int * position);
      virtual void delete_text_impl (int start_pos, int end_pos);
      virtual void activate_impl ();


      virtual void on_changed ();
      virtual void on_insert_text (const ustring & text, int * position);
      virtual void on_delete_text (int start_pos, int end_pos);
      virtual void on_activate ();
      
    private:
      Entry(const Entry&);
      Entry& operator=(const Entry&);

      
      GtkEditable * gtk_editable () const
      {
        return (GtkEditable*)g_object ();
      }
      

      static void cut_clipboard_proxy (GtkEditable * editable);
      static void copy_clipboard_proxy (GtkEditable * editable);
      static void paste_clipboard_proxy (GtkEditable * editable);
      

      static void changed_proxy (GtkEditable * editable);
      static void insert_text_proxy (GtkEditable * editable,
                                     const char * text,
                                     int length, int * position);
      static void delete_text_proxy (GtkEditable * editable,
                                     int start_pos, int end_pos);
      static void activate_proxy (GtkEditable * editable);
      
    }; // class Entry

  }; // namespace Gtk
  
}; // namespace Inti

#endif // _INTI_GTK_ENTRY_H_
