// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_GTK_BUTTONBOX_H_
#define _INTI_GTK_BUTTONBOX_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/gtk/box.h>
#include <inti/gtk/gtkbase.h>
#include <gtk/gtkhbbox.h>
#include <gtk/gtkvbbox.h>
#include <string>

/*$ doc header
  $short #Inti::Gtk::HButtonBox and #Inti::Gtk::VButtonBox, boxes
  for containing a set of buttons
  $*/

namespace Inti
{  
  namespace Gtk
  {
    namespace Private
    {
      class ButtonBoxClass;
      class HButtonBoxClass;
      class VButtonBoxClass;
    };
    
    class ButtonBox : public Box
    {
    public:
      /*$ doc class ButtonBox
        $short Base class for #HButtonBox and #VButtonBox

        $copy none
        $memory floating
        
        $long

        <para>

        </para>
        
        $*/
        
      GtkButtonBox * gtk_button_box () const
      {
        return (GtkButtonBox*)g_object ();
      }

      /*$ doc constructor
        $short Construct a new ButtonBox with no child
        $long

        <para>

        </para>
        
        $*/
      ButtonBox ();

      typedef enum
      {
        BUTTONBOX_DEFAULT_STYLE = GTK_BUTTONBOX_DEFAULT_STYLE,
        BUTTONBOX_SPREAD = GTK_BUTTONBOX_SPREAD,
        BUTTONBOX_EDGE = GTK_BUTTONBOX_EDGE,
        BUTTONBOX_START = GTK_BUTTONBOX_START,
        BUTTONBOX_END = GTK_BUTTONBOX_END
      } Style;
      
      // The button_box_set_*_default methods should not be called
      // by application authors and thus aren't wrapped.

      void set_spacing (int spacing);
      void set_layout (Style style);
      void set_child_size (int min_width, int min_height);
      void set_child_ipadding (int ipad_x, int ipad_y);

      int spacing () const;
      Style layout () const;
      int child_size_x () const;
      int child_size_y () const;
      int child_ipadding_x () const;
      int child_ipadding_y () const;
      
    protected:
      friend class Private::ButtonBoxClass;
      
      explicit ButtonBox (GtkButtonBox *src, GtkButtonBoxClass *orig);
      virtual ~ButtonBox ();
      
    private:
      ButtonBox(const ButtonBox&);
      ButtonBox& operator=(const ButtonBox&);
      
    }; // class ButtonBox

    
    class HButtonBox : public ButtonBox
    {
    public:
      /*$ doc class HButtonBox
        $short Horizontal button box

        $copy none
        $memory floating
        
        $long

        <para>

        </para>
        
        $*/
        
      GtkHButtonBox * gtk_hbutton_box () const
      {
        return (GtkHButtonBox*)g_object ();
      }

      /*$ doc constructor
        $short Construct a new HButtonBox with no child
        $long

        <para>

        </para>
        
        $*/
      HButtonBox ();
      
    protected:
      friend class Private::HButtonBoxClass;
      
      explicit HButtonBox (GtkHButtonBox *src, GtkHButtonBoxClass *orig);
      virtual ~HButtonBox ();
      
    private:
      HButtonBox(const HButtonBox&);
      HButtonBox& operator=(const HButtonBox&);
      
    }; // class HButtonBox

    
    class VButtonBox : public ButtonBox
    {
    public:
      /*$ doc class VButtonBox
        $short Horizontal button box

        $copy none
        $memory floating
        
        $long

        <para>

        </para>
        
        $*/
        
      GtkVButtonBox * gtk_vbutton_box () const
      {
        return (GtkVButtonBox*)g_object ();
      }

      /*$ doc constructor
        $short Construct a new VButtonBox with no child
        $long

        <para>

        </para>
        
        $*/
      VButtonBox ();
      
    protected:
      friend class Private::VButtonBoxClass;
      
      explicit VButtonBox (GtkVButtonBox *src, GtkVButtonBoxClass *orig);
      virtual ~VButtonBox ();
      
    private:
      VButtonBox(const VButtonBox&);
      VButtonBox& operator=(const VButtonBox&);
      
    }; // class VButtonBox
    
    
  }; // namespace Gtk
  
}; // namespace Inti

#endif // _INTI_GTK_BUTTONBOX_H_
