// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_GTK_BUTTON_H_
#define _INTI_GTK_BUTTON_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/gtk/bin.h>
#include <inti/gtk/gtkbase.h>
#include <gtk/gtkbutton.h>
#include <string>

/*$ doc header
  $short The #Inti::Gtk::Button class
  $*/

namespace Inti
{
  namespace Gtk
  {
    namespace Private
    {
      class ButtonClass;
    };

    class Button : public Bin
    {
    public:
      /*$ doc class Button
        $short button widget

        $copy none
        $memory floating

        $long

        <para>

        </para>

        <para>

        </para>

        $*/

      GtkButton * gtk_button () const
      {
        return (GtkButton*)g_object ();
      }

      /*$ doc constructor
        $short Construct a new Button with no child
        $long

        <para>

        </para>

        $*/
      Button ();

      /*$ doc constructor
        $short Construct a new Button with a #Label as its child; the
        label's text is set to @text
        @text text of a #Label which will be automatically added to the button
        $long

        <para>

        </para>

        $*/
      Button (const ustring & text);
      Button (const char * text);

    protected:
      typedef WrapSignal0<void> ClickedSignalType;
      static const ClickedSignalType clicked_signal;

    public:
      typedef SignalProxy<Object,ClickedSignalType> ClickedProxyType;
      const ClickedProxyType sig_clicked ()
      {
        return ClickedProxyType (this, &clicked_signal);
      }
    protected:
      typedef WrapSignal0<void> PressedSignalType;
      static const PressedSignalType pressed_signal;

    public:
      typedef SignalProxy<Object,PressedSignalType> PressedProxyType;
      const PressedProxyType sig_pressed ()
      {
        return PressedProxyType (this, &pressed_signal);
      }
    protected:
      typedef WrapSignal0<void> ReleasedSignalType;
      static const ReleasedSignalType released_signal;

    public:
      typedef SignalProxy<Object,ReleasedSignalType> ReleasedProxyType;
      const ReleasedProxyType sig_released ()
      {
        return ReleasedProxyType (this, &released_signal);
      }
    protected:
      typedef WrapSignal0<void> EnterSignalType;
      static const EnterSignalType enter_signal;

    public:
      typedef SignalProxy<Object,EnterSignalType> EnterProxyType;
      const EnterProxyType sig_enter ()
      {
        return EnterProxyType (this, &enter_signal);
      }
    protected:
      typedef WrapSignal0<void> LeaveSignalType;
      static const LeaveSignalType leave_signal;

    public:
      typedef SignalProxy<Object,LeaveSignalType> LeaveProxyType;
      const LeaveProxyType sig_leave ()
      {
        return LeaveProxyType (this, &leave_signal);
      }

      void set_relief (Gtk::ReliefStyle newstyle);

      ReliefStyle relief () const;

      // Activatable
      virtual void activate ();

    protected:
      friend class Private::ButtonClass;

      explicit Button (GtkButton *src, GtkButtonClass *orig);
      virtual ~Button ();

      virtual void clicked_impl ();
      virtual void pressed_impl ();
      virtual void released_impl ();
      virtual void enter_impl ();
      virtual void leave_impl ();

      virtual void on_clicked ();
      virtual void on_pressed ();
      virtual void on_released ();
      virtual void on_enter ();
      virtual void on_leave ();

    private:
      Button(const Button&);
      Button& operator=(const Button&);

      static void button_clicked_proxy (GtkButton * button);
      static void button_pressed_proxy (GtkButton * button);
      static void button_released_proxy (GtkButton * button);
      static void button_enter_proxy (GtkButton * button);
      static void button_leave_proxy (GtkButton * button);

    }; // class Button

  }; // namespace Gtk

}; // namespace Inti

#endif // _INTI_GTK_BUTTON_H_
