// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_GDK_GC_H_
#define _INTI_GDK_GC_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gdk/gdkgc.h>
#include <inti/object.h>

namespace Inti
{  
  namespace Gdk
  {
    namespace Private
    {
      class GCClass;
    }; // namespace Private

    typedef enum
    {
      CAP_NOT_LAST = GDK_CAP_NOT_LAST,
      CAP_BUTT = GDK_CAP_BUTT,
      CAP_ROUND = GDK_CAP_ROUND,
      CAP_PROJECTING = GDK_CAP_PROJECTING
    } CapStyle;
    typedef enum
    {
      SOLID = GDK_SOLID,
      TILED = GDK_TILED,
      STIPPLED = GDK_STIPPLED,
      OPAQUE_STIPPLED = GDK_OPAQUE_STIPPLED
    } Fill;
    typedef enum
    {
      COPY = GDK_COPY,
      INVERT = GDK_INVERT,
      XOR = GDK_XOR,
      CLEAR = GDK_CLEAR,
      AND = GDK_AND,
      AND_REVERSE = GDK_AND_REVERSE,
      AND_INVERT = GDK_AND_INVERT,
      NOOP = GDK_NOOP,
      OR = GDK_OR,
      EQUIV = GDK_EQUIV,
      OR_REVERSE = GDK_OR_REVERSE,
      COPY_INVERT = GDK_COPY_INVERT,
      OR_INVERT = GDK_OR_INVERT,
      NAND = GDK_NAND,
      NOR = GDK_NOR,
      SET = GDK_SET
    } Function;
    typedef enum
    {
      JOIN_MITER = GDK_JOIN_MITER,
      JOIN_ROUND = GDK_JOIN_ROUND,
      JOIN_BEVEL = GDK_JOIN_BEVEL
    } JoinStyle;
    typedef enum
    {
      LINE_SOLID = GDK_LINE_SOLID,
      LINE_ON_OFF_DASH = GDK_LINE_ON_OFF_DASH,
      LINE_DOUBLE_DASH = GDK_LINE_DOUBLE_DASH
    } LineStyle;
    typedef enum
    {
      CLIP_BY_CHILDREN = GDK_CLIP_BY_CHILDREN,
      INCLUDE_INFERIORS = GDK_INCLUDE_INFERIORS
    } SubwindowMode;

    class Visual;
    class Pixmap;
    class Bitmap;
    class Color;
    class Region;
    class Point;
    class Rectangle;
    class Drawable;
    
    class GC : public Object
    {
    public:
      class Values
      {
      public:
        GdkGCValues * gdk_gc_values () const;
        GdkGCValuesMask gdk_gc_values_mask () const;

        void set_foreground (const Color& color);
        const Color & foreground () const;
        void unset_foreground ();
        bool foreground_set () const
        {
          return (mask_ & GDK_GC_FOREGROUND) != 0;
        }

        void set_background (const Color& color);
        const Color & background () const;
        void unset_background ();
        bool background_set () const
        {
          return (mask_ & GDK_GC_FOREGROUND) != 0;
        }
        
        void set_function (Function func);
        Function function () const;
        void unset_function ();
        bool function_set () const
        {
          return (mask_ & GDK_GC_FUNCTION) != 0;
        }

        void set_fill (Fill f);
        Fill fill () const;
        void unset_fill ();
        bool fill_set () const
        {
          return (mask_ & GDK_GC_FILL) != 0;
        }

        void set_tile (Pixmap * tile);
        Pixmap * tile () const;
        void unset_tile ();
        bool tile_set () const
        {
          return (mask_ & GDK_GC_TILE) != 0;
        }

        void set_stipple (Bitmap * stipple);
        Bitmap * stipple () const;
        void unset_stipple ();
        bool stipple_set () const
        {
          return (mask_ & GDK_GC_STIPPLE) != 0;
        }

        void set_clip_mask (Bitmap * mask);
        Bitmap * clip_mask () const;
        void unset_clip_mask ();
        bool clip_mask_set () const
        {
          return (mask_ & GDK_GC_CLIP_MASK) != 0;
        }

        void set_subwindow_mode (SubwindowMode mode);
        SubwindowMode subwindow_mode () const;
        void unset_subwindow_mode ();
        bool subwindow_mode_set () const
        {
          return (mask_ & GDK_GC_SUBWINDOW) != 0;
        }

        void set_tile_stipple_origin (int x_origin, int y_origin);
        
        void set_tile_stipple_x_origin (int origin);
        int tile_stipple_x_origin () const;
        void unset_tile_stipple_x_origin ();
        bool tile_stipple_x_origin_set () const
        {
          return (mask_ & GDK_GC_TS_X_ORIGIN) != 0;
        }
        
        void set_tile_stipple_y_origin (int origin);
        int tile_stipple_y_origin () const;
        void unset_tile_stipple_y_origin ();
        bool tile_stipple_y_origin_set () const
        {
          return (mask_ & GDK_GC_TS_Y_ORIGIN) != 0;
        }

        void set_clip_origin (int x_origin, int y_origin);
        
        void set_clip_x_origin (int origin);
        int clip_x_origin () const;
        void unset_clip_x_origin ();
        bool clip_x_origin_set () const
        {
          return (mask_ & GDK_GC_CLIP_X_ORIGIN) != 0;
        }
        
        void set_clip_y_origin (int origin);
        int clip_y_origin () const;
        void unset_clip_y_origin ();
        bool clip_y_origin_set () const
        {
          return (mask_ & GDK_GC_CLIP_Y_ORIGIN) != 0;
        }

        void set_graphics_exposures (bool exposures);
        bool graphics_exposures () const;
        void unset_graphics_exposures ();
        bool graphics_exposures_set () const
        {
          return (mask_ & GDK_GC_EXPOSURES) != 0;
        }

        void set_line_width (int width);
        int line_width () const;
        void unset_line_width ();
        bool line_width_set () const
        {
          return (mask_ & GDK_GC_LINE_WIDTH) != 0;
        }

        void set_line_style (LineStyle style);
        LineStyle line_style () const;
        void unset_line_style ();
        bool line_style_set () const
        {
          return (mask_ & GDK_GC_LINE_STYLE) != 0;
        }

        void set_cap_style (CapStyle style);
        CapStyle cap_style () const;
        void unset_cap_style ();
        bool cap_style_set () const
        {
          return (mask_ & GDK_GC_CAP_STYLE) != 0;
        }

        void set_join_style (JoinStyle style);
        JoinStyle join_style () const;
        void unset_join_style ();
        bool join_style_set () const
        {
          return (mask_ & GDK_GC_JOIN_STYLE) != 0;
        }

        Values (const Values & src);
        Values& operator= (const Values & src);
        Values ();
        ~Values ();
        
      private:
        GdkGCValues values_;
        int mask_;
        friend class GC;
        friend class Drawable;
        void fill_from_gdk_gc_values (GdkGCValues * values);
        void fill_from_gdk_gc_values (GdkGCValues * values,
                                      GdkGCValuesMask mask);
      };
      
      GdkGC * gdk_gc () const { return (GdkGC*) g_object (); }
      
      // We have these things that can be set but not got, which means
      // that user subclasses of GdkGC/GdkDrawable can't implement
      // them, blah. Should probably move them to a GdkWindowingGC
      // subclass...

      void set_clip (const Rectangle & rect);
      void set_clip (const Region & region);

      void unset_clip ();
      
      void set_dashes (int dash_offset,
                       const vector<gint8> & dash_list); 

      void set_dashes (int dash_offset,
                       const gint8 * dash_list,
                       unsigned int dash_list_length);
      
      void set_values (const Values & values);
      void get_values (Values * values);
      
      void set_foreground (const Color& color);

      void set_background (const Color& color);
        
      void set_function (Function func);

      void set_fill (Fill f);

      void set_tile (Pixmap * tile);

      void set_stipple (Bitmap * stipple);

      void set_clip (Bitmap * mask);

      void set_subwindow_mode (SubwindowMode mode);

      void set_tile_stipple_origin (int x_origin, int y_origin);
      
      void set_tile_stipple_x_origin (int origin);
        
      void set_tile_stipple_y_origin (int origin);

      void set_clip_origin (int x_origin, int y_origin);
      
      void set_clip_x_origin (int origin);
        
      void set_clip_y_origin (int origin);

      void set_graphics_exposures (bool exposures);

      void set_line_width (int width);

      void set_line_style (LineStyle style);

      void set_cap_style (CapStyle style);

      void set_join_style (JoinStyle style);
      
    protected:
      virtual ~GC () = 0; // abstract base class
      explicit GC (GdkGC * src, GdkGCClass * orig);
      GC ();
      
      virtual void get_values_impl (Values * values);
      virtual void set_values_impl (const Values & values);
      virtual void set_dashes_impl (int dash_offset,
                                    const gint8 * dash_list,
                                    unsigned int dash_list_length);
      
    private:
      GC (const GC&);
      GC& operator=(const GC&);
      
      friend class Private::GCClass;

      static void get_values_proxy (GdkGC * gc,
                                    GdkGCValues * values);
      static void set_values_proxy (GdkGC * gc,
                                    GdkGCValues * values,
                                    GdkGCValuesMask mask);
      static void set_dashes_proxy (GdkGC * gc,
                                    gint dash_offset,
                                    gint8* dash_list,
                                    gint n);
    };
    
  }; // namespace Gdk
  
}; // namespace Inti

#endif // _INTI_GDK_GC_H_
