// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This source file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
#include "gc.h"
#include "gc-class.h"
#include "gdkbase.h"
#include "pixmap.h"
#include "bitmap.h"
#include "color.h"
#include "gdkbase.h"
#include "region.h"
#include <inti/private-util.h>

/*
 * GCValues
 */

Inti::Gdk::GC::Values::Values ()
  : mask_ (0)
{
  values_.clip_mask = 0;
  values_.stipple = 0;
  values_.tile = 0;
}

Inti::Gdk::GC::Values::~Values ()
{
  unset_clip_mask ();
  unset_stipple ();
  unset_tile ();
}

Inti::Gdk::GC::Values::Values (const Values & src)
  : values_ (src.values_), mask_ (src.mask_)
{
  if (src.clip_mask_set () &&
      src.values_.clip_mask)
    g_object_ref (G_OBJECT (src.values_.clip_mask));

  if (src.stipple_set () &&
      src.values_.stipple)
    g_object_ref (G_OBJECT (src.values_.stipple));

  if (src.tile_set () &&
      src.values_.tile)
    g_object_ref (G_OBJECT (src.values_.tile));
}

Inti::Gdk::GC::Values::Values&
Inti::Gdk::GC::Values::operator= (const Values & src)
{
  if (src.clip_mask_set () &&
      src.values_.clip_mask)
    g_object_ref (G_OBJECT (src.values_.clip_mask));

  if (src.stipple_set () &&
      src.values_.stipple)
    g_object_ref (G_OBJECT (src.values_.stipple));

  if (src.tile_set () &&
      src.values_.tile)
    g_object_ref (G_OBJECT (src.values_.tile));

  unset_clip_mask ();
  unset_stipple ();
  unset_tile ();
  
  values_ = src.values_;
  mask_ = src.mask_;

  return *this;
}

GdkGCValues *
Inti::Gdk::GC::Values::gdk_gc_values () const
{
  return const_cast<GdkGCValues*>(&values_);
}

GdkGCValuesMask
Inti::Gdk::GC::Values::gdk_gc_values_mask () const
{
  return (GdkGCValuesMask) mask_;
}

void
Inti::Gdk::GC::Values::set_foreground (const Color& color)
{
  values_.foreground = *color.gdk_color ();
  mask_ |= GDK_GC_FOREGROUND;
}

const Inti::Gdk::Color &
Inti::Gdk::GC::Values::foreground () const
{
  return * Color::wrap (const_cast<GdkColor*>(&values_.foreground));
}

void
Inti::Gdk::GC::Values::unset_foreground ()
{
  mask_ &= ~GDK_GC_FOREGROUND;
}

void
Inti::Gdk::GC::Values::set_background (const Color& color)
{
  values_.background = *color.gdk_color ();
}

const Inti::Gdk::Color &
Inti::Gdk::GC::Values::background () const
{
  return * Color::wrap (const_cast<GdkColor*>(&values_.background));
}

void
Inti::Gdk::GC::Values::unset_background ()
{
  mask_ &= ~GDK_GC_BACKGROUND;
}
        
void
Inti::Gdk::GC::Values::set_function (Function func)
{
  values_.function = (GdkFunction) func;
  mask_ &= GDK_GC_FUNCTION;
}

Inti::Gdk::Function
Inti::Gdk::GC::Values::function () const
{
  return (Function) values_.function;
}

void
Inti::Gdk::GC::Values::unset_function ()
{
  mask_ &= ~GDK_GC_FUNCTION;
}

void
Inti::Gdk::GC::Values::set_fill (Fill f)
{
  values_.fill = (GdkFill) f;
  mask_ |= GDK_GC_FILL;
}

Inti::Gdk::Fill
Inti::Gdk::GC::Values::fill () const
{
  return (Fill) values_.fill;
}

void
Inti::Gdk::GC::Values::unset_fill ()
{
  mask_ &= ~GDK_GC_FILL;
}

void
Inti::Gdk::GC::Values::set_tile (Pixmap * tile)
{
  unset_tile ();
  values_.tile = tile->gdk_pixmap ();
  tile->ref ();
  tile->sink ();
  mask_ |= GDK_GC_TILE;
}

Inti::Gdk::Pixmap *
Inti::Gdk::GC::Values::tile () const
{
  if (!tile_set ())
    return 0;
  
  Pixmap * pix =
    dynamic_cast<Pixmap*> (Object::_private_wrap ((GObject*)values_.tile, false));

  return pix;
}

void
Inti::Gdk::GC::Values::unset_tile ()
{
  if (tile_set ())
    {
      g_object_unref (G_OBJECT (values_.tile));
      mask_ &= ~GDK_GC_TILE;
      values_.tile = 0;
    }
}

void
Inti::Gdk::GC::Values::set_stipple (Bitmap * stipple)
{
  unset_stipple ();
  values_.stipple = stipple->gdk_pixmap ();
  stipple->ref ();
  stipple->sink ();
  mask_ |= GDK_GC_STIPPLE;
}

Inti::Gdk::Bitmap *
Inti::Gdk::GC::Values::stipple () const
{
  if (!stipple_set ())
    return 0;
  
  Bitmap * pix =
    dynamic_cast<Bitmap*> (Object::_private_wrap ((GObject*)values_.stipple, false));

  return pix;
}

void
Inti::Gdk::GC::Values::unset_stipple ()
{
  if (stipple_set ())
    {
      g_object_unref (G_OBJECT (values_.stipple));
      mask_ &= ~GDK_GC_STIPPLE;
      values_.stipple = 0;
    }
}

void
Inti::Gdk::GC::Values::set_clip_mask (Bitmap * mask)
{
  unset_clip_mask ();
  values_.clip_mask = mask->gdk_pixmap ();
  mask->ref ();
  mask->sink ();
  mask_ |= GDK_GC_CLIP_MASK;
}

Inti::Gdk::Bitmap *
Inti::Gdk::GC::Values::clip_mask () const
{
  if (!clip_mask_set ())
    return 0;
  
  Bitmap * pix =
    dynamic_cast<Bitmap*> (Object::_private_wrap ((GObject*)values_.clip_mask, false));

  return pix;
}

void
Inti::Gdk::GC::Values::unset_clip_mask ()
{
  if (clip_mask_set ())
    {
      g_object_unref (G_OBJECT (values_.clip_mask));
      mask_ &= ~GDK_GC_CLIP_MASK;
      values_.clip_mask = 0;
    }
}

void
Inti::Gdk::GC::Values::set_subwindow_mode (SubwindowMode mode)
{
  values_.subwindow_mode = (GdkSubwindowMode) mode;
  mask_ |= GDK_GC_SUBWINDOW;
}

Inti::Gdk::SubwindowMode
Inti::Gdk::GC::Values::subwindow_mode () const
{
  return (SubwindowMode) values_.subwindow_mode;
}

void
Inti::Gdk::GC::Values::unset_subwindow_mode ()
{
  mask_ &= ~GDK_GC_SUBWINDOW;
}

void
Inti::Gdk::GC::Values::set_tile_stipple_origin (int x_origin, int y_origin)
{
  set_tile_stipple_x_origin (x_origin);
  set_tile_stipple_y_origin (y_origin);
}
        
void
Inti::Gdk::GC::Values::set_tile_stipple_x_origin (int origin)
{
  values_.ts_x_origin = origin;
  mask_ |= GDK_GC_TS_X_ORIGIN;
}

int
Inti::Gdk::GC::Values::tile_stipple_x_origin () const
{
  return values_.ts_x_origin;
}

void
Inti::Gdk::GC::Values::unset_tile_stipple_x_origin ()
{
  mask_ &= ~GDK_GC_TS_X_ORIGIN;
}
        
void
Inti::Gdk::GC::Values::set_tile_stipple_y_origin (int origin)
{
  values_.ts_y_origin = origin;
  mask_ |= GDK_GC_TS_Y_ORIGIN;
}

int
Inti::Gdk::GC::Values::tile_stipple_y_origin () const
{
  return values_.ts_y_origin;
}

void
Inti::Gdk::GC::Values::unset_tile_stipple_y_origin ()
{
  mask_ &= ~GDK_GC_TS_Y_ORIGIN;
}

void
Inti::Gdk::GC::Values::set_clip_origin (int x_origin, int y_origin)
{
  set_clip_x_origin (x_origin);
  set_clip_y_origin (y_origin);
}
        
void
Inti::Gdk::GC::Values::set_clip_x_origin (int origin)
{
  values_.clip_x_origin = origin;
  mask_ |= GDK_GC_CLIP_X_ORIGIN;
}

int
Inti::Gdk::GC::Values::clip_x_origin () const
{
  return values_.clip_x_origin;
}

void
Inti::Gdk::GC::Values::unset_clip_x_origin ()
{
  mask_ &= ~GDK_GC_CLIP_X_ORIGIN;
}
        
void
Inti::Gdk::GC::Values::set_clip_y_origin (int origin)
{
  values_.clip_y_origin = origin;
  mask_ |= GDK_GC_CLIP_Y_ORIGIN;
}

int
Inti::Gdk::GC::Values::clip_y_origin () const
{
  return values_.clip_y_origin;
}

void
Inti::Gdk::GC::Values::unset_clip_y_origin ()
{
  mask_ &= ~GDK_GC_CLIP_Y_ORIGIN;
}

void
Inti::Gdk::GC::Values::set_graphics_exposures (bool exposures)
{
  values_.graphics_exposures = exposures;
  mask_ |= GDK_GC_EXPOSURES;
}

bool
Inti::Gdk::GC::Values::graphics_exposures () const
{
  return values_.graphics_exposures;
}

void
Inti::Gdk::GC::Values::unset_graphics_exposures ()
{
  mask_ &= ~GDK_GC_EXPOSURES;
}

void
Inti::Gdk::GC::Values::set_line_width (int width)
{
  values_.line_width = width;
  mask_ |= GDK_GC_LINE_WIDTH;
}

int
Inti::Gdk::GC::Values::line_width () const
{
  return values_.line_width;
}

void
Inti::Gdk::GC::Values::unset_line_width ()
{
  mask_ &= ~GDK_GC_LINE_WIDTH;
}

void
Inti::Gdk::GC::Values::set_line_style (LineStyle style)
{
  values_.line_style = (GdkLineStyle) style;
  mask_ |= GDK_GC_LINE_STYLE;
}

Inti::Gdk::LineStyle
Inti::Gdk::GC::Values::line_style () const
{
  return (LineStyle) values_.line_style;
}

void
Inti::Gdk::GC::Values::unset_line_style ()
{
  mask_ &= ~GDK_GC_LINE_STYLE;
}

void
Inti::Gdk::GC::Values::set_cap_style (CapStyle style)
{
  values_.cap_style = (GdkCapStyle) style;
  mask_ |= GDK_GC_CAP_STYLE;
}

Inti::Gdk::CapStyle
Inti::Gdk::GC::Values::cap_style () const
{
  return (CapStyle) values_.cap_style;
}

void
Inti::Gdk::GC::Values::unset_cap_style ()
{
  mask_ &= ~GDK_GC_CAP_STYLE;
}

void
Inti::Gdk::GC::Values::set_join_style (JoinStyle style)
{
  values_.join_style = (GdkJoinStyle) style;
  mask_ |= GDK_GC_JOIN_STYLE;
}

Inti::Gdk::JoinStyle
Inti::Gdk::GC::Values::join_style () const
{
  return (JoinStyle) values_.join_style;
}

void
Inti::Gdk::GC::Values::unset_join_style ()
{
  mask_ &= ~GDK_GC_JOIN_STYLE;
}

void
Inti::Gdk::GC::Values::fill_from_gdk_gc_values (GdkGCValues * values)
{
  unset_clip_mask ();
  unset_stipple ();
  unset_tile ();
  
  values_ = *values;

  mask_ =   GDK_GC_FOREGROUND |
    GDK_GC_BACKGROUND         |
    GDK_GC_FONT	              |
    GDK_GC_FUNCTION           |
    GDK_GC_FILL	              |
    GDK_GC_SUBWINDOW          |
    GDK_GC_TS_X_ORIGIN        |
    GDK_GC_TS_Y_ORIGIN        |
    GDK_GC_CLIP_X_ORIGIN      |
    GDK_GC_CLIP_Y_ORIGIN      |
    GDK_GC_EXPOSURES          |
    GDK_GC_LINE_WIDTH         |
    GDK_GC_LINE_STYLE         |
    GDK_GC_CAP_STYLE          |
    GDK_GC_JOIN_STYLE;
  
  if (values_.stipple)
    {
      g_object_ref (G_OBJECT (values_.stipple));
      mask_ |= GDK_GC_STIPPLE;
    }

  if (values_.tile)
    {
      g_object_ref (G_OBJECT (values_.tile));
      mask_ |= GDK_GC_TILE;
    }

  if (values_.clip_mask)
    {
      g_object_ref (G_OBJECT (values_.clip_mask));
      mask_ |= GDK_GC_CLIP_MASK;
    }
}

void
Inti::Gdk::GC::Values::fill_from_gdk_gc_values (GdkGCValues * values,
                                                   GdkGCValuesMask mask)
{
  // Strip out junk pointers
  if ((mask & GDK_GC_STIPPLE) == 0)
    values->stipple = 0;
  if ((mask & GDK_GC_TILE) == 0)
    values->tile = 0;
  if ((mask & GDK_GC_CLIP_MASK) == 0)
    values->clip_mask = 0;
  
  fill_from_gdk_gc_values (values);
  mask_ = mask;
}

/*
 * GC
 */


Inti::Gdk::GC::GC ()
  : Object (Private::GCClass::make_proxy (),
            Private::GCClass::original_class ())
{
  
}

Inti::Gdk::GC::GC (GdkGC * src, GdkGCClass * orig)
  : Object ((GObject*) src, (GObjectClass*) orig)
{
  
}

Inti::Gdk::GC::~GC ()
{

}


void
Inti::Gdk::GC::set_clip (const Rectangle & rect)
{
  gdk_gc_set_clip_rectangle (gdk_gc (), rect.gdk_rectangle ());
}

void
Inti::Gdk::GC::set_clip (const Region & region)
{
  gdk_gc_set_clip_region (gdk_gc (), region.gdk_region ());
}

void
Inti::Gdk::GC::unset_clip ()
{
  gdk_gc_set_clip_region (gdk_gc (), 0);
}

void
Inti::Gdk::GC::set_dashes (int dash_offset,
                              const vector<gint8> & dash_list)
{
  g_return_if_fail (!dash_list.empty ());

  int i = 0;
  int end = dash_list.size ();
  
  gint8 * array = new gint8[end];
  
  while (i != end)
    {
      array[i] = dash_list[i];
      
      ++i;
    }

  set_dashes (dash_offset, array, end);

  delete [] array;
} 

void
Inti::Gdk::GC::set_dashes (int dash_offset,
                              const gint8 * dash_list,
                              unsigned int dash_list_length)
{
  gdk_gc_set_dashes (gdk_gc (), dash_offset,
                     const_cast<gint8*>(dash_list),
                     dash_list_length);
}
      
void
Inti::Gdk::GC::set_values (const Values & values)
{
  gdk_gc_set_values (gdk_gc (),
                     values.gdk_gc_values (),
                     values.gdk_gc_values_mask ());
}

void
Inti::Gdk::GC::get_values (Values * values)
{
  GdkGCValues tmp;

  gdk_gc_get_values (gdk_gc (), &tmp);

  values->fill_from_gdk_gc_values (&tmp);
}
      
void
Inti::Gdk::GC::set_foreground (const Color& color)
{
  gdk_gc_set_foreground (gdk_gc (), color.gdk_color ());
}

void
Inti::Gdk::GC::set_background (const Color& color)
{
  gdk_gc_set_background (gdk_gc (), color.gdk_color ());
}
        
void
Inti::Gdk::GC::set_function (Function func)
{
  gdk_gc_set_function (gdk_gc (), (GdkFunction) func);
}

void
Inti::Gdk::GC::set_fill (Fill f)
{
  gdk_gc_set_fill (gdk_gc (), (GdkFill) f);
}

void
Inti::Gdk::GC::set_tile (Pixmap * tile)
{
  gdk_gc_set_tile (gdk_gc (), tile ? tile->gdk_pixmap () : 0);
}

void
Inti::Gdk::GC::set_stipple (Bitmap * stipple)
{
  gdk_gc_set_stipple (gdk_gc (), stipple ? stipple->gdk_pixmap () : 0);
}

void
Inti::Gdk::GC::set_clip (Bitmap * mask)
{
  gdk_gc_set_clip_mask (gdk_gc (), mask ? mask->gdk_pixmap () : 0);
}

void
Inti::Gdk::GC::set_subwindow_mode (SubwindowMode mode)
{
  gdk_gc_set_subwindow (gdk_gc (), (GdkSubwindowMode) mode);
}

void
Inti::Gdk::GC::set_tile_stipple_origin (int x_origin, int y_origin)
{
  gdk_gc_set_ts_origin (gdk_gc (), x_origin, y_origin);
}
      
void
Inti::Gdk::GC::set_tile_stipple_x_origin (int origin)
{
  gdk_gc_set_ts_origin (gdk_gc (),
                        gdk_gc ()->ts_x_origin,
                        origin);
}
        
void
Inti::Gdk::GC::set_tile_stipple_y_origin (int origin)
{
  gdk_gc_set_ts_origin (gdk_gc (),
                        origin,
                        gdk_gc ()->ts_y_origin);
}

void
Inti::Gdk::GC::set_clip_origin (int x_origin, int y_origin)
{
  gdk_gc_set_clip_origin (gdk_gc (), x_origin, y_origin);
}
      
void
Inti::Gdk::GC::set_clip_x_origin (int origin)
{
  gdk_gc_set_clip_origin (gdk_gc (),
                          gdk_gc ()->clip_x_origin,
                          origin);
}
        
void
Inti::Gdk::GC::set_clip_y_origin (int origin)
{
  gdk_gc_set_clip_origin (gdk_gc (),
                          origin,
                          gdk_gc ()->clip_y_origin);
}

void
Inti::Gdk::GC::set_graphics_exposures (bool exposures)
{
  gdk_gc_set_exposures (gdk_gc (), exposures);
}

void
Inti::Gdk::GC::set_line_width (int width)
{
  Values vals;
  vals.set_line_width (width);
  set_values (vals);
}

void
Inti::Gdk::GC::set_line_style (LineStyle style)
{
  Values vals;
  vals.set_line_style (style);
  set_values (vals);
}

void
Inti::Gdk::GC::set_cap_style (CapStyle style)
{
  Values vals;
  vals.set_cap_style (style);
  set_values (vals);
}

void
Inti::Gdk::GC::set_join_style (JoinStyle style)
{
  Values vals;
  vals.set_join_style (style);
  set_values (vals);
}


void
Inti::Gdk::GC::get_values_impl (Values * values)
{
  GdkGCClass * orig =
    (GdkGCClass *) original_class();

  if (orig->get_values)
    {
      GdkGCValues tmp;
      (* orig->get_values) (gdk_gc (), &tmp);
      values->fill_from_gdk_gc_values (&tmp);
    }
}

void
Inti::Gdk::GC::set_values_impl (const Values & values)
{
  GdkGCClass * orig =
    (GdkGCClass *) original_class();

  if (orig->set_values)
    (* orig->set_values) (gdk_gc (),
                          values.gdk_gc_values (),
                          values.gdk_gc_values_mask ());
}

void
Inti::Gdk::GC::set_dashes_impl (int dash_offset,
                                   const gint8 * dash_list,
                                   unsigned int dash_list_length)
{
  GdkGCClass * orig =
    (GdkGCClass *) original_class();

  if (orig->set_dashes)
    (* orig->set_dashes) (gdk_gc (), dash_offset,
                          const_cast<gint8*>(dash_list),
                          dash_list_length);
}

void
Inti::Gdk::GC::get_values_proxy (GdkGC * gc,
                                    GdkGCValues * values)
{
  GC * o = (GC*)
    g_object_get_qdata ((GObject*)gc, Inti::Private::quark ());
  
  Values vals;
  vals.fill_from_gdk_gc_values (values);

  o->get_values_impl (&vals);
}

void
Inti::Gdk::GC::set_values_proxy (GdkGC * gc,
                                    GdkGCValues * values,
                                    GdkGCValuesMask mask)
{
  GC * o = (GC*)
    g_object_get_qdata ((GObject*)gc, Inti::Private::quark ());

  Values vals;

  vals.fill_from_gdk_gc_values (values, mask);
  
  o->set_values_impl (vals); 
}

void
Inti::Gdk::GC::set_dashes_proxy (GdkGC * gc,
                                    gint dash_offset,
                                    gint8* dash_list,
                                    gint n)
{
  GC * o = (GC*)
    g_object_get_qdata ((GObject*)gc, Inti::Private::quark ());
  
  o->set_dashes_impl (dash_offset, dash_list, n);
}



/////////// Everything below here is machine-generated
