// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_GDK_EVENT_H_
#define _INTI_GDK_EVENT_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gdk/gdkevents.h>
#include <inti/gdk/gdkbase.h>
#include <inti/gdk/dnd.h>
#include <inti/utf-string.h>
#include <inti/object.h>

namespace Inti
{  
  namespace Gdk
  {
    namespace Private
    {
      // We can't derive from a union, so we create a struct that's
      // the same size as the union.  Cheesy hack alert. We want to be
      // able to "wrap" incoming events with a simple cast, for speed
      // reasons.
      struct GdkEventStruct
      {
        GdkEvent event;
      };
    }; // namespace Private

    class Window;
    
    typedef enum
    {
      VISIBILITY_UNOBSCURED = GDK_VISIBILITY_UNOBSCURED,
      VISIBILITY_PARTIAL = GDK_VISIBILITY_PARTIAL,
      VISIBILITY_FULLY_OBSCURED = GDK_VISIBILITY_FULLY_OBSCURED
    } VisibilityState;
    typedef enum
    {
      SCROLL_UP = GDK_SCROLL_UP,
      SCROLL_DOWN = GDK_SCROLL_DOWN,
      SCROLL_LEFT = GDK_SCROLL_LEFT,
      SCROLL_RIGHT = GDK_SCROLL_RIGHT
    } ScrollDirection;
    typedef enum
    {
      NOTIFY_ANCESTOR = GDK_NOTIFY_ANCESTOR,
      NOTIFY_VIRTUAL = GDK_NOTIFY_VIRTUAL,
      NOTIFY_INFERIOR = GDK_NOTIFY_INFERIOR,
      NOTIFY_NONLINEAR = GDK_NOTIFY_NONLINEAR,
      NOTIFY_NONLINEAR_VIRTUAL = GDK_NOTIFY_NONLINEAR_VIRTUAL,
      NOTIFY_UNKNOWN = GDK_NOTIFY_UNKNOWN
    } NotifyType;
    typedef enum
    {
      CROSSINNORMAL = GDK_CROSSING_NORMAL,
      CROSSINGRAB = GDK_CROSSING_GRAB,
      CROSSINUNGRAB = GDK_CROSSING_UNGRAB
    } CrossingMode;
    typedef enum
    {
      PROPERTY_NEW_VALUE = GDK_PROPERTY_NEW_VALUE,
      PROPERTY_DELETE = GDK_PROPERTY_DELETE
    } PropertyState;
    
    class EventExpose;
    class EventNoExpose;
    class EventVisibility;
    class EventMotion;
    class EventButton;
    class EventScroll;
    class EventKey;
    class EventCrossing;
    class EventFocus;
    class EventConfigure;
    class EventProperty;
    class EventSelection;
    class EventProximity;
    class EventClient;
    class EventDND;
    
    class Event : private Private::GdkEventStruct
    {
    protected:
      typedef Private::GdkEventStruct Base;
    public:
      GdkEvent * gdk_event () const
      {
        return (GdkEvent*) this;
      }

      GdkEventAny * gdk_event_any () const
      {
        return (GdkEventAny*) this;
      }
      
      explicit Event (GdkEvent *);

      static inline Event * wrap (GdkEvent* src) { return (Event*) src; }
      static inline Event * wrap (GdkEventAny* src) { return (Event*) src; }
      
      typedef enum
      {
        NOTHING = GDK_NOTHING,
        DELETE = GDK_DELETE,
        DESTROY = GDK_DESTROY,
        EXPOSE = GDK_EXPOSE,
        MOTION_NOTIFY = GDK_MOTION_NOTIFY,
        BUTTON_PRESS = GDK_BUTTON_PRESS,
        TWO_BUTTON_PRESS = GDK_2BUTTON_PRESS,
        THREE_BUTTON_PRESS = GDK_3BUTTON_PRESS,
        BUTTON_RELEASE = GDK_BUTTON_RELEASE,
        KEY_PRESS = GDK_KEY_PRESS,
        KEY_RELEASE = GDK_KEY_RELEASE,
        ENTER_NOTIFY = GDK_ENTER_NOTIFY,
        LEAVE_NOTIFY = GDK_LEAVE_NOTIFY,
        FOCUS_CHANGE = GDK_FOCUS_CHANGE,
        CONFIGURE = GDK_CONFIGURE,
        MAP = GDK_MAP,
        UNMAP = GDK_UNMAP,
        PROPERTY_NOTIFY = GDK_PROPERTY_NOTIFY,
        SELECTION_CLEAR = GDK_SELECTION_CLEAR,
        SELECTION_REQUEST = GDK_SELECTION_REQUEST,
        SELECTION_NOTIFY = GDK_SELECTION_NOTIFY,
        PROXIMITY_IN = GDK_PROXIMITY_IN,
        PROXIMITY_OUT = GDK_PROXIMITY_OUT,
        DRAENTER = GDK_DRAG_ENTER,
        DRALEAVE = GDK_DRAG_LEAVE,
        DRAMOTION = GDK_DRAG_MOTION,
        DRASTATUS = GDK_DRAG_STATUS,
        DROP_START = GDK_DROP_START,
        DROP_FINISHED = GDK_DROP_FINISHED,
        CLIENT_EVENT = GDK_CLIENT_EVENT,
        VISIBILITY_NOTIFY = GDK_VISIBILITY_NOTIFY,
        NO_EXPOSE = GDK_NO_EXPOSE,
        SCROLL = GDK_SCROLL
      } Type;
      typedef enum
      {
        EXPOSURE_MASK = GDK_EXPOSURE_MASK,
        POINTER_MOTION_MASK = GDK_POINTER_MOTION_MASK,
        POINTER_MOTION_HINT_MASK = GDK_POINTER_MOTION_HINT_MASK,
        BUTTON_MOTION_MASK = GDK_BUTTON_MOTION_MASK,
        BUTTON1_MOTION_MASK = GDK_BUTTON1_MOTION_MASK,
        BUTTON2_MOTION_MASK = GDK_BUTTON2_MOTION_MASK,
        BUTTON3_MOTION_MASK = GDK_BUTTON3_MOTION_MASK,
        BUTTON_PRESS_MASK = GDK_BUTTON_PRESS_MASK,
        BUTTON_RELEASE_MASK = GDK_BUTTON_RELEASE_MASK,
        KEY_PRESS_MASK = GDK_KEY_PRESS_MASK,
        KEY_RELEASE_MASK = GDK_KEY_RELEASE_MASK,
        ENTER_NOTIFY_MASK = GDK_ENTER_NOTIFY_MASK,
        LEAVE_NOTIFY_MASK = GDK_LEAVE_NOTIFY_MASK,
        FOCUS_CHANGE_MASK = GDK_FOCUS_CHANGE_MASK,
        STRUCTURE_MASK = GDK_STRUCTURE_MASK,
        PROPERTY_CHANGE_MASK = GDK_PROPERTY_CHANGE_MASK,
        VISIBILITY_NOTIFY_MASK = GDK_VISIBILITY_NOTIFY_MASK,
        PROXIMITY_IN_MASK = GDK_PROXIMITY_IN_MASK,
        PROXIMITY_OUT_MASK = GDK_PROXIMITY_OUT_MASK,
        SUBSTRUCTURE_MASK = GDK_SUBSTRUCTURE_MASK,
        SCROLL_MASK = GDK_SCROLL_MASK,
        ALL_EVENTS_MASK = GDK_ALL_EVENTS_MASK
      } Mask;

      Event (const Event& src);
      Event& operator=(const Event& src);
      ~Event ();
      
      Type type () const
      {
        return (Type)Base::event.type;
      }

      Window * window () const;

      bool send_event () const
      {
        return Base::event.any.send_event != 0;
      }
      
    private:
      Event (); // makes no sense to do this
      
      // The basic issue here is that we want to
      // expose the fields in GdkEvent to our
      // built-in subclasses, but not to user
      // subclasses (though user subclasses aren't
      // really possible anyway, since there's no
      // virtual destructor and the Type enum isn't
      // extensible)
      friend class EventExpose;
      friend class EventNoExpose;
      friend class EventVisibility;
      friend class EventMotion;
      friend class EventButton;
      friend class EventScroll;
      friend class EventKey;
      friend class EventCrossing;
      friend class EventFocus;
      friend class EventConfigure;
      friend class EventProperty;
      friend class EventSelection;
      friend class EventProximity;
      friend class EventClient;
      friend class EventDND;

      /// Expose

      Rectangle * expose_area () const
      {
        return (Rectangle*)&Base::event.expose.area;
      }

      int expose_count () const
      {
        return Base::event.expose.count;
      }

      /// Visibility
      
      VisibilityState visibility_state () const
      {
        return (VisibilityState)Base::event.visibility.state;
      }

      /// Motion
      
      guint32 motion_time () const
      {
        return Base::event.motion.time;
      }
      
      double motion_x () const
      {
        return Base::event.motion.x;
      }

      double motion_y () const
      {
        return Base::event.motion.y;
      }

      ModifierTypeField motion_state () const
      {
        return Base::event.motion.state;
      }

      bool motion_hint () const
      {
        return Base::event.motion.is_hint;
      }

      double motion_x_root () const
      {
        return Base::event.motion.x_root;
      }

      double motion_y_root () const
      {
        return Base::event.motion.y_root;
      }

      /// Button
      
      guint32 button_time () const
      {
        return Base::event.button.time;
      }
      
      double button_x () const
      {
        return Base::event.button.x;
      }

      double button_y () const
      {
        return Base::event.button.y;
      }

      ModifierTypeField button_state () const
      {
        return Base::event.button.state;
      }

      int button_button () const
      {
        return Base::event.button.button;
      }

      double button_x_root () const
      {
        return Base::event.button.x_root;
      }

      double button_y_root () const
      {
        return Base::event.button.y_root;
      }

      /// Scroll
      
      guint32 scroll_time () const
      {
        return Base::event.scroll.time;
      }
      
      double scroll_x () const
      {
        return Base::event.scroll.x;
      }

      double scroll_y () const
      {
        return Base::event.scroll.y;
      }

      ModifierTypeField scroll_state () const
      {
        return Base::event.scroll.state;
      }

      ScrollDirection scroll_direction () const
      {
        return (ScrollDirection)Base::event.scroll.direction;
      }

      double scroll_x_root () const
      {
        return Base::event.scroll.x_root;
      }

      double scroll_y_root () const
      {
        return Base::event.scroll.y_root;
      }

      /// Key
      
      guint32 key_time () const
      {
        return Base::event.key.time;
      }

      ModifierTypeField key_state () const
      {
        return Base::event.key.state;
      }

      unsigned int key_val () const
      {
        return Base::event.key.keyval;
      }

      int key_length () const
      {
        return Base::event.key.length;
      }

      const char * key_string () const
      {
        return Base::event.key.string;
      }

      /// Crossing

      Window * crossing_subwindow () const;

      guint32 crossing_time () const
      {
        return Base::event.crossing.time;
      }

      double crossing_x () const
      {
        return Base::event.crossing.x;
      }

      double crossing_y () const
      {
        return Base::event.crossing.y;
      }

      double crossing_x_root () const
      {
        return Base::event.crossing.x_root;
      }

      double crossing_y_root () const
      {
        return Base::event.crossing.y_root;
      }

      CrossingMode crossing_mode () const
      {
        return (CrossingMode) Base::event.crossing.mode;
      }

      NotifyType crossing_detail () const
      {
        return (NotifyType) Base::event.crossing.detail;
      }

      bool crossing_focus () const
      {
        return Base::event.crossing.focus != FALSE;
      }

      ModifierTypeField crossing_state () const
      {
        return Base::event.crossing.state;
      }

      /// Focus

      bool focus_in () const
      {
        return Base::event.focus_change.in != FALSE;
      }

      /// Configure

      int configure_x () const
      {
        return Base::event.configure.x;
      }

      int configure_y () const
      {
        return Base::event.configure.y;
      }

      int configure_width () const
      {
        return Base::event.configure.width;
      }

      int configure_height () const
      {
        return Base::event.configure.height;
      }

      /// Property

      Gdk::Atom property_atom () const
      {
        return Base::event.property.atom;
      }

      guint32 property_time () const
      {
        return Base::event.property.time;
      }

      ModifierTypeField property_state () const
      {
        return Base::event.property.state;
      }
      
      /// Selection

      Gdk::Atom selection_selection () const
      {
        return Base::event.selection.selection;
      }

      Gdk::Atom selection_target () const
      {
        return Base::event.selection.target;
      }

      Gdk::Atom selection_property () const
      {
        return Base::event.selection.property;
      }

      guint32 selection_requestor () const
      {
        return Base::event.selection.requestor;
      }

      guint32 selection_time () const
      {
        return Base::event.selection.time;
      }

      /// Proximity

      guint32 proximity_time () const
      {
        return Base::event.proximity.time;
      }

      /// Client

      Gdk::Atom client_message_type () const
      {
        return Base::event.client.message_type;
      }

      unsigned short client_data_format () const
      {
        return Base::event.client.data_format;
      }

      const char * client_char_data () const
      {
        return Base::event.client.data.b;
      }

      const short * client_short_data () const
      {
        return Base::event.client.data.s;
      }

      const long * client_long_data () const
      {
        return Base::event.client.data.l;
      }
      
      /// DND

      DragContext * dnd_drag_context () const
      {
        return (DragContext*) Base::event.dnd.context;
      }

      guint32 dnd_time () const
      {
        return Base::event.dnd.time;
      }

      short dnd_x_root () const
      {
        return Base::event.dnd.x_root;
      }

      short dnd_y_root () const
      {
        return Base::event.dnd.y_root;
      }
      
    };

    class EventExpose : public Event
    {
    public:
      const Rectangle & area () const
      {
        return *(Rectangle*)expose_area ();
      }

      int count () const
      {
        return expose_count ();
      }

      static inline EventExpose * wrap (GdkEventExpose* src) { return (EventExpose*) src; }

      GdkEventExpose * gdk_event_expose () const { return (GdkEventExpose*) this; }
    };
    
    
    class EventVisibility : public Event
    {
    public:
      VisibilityState state () const
      {
        return visibility_state ();
      }

      static inline EventVisibility * wrap (GdkEventVisibility* src) { return (EventVisibility*) src; }

      GdkEventVisibility * gdk_event_visibility () const { return (GdkEventVisibility*) this; }
    }; // class EventVisibility

    class EventMotion : public Event
    {
    public:
      guint32 time () const
      {
        return motion_time ();
      }

      double x () const
      {
        return motion_x ();
      }

      double y () const
      {
        return motion_y ();
      }

      ModifierTypeField state () const
      {
        return motion_state ();
      }

      bool hint () const
      {
        return motion_hint ();
      }
      
      double x_root () const
      {
        return motion_x_root ();
      }

      double y_root () const
      {
        return motion_y_root ();
      }

      static inline EventMotion * wrap (GdkEventMotion* src) { return (EventMotion*) src; }

      GdkEventMotion * gdk_event_motion () const { return (GdkEventMotion*) this; }
      
    }; // class EventMotion

    class EventButton : public Event
    {
    public:
      guint32 time () const
      {
        return button_time ();
      }

      double x () const
      {
        return button_x ();
      }

      double y () const
      {
        return button_y ();
      }

      ModifierTypeField state () const
      {
        return button_state ();
      }

      int button () const
      {
        return button_button ();
      }

      double x_root () const
      {
        return button_x_root ();
      }

      double y_root () const
      {
        return button_y_root ();
      }

      static inline EventButton * wrap (GdkEventButton* src) { return (EventButton*) src; }

      GdkEventButton * gdk_event_button () const { return (GdkEventButton*) this; }      
    }; // class EventButton      

    class EventScroll : public Event
    {
    public:
      guint32 time () const
      {
        return scroll_time ();
      }

      double x () const
      {
        return scroll_x ();
      }

      double y () const
      {
        return scroll_y ();
      }

      ModifierTypeField state () const
      {
        return scroll_state ();
      }

      ScrollDirection direction () const
      {
        return scroll_direction ();
      }

      double x_root () const
      {
        return scroll_x_root ();
      }

      double y_root () const
      {
        return scroll_y_root ();
      }

      static inline EventScroll * wrap (GdkEventScroll* src) { return (EventScroll*) src; }

      GdkEventScroll * gdk_event_scroll () const { return (GdkEventScroll*) this; }      
    }; // class EventScroll

    class EventKey : public Event
    {
    public:
      guint32 time () const
      {
        return key_time ();
      }

      ModifierTypeField state () const
      {
        return key_state ();
      }

      unsigned int val () const
      {
        return key_val ();
      }

      int length () const
      {
        return key_length ();
      }

      ustring text () const
      {
        return key_string () ? ustring (key_string()) : ustring("");
      }

      static inline EventKey * wrap (GdkEventKey* src) { return (EventKey*) src; }

      GdkEventKey * gdk_event_key () const { return (GdkEventKey*) this; }
    }; // class EventKey

    class EventCrossing : public Event
    {
    public:
      Window * subwindow () const
      {
        return crossing_subwindow ();
      }

      guint32 time () const
      {
        return crossing_time ();
      }

      double x () const
      {
        return crossing_x ();
      }

      double y () const
      {
        return crossing_y ();
      }

      double x_root () const
      {
        return crossing_x_root ();
      }

      double y_root () const
      {
        return crossing_y_root ();
      }

      CrossingMode mode () const
      {
        return crossing_mode ();
      }

      NotifyType detail () const
      {
        return crossing_detail ();
      }

      bool focus_window () const
      {
        return crossing_focus ();
      }

      ModifierTypeField state () const
      {
        return crossing_state ();
      }

      static inline EventCrossing * wrap (GdkEventCrossing* src) { return (EventCrossing*) src; }

      GdkEventCrossing * gdk_event_crossing () const { return (GdkEventCrossing*) this; }      
      
    }; // class EventCrossing

    class EventFocus : public Event
    {
    public:
      bool in () const
      {
        return focus_in ();
      }

      bool out () const
      {
        return !focus_in ();
      }


      static inline EventFocus * wrap (GdkEventFocus* src) { return (EventFocus*) src; }

      GdkEventFocus * gdk_event_focus () const { return (GdkEventFocus*) this; }      
      
    }; // class EventFocus

    class EventConfigure : public Event
    {
    public:
      int x () const
      {
        return configure_x ();
      }

      int y () const
      {
        return configure_y ();
      }

      int width () const
      {
        return configure_width ();
      }

      int height () const
      {
        return configure_height ();
      }


      static inline EventConfigure * wrap (GdkEventConfigure* src) { return (EventConfigure*) src; }

      GdkEventConfigure * gdk_event_configure () const { return (GdkEventConfigure*) this; }      
      
    }; // class EventConfigure

    class EventProperty : public Event
    {
    public:
      Gdk::Atom atom () const
      {
        return property_atom ();
      }

      guint32 time () const
      {
        return property_time ();
      }

      ModifierTypeField state () const
      {
        return property_state ();
      }

      static inline EventProperty * wrap (GdkEventProperty* src) { return (EventProperty*) src; }

      GdkEventProperty * gdk_event_property () const { return (GdkEventProperty*) this; }      
    }; // class EventProperty

    class EventSelection : public Event
    {
    public:
      Gdk::Atom selection () const
      {
        return selection_selection ();
      }

      Gdk::Atom target () const
      {
        return selection_target ();
      }

      Gdk::Atom property () const
      {
        return selection_property ();
      }

      guint32 requestor () const
      {
        return selection_requestor ();
      }

      guint32 time () const
      {
        return selection_time ();
      }


      static inline EventSelection * wrap (GdkEventSelection* src) { return (EventSelection*) src; }

      GdkEventSelection * gdk_event_selection () const { return (GdkEventSelection*) this; }      
      
    }; // class EventSelection

    class EventProximity : public Event
    {
    public:
      guint32 time () const
      {
        return proximity_time ();
      }

      static inline EventProximity * wrap (GdkEventProximity* src) { return (EventProximity*) src; }

      GdkEventProximity * gdk_event_proximity () const { return (GdkEventProximity*) this; }      
      
    }; // class EventProximity

    class EventClient : public Event
    {
    public:
      Gdk::Atom message_type () const
      {
        return client_message_type ();
      }

      unsigned short data_format () const
      {
        return client_data_format ();
      }

      const char * eight_bit_data () const
      {
        return client_char_data ();
      }

      const short * sixteen_bit_data () const
      {
        return client_short_data ();
      }

      const long * thirty_two_bit_data () const
      {
        return client_long_data ();
      }


      static inline EventClient * wrap (GdkEventClient* src) { return (EventClient*) src; }

      GdkEventClient * gdk_event_client () const { return (GdkEventClient*) this; }      
      
    }; // class EventClient

    class EventDND : public Event
    {
    public:
      DragContext * drag_context () const
      {
        return dnd_drag_context ();
      }

      guint32 time () const
      {
        return dnd_time ();
      }

      short x_root () const
      {
        return dnd_x_root ();
      }

      short y_root () const
      {
        return dnd_y_root ();
      
}
      static inline EventDND * wrap (GdkEventDND* src) { return (EventDND*) src; }

      GdkEventDND * gdk_event_dnd () const { return (GdkEventDND*) this; }
      
    }; // class EventDND

    
    Event * event_peek          ();
    void    event_put           (const Event & event);
    Event * get_graphics_expose (Window * win);
    
  }; // namespace Gdk
  
}; // namespace Inti

#endif // _INTI_GDK_EVENT_H_
