// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This source file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
#include "color.h"

Inti::Gdk::Color::Color (unsigned short red,
                         unsigned short green,
                         unsigned short blue)
{
  Base::red = red;
  Base::green = green;
  Base::blue = blue;
  Base::pixel = 0;
}

Inti::Gdk::Color::Color ()
{
  Base::red = Base::green = Base::blue = 0;
  Base::pixel = 0;
}

Inti::Gdk::Color::Color (const char * color_name)
{
  set (color_name);
}


Inti::Gdk::Color::Color (const ustring & color_name)
{
  set (color_name);
}

Inti::Gdk::Color::~Color ()
{

}

void
Inti::Gdk::Color::set (unsigned short r,
                       unsigned short g,
                       unsigned short b)
{
  Base::red = r;
  Base::green = g;
  Base::blue = b;
}

void
Inti::Gdk::Color::set (const char * color_name)
{
  if (!gdk_color_parse (color_name, (GdkColor*) this))
    g_warning ("unknown color name `%s'", color_name);
}


void
Inti::Gdk::Color::set (const ustring & color_name)
{
  set (color_name.c_str ());
}

bool
Inti::Gdk::Color::operator==(const Color & rhs)
{
  return
    red () == rhs.red () &&
    green () == rhs.green () &&
    blue () == rhs.blue ();
}

bool
Inti::Gdk::Color::operator!=(const Color & rhs)
{
  return !(*this == rhs);
}

unsigned int
Inti::Gdk::Color::hash () const
{
  return gdk_color_hash ((GdkColor*)this);
}

/////////// Everything below here is machine-generated
