#!/usr/bin/env python
# -*- Mode: Python; py-indent-offset: 4 -*-

from string import *
import sys
import re
import exceptions

class LineBuf:
    def __init__ (self):
        self.lines = []
        self.filename = ""

    # allow 'while linebuf:' expression
    def __nonzero__ (self):
        return self.lines != []

    def set_lines (self, filename, lines):
        self.lines = lines
        self.filename = filename
        self.total_lines = len(lines)

    def push (self, line):
        self.lines.insert(0, line)

    def pop (self):
        return self.lines.pop (0)

    def die (self, s):
        if self.total_lines:
            print "Error: %s: %d: %s" % (self.filename, self.total_lines - len(self.lines), s)
        else:
            print "Error: %s" % (s)
        sys.exit(1)

    def warn (self, s):
        if self.total_lines:
            print "Warning: %s: %d: %s" % (self.filename, self.total_lines - len(self.lines), s)
        else:
            print "Warning: %s" % (s)
