// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_BASE_SIGNAL_SYSTEM_H_
#define _INTI_BASE_SIGNAL_SYSTEM_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/slot.h>
#include <inti/destroy-notify.h>
#include <inti/connection.h>
#include <vector>

/*$ doc header
  $short Signals
  $*/

namespace Inti
{
  class Signal;
  
  ////////////////////// Marshaller (from libsigc++)

  template <typename ReturnType>
  class DefaultMarshal
  {
  public:
    typedef ReturnType OutType;
    typedef ReturnType InType;
    
    OutType & value() { return value_; }
    
    // return true to stop emission
    bool marshal(const InType & newval)
    {
      value_ = newval;
      return false;
    }

    DefaultMarshal()
      :value_()
    {
    }
    
  private:
    OutType value_;
  };

  // For template args we don't really want to use.
  class EmptyUselessClass
  {
  };
  
  // Used as a proxy for manipulating a signal (connection, mostly)
  template <class EmitterType, class SignalType>
  class SignalProxy
  {
  public:
    typedef typename SignalType::SlotType SlotType;
    
    SignalProxy (EmitterType * emitter,
                 const SignalType * signal)
      : emitter_(emitter), signal_(signal)
    {
    }
    
    Connection connect (SlotType * slot,
                        DestroyNotifier * alive_object = 0) const
    {
      return signal_->connect (emitter_, slot, alive_object);
    }

    template <class MethodClassType, class MethodType>
    Connection connect (MethodClassType * obj,
                        MethodType method,
                        DestroyNotifier * alive_object = 0) const
    {
      return signal_->connect (emitter_,
                               slot (obj, method),
                               alive_object);
    }

    // This should also work with function objects, if/when
    // we have a slot() that takes a function object.
    template <class FunctionType>
    Connection connect (FunctionType function,
                        DestroyNotifier * alive_object = 0) const
    {
      return signal_->connect (emitter_, slot (function), alive_object);
    }
    
  private:
    EmitterType * const emitter_;
    const SignalType * const signal_;
  };
  
  class Signal;

  namespace Private
  {
    class NativeConnectionImpl;
  }; // namespace Private
  
  ////////////////////// Object that can emit native C++ signals
  class SignalEmitterBase
  {
  public:
    typedef vector<Private::NativeConnectionImpl*> ConnectionList;
    
    virtual void add_signal_connection (Private::NativeConnectionImpl * impl) = 0;
    
    virtual void get_signal_connections (const Signal * signal,
                                         ConnectionList * connections) = 0;
    
    virtual void remove_signal_connection (Private::NativeConnectionImpl * impl) = 0;

    virtual ~SignalEmitterBase () = 0;

  protected:
    // Shared implementation
    static void free_connection_list (ConnectionList * list);
    static void add_to_connection_list (ConnectionList * list,
                                        Private::NativeConnectionImpl * impl);
    static void get_from_connection_list (ConnectionList * list,
                                          const Signal * signal,
                                          ConnectionList * connections);
    static void remove_from_connnection_list (ConnectionList * list,
                                              Private::NativeConnectionImpl * impl);
  };
  
  class SignalEmitter : public SignalEmitterBase
  {
  public:
    virtual void add_signal_connection (Private::NativeConnectionImpl * impl);
    
    virtual void get_signal_connections (const Signal * signal,
                                         ConnectionList * connections);
    
    virtual void remove_signal_connection (Private::NativeConnectionImpl * impl);
    
  protected:
    SignalEmitter ();
    
    virtual ~SignalEmitter ();
    
  private:
    ConnectionList * list_;
  };
  
  ////////////////////// Signal

  class Signal
  {
  public:
    Signal ();
    ~Signal ();

  private:
    Signal (const Signal&);
    Signal& operator= (const Signal&);
  };
  
  class NativeSignal : public Signal
  {
  protected:
    NativeSignal ();
    ~NativeSignal ();

    typedef std::vector<Private::NativeConnectionImpl*> ConnectionList;
    
    class Emission
    {
    public:
      Slot * next ();
      
      ~Emission ();
      Emission (const NativeSignal * signal,
                SignalEmitterBase * emitter);
      
    private:
      Emission (const Emission &);
      Emission & operator= (const Emission&);

      ConnectionList connections_;
      ConnectionList::const_iterator next_;
      ConnectionList::const_iterator end_;
    };

    Connection real_connect (SignalEmitterBase * emitter_object,
                             Slot * s,
                             DestroyNotifier * alive_object = 0) const;
    
  private:
    NativeSignal (const NativeSignal&);
    NativeSignal& operator= (const NativeSignal&);
  };


  template <class ReturnType, typename Marshal = class DefaultMarshal<ReturnType> >
  class Signal0 : public NativeSignal
  {
  public:
    typedef Slot0<ReturnType> SlotType;
    
    ReturnType emit (SignalEmitterBase * emitter_object) const;

    Connection connect (SignalEmitterBase * emitter_object,
                        SlotType* slot,
                        DestroyNotifier * alive_object = 0) const
    {
      return real_connect (emitter_object, slot, alive_object);
    }
    
  }; // class Signal0

  // We don't want to inline emit()
  template <class ReturnType, class Marshal>
  ReturnType Signal0<ReturnType, Marshal>::emit (SignalEmitterBase * emitter_object) const
  {
    Marshal m;
    Emission e (this, emitter_object);
    
    Slot * s = e.next ();
    while (s != 0)
      {
        SlotType * slot = (SlotType*)s;
        
        if (m.marshal (slot->invoke ()))
          break;
        
        s = e.next ();
      }
    
    return m.value ();
  }
  
  // partially specialize for void return value
  template <class IgnoredMarshal>
  class Signal0<void, IgnoredMarshal> : public NativeSignal
  {
  public:
    typedef Slot0<void> SlotType;
    
    void emit (SignalEmitterBase * emitter_object) const;

    Connection connect (SignalEmitterBase * emitter_object,
                        SlotType* slot,
                        DestroyNotifier * alive_object = 0) const
    {
      return real_connect (emitter_object, slot, alive_object);
    }
    
  }; // class Signal0 (void specialization)

  // don't inline emit()
  template <class IgnoredMarshal>
  void Signal0<void, IgnoredMarshal>::emit (SignalEmitterBase * emitter_object) const
  {
    Emission e (this, emitter_object);
    
    Slot * s = e.next ();
    while (s != 0)
      {
        SlotType * slot = (SlotType*)s;
        
        slot->invoke ();
        
        s = e.next ();
      }
  }

  template <class ReturnType, class Arg1Type, typename Marshal = class DefaultMarshal<ReturnType> >
  class Signal1 : public NativeSignal
  {
  public:
    typedef Slot1<ReturnType, Arg1Type> SlotType;
    
    ReturnType emit (SignalEmitterBase * emitter_object, Arg1Type arg1) const;

    Connection connect (SignalEmitterBase * emitter_object,
                        SlotType* slot,
                        DestroyNotifier * alive_object = 0) const
    {
      return real_connect (emitter_object, slot, alive_object);
    }
    
  }; // class Signal1

  // We don't want to inline emit()
  template <class ReturnType, class Arg1Type, class Marshal>
  ReturnType Signal1<ReturnType, Arg1Type, Marshal>::emit (SignalEmitterBase * emitter_object, Arg1Type arg1) const
  {
    Marshal m;
    Emission e (this, emitter_object);
    
    Slot * s = e.next ();
    while (s != 0)
      {
        SlotType * slot = (SlotType*)s;
        
        if (m.marshal (slot->invoke (arg1)))
          break;
        
        s = e.next ();
      }
    
    return m.value ();
  }
  
  // partially specialize for void return value
  template <class Arg1Type, class IgnoredMarshal>
  class Signal1<void, Arg1Type, IgnoredMarshal> : public NativeSignal
  {
  public:
    typedef Slot1<void, Arg1Type> SlotType;
    
    void emit (SignalEmitterBase * emitter_object, Arg1Type arg1) const;

    Connection connect (SignalEmitterBase * emitter_object,
                        SlotType* slot,
                        DestroyNotifier * alive_object = 0) const
    {
      return real_connect (emitter_object, slot, alive_object);
    }
    
  }; // class Signal1 (void specialization)

  // don't inline emit()
  template <class Arg1Type, class IgnoredMarshal>
  void Signal1<void, Arg1Type, IgnoredMarshal>::emit (SignalEmitterBase * emitter_object, Arg1Type arg1) const
  {
    Emission e (this, emitter_object);
    
    Slot * s = e.next ();
    while (s != 0)
      {
        SlotType * slot = (SlotType*)s;
        
        slot->invoke (arg1);
        
        s = e.next ();
      }
  }

  template <class ReturnType, class Arg1Type, class Arg2Type, typename Marshal = class DefaultMarshal<ReturnType> >
  class Signal2 : public NativeSignal
  {
  public:
    typedef Slot2<ReturnType, Arg1Type, Arg2Type> SlotType;
    
    ReturnType emit (SignalEmitterBase * emitter_object, Arg1Type arg1, Arg2Type arg2) const;

    Connection connect (SignalEmitterBase * emitter_object,
                        SlotType* slot,
                        DestroyNotifier * alive_object = 0) const
    {
      return real_connect (emitter_object, slot, alive_object);
    }
    
  }; // class Signal2

  // We don't want to inline emit()
  template <class ReturnType, class Arg1Type, class Arg2Type, class Marshal>
  ReturnType Signal2<ReturnType, Arg1Type, Arg2Type, Marshal>::emit (SignalEmitterBase * emitter_object, Arg1Type arg1, Arg2Type arg2) const
  {
    Marshal m;
    Emission e (this, emitter_object);
    
    Slot * s = e.next ();
    while (s != 0)
      {
        SlotType * slot = (SlotType*)s;
        
        if (m.marshal (slot->invoke (arg1, arg2)))
          break;
        
        s = e.next ();
      }
    
    return m.value ();
  }
  
  // partially specialize for void return value
  template <class Arg1Type, class Arg2Type, class IgnoredMarshal>
  class Signal2<void, Arg1Type, Arg2Type, IgnoredMarshal> : public NativeSignal
  {
  public:
    typedef Slot2<void, Arg1Type, Arg2Type> SlotType;
    
    void emit (SignalEmitterBase * emitter_object, Arg1Type arg1, Arg2Type arg2) const;

    Connection connect (SignalEmitterBase * emitter_object,
                        SlotType* slot,
                        DestroyNotifier * alive_object = 0) const
    {
      return real_connect (emitter_object, slot, alive_object);
    }
    
  }; // class Signal2 (void specialization)

  // don't inline emit()
  template <class Arg1Type, class Arg2Type, class IgnoredMarshal>
  void Signal2<void, Arg1Type, Arg2Type, IgnoredMarshal>::emit (SignalEmitterBase * emitter_object, Arg1Type arg1, Arg2Type arg2) const
  {
    Emission e (this, emitter_object);
    
    Slot * s = e.next ();
    while (s != 0)
      {
        SlotType * slot = (SlotType*)s;
        
        slot->invoke (arg1, arg2);
        
        s = e.next ();
      }
  }

  template <class ReturnType, class Arg1Type, class Arg2Type, class Arg3Type, typename Marshal = class DefaultMarshal<ReturnType> >
  class Signal3 : public NativeSignal
  {
  public:
    typedef Slot3<ReturnType, Arg1Type, Arg2Type, Arg3Type> SlotType;
    
    ReturnType emit (SignalEmitterBase * emitter_object, Arg1Type arg1, Arg2Type arg2, Arg3Type arg3) const;

    Connection connect (SignalEmitterBase * emitter_object,
                        SlotType* slot,
                        DestroyNotifier * alive_object = 0) const
    {
      return real_connect (emitter_object, slot, alive_object);
    }
    
  }; // class Signal3

  // We don't want to inline emit()
  template <class ReturnType, class Arg1Type, class Arg2Type, class Arg3Type, class Marshal>
  ReturnType Signal3<ReturnType, Arg1Type, Arg2Type, Arg3Type, Marshal>::emit (SignalEmitterBase * emitter_object, Arg1Type arg1, Arg2Type arg2, Arg3Type arg3) const
  {
    Marshal m;
    Emission e (this, emitter_object);
    
    Slot * s = e.next ();
    while (s != 0)
      {
        SlotType * slot = (SlotType*)s;
        
        if (m.marshal (slot->invoke (arg1, arg2, arg3)))
          break;
        
        s = e.next ();
      }
    
    return m.value ();
  }
  
  // partially specialize for void return value
  template <class Arg1Type, class Arg2Type, class Arg3Type, class IgnoredMarshal>
  class Signal3<void, Arg1Type, Arg2Type, Arg3Type, IgnoredMarshal> : public NativeSignal
  {
  public:
    typedef Slot3<void, Arg1Type, Arg2Type, Arg3Type> SlotType;
    
    void emit (SignalEmitterBase * emitter_object, Arg1Type arg1, Arg2Type arg2, Arg3Type arg3) const;

    Connection connect (SignalEmitterBase * emitter_object,
                        SlotType* slot,
                        DestroyNotifier * alive_object = 0) const
    {
      return real_connect (emitter_object, slot, alive_object);
    }
    
  }; // class Signal3 (void specialization)

  // don't inline emit()
  template <class Arg1Type, class Arg2Type, class Arg3Type, class IgnoredMarshal>
  void Signal3<void, Arg1Type, Arg2Type, Arg3Type, IgnoredMarshal>::emit (SignalEmitterBase * emitter_object, Arg1Type arg1, Arg2Type arg2, Arg3Type arg3) const
  {
    Emission e (this, emitter_object);
    
    Slot * s = e.next ();
    while (s != 0)
      {
        SlotType * slot = (SlotType*)s;
        
        slot->invoke (arg1, arg2, arg3);
        
        s = e.next ();
      }
  }

  template <class ReturnType, class Arg1Type, class Arg2Type, class Arg3Type, class Arg4Type, typename Marshal = class DefaultMarshal<ReturnType> >
  class Signal4 : public NativeSignal
  {
  public:
    typedef Slot4<ReturnType, Arg1Type, Arg2Type, Arg3Type, Arg4Type> SlotType;
    
    ReturnType emit (SignalEmitterBase * emitter_object, Arg1Type arg1, Arg2Type arg2, Arg3Type arg3, Arg4Type arg4) const;

    Connection connect (SignalEmitterBase * emitter_object,
                        SlotType* slot,
                        DestroyNotifier * alive_object = 0) const
    {
      return real_connect (emitter_object, slot, alive_object);
    }
    
  }; // class Signal4

  // We don't want to inline emit()
  template <class ReturnType, class Arg1Type, class Arg2Type, class Arg3Type, class Arg4Type, class Marshal>
  ReturnType Signal4<ReturnType, Arg1Type, Arg2Type, Arg3Type, Arg4Type, Marshal>::emit (SignalEmitterBase * emitter_object, Arg1Type arg1, Arg2Type arg2, Arg3Type arg3, Arg4Type arg4) const
  {
    Marshal m;
    Emission e (this, emitter_object);
    
    Slot * s = e.next ();
    while (s != 0)
      {
        SlotType * slot = (SlotType*)s;
        
        if (m.marshal (slot->invoke (arg1, arg2, arg3, arg4)))
          break;
        
        s = e.next ();
      }
    
    return m.value ();
  }
  
  // partially specialize for void return value
  template <class Arg1Type, class Arg2Type, class Arg3Type, class Arg4Type, class IgnoredMarshal>
  class Signal4<void, Arg1Type, Arg2Type, Arg3Type, Arg4Type, IgnoredMarshal> : public NativeSignal
  {
  public:
    typedef Slot4<void, Arg1Type, Arg2Type, Arg3Type, Arg4Type> SlotType;
    
    void emit (SignalEmitterBase * emitter_object, Arg1Type arg1, Arg2Type arg2, Arg3Type arg3, Arg4Type arg4) const;

    Connection connect (SignalEmitterBase * emitter_object,
                        SlotType* slot,
                        DestroyNotifier * alive_object = 0) const
    {
      return real_connect (emitter_object, slot, alive_object);
    }
    
  }; // class Signal4 (void specialization)

  // don't inline emit()
  template <class Arg1Type, class Arg2Type, class Arg3Type, class Arg4Type, class IgnoredMarshal>
  void Signal4<void, Arg1Type, Arg2Type, Arg3Type, Arg4Type, IgnoredMarshal>::emit (SignalEmitterBase * emitter_object, Arg1Type arg1, Arg2Type arg2, Arg3Type arg3, Arg4Type arg4) const
  {
    Emission e (this, emitter_object);
    
    Slot * s = e.next ();
    while (s != 0)
      {
        SlotType * slot = (SlotType*)s;
        
        slot->invoke (arg1, arg2, arg3, arg4);
        
        s = e.next ();
      }
  }

  template <class ReturnType, class Arg1Type, class Arg2Type, class Arg3Type, class Arg4Type, class Arg5Type, typename Marshal = class DefaultMarshal<ReturnType> >
  class Signal5 : public NativeSignal
  {
  public:
    typedef Slot5<ReturnType, Arg1Type, Arg2Type, Arg3Type, Arg4Type, Arg5Type> SlotType;
    
    ReturnType emit (SignalEmitterBase * emitter_object, Arg1Type arg1, Arg2Type arg2, Arg3Type arg3, Arg4Type arg4, Arg5Type arg5) const;

    Connection connect (SignalEmitterBase * emitter_object,
                        SlotType* slot,
                        DestroyNotifier * alive_object = 0) const
    {
      return real_connect (emitter_object, slot, alive_object);
    }
    
  }; // class Signal5

  // We don't want to inline emit()
  template <class ReturnType, class Arg1Type, class Arg2Type, class Arg3Type, class Arg4Type, class Arg5Type, class Marshal>
  ReturnType Signal5<ReturnType, Arg1Type, Arg2Type, Arg3Type, Arg4Type, Arg5Type, Marshal>::emit (SignalEmitterBase * emitter_object, Arg1Type arg1, Arg2Type arg2, Arg3Type arg3, Arg4Type arg4, Arg5Type arg5) const
  {
    Marshal m;
    Emission e (this, emitter_object);
    
    Slot * s = e.next ();
    while (s != 0)
      {
        SlotType * slot = (SlotType*)s;
        
        if (m.marshal (slot->invoke (arg1, arg2, arg3, arg4, arg5)))
          break;
        
        s = e.next ();
      }
    
    return m.value ();
  }
  
  // partially specialize for void return value
  template <class Arg1Type, class Arg2Type, class Arg3Type, class Arg4Type, class Arg5Type, class IgnoredMarshal>
  class Signal5<void, Arg1Type, Arg2Type, Arg3Type, Arg4Type, Arg5Type, IgnoredMarshal> : public NativeSignal
  {
  public:
    typedef Slot5<void, Arg1Type, Arg2Type, Arg3Type, Arg4Type, Arg5Type> SlotType;
    
    void emit (SignalEmitterBase * emitter_object, Arg1Type arg1, Arg2Type arg2, Arg3Type arg3, Arg4Type arg4, Arg5Type arg5) const;

    Connection connect (SignalEmitterBase * emitter_object,
                        SlotType* slot,
                        DestroyNotifier * alive_object = 0) const
    {
      return real_connect (emitter_object, slot, alive_object);
    }
    
  }; // class Signal5 (void specialization)

  // don't inline emit()
  template <class Arg1Type, class Arg2Type, class Arg3Type, class Arg4Type, class Arg5Type, class IgnoredMarshal>
  void Signal5<void, Arg1Type, Arg2Type, Arg3Type, Arg4Type, Arg5Type, IgnoredMarshal>::emit (SignalEmitterBase * emitter_object, Arg1Type arg1, Arg2Type arg2, Arg3Type arg3, Arg4Type arg4, Arg5Type arg5) const
  {
    Emission e (this, emitter_object);
    
    Slot * s = e.next ();
    while (s != 0)
      {
        SlotType * slot = (SlotType*)s;
        
        slot->invoke (arg1, arg2, arg3, arg4, arg5);
        
        s = e.next ();
      }
  }

  template <class ReturnType, class Arg1Type, class Arg2Type, class Arg3Type, class Arg4Type, class Arg5Type, class Arg6Type, typename Marshal = class DefaultMarshal<ReturnType> >
  class Signal6 : public NativeSignal
  {
  public:
    typedef Slot6<ReturnType, Arg1Type, Arg2Type, Arg3Type, Arg4Type, Arg5Type, Arg6Type> SlotType;
    
    ReturnType emit (SignalEmitterBase * emitter_object, Arg1Type arg1, Arg2Type arg2, Arg3Type arg3, Arg4Type arg4, Arg5Type arg5, Arg6Type arg6) const;

    Connection connect (SignalEmitterBase * emitter_object,
                        SlotType* slot,
                        DestroyNotifier * alive_object = 0) const
    {
      return real_connect (emitter_object, slot, alive_object);
    }
    
  }; // class Signal6

  // We don't want to inline emit()
  template <class ReturnType, class Arg1Type, class Arg2Type, class Arg3Type, class Arg4Type, class Arg5Type, class Arg6Type, class Marshal>
  ReturnType Signal6<ReturnType, Arg1Type, Arg2Type, Arg3Type, Arg4Type, Arg5Type, Arg6Type, Marshal>::emit (SignalEmitterBase * emitter_object, Arg1Type arg1, Arg2Type arg2, Arg3Type arg3, Arg4Type arg4, Arg5Type arg5, Arg6Type arg6) const
  {
    Marshal m;
    Emission e (this, emitter_object);
    
    Slot * s = e.next ();
    while (s != 0)
      {
        SlotType * slot = (SlotType*)s;
        
        if (m.marshal (slot->invoke (arg1, arg2, arg3, arg4, arg5, arg6)))
          break;
        
        s = e.next ();
      }
    
    return m.value ();
  }
  
  // partially specialize for void return value
  template <class Arg1Type, class Arg2Type, class Arg3Type, class Arg4Type, class Arg5Type, class Arg6Type, class IgnoredMarshal>
  class Signal6<void, Arg1Type, Arg2Type, Arg3Type, Arg4Type, Arg5Type, Arg6Type, IgnoredMarshal> : public NativeSignal
  {
  public:
    typedef Slot6<void, Arg1Type, Arg2Type, Arg3Type, Arg4Type, Arg5Type, Arg6Type> SlotType;
    
    void emit (SignalEmitterBase * emitter_object, Arg1Type arg1, Arg2Type arg2, Arg3Type arg3, Arg4Type arg4, Arg5Type arg5, Arg6Type arg6) const;

    Connection connect (SignalEmitterBase * emitter_object,
                        SlotType* slot,
                        DestroyNotifier * alive_object = 0) const
    {
      return real_connect (emitter_object, slot, alive_object);
    }
    
  }; // class Signal6 (void specialization)

  // don't inline emit()
  template <class Arg1Type, class Arg2Type, class Arg3Type, class Arg4Type, class Arg5Type, class Arg6Type, class IgnoredMarshal>
  void Signal6<void, Arg1Type, Arg2Type, Arg3Type, Arg4Type, Arg5Type, Arg6Type, IgnoredMarshal>::emit (SignalEmitterBase * emitter_object, Arg1Type arg1, Arg2Type arg2, Arg3Type arg3, Arg4Type arg4, Arg5Type arg5, Arg6Type arg6) const
  {
    Emission e (this, emitter_object);
    
    Slot * s = e.next ();
    while (s != 0)
      {
        SlotType * slot = (SlotType*)s;
        
        slot->invoke (arg1, arg2, arg3, arg4, arg5, arg6);
        
        s = e.next ();
      }
  }
  
}; // namespace Inti

#endif // _INTI_BASE_SIGNAL_SYSTEM_H_
