// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_BASE_I__N_H_
#define _INTI_BASE_I__N_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/utf-string.h>

// No-op i18n marker. Unfortunately there's no way
// to make this a function, since the whole point is
// to have a way to mark text for translation in
// contexts where a function call is not permitted.
// You can #define INTI_NO_NAMESPACE_POLLUTION to get
// rid of this macro.
#ifndef INTI_NO_NAMESPACE_POLLUTION
#ifndef N_
#define N_(str) (str)
#endif
#endif

namespace Inti
{
#ifdef _
#error "You can't include GNOME headers or other headers that define the _ macro before inti/i18n.h"
#endif
  
  // not in the i18n namespace, purely for convenience
  const char * _ (const char * str);
  const char * _ (const string & str);

  // Libraries must specify the domain always, since the global
  // domain is reserved for use by the application.
  const char * _ (const char * str,
                  const char * domain);
  const char * _ (const string & str,
                  const char * domain); // domain will always be a literal

  namespace i18n
  {
    const char * set_translation_domain (const char * domain);
    const char * set_translation_domain (const string & domain);
    
    const char * set_domain_directory (const char * domain,
                                       const char * directory_name);
    const char * set_domain_directory (const string & domain,
                                       const string & directory_name);
  }; // namespace i18n 
  
}; // namespace Inti

#endif // _INTI_BASE_I__N_H_
