// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This source file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
#include "viewport.h"
#include "viewport-class.h"
#include "adjustment.h"
#include <inti/private-util.h>

Inti::Gtk::Viewport::Viewport ()
  : Bin ((GtkBin*)Private::ViewportClass::make_proxy (),
         (GtkBinClass*) Private::ViewportClass::original_class ())
{

}

Inti::Gtk::Viewport::Viewport (Adjustment * hadj,
                                  Adjustment * vadj)
  : Bin ((GtkBin*)Private::ViewportClass::make_proxy (),
         (GtkBinClass*) Private::ViewportClass::original_class ())
{
  set_scroll_adjustments (hadj, vadj);
}

Inti::Gtk::Viewport::Viewport (GtkViewport *obj, GtkViewportClass * orig)
  : Bin ((GtkBin*)obj,
         (GtkBinClass*)orig)
{
  
}

Inti::Gtk::Viewport::~Viewport ()
{

}

      
void
Inti::Gtk::Viewport::set_scroll_adjustments (Adjustment * horizontal,
                                                Adjustment * vertical)
{
  set_scroll_hadjustment (horizontal);
  set_scroll_vadjustment (vertical);
}

void
Inti::Gtk::Viewport::set_scroll_hadjustment (Adjustment * hadj)
{
  gtk_viewport_set_hadjustment (gtk_viewport (),
                                hadj ? hadj->gtk_adjustment () : 0);
}

void
Inti::Gtk::Viewport::set_scroll_vadjustment (Adjustment * vadj)
{
  gtk_viewport_set_vadjustment (gtk_viewport (),
                                vadj ? vadj->gtk_adjustment () : 0);
}

Inti::Gtk::Adjustment *
Inti::Gtk::Viewport::scroll_hadjustment () const
{
  GtkAdjustment * hadj =
    gtk_viewport_get_hadjustment (gtk_viewport ());

  return dynamic_cast<Adjustment*>(Object::wrap ((GObject*) hadj));
}

Inti::Gtk::Adjustment *
Inti::Gtk::Viewport::scroll_vadjustment () const
{
  GtkAdjustment * vadj =
    gtk_viewport_get_vadjustment (gtk_viewport ());

  return dynamic_cast<Adjustment*>(Object::wrap ((GObject*) vadj));
}


/////////// Everything below here is machine-generated
void
Inti::Gtk::Viewport::set_shadow_type (Gtk::ShadowType type)
{
   gtk_viewport_set_shadow_type (gtk_viewport (), (GtkShadowType) type);
}
