// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This source file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
#include "notebook.h"
#include "notebook-class.h"
#include "label.h"
#include <inti/private-util.h>

Inti::Gtk::Notebook::Notebook ()
  : Container ((GtkContainer*)Private::NotebookClass::make_proxy (),
               (GtkContainerClass*) Private::NotebookClass::original_class ())
{

}

Inti::Gtk::Notebook::Notebook (GtkNotebook *obj, GtkNotebookClass * orig)
  : Container ((GtkContainer*)obj,
               (GtkContainerClass*)orig)
{

}

Inti::Gtk::Notebook::~Notebook ()
{

}

int
Inti::Gtk::Notebook::append_page (Widget * child,
                                     const string & tab_label)
{
  return append_page (child, tab_label.c_str ());
}

int
Inti::Gtk::Notebook::append_page (Widget * child,
                                     const string & tab_label,
                                     const string & menu_label)
{
  return append_page (child, tab_label.c_str (), menu_label.c_str ());
}

int
Inti::Gtk::Notebook::append_page (Widget * child,
                                     const char * tab_label,
                                     const char * menu_label)
{
  return append_page (child,
                      tab_label ? new Label (tab_label) : 0,
                      menu_label ? new Label (menu_label) : 0);
}

int
Inti::Gtk::Notebook::append_page (Widget * child,
                                     Widget * tab_label,
                                     Widget * menu_label)
{
  gtk_notebook_append_page_menu (gtk_notebook (),
                                 child->gtk_widget (),
                                 tab_label ? tab_label->gtk_widget () : 0,
                                 menu_label ? menu_label->gtk_widget () : 0);

  return page_number (child);
}

int
Inti::Gtk::Notebook::insert_page (Widget * child,
                                     int position,
                                     const string & tab_label)
{
  return insert_page (child, position, tab_label.c_str ());
}

int
Inti::Gtk::Notebook::insert_page (Widget * child,
                                     int position,
                                     const string & tab_label,
                                     const string & menu_label)
{
  return insert_page (child, position, tab_label.c_str (), menu_label.c_str ());
}

int
Inti::Gtk::Notebook::insert_page (Widget * child,
                                     int position,
                                     const char * tab_label,
                                     const char * menu_label)
{
  return insert_page (child, position,
                      tab_label ? new Label (tab_label) : 0,
                      menu_label ? new Label (menu_label) : 0);
}

int
Inti::Gtk::Notebook::insert_page (Widget * child,
                                     int position,
                                     Widget * tab_label,
                                     Widget * menu_label)
{
  gtk_notebook_insert_page_menu (gtk_notebook (),
                                 child->gtk_widget (),
                                 tab_label ? tab_label->gtk_widget () : 0,
                                 menu_label ? menu_label->gtk_widget () : 0,
                                 position);

  return position;
}

void
Inti::Gtk::Notebook::remove_page (int page_number)
{
  gtk_notebook_remove_page (gtk_notebook (), page_number);
}

Inti::Gtk::Widget *
Inti::Gtk::Notebook::child (int page_number) const
{
  GtkWidget * w = gtk_notebook_get_nth_page (gtk_notebook (), page_number);

  return dynamic_cast<Widget*>(Object::wrap ((GObject*) w));
}

int
Inti::Gtk::Notebook::page_number (Widget * child) const
{
  return gtk_notebook_page_num (gtk_notebook (),
                                child->gtk_widget ());
}

void
Inti::Gtk::Notebook::set_current_page (int page_number)
{
  gtk_notebook_set_page (gtk_notebook (), page_number);
}

int
Inti::Gtk::Notebook::current_page () const
{
  return gtk_notebook_get_current_page (gtk_notebook ());
}

void
Inti::Gtk::Notebook::next_page ()
{
  gtk_notebook_next_page (gtk_notebook ());
}

void
Inti::Gtk::Notebook::previous_page ()
{
  gtk_notebook_prev_page (gtk_notebook ());
}

bool
Inti::Gtk::Notebook::show_border () const
{
  return gtk_notebook ()->show_border;
}

bool
Inti::Gtk::Notebook::show_tabs () const
{
  return gtk_notebook ()->show_tabs;
}

void
Inti::Gtk::Notebook::set_tab_position (PositionType pos)
{
  gtk_notebook_set_tab_pos (gtk_notebook (),
                            (GtkPositionType) pos);
}

Inti::Gtk::PositionType
Inti::Gtk::Notebook::tab_position () const
{
  return (PositionType) gtk_notebook ()->tab_pos;
}

bool
Inti::Gtk::Notebook::homogeneous_tabs () const
{
  return gtk_notebook ()->homogeneous;
}

void
Inti::Gtk::Notebook::set_scrollable (bool setting)
{
  gtk_notebook_set_scrollable (gtk_notebook (), setting);
}

bool
Inti::Gtk::Notebook::scrollable () const
{
  return gtk_notebook ()->scrollable;
}


void
Inti::Gtk::Notebook::set_has_popup (bool setting)
{
  if (setting)
    gtk_notebook_popup_enable (gtk_notebook ());
  else
    gtk_notebook_popup_disable (gtk_notebook ());
}

bool
Inti::Gtk::Notebook::has_popup () const
{
  return gtk_notebook ()->menu != NULL;
}

void
Inti::Gtk::Notebook::set_tab_label (int page, Widget * tab_label)
{
  GtkWidget * child = gtk_notebook_get_nth_page (gtk_notebook (), page);
  if (child == 0)
    return;

  gtk_notebook_set_tab_label (gtk_notebook (), child,
                              tab_label ? tab_label->gtk_widget () : 0);
}

void
Inti::Gtk::Notebook::set_tab_label (int page, const char * tab_label)
{
  set_tab_label (page, tab_label ? new Label (tab_label) : 0);
}

void
Inti::Gtk::Notebook::set_tab_label (int page, const string & tab_label)
{
  set_tab_label (page, tab_label.c_str ());
}

Inti::Gtk::Widget *
Inti::Gtk::Notebook::tab_label (int page) const
{
  GtkWidget * child = gtk_notebook_get_nth_page (gtk_notebook (), page);
  if (child == 0)
    return 0;

  GtkWidget * tab_label = gtk_notebook_get_tab_label (gtk_notebook (), child);

  return dynamic_cast<Widget*>(Object::wrap ((GObject*)tab_label));
}

void
Inti::Gtk::Notebook::set_menu_label (int page, Widget * menu_label)
{
  GtkWidget * child = gtk_notebook_get_nth_page (gtk_notebook (), page);
  if (child == 0)
    return;

  gtk_notebook_set_menu_label (gtk_notebook (), child,
                               menu_label ? menu_label->gtk_widget () : 0);
}

void
Inti::Gtk::Notebook::set_menu_label (int page, const char * menu_label)
{
  set_menu_label (page, menu_label ? new Label (menu_label) : 0);
}

void
Inti::Gtk::Notebook::set_menu_label (int page, const string & menu_label)
{
  set_menu_label (page, menu_label.c_str ());
}

Inti::Gtk::Widget *
Inti::Gtk::Notebook::menu_label (int page) const
{
  GtkWidget * child = gtk_notebook_get_nth_page (gtk_notebook (), page);
  if (child == 0)
    return 0;

  GtkWidget * menu_label = gtk_notebook_get_menu_label (gtk_notebook (), child);

  return dynamic_cast<Widget*>(Object::wrap ((GObject*)menu_label));
}

void
Inti::Gtk::Notebook::move_page (int old_page_number, int new_page_number)
{
  GtkWidget * child = gtk_notebook_get_nth_page (gtk_notebook (), old_page_number);
  if (child == 0)
    return;

  gtk_notebook_reorder_child (gtk_notebook (), child, new_page_number);
}

void
Inti::Gtk::Notebook::switch_page_impl (int page_number, Widget * child)
{
  GtkNotebookClass * klass =
    (GtkNotebookClass*) original_class ();

  // sick hack alert
  GtkNotebookPage * p =
    (GtkNotebookPage*) gtk_object_get_data (GTK_OBJECT (child->g_object ()),
                                            "__inti_notebook_page");

  if (p == 0)
    {
      // happens if the virtual function was called directly.
      GList * iter = gtk_notebook ()->children;
      while (iter != 0)
        {
          GtkNotebookPage * pg = (GtkNotebookPage*) iter->data;

          if (pg->child == child->gtk_widget ())
            {
              p = pg;
              break;
            }

          iter = g_list_next (iter);
        }
    }

  g_assert (p != 0); // if this fails the child isn't in the notebook, probably

  if (* klass->switch_page)
    (* klass->switch_page) (gtk_notebook (), p, page_number);
}

void
Inti::Gtk::Notebook::on_switch_page (int page_number, Widget * child)
{
  // nothing
}

void
Inti::Gtk::Notebook::switch_page_proxy (GtkNotebook *notebook,
                                           GtkNotebookPage *page,
                                           guint page_num)
{
  Widget * child = dynamic_cast<Widget*> (Object::wrap ((GObject*) page->child));

  gtk_object_set_data (GTK_OBJECT (child->g_object ()),
                       "__inti_notebook_page",
                       (void*) page);

  Notebook *o = (Notebook*)
    gtk_object_get_data_by_id ((GtkObject*)notebook, Inti::Private::quark ());

  o->switch_page_impl (page_num, child);
  o->on_switch_page (page_num, child);

  gtk_object_remove_data (GTK_OBJECT (child->g_object ()),
                          "__inti_notebook_page");
}

void
Inti::Gtk::Private::slot2_notebook_callback (GtkNotebook * notebook,
                                                GtkNotebookPage * page,
                                                unsigned int page_num,
                                                gpointer data)
{
  Inti::Gtk::Private::ConnectionImpl * impl =
    static_cast<Inti::Gtk::Private::ConnectionImpl*>(data);

  Slot2<void,int,Widget*> * slot =
    dynamic_cast<Slot2<void,int,Widget*>*> (impl->slot ());

  Widget * child = dynamic_cast<Widget*> (Object::wrap ((GObject*) page->child));

  slot->invoke (page_num, child);
}

/////////// Everything below here is machine-generated
const Inti::Gtk::Notebook::SwitchPageSignalType
Inti::Gtk::Notebook::switch_page_signal ("switch_page", (Private::SignalFunc)Private::slot2_notebook_callback);

void
Inti::Gtk::Notebook::set_show_border (bool show_border)
{
   gtk_notebook_set_show_border (gtk_notebook (), show_border);
}
void
Inti::Gtk::Notebook::set_show_tabs (bool show_tabs)
{
   gtk_notebook_set_show_tabs (gtk_notebook (), show_tabs);
}
void
Inti::Gtk::Notebook::set_homogeneous_tabs (bool homogeneous)
{
   gtk_notebook_set_homogeneous_tabs (gtk_notebook (), homogeneous);
}
