// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_GTK_ENTRY_H_
#define _INTI_GTK_ENTRY_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/gtk/editable.h>
#include <gtk/gtkentry.h>
#include <inti/utf-string.h>

/*$ doc header
  $short The #Inti::Gtk::Entry widget, a one-line text entry field
  $*/

namespace Inti
{  
  namespace Gtk
  {
    namespace Private
    {
      class EntryClass;
    };
    
    class Entry : public Editable
    {
    public:
      /*$ doc class Entry
        $short widget for editing a single line of text

        $copy none
        $memory floating
        
        $long

        <para>

        </para>

        <para>

        </para>
        
        $*/
        
      GtkEntry * gtk_entry () const
      {
        return (GtkEntry*)g_object ();
      }

      Entry ();
      
      void set_text (const std::string& text);
      void append_text (const std::string& text);
      void prepend_text (const std::string& text);
      void set_max_length (guint16 max);
      void set_password_mode (bool setting);
      bool password_mode () const;
      
      ustring text () const;
      
      int max_length () const;
      
    protected:
      friend class Private::EntryClass;
      
      explicit Entry (GtkEntry *src, GtkEntryClass* orig);
      virtual ~Entry ();
      
    private:
      Entry(const Entry&);
      Entry& operator=(const Entry&);
      
    }; // class Entry

  }; // namespace Gtk
  
}; // namespace Inti

#endif // _INTI_GTK_ENTRY_H_
