// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_GTK_EDITABLE_H_
#define _INTI_GTK_EDITABLE_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/gtk/widget.h>
#include <gtk/gtkeditable.h>
#include <inti/utf-string.h>

/*$ doc header
  $short The #Inti::Gtk::Editable abstract base class
  $*/

namespace Inti
{
  namespace Gtk
  {
    namespace Private
    {
      class EditableClass;
    };

    class Editable : public Widget
    {
    public:
      /*$ doc class Editable
        $short widget that contains editable text

        $copy none
        $memory floating

        $long

        <para>

        </para>

        <para>

        </para>

        $*/

      GtkEditable * gtk_editable () const
      {
        return (GtkEditable*)g_object ();
      }

      void select_region (int start, int end);
      void insert_text (const string & text, int * position);
      void insert_text (const char * text, int * position);
      void delete_text (int start_pos, int end_pos);
      ustring get_chars (int start_pos, int end_pos);
      void cut_clipboard ();
      void copy_clipboard ();
      void paste_clipboard ();

      void delete_selection ();
      void set_position (int position);

      int position () const;

      void set_editable (bool is_editable);

      bool editable () const;

    protected:
      typedef WrapSignal0<void> ChangedSignalType;
      static const ChangedSignalType changed_signal;

    public:
      typedef SignalProxy<Object,ChangedSignalType> ChangedProxyType;
      const ChangedProxyType sig_changed ()
      {
        return ChangedProxyType (this, &changed_signal);
      }
    protected:
      typedef WrapSignal2<void,const string &,int * > InsertTextSignalType;
      static const InsertTextSignalType insert_text_signal;

    public:
      typedef SignalProxy<Object,InsertTextSignalType> InsertTextProxyType;
      const InsertTextProxyType sig_insert_text ()
      {
        return InsertTextProxyType (this, &insert_text_signal);
      }
    protected:
      typedef WrapSignal2<void,int,int> DeleteTextSignalType;
      static const DeleteTextSignalType delete_text_signal;

    public:
      typedef SignalProxy<Object,DeleteTextSignalType> DeleteTextProxyType;
      const DeleteTextProxyType sig_delete_text ()
      {
        return DeleteTextProxyType (this, &delete_text_signal);
      }
    protected:
      typedef WrapSignal0<void> ActivateSignalType;
      static const ActivateSignalType activate_signal;

    public:
      typedef SignalProxy<Object,ActivateSignalType> ActivateProxyType;
      const ActivateProxyType sig_activate ()
      {
        return ActivateProxyType (this, &activate_signal);
      }
    protected:
      typedef WrapSignal1<void,bool> SetEditableSignalType;
      static const SetEditableSignalType set_editable_signal;

    public:
      typedef SignalProxy<Object,SetEditableSignalType> SetEditableProxyType;
      const SetEditableProxyType sig_set_editable ()
      {
        return SetEditableProxyType (this, &set_editable_signal);
      }
    protected:
      typedef WrapSignal2<void,int,int> MoveCursorSignalType;
      static const MoveCursorSignalType move_cursor_signal;

    public:
      typedef SignalProxy<Object,MoveCursorSignalType> MoveCursorProxyType;
      const MoveCursorProxyType sig_move_cursor ()
      {
        return MoveCursorProxyType (this, &move_cursor_signal);
      }
    protected:
      typedef WrapSignal1<void,int> MoveWordSignalType;
      static const MoveWordSignalType move_word_signal;

    public:
      typedef SignalProxy<Object,MoveWordSignalType> MoveWordProxyType;
      const MoveWordProxyType sig_move_word ()
      {
        return MoveWordProxyType (this, &move_word_signal);
      }
    protected:
      typedef WrapSignal2<void,int,int> MovePageSignalType;
      static const MovePageSignalType move_page_signal;

    public:
      typedef SignalProxy<Object,MovePageSignalType> MovePageProxyType;
      const MovePageProxyType sig_move_page ()
      {
        return MovePageProxyType (this, &move_page_signal);
      }
    protected:
      typedef WrapSignal1<void,int> MoveToRowSignalType;
      static const MoveToRowSignalType move_to_row_signal;

    public:
      typedef SignalProxy<Object,MoveToRowSignalType> MoveToRowProxyType;
      const MoveToRowProxyType sig_move_to_row ()
      {
        return MoveToRowProxyType (this, &move_to_row_signal);
      }
    protected:
      typedef WrapSignal1<void,int> MoveToColumnSignalType;
      static const MoveToColumnSignalType move_to_column_signal;

    public:
      typedef SignalProxy<Object,MoveToColumnSignalType> MoveToColumnProxyType;
      const MoveToColumnProxyType sig_move_to_column ()
      {
        return MoveToColumnProxyType (this, &move_to_column_signal);
      }
    protected:
      typedef WrapSignal1<void,int> KillCharSignalType;
      static const KillCharSignalType kill_char_signal;

    public:
      typedef SignalProxy<Object,KillCharSignalType> KillCharProxyType;
      const KillCharProxyType sig_kill_char ()
      {
        return KillCharProxyType (this, &kill_char_signal);
      }
    protected:
      typedef WrapSignal1<void,int> KillWordSignalType;
      static const KillWordSignalType kill_word_signal;

    public:
      typedef SignalProxy<Object,KillWordSignalType> KillWordProxyType;
      const KillWordProxyType sig_kill_word ()
      {
        return KillWordProxyType (this, &kill_word_signal);
      }
    protected:
      typedef WrapSignal1<void,int> KillLineSignalType;
      static const KillLineSignalType kill_line_signal;

    public:
      typedef SignalProxy<Object,KillLineSignalType> KillLineProxyType;
      const KillLineProxyType sig_kill_line ()
      {
        return KillLineProxyType (this, &kill_line_signal);
      }
    protected:
      typedef WrapSignal0<void> CutClipboardSignalType;
      static const CutClipboardSignalType cut_clipboard_signal;

    public:
      typedef SignalProxy<Object,CutClipboardSignalType> CutClipboardProxyType;
      const CutClipboardProxyType sig_cut_clipboard ()
      {
        return CutClipboardProxyType (this, &cut_clipboard_signal);
      }
    protected:
      typedef WrapSignal0<void> CopyClipboardSignalType;
      static const CopyClipboardSignalType copy_clipboard_signal;

    public:
      typedef SignalProxy<Object,CopyClipboardSignalType> CopyClipboardProxyType;
      const CopyClipboardProxyType sig_copy_clipboard ()
      {
        return CopyClipboardProxyType (this, &copy_clipboard_signal);
      }
    protected:
      typedef WrapSignal0<void> PasteClipboardSignalType;
      static const PasteClipboardSignalType paste_clipboard_signal;

    public:
      typedef SignalProxy<Object,PasteClipboardSignalType> PasteClipboardProxyType;
      const PasteClipboardProxyType sig_paste_clipboard ()
      {
        return PasteClipboardProxyType (this, &paste_clipboard_signal);
      }

    protected:
      friend class Private::EditableClass;

      Editable ();
      explicit Editable (GtkEditable *src, GtkEditableClass* orig);
      virtual ~Editable () = 0; // abstract class

      void claim_selection (bool claim, guint32 time);

      // Non-signal virtual functions

      virtual void update_text_impl (int start_pos, int end_pos);
      virtual string get_chars_impl (int start_pos, int end_pos);
      virtual void set_selection_impl (int start_pos, int end_pos);
      virtual void set_position_impl (int pos);

      // Signals

      virtual void changed_impl ();
      virtual void insert_text_impl (const string & text, int * position);
      virtual void delete_text_impl (int start_pos, int end_pos);
      virtual void activate_impl ();
      virtual void set_editable_impl (bool setting);
      virtual void move_cursor_impl (int x, int y);
      virtual void move_word_impl (int n);
      virtual void move_page_impl (int x, int y);
      virtual void move_to_row_impl (int row);
      virtual void move_to_column_impl (int column);
      virtual void kill_char_impl (int direction);
      virtual void kill_word_impl (int direction);
      virtual void kill_line_impl (int direction);
      virtual void cut_clipboard_impl ();
      virtual void copy_clipboard_impl ();
      virtual void paste_clipboard_impl ();


      virtual void on_changed ();
      virtual void on_insert_text (const string & text, int * position);
      virtual void on_delete_text (int start_pos, int end_pos);
      virtual void on_activate ();
      virtual void on_set_editable (bool setting);
      virtual void on_move_cursor (int x, int y);
      virtual void on_move_word (int n);
      virtual void on_move_page (int x, int y);
      virtual void on_move_to_row (int row);
      virtual void on_move_to_column (int column);
      virtual void on_kill_char (int direction);
      virtual void on_kill_word (int direction);
      virtual void on_kill_line (int direction);
      virtual void on_cut_clipboard ();
      virtual void on_copy_clipboard ();
      virtual void on_paste_clipboard ();

    private:
      Editable(const Editable&);
      Editable& operator=(const Editable&);


      static void update_text_proxy (GtkEditable * editable,
                                     int start_pos, int end_pos);
      static char * get_chars_proxy (GtkEditable * editable,
                                     int start_pos, int end_pos);
      static void set_selection_proxy (GtkEditable * editable,
                                       int start_pos, int end_pos);
      static void set_position_proxy (GtkEditable * editable,
                                      int pos);


      static void changed_proxy (GtkEditable * editable);
      static void insert_text_proxy (GtkEditable * editable,
                                     const char * text,
                                     int length, int * position);
      static void delete_text_proxy (GtkEditable * editable,
                                     int start_pos, int end_pos);
      static void activate_proxy (GtkEditable * editable);
      static void set_editable_proxy (GtkEditable * editable, gboolean setting);
      static void move_cursor_proxy (GtkEditable * editable, int x, int y);
      static void move_word_proxy (GtkEditable * editable, int n);
      static void move_page_proxy (GtkEditable * editable, int x, int y);
      static void move_to_row_proxy (GtkEditable * editable, int row);
      static void move_to_column_proxy (GtkEditable * editable, int column);
      static void kill_char_proxy (GtkEditable * editable, int direction);
      static void kill_word_proxy (GtkEditable * editable, int direction);
      static void kill_line_proxy (GtkEditable * editable, int direction);
      static void cut_clipboard_proxy (GtkEditable * editable);
      static void copy_clipboard_proxy (GtkEditable * editable);
      static void paste_clipboard_proxy (GtkEditable * editable);

    }; // class Editable

  }; // namespace Gtk

}; // namespace Inti

#endif // _INTI_GTK_EDITABLE_H_
