// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_GDK_CURSOR_H_
#define _INTI_GDK_CURSOR_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/gdk/gdkbase.h>
#include <gdk/gdkcursor.h>

/*$ doc header
  $short The #Inti::Gdk::Cursor class (describes the appearance of the mouse pointer)
  $*/

namespace Inti
{  
  namespace Gdk
  {
    class Color;
    class Pixmap;
    class Bitmap;
    
    class Cursor
    {
    public:
      GdkCursor * gdk_cursor () const
      {
        return cursor_;
      }

      typedef enum
      {
        STANDARD_ARROW,
        RIGHT_ARROW,
        INVISIBLE,
        CROSSHAIR,
        IBEAM,
        BUSY,
        MOVE,
        HAND,
        
        RESIZE_LEFT,
        RESIZE_RIGHT,
        RESIZE_NW,
        RESIZE_NE,
        RESIZE_SW,
        RESIZE_SE,
        RESIZE_TOP,
        RESIZE_BOTTOM,
        
        RESIZE_VERTICAL_SPLIT,
        RESIZE_HORIZONTAL_SPLIT,
        
        CUSTOM
      } Type;

      Cursor (Type t);
      Cursor (const Pixmap * pixmap,
              const Bitmap * mask,
              const Color & foreground,
              const Color & background,
              int hotspot_x,
              int hotspot_y);
      Cursor (GdkCursorType gdk_type);
      
      Cursor (const Cursor & src);
      Cursor& operator=(const Cursor & src);
      ~Cursor ();

      Type type () const
      {
        return type_;
      }
      
    protected:
      
    private:
      Type type_;
      GdkCursor * cursor_;
      
    }; // class Cursor

  }; // namespace Gdk
  
}; // namespace Inti

#endif // _INTI_GDK_CURSOR_H_
