// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
// Typing game example
/*
  The following license applies to this example code, but not to
  the Inti library itself:
  
    Permission is hereby granted, free of charge, to any person obtaining
    a copy of this software and associated documentation files (the
    "Software"), to deal in the Software without restriction, including
    without limitation the rights to use, copy, modify, merge, publish,
    distribute, sublicense, and/or sell copies of the Software, and to
    permit persons to whom the Software is furnished to do so, subject to
    the following conditions:

    The above copyright notice and this permission notice shall be
    included in all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
    NONINFRINGEMENT.  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
    DISTRIBUTOR OF THE SOFTWARE BE LIABLE FOR ANY CLAIM, DAMAGES OR
    OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
    OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
    OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/
#ifndef GAME_VIEW_H
#define GAME_VIEW_H

#include <inti/gtk/drawingarea.h>
#include <inti/gdk/event.h>

using namespace Inti;

class Game;

class GameView : public Gtk::DrawingArea
{
public:
  GameView ();

  void set_game (Game * game);
  
protected:
  ~GameView ();

  virtual bool on_expose_event (const Gdk::EventExpose & event);
  virtual bool on_configure_event (const Gdk::EventConfigure & event);
  
private:

  void on_game_update ();
  
  Game * game_;

  Connection update_connection_;
};

#endif
