// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
// Typing game example
/*
  The following license applies to this example code, but not to
  the Inti library itself:
  
    Permission is hereby granted, free of charge, to any person obtaining
    a copy of this software and associated documentation files (the
    "Software"), to deal in the Software without restriction, including
    without limitation the rights to use, copy, modify, merge, publish,
    distribute, sublicense, and/or sell copies of the Software, and to
    permit persons to whom the Software is furnished to do so, subject to
    the following conditions:

    The above copyright notice and this permission notice shall be
    included in all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
    NONINFRINGEMENT.  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
    DISTRIBUTOR OF THE SOFTWARE BE LIABLE FOR ANY CLAIM, DAMAGES OR
    OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
    OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
    OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include "gameview.h"
#include "game.h"
#include "badguy.h"
#include "player.h"
#include <inti/gtk/style.h>
#include <inti/gdk/window.h>

GameView::GameView ()
{


}

void
GameView::set_game (Game * game)
{
  if (game == game_)
    return;
  
  update_connection_.disconnect ();

  game_ = game;

  if (game)
    update_connection_ =
      game->sig_update ().connect (this,
                                   &GameView::on_game_update);

  queue_draw ();
}
  
GameView::~GameView ()
{
  update_connection_.disconnect ();
}


void
GameView::on_game_update ()
{
  queue_draw ();
}

bool
GameView::on_expose_event (const Gdk::EventExpose & event)
{
  if (!game_->started ())
    game_->start ();
  
  window ()->draw_rectangle (style ()->base_gc (state ()),
                             true, event.area ());
  
  if (game_ != 0)
    {
      vector<Badguy*>::const_iterator i = game_->badguys ().begin ();
      vector<Badguy*>::const_iterator end = game_->badguys ().end ();

      while (i != end)
        {
          if (event.area ().intersects ((*i)->extents ()))
            (*i)->render (this, window (), event.area ());
          
          ++i;
        }
    };

  return true;
}

bool
GameView::on_configure_event (const Gdk::EventConfigure & event)
{
  game_->set_size (event.width (),
                   event.height ());
  
  return false;
}
